/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.IPurgeUtilityLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.MDC;

public class PurgeUtilityTextLayout
extends Layout
implements IPurgeUtilityLayout {
    protected static final int BUF_SIZE = 256;
    protected static final int MAX_CAPACITY = 1024;
    private Level loggerLogLevel = Level.DEBUG;
    private StringBuffer sbuf = new StringBuffer(256);
    String title = "Log4J Log Messages";

    public PurgeUtilityTextLayout(Level loggerLogLevel) {
        this.loggerLogLevel = loggerLogLevel;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    public void activateOptions() {
    }

    @Override
    public String format(LoggingEvent event) {
        Level logLevel = event.getLevel();
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(Layout.LINE_SEP);
        if (this.showTimeColumn()) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            date.setTime(event.timeStamp);
            String time = null;
            try {
                time = df.format(date);
            }
            catch (Exception ex) {
                LogLog.error((String)"Error occured while converting date.", (Throwable)ex);
            }
            this.sbuf.append(time);
        }
        this.sbuf.append("\t");
        this.sbuf.append(MDC.get((String)"currentFile"));
        if (this.showLevelColumn()) {
            this.sbuf.append("\t");
            this.sbuf.append(String.valueOf(event.getLevel()));
        }
        if (this.showCodeLineColumn()) {
            this.sbuf.append("\t");
            this.sbuf.append(MDC.get((String)"codeLine"));
        }
        this.sbuf.append("\t");
        this.sbuf.append(event.getRenderedMessage());
        return this.sbuf.toString();
    }

    @Override
    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.title);
        return sbuf.toString();
    }

    @Override
    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("End of Log");
        return sbuf.toString();
    }

    @Override
    public boolean ignoresThrowable() {
        return true;
    }

    private boolean showCodeLineColumn() {
        return Level.DEBUG.isGreaterOrEqual((Priority)this.loggerLogLevel);
    }

    private boolean showTimeColumn() {
        return Level.DEBUG.isGreaterOrEqual((Priority)this.loggerLogLevel);
    }

    private boolean showLevelColumn() {
        return true;
    }
}

