/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.api.analyzer.kettle.IDatabaseConnectionAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;

public abstract class DatabaseConnectionAnalyzer<T>
extends BaseKettleMetaverseComponent
implements IDatabaseConnectionAnalyzer<T> {
    @Override
    public IMetaverseNode analyze(IComponentDescriptor descriptor, DatabaseMeta dbMeta) throws MetaverseAnalyzerException {
        if (dbMeta == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.DatabaseMeta.IsNull"));
        }
        if (this.metaverseObjectFactory == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseObjectFactory.IsNull"));
        }
        if (this.metaverseBuilder == null) {
            throw new MetaverseAnalyzerException(Messages.getString("ERROR.MetaverseBuilder.IsNull"));
        }
        IMetaverseNode node = this.createNodeFromDescriptor(descriptor);
        node.setType("Database Connection");
        int accessType = dbMeta.getAccessType();
        node.setProperty("accessType", accessType);
        String accessTypeDesc = dbMeta.environmentSubstitute(dbMeta.getAccessTypeDesc());
        node.setProperty("accessTypeDesc", accessTypeDesc);
        String databaseName = dbMeta.environmentSubstitute(dbMeta.getDatabaseName());
        node.setProperty("databaseName", databaseName);
        String connectionName = dbMeta.environmentSubstitute(dbMeta.getName());
        node.setProperty("name", connectionName);
        DatabaseInterface dbInterface = dbMeta.getDatabaseInterface();
        node.setProperty("databaseType", dbInterface != null ? Const.NVL((String)dbInterface.getPluginName(), (String)"Unknown") : "Unknown");
        String port = dbMeta.environmentSubstitute(dbMeta.getDatabasePortNumberString());
        node.setProperty("port", port);
        String host = dbMeta.environmentSubstitute(dbMeta.getHostname());
        node.setProperty("hostName", host);
        String user = dbMeta.environmentSubstitute(dbMeta.getUsername());
        node.setProperty("userName", user);
        boolean shared = dbMeta.isShared();
        node.setProperty("shared", shared);
        if (accessTypeDesc != null && accessTypeDesc.equals("JNDI")) {
            node.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DB_JNDI);
        } else {
            node.setLogicalIdGenerator(this.getLogicalIdGenerator());
        }
        return node;
    }

    @Override
    protected ILogicalIdGenerator getLogicalIdGenerator() {
        return DictionaryConst.LOGICAL_ID_GENERATOR_DB_JDBC;
    }

    @Override
    public IComponentDescriptor buildComponentDescriptor(IComponentDescriptor parentDescriptor, DatabaseMeta connection) {
        MetaverseComponentDescriptor dbDescriptor = new MetaverseComponentDescriptor(connection.getName(), "Database Connection", parentDescriptor.getNamespace(), parentDescriptor.getContext());
        return dbDescriptor;
    }
}

