/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.propforms;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.propforms.AbstractModelerNodeForm;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.stereotype.Bindable;

public class DimensionPropertiesForm
extends AbstractModelerNodeForm<DimensionMetaData> {
    private static final long serialVersionUID = 7467855499137361995L;
    private XulTextbox name;
    private XulCheckbox isTimeDim;
    private XulVbox messageBox;
    private XulLabel messageLabel;
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("valid")) {
                return;
            }
            DimensionPropertiesForm.this.showValidations();
        }
    };
    private XulButton messageBtn;

    public DimensionPropertiesForm() {
        super("dimensionprops");
    }

    @Override
    public void setObject(DimensionMetaData dim) {
        if (this.getNode() != null) {
            ((DimensionMetaData)this.getNode()).removePropertyChangeListener(this.propListener);
        }
        this.setNode(dim);
        if (dim == null) {
            return;
        }
        dim.addPropertyChangeListener(this.propListener);
        this.name.setValue(dim.getName());
        this.isTimeDim.setChecked(dim.isTimeDimension());
        this.showValidations();
    }

    @Bindable
    private void showValidations() {
        if (this.getNode() == null) {
            return;
        }
        this.messageBox.setVisible(((DimensionMetaData)this.getNode()).getValidationMessages().size() > 0);
        this.setValidMessages(((DimensionMetaData)this.getNode()).getValidationMessagesString());
    }

    @Override
    public void init(ModelerWorkspace workspace) {
        super.init(workspace);
        this.name = (XulTextbox)this.document.getElementById("dimension_name");
        this.bf.createBinding((Object)this, "name", (Object)this.name, "value", new BindingConvertor[0]);
        this.isTimeDim = (XulCheckbox)this.document.getElementById("is_time_dimension");
        this.bf.createBinding((Object)this, "timeDimension", (Object)this.isTimeDim, "checked", new BindingConvertor[0]);
        this.messageBox = (XulVbox)this.document.getElementById("dimension_message");
        this.messageLabel = (XulLabel)this.document.getElementById("dimension_message_label");
        this.bf.createBinding((Object)this, "validMessages", (Object)this.messageLabel, "value", new BindingConvertor[]{validMsgTruncatedBinding});
        this.messageBtn = (XulButton)this.document.getElementById("dimension_message_btn");
        this.bf.createBinding((Object)this, "validMessages", (Object)this.messageBtn, "visible", new BindingConvertor[]{showMsgBinding});
    }

    @Bindable
    public void setName(String name) {
        if (this.getNode() != null) {
            ((DimensionMetaData)this.getNode()).setName(name);
        }
        this.name.setValue(name);
    }

    @Bindable
    public String getName() {
        if (this.getNode() == null) {
            return null;
        }
        return ((DimensionMetaData)this.getNode()).getName();
    }

    @Bindable
    public void setTimeDimension(boolean timeDimension) {
        if (this.getNode() != null) {
            ((DimensionMetaData)this.getNode()).setTimeDimension(timeDimension);
        }
        if (timeDimension == this.isTimeDim.isChecked()) {
            return;
        }
        this.isTimeDim.setChecked(timeDimension);
    }

    @Bindable
    public boolean isTimeDimension() {
        if (this.getNode() == null) {
            return false;
        }
        return ((DimensionMetaData)this.getNode()).isTimeDimension();
    }

    @Override
    public String getValidMessages() {
        if (this.getNode() != null) {
            return ((DimensionMetaData)this.getNode()).getValidationMessagesString();
        }
        return null;
    }
}

