/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.io.ClientProxy;
import com.infobright.io.LinuxNamedPipe;
import com.infobright.io.NamedPipe;
import com.infobright.io.OSType;
import com.infobright.io.PipeCallStrategy;
import com.infobright.io.RemoteNamedPipe;
import com.infobright.io.UnixPipeCallStrategy;
import com.infobright.io.WindowsNamedPipe;
import com.infobright.io.WindowsPipeCallStrategy;
import com.infobright.logging.EtlLogger;
import java.io.IOException;

class NamedPipeFactory {
    private final OSType osType;
    private final ClientProxy proxy;
    private final LinuxHelper linuxHelper;
    private final WindowsHelper windowsHelper;

    private NamedPipeFactory(String osName, ClientProxy proxy) {
        this.osType = new OSType(osName);
        this.proxy = proxy;
        this.linuxHelper = new LinuxHelper();
        this.windowsHelper = new WindowsHelper();
    }

    public NamedPipeFactory(ClientProxy proxy) throws IOException {
        this(proxy == null ? System.getProperty("os.name") : proxy.getOSName(), proxy);
    }

    public NamedPipeFactory() {
        this(System.getProperty("os.name"), null);
    }

    NamedPipe createServer(String pipeName) throws IOException {
        return this.createServer(pipeName, true, true, 4096, 10000L);
    }

    NamedPipe createServer(String pipeName, boolean writeAllowed, boolean readAllowed, int bufsize, long timeout) throws IOException {
        NamedPipe namedPipe;
        if (this.osType.isUnix()) {
            namedPipe = this.linuxHelper.createPipe(pipeName);
        } else if (this.osType.isWindows()) {
            namedPipe = this.windowsHelper.createServerPipe(pipeName, writeAllowed, readAllowed, bufsize, timeout);
        } else {
            throw new UnsupportedOperationException("Unsupported platform");
        }
        return namedPipe;
    }

    NamedPipe createClient(String pipeName) throws IOException {
        NamedPipe namedPipe;
        if (this.osType.isUnix()) {
            namedPipe = this.linuxHelper.createPipe(pipeName);
        } else if (this.osType.isWindows()) {
            namedPipe = this.windowsHelper.createClientPipe(pipeName);
        } else {
            throw new UnsupportedOperationException("Unsupported platform");
        }
        return namedPipe;
    }

    public String getNativePipeName(String name) {
        if (this.osType.isUnix()) {
            return LinuxNamedPipe.getNativeName(name);
        }
        if (this.osType.isWindows()) {
            return WindowsNamedPipe.getNativeName(name);
        }
        throw new UnsupportedOperationException("Unsupported platform");
    }

    public PipeCallStrategy getStrategy(EtlLogger logger) {
        if (this.osType.isUnix()) {
            return new UnixPipeCallStrategy(this.proxy, logger);
        }
        if (this.osType.isWindows()) {
            return new WindowsPipeCallStrategy(this.proxy, logger);
        }
        throw new UnsupportedOperationException("Unsupported platform");
    }

    private class WindowsHelper {
        private WindowsHelper() {
        }

        NamedPipe createServerPipe(String pipeName, boolean writeAllowed, boolean readAllowed, int bufsize, long timeout) throws IOException {
            if (NamedPipeFactory.this.proxy == null) {
                return new WindowsNamedPipe(pipeName, writeAllowed, readAllowed, bufsize, timeout);
            }
            return new RemoteNamedPipe(pipeName, NamedPipeFactory.this.proxy);
        }

        NamedPipe createClientPipe(String pipeName) throws IOException {
            if (NamedPipeFactory.this.proxy == null) {
                return new WindowsNamedPipe(pipeName);
            }
            return new RemoteNamedPipe(pipeName, NamedPipeFactory.this.proxy);
        }
    }

    private class LinuxHelper {
        private LinuxHelper() {
        }

        NamedPipe createPipe(String pipeName) throws IOException {
            if (NamedPipeFactory.this.proxy == null) {
                return new LinuxNamedPipe(pipeName, true);
            }
            return new RemoteNamedPipe(pipeName, NamedPipeFactory.this.proxy);
        }
    }
}

