/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import org.apache.hadoop.io.Text;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class TextToLongConverter
implements ITypeConverter<Text, Long> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return Text.class.equals((Object)from) && Long.class.equals((Object)to);
    }

    @Override
    public Long convert(ValueMetaInterface meta, Text obj) throws TypeConversionException {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new TypeConversionException(BaseMessages.getString(TypeConverterFactory.class, (String)"ErrorConverting", (Object[])new Object[]{Long.class.getSimpleName(), obj}), ex);
        }
    }
}

