/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import org.apache.hadoop.io.Text;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class TextToIntegerConverter
implements ITypeConverter<Text, Integer> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return Text.class.equals((Object)from) && Integer.class.equals((Object)to);
    }

    @Override
    public Integer convert(ValueMetaInterface meta, Text obj) throws TypeConversionException {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new TypeConversionException(BaseMessages.getString(TypeConverterFactory.class, (String)"ErrorConverting", (Object[])new Object[]{Integer.class.getSimpleName(), obj}), ex);
        }
    }
}

