/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api;

import com.debortoliwines.openerp.api.OpeneERPApiException;
import java.util.ArrayList;

public class FilterCollection {
    private ArrayList<Object> filters = new ArrayList();

    public void add(int index, String fieldName, String comparison, Object value) throws OpeneERPApiException {
        if (fieldName == null) {
            throw new OpeneERPApiException("First filter parameter is mandatory.  Please read the OpenERP help.");
        }
        if (comparison == null) {
            throw new OpeneERPApiException("Second filter parameter is mandatory.  Please read the OpenERP help.");
        }
        Object[] filter = new Object[]{fieldName, comparison, value};
        this.filters.add(index, filter);
    }

    public void add(String fieldName, String comparison, Object value) throws OpeneERPApiException {
        this.add(this.filters.size(), fieldName, comparison, value);
    }

    public void add(FilterOperator operator) {
        this.add(this.filters.size(), operator);
    }

    public void add(int index, FilterOperator operator) {
        switch (operator) {
            case OR: {
                this.filters.add(index, "|");
                break;
            }
            case NOT: {
                this.filters.add(index, "!");
                break;
            }
        }
    }

    public void clear() {
        this.filters.clear();
    }

    public Object[] getFilters() {
        return this.filters.toArray(new Object[this.filters.size()]);
    }

    public int size() {
        return this.filters.size();
    }

    public static enum FilterOperator {
        AND,
        OR,
        NOT;

    }
}

