/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.util.web;

import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.service.spi.util.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.http.HttpContext;

public final class MarketplaceHttpContext
implements HttpContext {
    private Log logger = LogFactory.getLog(this.getClass());
    private Bundle bundle;
    private Map<String, String> mimeTypes = new Hashtable<String, String>();

    private Log getLogger() {
        return this.logger;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(Map<String, String> mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public MarketplaceHttpContext() {
        this.bundle = FrameworkUtil.getBundle(MarketplaceHttpContext.class);
    }

    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return true;
    }

    public URL getResource(String name) {
        String normalizedname = Path.normalizeResourcePath((String)name);
        Bundle bundle = this.getBundle();
        this.getLogger().debug((Object)("Searching bundle [" + bundle + "] for resource [" + normalizedname + "]"));
        return bundle.getResource(normalizedname);
    }

    public String getMimeType(String name) {
        String extension = FilenameUtils.getExtension((String)name);
        return this.getMimeTypes().get(extension);
    }
}

