/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.services;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.serialization.IMarketplaceXmlSerializer;
import org.pentaho.marketplace.domain.services.interfaces.IRemotePluginProvider;
import org.pentaho.marketplace.util.web.HttpUtil;

public class RemoteMetadataPluginProvider
implements IRemotePluginProvider {
    private static final String MARKETPLACE_ENTRIES_URL_FALLBACK = "https://raw.github.com/pentaho/marketplace-metadata/master/marketplace.xml";
    private Log logger = LogFactory.getLog(this.getClass());
    private URL metadataUrl;
    private IMarketplaceXmlSerializer xmlPluginsSerializer;

    private Log getLogger() {
        return this.logger;
    }

    @Override
    public URL getUrl() {
        return this.metadataUrl;
    }

    @Override
    public void setUrl(URL metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    public IMarketplaceXmlSerializer getXmlSerializer() {
        return this.xmlPluginsSerializer;
    }

    protected RemoteMetadataPluginProvider setXmlSerializer(IMarketplaceXmlSerializer serializer) {
        this.xmlPluginsSerializer = serializer;
        return this;
    }

    public RemoteMetadataPluginProvider(IMarketplaceXmlSerializer xmlSerializer) {
        this.setXmlSerializer(xmlSerializer);
        try {
            this.setUrl(new URL(MARKETPLACE_ENTRIES_URL_FALLBACK));
        }
        catch (MalformedURLException e) {
            this.getLogger().error((Object)"Invalid metadata url: https://raw.github.com/pentaho/marketplace-metadata/master/marketplace.xml", (Throwable)e);
        }
    }

    @Override
    public Map<String, IPlugin> getPlugins() {
        InputStream inputStream = HttpUtil.getURLInputStream(this.getUrl());
        Map<String, IPlugin> plugins = this.getXmlSerializer().getPlugins(inputStream);
        return plugins;
    }
}

