/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hive.common.HiveCompat;

@Description(name="op", value="a op b - Returns the result of operation")
public abstract class GenericUDFBaseNumeric
extends GenericUDF {
    protected String opName;
    protected String opDisplayName;
    protected transient PrimitiveObjectInspector leftOI;
    protected transient PrimitiveObjectInspector rightOI;
    protected transient PrimitiveObjectInspector resultOI;
    protected transient ObjectInspectorConverters.Converter converterLeft;
    protected transient ObjectInspectorConverters.Converter converterRight;
    protected ByteWritable byteWritable = new ByteWritable();
    protected ShortWritable shortWritable = new ShortWritable();
    protected IntWritable intWritable = new IntWritable();
    protected LongWritable longWritable = new LongWritable();
    protected FloatWritable floatWritable = new FloatWritable();
    protected DoubleWritable doubleWritable = new DoubleWritable();
    protected HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
    protected boolean confLookupNeeded = true;
    protected boolean ansiSqlArithmetic = false;

    public GenericUDFBaseNumeric() {
        this.opName = this.getClass().getSimpleName();
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException(this.opName + " requires two arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of " + this.opName + "  is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        if (this.confLookupNeeded) {
            HiveCompat.CompatLevel compatLevel = HiveCompat.getCompatLevel(SessionState.get().getConf());
            this.ansiSqlArithmetic = compatLevel.ordinal() > HiveCompat.CompatLevel.HIVE_0_12.ordinal();
            this.confLookupNeeded = false;
        }
        this.leftOI = (PrimitiveObjectInspector)arguments[0];
        this.rightOI = (PrimitiveObjectInspector)arguments[1];
        this.resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(this.deriveResultTypeInfo());
        this.converterLeft = ObjectInspectorConverters.getConverter((ObjectInspector)this.leftOI, (ObjectInspector)this.resultOI);
        this.converterRight = ObjectInspectorConverters.getConverter((ObjectInspector)this.rightOI, (ObjectInspector)this.resultOI);
        return this.resultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0] == null || arguments[1] == null) {
            return null;
        }
        Object left = arguments[0].get();
        Object right = arguments[1].get();
        if (left == null && right == null) {
            return null;
        }
        if (this.resultOI.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            HiveDecimal hdLeft = PrimitiveObjectInspectorUtils.getHiveDecimal(left, this.leftOI);
            HiveDecimal hdRight = PrimitiveObjectInspectorUtils.getHiveDecimal(right, this.rightOI);
            if (hdLeft == null || hdRight == null) {
                return null;
            }
            HiveDecimalWritable result = this.evaluate(hdLeft, hdRight);
            return this.resultOI.getPrimitiveWritableObject(result);
        }
        if ((left = this.converterLeft.convert(left)) == null) {
            return null;
        }
        if ((right = this.converterRight.convert(right)) == null) {
            return null;
        }
        switch (this.resultOI.getPrimitiveCategory()) {
            case BYTE: {
                return this.evaluate((ByteWritable)((Object)left), (ByteWritable)((Object)right));
            }
            case SHORT: {
                return this.evaluate((ShortWritable)left, (ShortWritable)right);
            }
            case INT: {
                return this.evaluate((IntWritable)left, (IntWritable)right);
            }
            case LONG: {
                return this.evaluate((LongWritable)left, (LongWritable)right);
            }
            case FLOAT: {
                return this.evaluate((FloatWritable)left, (FloatWritable)right);
            }
            case DOUBLE: {
                return this.evaluate((DoubleWritable)((Object)left), (DoubleWritable)((Object)right));
            }
        }
        throw new RuntimeException("Unexpected type in evaluating " + this.opName + ": " + (Object)((Object)this.resultOI.getPrimitiveCategory()));
    }

    protected ByteWritable evaluate(ByteWritable left, ByteWritable right) {
        return null;
    }

    protected ShortWritable evaluate(ShortWritable left, ShortWritable right) {
        return null;
    }

    protected IntWritable evaluate(IntWritable left, IntWritable right) {
        return null;
    }

    protected LongWritable evaluate(LongWritable left, LongWritable right) {
        return null;
    }

    protected FloatWritable evaluate(FloatWritable left, FloatWritable right) {
        return null;
    }

    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        return null;
    }

    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        return null;
    }

    private PrimitiveTypeInfo deriveResultTypeInfo() throws UDFArgumentException {
        PrimitiveTypeInfo left = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(this.leftOI);
        PrimitiveTypeInfo right = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(this.rightOI);
        if (!FunctionRegistry.isNumericType(left) || !FunctionRegistry.isNumericType(right)) {
            ArrayList<TypeInfo> argTypeInfos = new ArrayList<TypeInfo>(2);
            argTypeInfos.add(left);
            argTypeInfos.add(right);
            throw new NoMatchingMethodException(this.getClass(), argTypeInfos, null);
        }
        if (!FunctionRegistry.isExactNumericType(left) || !FunctionRegistry.isExactNumericType(right)) {
            return this.deriveResultApproxTypeInfo();
        }
        return this.deriveResultExactTypeInfo();
    }

    protected PrimitiveTypeInfo deriveResultApproxTypeInfo() {
        PrimitiveObjectInspector.PrimitiveCategory commonCat;
        PrimitiveTypeInfo left = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(this.leftOI);
        PrimitiveTypeInfo right = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(this.rightOI);
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(left.getPrimitiveCategory()) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            left = TypeInfoFactory.doubleTypeInfo;
        }
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(right.getPrimitiveCategory()) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            right = TypeInfoFactory.doubleTypeInfo;
        }
        if ((commonCat = FunctionRegistry.getCommonCategory(left, right)) == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return TypeInfoFactory.doubleTypeInfo;
        }
        if (commonCat == null) {
            return TypeInfoFactory.doubleTypeInfo;
        }
        return left.getPrimitiveCategory() == commonCat ? left : right;
    }

    protected PrimitiveTypeInfo deriveResultExactTypeInfo() {
        PrimitiveTypeInfo right;
        PrimitiveTypeInfo left = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(this.leftOI);
        PrimitiveObjectInspector.PrimitiveCategory commonCat = FunctionRegistry.getCommonCategory(left, right = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(this.rightOI));
        if (commonCat == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return this.deriveResultDecimalTypeInfo();
        }
        return left.getPrimitiveCategory() == commonCat ? left : right;
    }

    protected DecimalTypeInfo deriveResultDecimalTypeInfo() {
        int prec1 = this.leftOI.precision();
        int prec2 = this.rightOI.precision();
        int scale1 = this.leftOI.scale();
        int scale2 = this.rightOI.scale();
        return this.deriveResultDecimalTypeInfo(prec1, scale1, prec2, scale2);
    }

    protected abstract DecimalTypeInfo deriveResultDecimalTypeInfo(int var1, int var2, int var3, int var4);

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2) : this.opDisplayName + " with " + children.length + " children";
        return "(" + children[0] + " " + this.opDisplayName + " " + children[1] + ")";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFBaseNumeric other = (GenericUDFBaseNumeric)newInstance;
        other.confLookupNeeded = this.confLookupNeeded;
        other.ansiSqlArithmetic = this.ansiSqlArithmetic;
    }

    public boolean isConfLookupNeeded() {
        return this.confLookupNeeded;
    }

    public void setConfLookupNeeded(boolean confLookupNeeded) {
        this.confLookupNeeded = confLookupNeeded;
    }

    public boolean isAnsiSqlArithmetic() {
        return this.ansiSqlArithmetic;
    }

    public void setAnsiSqlArithmetic(boolean ansiSqlArithmetic) {
        this.ansiSqlArithmetic = ansiSqlArithmetic;
    }

    public PrimitiveTypeInfo deriveMinArgumentCast(ExprNodeDesc childExpr, TypeInfo targetType) {
        assert (targetType instanceof PrimitiveTypeInfo) : "Not a primitive type" + targetType;
        PrimitiveTypeInfo pti = (PrimitiveTypeInfo)targetType;
        if (pti.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL || !(childExpr.getTypeInfo() instanceof PrimitiveTypeInfo)) {
            return pti;
        }
        PrimitiveTypeInfo childTi = (PrimitiveTypeInfo)childExpr.getTypeInfo();
        return HiveDecimalUtils.getDecimalTypeForPrimitiveCategory(childTi);
    }
}

