/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class CounterStatsAggregator
implements StatsAggregator,
StatsCollectionTaskIndependent {
    private static final Log LOG = LogFactory.getLog((String)CounterStatsAggregator.class.getName());
    private Counters counters;
    private JobClient jc;

    @Override
    public boolean connect(StatsCollectionContext scc) {
        Task sourceTask = scc.getTask();
        if (sourceTask instanceof MapRedTask) {
            try {
                this.jc = new JobClient(this.toJobConf(scc.getHiveConf()));
                RunningJob job = this.jc.getJob(((MapRedTask)sourceTask).getJobID());
                if (job != null) {
                    this.counters = job.getCounters();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to get Job instance for " + sourceTask.getJobID()), (Throwable)e);
            }
        }
        return this.counters != null;
    }

    private JobConf toJobConf(Configuration hconf) {
        return hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf, ExecDriver.class);
    }

    @Override
    public String aggregateStats(String counterGrpName, String statType) {
        long value = 0L;
        if (this.counters != null) {
            value = this.counters.getGroup(counterGrpName).getCounter(statType);
        }
        return String.valueOf(value);
    }

    @Override
    public boolean closeConnection(StatsCollectionContext scc) {
        try {
            this.jc.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing job client for stats aggregator.", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean cleanUp(String keyPrefix) {
        return true;
    }
}

