/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.CheckJDOException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.ParallelDirectoryRenamer;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;

public class Hive {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Hive");
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private UserGroupInformation owner;
    private final Map<String, Long> metaCallTimeMap = new HashMap<String, Long>();
    private static ThreadLocal<Hive> hiveDB = new ThreadLocal<Hive>(){

        @Override
        protected synchronized Hive initialValue() {
            return null;
        }

        @Override
        public synchronized void remove() {
            if (this.get() != null) {
                ((Hive)this.get()).close();
            }
            super.remove();
        }
    };
    private static final AtomicInteger didRegisterAllFuncs = new AtomicInteger(0);
    private static final int REG_FUNCS_NO = 0;
    private static final int REG_FUNCS_DONE = 2;
    private static final int REG_FUNCS_PENDING = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllFunctionsOnce() throws HiveException {
        boolean breakLoop = false;
        block21: while (!breakLoop) {
            int val = didRegisterAllFuncs.get();
            switch (val) {
                case 0: {
                    if (!didRegisterAllFuncs.compareAndSet(val, 1)) continue block21;
                    breakLoop = true;
                    continue block21;
                }
                case 1: {
                    AtomicInteger atomicInteger = didRegisterAllFuncs;
                    synchronized (atomicInteger) {
                        try {
                            didRegisterAllFuncs.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
            throw new AssertionError(val);
        }
        try {
            this.reloadFunctions();
            didRegisterAllFuncs.compareAndSet(1, 2);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to register all functions.", (Throwable)e);
            didRegisterAllFuncs.compareAndSet(1, 0);
            throw new HiveException(e);
        }
        finally {
            AtomicInteger atomicInteger = didRegisterAllFuncs;
            synchronized (atomicInteger) {
                didRegisterAllFuncs.notifyAll();
            }
        }
    }

    public void reloadFunctions() throws HiveException {
        HashSet<String> registryFunctions = new HashSet<String>(FunctionRegistry.getFunctionNames(".+\\..+"));
        for (Function function : this.getAllFunctions()) {
            String functionName = function.getFunctionName();
            try {
                LOG.info((Object)("Registering function " + functionName + " " + function.getClassName()));
                String qualFunc = FunctionUtils.qualifyFunctionName(functionName, function.getDbName());
                FunctionRegistry.registerPermanentFunction(qualFunc, function.getClassName(), false, FunctionTask.toFunctionResource(function.getResourceUris()));
                registryFunctions.remove(qualFunc);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to register persistent function " + functionName + ":" + function.getClassName() + ". Ignore and continue."));
            }
        }
        for (String functionName : registryFunctions) {
            try {
                FunctionRegistry.unregisterPermanentFunction(functionName);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to unregister persistent function " + functionName + "on reload. Ignore and continue."));
            }
        }
    }

    public static Hive get(Configuration c, Class<?> clazz) throws HiveException {
        return Hive.get(c instanceof HiveConf ? (HiveConf)c : new HiveConf(c, clazz));
    }

    public static Hive get(HiveConf c) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || !db.isCurrentUserOwner() || db.metaStoreClient != null && !db.metaStoreClient.isCompatibleWith(c)) {
            return Hive.get(c, true);
        }
        db.conf = c;
        return db;
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || needsRefresh || !db.isCurrentUserOwner()) {
            if (db != null) {
                LOG.debug((Object)("Creating new db. db = " + db + ", needsRefresh = " + needsRefresh + ", db.isCurrentUserOwner = " + db.isCurrentUserOwner()));
            }
            Hive.closeCurrent();
            c.set("fs.scheme.class", "dfs");
            Hive newdb = new Hive(c);
            hiveDB.set(newdb);
            return newdb;
        }
        db.conf = c;
        return db;
    }

    public static Hive get() throws HiveException {
        Hive db = hiveDB.get();
        if (db != null && !db.isCurrentUserOwner()) {
            LOG.debug((Object)("Creating new db. db.isCurrentUserOwner = " + db.isCurrentUserOwner()));
            db.close();
            db = null;
        }
        if (db == null) {
            SessionState session = SessionState.get();
            db = new Hive(session == null ? new HiveConf(Hive.class) : session.getConf());
            hiveDB.set(db);
        }
        return db;
    }

    public static void set(Hive hive) {
        hiveDB.set(hive);
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c) throws HiveException {
        this.conf = c;
        this.registerAllFunctionsOnce();
    }

    private boolean isCurrentUserOwner() throws HiveException {
        try {
            return this.owner == null || this.owner.equals((Object)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new HiveException("Error getting current user: " + e.getMessage(), e);
        }
    }

    private void close() {
        LOG.debug((Object)"Closing current thread's connection to Hive Metastore.");
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
            this.metaStoreClient = null;
        }
        if (this.owner != null) {
            this.owner = null;
        }
    }

    public void createDatabase(Database db, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDatabase(db);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createDatabase(Database db) throws AlreadyExistsException, HiveException {
        this.createDatabase(db, false);
    }

    public void dropDatabase(String name) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropDatabase(name, deleteData, ignoreUnknownDb, cascade);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, bucketCount, bucketCols, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols, Map<String, String> parameters) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = this.newTable(tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        if (parameters != null) {
            tbl.setParamters(parameters);
        }
        this.createTable(tbl);
    }

    public void alterTable(String tblName, Table newTbl) throws InvalidOperationException, HiveException {
        this.alterTable(tblName, newTbl, false);
    }

    public void alterTable(String tblName, Table newTbl, boolean cascade) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        try {
            if (newTbl.getParameters() != null) {
                newTbl.getParameters().remove("transient_lastDdlTime");
            }
            newTbl.checkValidity();
            this.getMSC().alter_table(names[0], names[1], newTbl.getTTable(), cascade);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
    }

    public void alterIndex(String baseTableName, String indexName, Index newIdx) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(baseTableName);
        this.alterIndex(names[0], names[1], indexName, newIdx);
    }

    public void alterIndex(String dbName, String baseTblName, String idxName, Index newIdx) throws InvalidOperationException, HiveException {
        try {
            this.getMSC().alter_index(dbName, baseTblName, idxName, newIdx);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter index. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter index. " + e.getMessage(), e);
        }
    }

    public void alterPartition(String tblName, Partition newPart) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        this.alterPartition(names[0], names[1], newPart);
    }

    public void alterPartition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, HiveException {
        try {
            if (newPart.getParameters() != null) {
                newPart.getParameters().remove("transient_lastDdlTime");
            }
            newPart.checkValidity();
            this.getMSC().alter_partition(dbName, tblName, newPart.getTPartition());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    public void alterPartitions(String tblName, List<Partition> newParts) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> newTParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        try {
            for (Partition tmpPart : newParts) {
                if (tmpPart.getParameters() != null) {
                    tmpPart.getParameters().remove("transient_lastDdlTime");
                }
                newTParts.add(tmpPart.getTPartition());
            }
            this.getMSC().alter_partitions(names[0], names[1], newTParts);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    public void renamePartition(Table tbl, Map<String, String> oldPartSpec, Partition newPart) throws HiveException {
        try {
            LinkedHashMap<String, String> newPartSpec = newPart.getSpec();
            if (oldPartSpec.keySet().size() != tbl.getPartCols().size() || newPartSpec.keySet().size() != tbl.getPartCols().size()) {
                throw new HiveException("Unable to rename partition to the same name: number of partition cols don't match. ");
            }
            if (!oldPartSpec.keySet().equals(newPartSpec.keySet())) {
                throw new HiveException("Unable to rename partition to the same name: old and new partition cols don't match. ");
            }
            ArrayList<String> pvals = new ArrayList<String>();
            for (FieldSchema field : tbl.getPartCols()) {
                String val = oldPartSpec.get(field.getName());
                if (val == null || val.length() == 0) {
                    throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
                }
                if (val == null) continue;
                pvals.add(val);
            }
            this.getMSC().renamePartition(tbl.getDbName(), tbl.getTableName(), pvals, newPart.getTPartition());
        }
        catch (InvalidOperationException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
    }

    public void alterDatabase(String dbName, Database db) throws HiveException {
        try {
            this.getMSC().alterDatabase(dbName, db);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Database " + dbName + " does not exists.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        try {
            CreateTableAutomaticGrant grants;
            if (tbl.getDbName() == null || "".equals(tbl.getDbName().trim())) {
                tbl.setDbName(SessionState.get().getCurrentDatabase());
            }
            if (tbl.getCols().size() == 0 || tbl.getSd().getColsSize() == 0) {
                tbl.setFields(MetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)tbl.getDeserializer()));
            }
            tbl.checkValidity();
            if (tbl.getParameters() != null) {
                tbl.getParameters().remove("transient_lastDdlTime");
            }
            org.apache.hadoop.hive.metastore.api.Table tTbl = tbl.getTTable();
            PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
            SessionState ss = SessionState.get();
            if (ss != null && (grants = ss.getCreateTableGrants()) != null) {
                principalPrivs.setUserPrivileges(grants.getUserGrants());
                principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                principalPrivs.setRolePrivileges(grants.getRoleGrants());
                tTbl.setPrivileges(principalPrivs);
            }
            this.getMSC().createTable(tTbl);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createIndex(String tableName, String indexName, String indexHandlerClass, List<String> indexedCols, String indexTblName, boolean deferredRebuild, String inputFormat, String outputFormat, String serde, String storageHandler, String location, Map<String, String> idxProps, Map<String, String> tblProps, Map<String, String> serdeProps, String collItemDelim, String fieldDelim, String fieldEscape, String lineDelim, String mapKeyDelim, String indexComment) throws HiveException {
        try {
            String tdname = Utilities.getDatabaseName(tableName);
            String idname = Utilities.getDatabaseName(indexTblName);
            if (!idname.equals(tdname)) {
                throw new HiveException("Index on different database (" + idname + ") from base table (" + tdname + ") is not supported.");
            }
            Index old_index = null;
            try {
                old_index = this.getIndex(tableName, indexName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (old_index != null) {
                throw new HiveException("Index " + indexName + " already exists on table " + tableName);
            }
            org.apache.hadoop.hive.metastore.api.Table baseTbl = this.getTable(tableName).getTTable();
            if (baseTbl.getTableType() == TableType.VIRTUAL_VIEW.toString()) {
                throw new HiveException("tableName=" + tableName + " is a VIRTUAL VIEW. Index on VIRTUAL VIEW is not supported.");
            }
            if (baseTbl.isTemporary()) {
                throw new HiveException("tableName=" + tableName + " is a TEMPORARY TABLE. Index on TEMPORARY TABLE is not supported.");
            }
            org.apache.hadoop.hive.metastore.api.Table temp = null;
            try {
                temp = this.getTable(indexTblName).getTTable();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (temp != null) {
                throw new HiveException("Table name " + indexTblName + " already exists. Choose another name.");
            }
            SerDeInfo serdeInfo = new SerDeInfo();
            serdeInfo.setName(indexTblName);
            if (serde != null) {
                serdeInfo.setSerializationLib(serde);
            } else if (storageHandler == null) {
                serdeInfo.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                HiveStorageHandler sh = HiveUtils.getStorageHandler(this.getConf(), storageHandler);
                String serDeClassName = sh.getSerDeClass().getName();
                serdeInfo.setSerializationLib(serDeClassName);
            }
            serdeInfo.setParameters(new HashMap());
            if (fieldDelim != null) {
                serdeInfo.getParameters().put("field.delim", fieldDelim);
                serdeInfo.getParameters().put("serialization.format", fieldDelim);
            }
            if (fieldEscape != null) {
                serdeInfo.getParameters().put("escape.delim", fieldEscape);
            }
            if (collItemDelim != null) {
                serdeInfo.getParameters().put("colelction.delim", collItemDelim);
            }
            if (mapKeyDelim != null) {
                serdeInfo.getParameters().put("mapkey.delim", mapKeyDelim);
            }
            if (lineDelim != null) {
                serdeInfo.getParameters().put("line.delim", lineDelim);
            }
            if (serdeProps != null) {
                for (Map.Entry<String, String> m : serdeProps.entrySet()) {
                    serdeInfo.getParameters().put(m.getKey(), m.getValue());
                }
            }
            ArrayList<FieldSchema> indexTblCols = new ArrayList<FieldSchema>();
            ArrayList<Order> sortCols = new ArrayList<Order>();
            int k = 0;
            Table metaBaseTbl = new Table(baseTbl);
            for (int i = 0; i < metaBaseTbl.getCols().size(); ++i) {
                FieldSchema col = metaBaseTbl.getCols().get(i);
                if (!indexedCols.contains(col.getName())) continue;
                indexTblCols.add(col);
                sortCols.add(new Order(col.getName(), 1));
                ++k;
            }
            if (k != indexedCols.size()) {
                throw new RuntimeException("Check the index columns, they should appear in the table being indexed.");
            }
            int time = (int)(System.currentTimeMillis() / 1000L);
            org.apache.hadoop.hive.metastore.api.Table tt = null;
            HiveIndexHandler indexHandler = HiveUtils.getIndexHandler(this.getConf(), indexHandlerClass);
            String itname = Utilities.getTableName(indexTblName);
            if (indexHandler.usesIndexTable()) {
                CreateTableAutomaticGrant grants;
                SessionState ss;
                tt = new Table(idname, itname).getTTable();
                List partKeys = baseTbl.getPartitionKeys();
                tt.setPartitionKeys(partKeys);
                tt.setTableType(TableType.INDEX_TABLE.toString());
                if (tblProps != null) {
                    for (Map.Entry<String, String> prop : tblProps.entrySet()) {
                        tt.putToParameters(prop.getKey(), prop.getValue());
                    }
                }
                if ((ss = SessionState.get()) != null && (grants = ss.getCreateTableGrants()) != null) {
                    PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
                    principalPrivs.setUserPrivileges(grants.getUserGrants());
                    principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                    principalPrivs.setRolePrivileges(grants.getRoleGrants());
                    tt.setPrivileges(principalPrivs);
                }
            }
            if (!deferredRebuild) {
                throw new RuntimeException("Please specify deferred rebuild using \" WITH DEFERRED REBUILD \".");
            }
            StorageDescriptor indexSd = new StorageDescriptor(indexTblCols, location, inputFormat, outputFormat, false, -1, serdeInfo, null, sortCols, null);
            String ttname = Utilities.getTableName(tableName);
            Index indexDesc = new Index(indexName, indexHandlerClass, tdname, ttname, time, time, itname, indexSd, new HashMap(), deferredRebuild);
            if (indexComment != null) {
                indexDesc.getParameters().put("comment", indexComment);
            }
            if (idxProps != null) {
                indexDesc.getParameters().putAll(idxProps);
            }
            indexHandler.analyzeIndexDefinition(baseTbl, indexDesc, tt);
            this.getMSC().createIndex(indexDesc, tt);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Index getIndex(String baseTableName, String indexName) throws HiveException {
        String[] names = Utilities.getDbTableName(baseTableName);
        return this.getIndex(names[0], names[1], indexName);
    }

    public Index getIndex(String dbName, String baseTableName, String indexName) throws HiveException {
        try {
            return this.getMSC().getIndex(dbName, baseTableName, indexName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean dropIndex(String baseTableName, String index_name, boolean throwException, boolean deleteData) throws HiveException {
        String[] names = Utilities.getDbTableName(baseTableName);
        return this.dropIndex(names[0], names[1], index_name, throwException, deleteData);
    }

    public boolean dropIndex(String db_name, String tbl_name, String index_name, boolean throwException, boolean deleteData) throws HiveException {
        try {
            return this.getMSC().dropIndex(db_name, tbl_name, index_name, deleteData);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                throw new HiveException("Index " + index_name + " doesn't exist. ", e);
            }
            return false;
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public void dropTable(String tableName, boolean ifPurge) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        this.dropTable(names[0], names[1], true, true, ifPurge);
    }

    public void dropTable(String tableName) throws HiveException {
        this.dropTable(tableName, false);
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        this.dropTable(dbName, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab, ifPurge);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String tableName) throws HiveException {
        return this.getTable(tableName, true);
    }

    public Table getTable(String tableName, boolean throwException) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        return this.getTable(names[0], names[1], throwException);
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        if (tableName.contains(".")) {
            String[] names = Utilities.getDbTableName(tableName);
            return this.getTable(names[0], names[1], true);
        }
        return this.getTable(dbName, tableName, true);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            tTable = this.getMSC().getTable(dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                LOG.error((Object)("Table " + tableName + " not found: " + e.getMessage()));
                throw new InvalidTableException(tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName + ". " + e.getMessage(), e);
        }
        if (!TableType.VIRTUAL_VIEW.toString().equals(tTable.getTableType())) {
            char[] b;
            Map parameters = tTable.getSd().getParameters();
            String sf = (String)parameters.get("serialization.format");
            if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
                parameters.put("serialization.format", Integer.toString(b[0]));
            }
            if (MetadataTypedColumnsetSerDe.class.getName().equals(tTable.getSd().getSerdeInfo().getSerializationLib()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        }
        return new Table(tTable);
    }

    public List<String> getAllTables() throws HiveException {
        return this.getAllTables(SessionState.get().getCurrentDatabase());
    }

    public List<String> getAllTables(String dbName) throws HiveException {
        return this.getTablesByPattern(dbName, ".*");
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesByPattern(SessionState.get().getCurrentDatabase(), tablePattern);
    }

    public List<String> getTablesByPattern(String dbName, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(dbName, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(database, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllDatabases() throws HiveException {
        try {
            return this.getMSC().getAllDatabases();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getDatabasesByPattern(String databasePattern) throws HiveException {
        try {
            return this.getMSC().getDatabases(databasePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().grant_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_privileges(privileges, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean databaseExists(String dbName) throws HiveException {
        return this.getDatabase(dbName) != null;
    }

    public Database getDatabase(String dbName) throws HiveException {
        try {
            return this.getMSC().getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Database getDatabaseCurrent() throws HiveException {
        String currentDb = SessionState.get().getCurrentDatabase();
        return this.getDatabase(currentDb);
    }

    public void loadPartition(Path loadPath, String tableName, Map<String, String> partSpec, boolean replace, boolean holdDDLTime, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcid) throws HiveException {
        Table tbl = this.getTable(tableName);
        this.loadPartition(loadPath, tbl, partSpec, replace, holdDDLTime, inheritTableSpecs, isSkewedStoreAsSubdir, isSrcLocal, isAcid);
    }

    public Partition loadPartition(Path loadPath, Table tbl, Map<String, String> partSpec, boolean replace, boolean holdDDLTime, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcid) throws HiveException {
        Path tblDataLocationPath = tbl.getDataLocation();
        Partition newTPart = null;
        try {
            Partition oldPart = this.getPartition(tbl, partSpec, false);
            Path oldPartPath = oldPart != null ? oldPart.getDataLocation() : null;
            Path newPartPath = null;
            if (inheritTableSpecs) {
                FileSystem loadPathFS;
                FileSystem oldPartPathFS;
                Path partPath = new Path(tbl.getDataLocation(), Warehouse.makePartPath(partSpec));
                newPartPath = new Path(tblDataLocationPath.toUri().getScheme(), tblDataLocationPath.toUri().getAuthority(), partPath.toUri().getPath());
                if (oldPart != null && FileUtils.equalsFileSystem(oldPartPathFS = oldPartPath.getFileSystem((Configuration)this.getConf()), loadPathFS = loadPath.getFileSystem((Configuration)this.getConf()))) {
                    newPartPath = oldPartPath;
                }
            } else {
                newPartPath = oldPartPath;
            }
            List<Path> newFiles = null;
            if (replace || oldPart == null && !isAcid) {
                Hive.replaceFiles(tbl.getPath(), loadPath, newPartPath, oldPartPath, this.getConf(), isSrcLocal);
            } else {
                if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary() && oldPart != null) {
                    newFiles = Collections.synchronizedList(new ArrayList());
                }
                FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                Hive.copyFiles(this.conf, loadPath, newPartPath, fs, isSrcLocal, isAcid, newFiles);
            }
            boolean forceCreate = !holdDDLTime;
            newTPart = this.getPartition(tbl, partSpec, forceCreate, newPartPath.toString(), inheritTableSpecs, newFiles);
            if (!holdDDLTime) {
                if (isSkewedStoreAsSubdir) {
                    org.apache.hadoop.hive.metastore.api.Partition newCreatedTpart = newTPart.getTPartition();
                    SkewedInfo skewedInfo = newCreatedTpart.getSd().getSkewedInfo();
                    Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(newPartPath, skewedInfo);
                    skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
                    newCreatedTpart.getSd().setSkewedInfo(skewedInfo);
                    if (!this.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                        newTPart.getParameters().put("COLUMN_STATS_ACCURATE", "false");
                    }
                    this.alterPartition(tbl.getDbName(), tbl.getTableName(), new Partition(tbl, newCreatedTpart));
                    newTPart = this.getPartition(tbl, partSpec, true, newPartPath.toString(), inheritTableSpecs, newFiles);
                    return new Partition(tbl, newCreatedTpart);
                }
                if (!this.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    newTPart.getParameters().put("COLUMN_STATS_ACCURATE", "false");
                    this.alterPartition(tbl.getDbName(), tbl.getTableName(), new Partition(tbl, newTPart.getTPartition()));
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (MetaException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (InvalidOperationException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return newTPart;
    }

    private void walkDirTree(FileStatus fSta, FileSystem fSys, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) throws IOException {
        if (!fSta.isDir()) {
            this.constructOneLBLocationMap(fSta, skewedColValueLocationMaps, newPartPath, skewedInfo);
            return;
        }
        FileStatus[] children = fSys.listStatus(fSta.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (children != null) {
            for (FileStatus child : children) {
                this.walkDirTree(child, fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
            }
        }
    }

    private void constructOneLBLocationMap(FileStatus fSta, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) {
        String[] dirNames;
        Path lbdPath = fSta.getPath().getParent();
        ArrayList<String> skewedValue = new ArrayList<String>();
        String lbDirName = FileUtils.unescapePathName(lbdPath.toString());
        String partDirName = FileUtils.unescapePathName(newPartPath.toString());
        String lbDirSuffix = lbDirName.replace(partDirName, "");
        for (String dirName : dirNames = lbDirSuffix.split("/")) {
            String[] kv;
            if (dirName == null || dirName.length() <= 0 || dirName.equalsIgnoreCase("HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME") || (kv = dirName.split("=")).length != 2) continue;
            skewedValue.add(kv[1]);
        }
        if (skewedValue.size() > 0 && skewedValue.size() == skewedInfo.getSkewedColNames().size() && !skewedColValueLocationMaps.containsKey(skewedValue)) {
            skewedColValueLocationMaps.put(skewedValue, lbdPath.toString());
        }
    }

    private Map<List<String>, String> constructListBucketingLocationMap(Path newPartPath, SkewedInfo skewedInfo) throws IOException, FileNotFoundException {
        HashMap<List<String>, String> skewedColValueLocationMaps = new HashMap<List<String>, String>();
        FileSystem fSys = newPartPath.getFileSystem((Configuration)this.conf);
        this.walkDirTree(fSys.getFileStatus(newPartPath), fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
        return skewedColValueLocationMaps;
    }

    private Set<Path> getValidPartitionsInPath(int numDP, Path loadPath) throws HiveException {
        HashSet<Path> validPartitions = new HashSet<Path>();
        try {
            FileStatus[] leafStatus;
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            for (FileStatus s : leafStatus = HiveStatsUtils.getFileStatusRecurse(loadPath, numDP, fs)) {
                if (!s.isDirectory()) {
                    throw new HiveException("partition " + s.getPath() + " is not a directory!");
                }
                validPartitions.add(s.getPath());
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        int partsToLoad = validPartitions.size();
        if (partsToLoad == 0) {
            LOG.warn((Object)"No partition is generated by dynamic partitioning");
        }
        if (partsToLoad > this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS)) {
            throw new HiveException("Number of dynamic partitions created is " + partsToLoad + ", which is more than " + this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS) + ". To solve this try to set " + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + " to at least " + partsToLoad + '.');
        }
        return validPartitions;
    }

    public Map<Map<String, String>, Partition> loadDynamicPartitions(Path loadPath, String tableName, Map<String, String> partSpec, final boolean replace, int numDP, final boolean holdDDLTime, final boolean listBucketingEnabled, final boolean isAcid) throws HiveException {
        final Map<Map<String, String>, Partition> partitionsMap = Collections.synchronizedMap(new LinkedHashMap());
        int poolSize = this.conf.getInt(HiveConf.ConfVars.HIVE_LOAD_DYNAMIC_PARTITIONS_THREAD_COUNT.varname, 1);
        ExecutorService pool = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("load-dynamic-partitions-%d").build());
        final Table tbl = this.getTable(tableName);
        Set<Path> validPartitions = this.getValidPartitionsInPath(numDP, loadPath);
        int partsToLoad = validPartitions.size();
        final SessionState parentSession = SessionState.get();
        LinkedList<Future<Void>> futures = Lists.newLinkedList();
        try {
            for (final Path path : validPartitions) {
                final LinkedHashMap<String, String> linkedHashMap = Maps.newLinkedHashMap(partSpec);
                Warehouse.makeSpecFromName(linkedHashMap, (Path)path);
                futures.add(pool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            SessionState.setCurrentSessionState(parentSession);
                            LOG.info((Object)("New loading path = " + path + " with partSpec " + linkedHashMap));
                            Partition newPartition = Hive.this.loadPartition(path, tbl, (Map<String, String>)linkedHashMap, replace, holdDDLTime, true, listBucketingEnabled, false, isAcid);
                            partitionsMap.put(linkedHashMap, newPartition);
                            return null;
                        }
                        catch (Exception t) {
                            LOG.error((Object)("Exception when loading partition with parameters  partPath=" + path + ", " + " table=" + tbl.getTableName() + ", " + " partSpec=" + linkedHashMap + ", " + " replace=" + replace + ", " + " listBucketingEnabled=" + listBucketingEnabled + ", " + " isAcid=" + isAcid), (Throwable)t);
                            throw t;
                        }
                    }
                }));
            }
            pool.shutdown();
            LOG.debug((Object)("Number of partitions to be added is " + futures.size()));
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug((Object)("Cancelling " + futures.size() + " dynamic loading tasks"));
            for (Future future : futures) {
                future.cancel(true);
            }
            throw new HiveException("Exception when loading " + partsToLoad + " in table " + tbl.getTableName() + " with loadPath=" + loadPath, e);
        }
        return partitionsMap;
    }

    public void loadTable(Path loadPath, String tableName, boolean replace, boolean holdDDLTime, boolean isSrcLocal, boolean isSkewedStoreAsSubdir, boolean isAcid) throws HiveException {
        List<Path> newFiles = null;
        Table tbl = this.getTable(tableName);
        HiveConf sessionConf = SessionState.getSessionConf();
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary()) {
            newFiles = Collections.synchronizedList(new ArrayList());
        }
        if (replace) {
            Path tableDest = tbl.getPath();
            Hive.replaceFiles(tableDest, loadPath, tableDest, tableDest, sessionConf, isSrcLocal);
        } else {
            try {
                FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)sessionConf);
                Hive.copyFiles(sessionConf, loadPath, tbl.getPath(), fs, isSrcLocal, isAcid, newFiles);
            }
            catch (IOException e) {
                throw new HiveException("addFiles: filesystem error in check phase", e);
            }
        }
        if (!this.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            tbl.getParameters().put("COLUMN_STATS_ACCURATE", "false");
        } else {
            tbl.getParameters().put("STATS_GENERATED_VIA_STATS_TASK", "true");
        }
        try {
            if (isSkewedStoreAsSubdir) {
                SkewedInfo skewedInfo = tbl.getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(tbl.getPath(), skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
            }
        }
        catch (IOException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        if (!holdDDLTime) {
            try {
                this.alterTable(tableName, tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
        }
        this.fireInsertEvent(tbl, null, newFiles);
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        try {
            return new Partition(tbl, this.getMSC().add_partition(Partition.createMetaPartitionObject(tbl, partSpec, null)));
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<Partition> createPartitions(AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = this.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        int size = addPartitionDesc.getPartitionCount();
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> in = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(size);
        for (int i = 0; i < size; ++i) {
            in.add(this.convertAddSpecToMetaPartition(tbl, addPartitionDesc.getPartition(i)));
        }
        ArrayList<Partition> out = new ArrayList<Partition>();
        try {
            if (!addPartitionDesc.getReplaceMode()) {
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().add_partitions(in, addPartitionDesc.isIfNotExists(), true)) {
                    out.add(new Partition(tbl, outPart));
                }
            } else {
                this.getMSC().alter_partitions(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), in);
                ArrayList<String> part_names = new ArrayList<String>();
                for (org.apache.hadoop.hive.metastore.api.Partition p : in) {
                    part_names.add(Warehouse.makePartName(tbl.getPartitionKeys(), (List)p.getValues()));
                }
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().getPartitionsByNames(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), part_names)) {
                    out.add(new Partition(tbl, outPart));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return out;
    }

    private org.apache.hadoop.hive.metastore.api.Partition convertAddSpecToMetaPartition(Table tbl, AddPartitionDesc.OnePartitionDesc addSpec) throws HiveException {
        Path location;
        Path path = location = addSpec.getLocation() != null ? new Path(tbl.getPath(), addSpec.getLocation()) : null;
        if (location != null && !Utilities.isDefaultNameNode(this.conf)) {
            location = new Path(Utilities.getQualifiedPath(this.conf, location));
        }
        org.apache.hadoop.hive.metastore.api.Partition part = Partition.createMetaPartitionObject(tbl, addSpec.getPartSpec(), location);
        if (addSpec.getPartParams() != null) {
            part.setParameters(addSpec.getPartParams());
        }
        if (addSpec.getInputFormat() != null) {
            part.getSd().setInputFormat(addSpec.getInputFormat());
        }
        if (addSpec.getOutputFormat() != null) {
            part.getSd().setOutputFormat(addSpec.getOutputFormat());
        }
        if (addSpec.getNumBuckets() != -1) {
            part.getSd().setNumBuckets(addSpec.getNumBuckets());
        }
        if (addSpec.getCols() != null) {
            part.getSd().setCols(addSpec.getCols());
        }
        if (addSpec.getSerializationLib() != null) {
            part.getSd().getSerdeInfo().setSerializationLib(addSpec.getSerializationLib());
        }
        if (addSpec.getSerdeParams() != null) {
            part.getSd().getSerdeInfo().setParameters(addSpec.getSerdeParams());
        }
        if (addSpec.getBucketCols() != null) {
            part.getSd().setBucketCols(addSpec.getBucketCols());
        }
        if (addSpec.getSortCols() != null) {
            part.getSd().setSortCols(addSpec.getSortCols());
        }
        return part;
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, null, true, null);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath, boolean inheritTableSpecs) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, partPath, inheritTableSpecs, null);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath, boolean inheritTableSpecs, List<Path> newFiles) throws HiveException {
        tbl.validatePartColumnNames(partSpec, true);
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING) || val != null && val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            if (val == null) continue;
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
        }
        catch (NoSuchObjectException nsoe) {
            tpart = null;
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        try {
            if (forceCreate) {
                if (tpart == null) {
                    LOG.debug((Object)("creating partition for table " + tbl.getTableName() + " with partition spec : " + partSpec));
                    try {
                        tpart = this.getMSC().appendPartition(tbl.getDbName(), tbl.getTableName(), pvals);
                    }
                    catch (AlreadyExistsException aee) {
                        LOG.debug((Object)"Caught already exists exception, trying to alter partition instead");
                        tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
                        this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    }
                    catch (Exception e) {
                        if (CheckJDOException.isJDODataStoreException(e)) {
                            LOG.debug((Object)"Caught JDO exception, trying to alter partition instead");
                            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
                            if (tpart == null) {
                                this.cleanPartitionContents(new Path(partPath), tbl);
                                throw e;
                            }
                            this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                        }
                        this.cleanPartitionContents(new Path(partPath), tbl);
                        throw e;
                    }
                } else {
                    this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    this.fireInsertEvent(tbl, partSpec, newFiles);
                }
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, tpart);
    }

    private void cleanPartitionContents(Path newPartPath, Table tbl) {
        try {
            FileSystem newPathFileSystem = newPartPath.getFileSystem((Configuration)this.getConf());
            FileUtils.moveToTrash(newPathFileSystem, newPartPath, this.getConf());
        }
        catch (IOException io) {
            LOG.error((Object)"Could not delete partition directory contents after failed partition creation: ", (Throwable)io);
        }
    }

    private void alterPartitionSpec(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        LOG.debug((Object)("altering partition for table " + tbl.getTableName() + " with partition spec : " + partSpec));
        if (inheritTableSpecs) {
            tpart.getSd().setOutputFormat(tbl.getTTable().getSd().getOutputFormat());
            tpart.getSd().setInputFormat(tbl.getTTable().getSd().getInputFormat());
            tpart.getSd().getSerdeInfo().setSerializationLib(tbl.getSerializationLib());
            tpart.getSd().getSerdeInfo().setParameters(tbl.getTTable().getSd().getSerdeInfo().getParameters());
            tpart.getSd().setBucketCols(tbl.getBucketCols());
            tpart.getSd().setNumBuckets(tbl.getNumBuckets());
            tpart.getSd().setSortCols(tbl.getSortCols());
        }
        if (partPath == null || partPath.trim().equals("")) {
            throw new HiveException("new partition path should not be null or empty.");
        }
        tpart.getSd().setLocation(partPath);
        tpart.getParameters().put("STATS_GENERATED_VIA_STATS_TASK", "true");
        String fullName = tbl.getTableName();
        if (!StringUtils.isEmpty(tbl.getDbName())) {
            fullName = tbl.getDbName() + "." + tbl.getTableName();
        }
        this.alterPartition(fullName, new Partition(tbl, tpart));
    }

    private void fireInsertEvent(Table tbl, Map<String, String> partitionSpec, List<Path> newFiles) throws HiveException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug((Object)"Firing dml insert event");
            if (tbl.isTemporary()) {
                LOG.debug((Object)("Not firing dml insert event as " + tbl.getTableName() + " is temporary"));
                return;
            }
            FireEventRequestData data = new FireEventRequestData();
            InsertEventRequestData insertData = new InsertEventRequestData();
            data.setInsertData(insertData);
            if (newFiles != null && newFiles.size() > 0) {
                for (Path p : newFiles) {
                    insertData.addToFilesAdded(p.toString());
                }
            }
            FireEventRequest rqst = new FireEventRequest(true, data);
            rqst.setDbName(tbl.getDbName());
            rqst.setTableName(tbl.getTableName());
            if (partitionSpec != null && partitionSpec.size() > 0) {
                ArrayList<String> partVals = new ArrayList<String>(partitionSpec.size());
                for (FieldSchema fs : tbl.getPartitionKeys()) {
                    partVals.add(partitionSpec.get(fs.getName()));
                }
                rqst.setPartitionVals(partVals);
            }
            try {
                this.getMSC().fireListenerEvent(rqst);
            }
            catch (TException e) {
                throw new HiveException(e);
            }
        }
    }

    public boolean dropPartition(String tblName, List<String> part_vals, boolean deleteData) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.dropPartition(names[0], names[1], part_vals, deleteData);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws HiveException {
        return this.dropPartition(db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partVals, PartitionDropOptions options) throws HiveException {
        try {
            return this.getMSC().dropPartition(dbName, tableName, partVals, options);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<Partition> dropPartitions(String tblName, List<DropTableDesc.PartSpec> partSpecs, boolean deleteData, boolean ignoreProtection, boolean ifExists) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.dropPartitions(names[0], names[1], partSpecs, deleteData, ignoreProtection, ifExists);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<DropTableDesc.PartSpec> partSpecs, boolean deleteData, boolean ignoreProtection, boolean ifExists) throws HiveException {
        return this.dropPartitions(dbName, tblName, partSpecs, PartitionDropOptions.instance().deleteData(deleteData).ignoreProtection(ignoreProtection).ifExists(ifExists));
    }

    public List<Partition> dropPartitions(String tblName, List<DropTableDesc.PartSpec> partSpecs, PartitionDropOptions dropOptions) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.dropPartitions(names[0], names[1], partSpecs, dropOptions);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<DropTableDesc.PartSpec> partSpecs, PartitionDropOptions dropOptions) throws HiveException {
        try {
            Table tbl = this.getTable(dbName, tblName);
            ArrayList<ObjectPair<Integer, byte[]>> partExprs = new ArrayList<ObjectPair<Integer, byte[]>>(partSpecs.size());
            for (DropTableDesc.PartSpec partSpec : partSpecs) {
                partExprs.add(new ObjectPair<Integer, byte[]>(partSpec.getPrefixLength(), Utilities.serializeExpressionToKryo(partSpec.getPartSpec())));
            }
            List tParts = this.getMSC().dropPartitions(dbName, tblName, partExprs, dropOptions);
            return Hive.convertFromMetastore(tbl, tParts);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<String> getPartitionNames(String tblName, short max) throws HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        return this.getPartitionNames(names[0], names[1], max);
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        List names = null;
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<String> getPartitionNames(String dbName, String tblName, Map<String, String> partSpec, short max) throws HiveException {
        List names = null;
        Table t = this.getTable(dbName, tblName);
        List pvals = MetaStoreUtils.getPvals(t.getPartCols(), partSpec);
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, pvals, max);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<Partition> getPartitions(Table tbl) throws HiveException {
        if (tbl.isPartitioned()) {
            List tParts;
            try {
                tParts = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), (short)-1, this.getUserName(), this.getGroupNames());
            }
            catch (Exception e) {
                LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
            ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
            for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                parts.add(new Partition(tbl, tpart));
            }
            return parts;
        }
        Partition part = new Partition(tbl);
        ArrayList<Partition> parts = new ArrayList<Partition>(1);
        parts.add(part);
        return parts;
    }

    public Set<Partition> getAllPartitionsOf(Table tbl) throws HiveException {
        List tParts;
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet(new Partition(tbl));
        }
        try {
            tParts = this.getMSC().listPartitions(tbl.getDbName(), tbl.getTableName(), (short)-1);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        LinkedHashSet<Partition> parts = new LinkedHashSet<Partition>(tParts.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
            parts.add(new Partition(tbl, tpart));
        }
        return parts;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec, short limit) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List partialPvals = MetaStoreUtils.getPvals(tbl.getPartCols(), partialPartSpec);
        List partitions = null;
        try {
            partitions = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), partialPvals, limit, this.getUserName(), this.getGroupNames());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ArrayList<Partition> qlPartitions = new ArrayList<Partition>();
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            qlPartitions.add(new Partition(tbl, p));
        }
        return qlPartitions;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        return this.getPartitions(tbl, partialPartSpec, (short)-1);
    }

    public List<Partition> getPartitionsByNames(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List<String> names = this.getPartitionNames(tbl.getDbName(), tbl.getTableName(), partialPartSpec, (short)-1);
        List<Partition> partitions = this.getPartitionsByNames(tbl, names);
        return partitions;
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>(partNames.size());
        int batchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
        int nParts = partNames.size();
        int nBatches = nParts / batchSize;
        try {
            List tParts;
            for (int i = 0; i < nBatches; ++i) {
                List tParts2 = this.getMSC().getPartitionsByNames(tbl.getDbName(), tbl.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
                if (tParts2 == null) continue;
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts2) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
            if (nParts > nBatches * batchSize && (tParts = this.getMSC().getPartitionsByNames(tbl.getDbName(), tbl.getTableName(), partNames.subList(nBatches * batchSize, nParts))) != null) {
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return partitions;
    }

    public List<Partition> getPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List tParts = this.getMSC().listPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter, (short)-1);
        return Hive.convertFromMetastore(tbl, tParts);
    }

    private static List<Partition> convertFromMetastore(Table tbl, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws HiveException {
        if (partitions == null) {
            return new ArrayList<Partition>();
        }
        ArrayList<Partition> results = new ArrayList<Partition>(partitions.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tPart : partitions) {
            results.add(new Partition(tbl, tPart));
        }
        return results;
    }

    public boolean getPartitionsByExpr(Table tbl, ExprNodeGenericFuncDesc expr, HiveConf conf, List<Partition> result) throws HiveException, TException {
        assert (result != null);
        byte[] exprBytes = Utilities.serializeExpressionToKryo(expr);
        String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> msParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        boolean hasUnknownParts = this.getMSC().listPartitionsByExpr(tbl.getDbName(), tbl.getTableName(), exprBytes, defaultPartitionName, (short)-1, msParts);
        result.addAll(Hive.convertFromMetastore(tbl, msParts));
        return hasUnknownParts;
    }

    public int getNumPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException("Partition spec should only be supplied for a partitioned table");
        }
        int numParts = this.getMSC().getNumPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter);
        return numParts;
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws HiveException {
        try {
            this.getMSC().validatePartitionNameCharacters(partVals);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createRole(String roleName, String ownerName) throws HiveException {
        try {
            this.getMSC().create_role(new Role(roleName, -1, ownerName));
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropRole(String roleName) throws HiveException {
        try {
            this.getMSC().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllRoleNames() throws HiveException {
        try {
            return this.getMSC().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<RolePrincipalGrant> getRoleGrantInfoForPrincipal(String principalName, PrincipalType principalType) throws HiveException {
        try {
            GetRoleGrantsForPrincipalRequest req = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
            GetRoleGrantsForPrincipalResponse resp = this.getMSC().get_role_grants_for_principal(req);
            return resp.getPrincipalGrants();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_role(roleName, userName, principalType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<Role> listRoles(String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectType objectType, String db_name, String table_name, List<String> part_values, String column_name, String user_name, List<String> group_names) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, db_name, table_name, part_values, column_name);
            return this.getMSC().get_privilege_set(hiveObj, user_name, group_names);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveObjectPrivilege> showPrivilegeGrant(HiveObjectType objectType, String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, dbName, tableName, partValues, columnName);
            return this.getMSC().list_privileges(principalName, principalType, hiveObj);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static void copyFiles(final HiveConf conf, final FileSystem destFs, FileStatus[] srcs, final FileSystem srcFs, final Path destf, final boolean isSrcLocal, final List<Path> newFiles) throws HiveException {
        HadoopShims.HdfsFileStatus fullDestStatus;
        try {
            fullDestStatus = ShimLoader.getHadoopShims().getFullFileStatus(conf, destFs, destf);
        }
        catch (IOException e1) {
            throw new HiveException(e1);
        }
        if (!fullDestStatus.getFileStatus().isDirectory()) {
            throw new HiveException(destf + " is not a directory.");
        }
        final boolean inheritPerms = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        LinkedList<Future<ObjectPair<Path, Path>>> futures = new LinkedList<Future<ObjectPair<Path, Path>>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
        for (FileStatus src : srcs) {
            FileStatus[] files;
            if (src.isDirectory()) {
                try {
                    files = srcFs.listStatus(src.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                }
                catch (IOException e) {
                    pool.shutdownNow();
                    throw new HiveException(e);
                }
            } else {
                files = new FileStatus[]{src};
            }
            final SessionState parentSession = SessionState.get();
            for (FileStatus srcFile : files) {
                String srcGroup;
                final Path srcP = srcFile.getPath();
                boolean needToCopy = Hive.needToCopy(srcP, destf, srcFs, destFs);
                final boolean isRenameAllowed = !needToCopy && !isSrcLocal;
                final String msg = "Unable to move source " + srcP + " to destination " + destf;
                String string = srcGroup = isRenameAllowed ? srcFile.getGroup() : fullDestStatus.getFileStatus().getGroup();
                if (null == pool) {
                    try {
                        Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isRenameAllowed);
                        if (null == newFiles) continue;
                        newFiles.add(destPath);
                        continue;
                    }
                    catch (Exception e) {
                        throw Hive.getHiveException(e, msg, "Failed to move: {}");
                    }
                }
                futures.add(pool.submit(new Callable<ObjectPair<Path, Path>>(){

                    @Override
                    public ObjectPair<Path, Path> call() throws HiveException {
                        SessionState.setCurrentSessionState(parentSession);
                        try {
                            Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isRenameAllowed);
                            if (inheritPerms) {
                                ShimLoader.getHadoopShims().setFullFileStatus(conf, fullDestStatus, srcGroup, destFs, destPath, false);
                            }
                            if (null != newFiles) {
                                newFiles.add(destPath);
                            }
                            return ObjectPair.create(srcP, destPath);
                        }
                        catch (Exception e) {
                            throw Hive.getHiveException(e, msg);
                        }
                    }
                }));
            }
        }
        if (null == pool) {
            if (inheritPerms) {
                ShimLoader.getHadoopShims().setFullFileStatus(conf, fullDestStatus, null, destFs, destf, true);
            }
        } else {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    ObjectPair pair = (ObjectPair)future.get();
                    LOG.debug((Object)String.format("Moved src: {}", ((Path)pair.getFirst()).toString(), ", to dest: {}", ((Path)pair.getSecond()).toString()));
                }
                catch (Exception e) {
                    throw Hive.handlePoolException(pool, e);
                }
            }
        }
    }

    private static boolean destExists(List<List<Path[]>> result, Path proposed) {
        for (List<Path[]> sdpairs : result) {
            for (Path[] sdpair : sdpairs) {
                if (!sdpair[1].equals((Object)proposed)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSubDir(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, boolean isSrcLocal) {
        if (srcf == null) {
            LOG.debug((Object)"The source path is null for isSubDir method.");
            return false;
        }
        String fullF1 = Hive.getQualifiedPathWithoutSchemeAndAuthority(srcf, srcFs) + "/";
        String fullF2 = Hive.getQualifiedPathWithoutSchemeAndAuthority(destf, destFs) + "/";
        boolean isInTest = HiveConf.getBoolVar(srcFs.getConf(), HiveConf.ConfVars.HIVE_IN_TEST);
        LOG.debug((Object)("The source path is " + fullF1 + " and the destination path is " + fullF2));
        if (isInTest) {
            return fullF1.startsWith(fullF2);
        }
        String schemaSrcf = srcf.toUri().getScheme();
        String schemaDestf = destf.toUri().getScheme();
        if (schemaDestf == null && isSrcLocal) {
            LOG.debug((Object)"The source file is in the local while the dest not.");
            return false;
        }
        if (schemaSrcf != null && schemaDestf != null && !schemaSrcf.equals(schemaDestf)) {
            LOG.debug((Object)("The source path's schema is " + schemaSrcf + " and the destination path's schema is " + schemaDestf + "."));
            return false;
        }
        LOG.debug((Object)("The source path is " + fullF1 + " and the destination path is " + fullF2));
        return fullF1.startsWith(fullF2);
    }

    private static String getQualifiedPathWithoutSchemeAndAuthority(Path srcf, FileSystem fs) {
        Path currentWorkingDir = fs.getWorkingDirectory();
        Path path = srcf.makeQualified(srcf.toUri(), currentWorkingDir);
        return ShimLoader.getHadoopShims().getPathWithoutSchemeAndAuthority(path).toString();
    }

    private static Path mvFile(HiveConf conf, FileSystem sourceFs, Path sourcePath, FileSystem destFs, Path destDirPath, boolean isSrcLocal, boolean isRenameAllowed) throws IOException {
        boolean isDestLocal;
        boolean isBlobStoragePath = BlobStorageUtils.isBlobStoragePath(conf, destDirPath);
        String fullname = sourcePath.getName();
        String name = FilenameUtils.getBaseName((String)sourcePath.getName());
        String type = FilenameUtils.getExtension((String)sourcePath.getName());
        Path destFilePath = new Path(destDirPath, fullname);
        int counter = 1;
        boolean bl = isDestLocal = destFs.getUri().getScheme().equals("file") || destFs.getUri().getScheme().equals("pfile");
        if (!isRenameAllowed || isBlobStoragePath || isDestLocal) {
            while (destFs.exists(destFilePath)) {
                destFilePath = new Path(destDirPath, name + "_copy_" + counter + (!type.isEmpty() ? "." + type : ""));
                ++counter;
            }
        }
        if (isRenameAllowed) {
            while (!destFs.rename(sourcePath, destFilePath)) {
                destFilePath = new Path(destDirPath, name + "_copy_" + counter + (!type.isEmpty() ? "." + type : ""));
                ++counter;
            }
        } else if (isSrcLocal) {
            destFs.copyFromLocalFile(sourcePath, destFilePath);
        } else {
            FileUtils.copy(sourceFs, sourcePath, destFs, destFilePath, true, false, conf);
        }
        return destFilePath;
    }

    public static void clearDestForSubDirSrc(HiveConf conf, Path dest, Path src, boolean isSrcLocal) throws IOException {
        FileSystem destFS = dest.getFileSystem((Configuration)conf);
        FileSystem srcFS = src.getFileSystem((Configuration)conf);
        if (Hive.isSubDir(src, dest, srcFS, destFS, isSrcLocal)) {
            FileStatus[] existingFiles;
            Path fullDestPath;
            Path fullSrcPath = new Path(Hive.getQualifiedPathWithoutSchemeAndAuthority(src, srcFS));
            if (fullSrcPath.equals((Object)(fullDestPath = new Path(Hive.getQualifiedPathWithoutSchemeAndAuthority(dest, destFS))))) {
                return;
            }
            Path parent = fullSrcPath;
            while (!parent.getParent().equals((Object)fullDestPath)) {
                parent = parent.getParent();
            }
            for (FileStatus fileStatus : existingFiles = destFS.listStatus(dest, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (fileStatus.getPath().getName().equals(parent.getName())) continue;
                destFS.delete(fileStatus.getPath(), true);
            }
        }
    }

    private static Path mvFile(HiveConf conf, Path srcf, Path destf, boolean isSrcLocal, FileSystem srcFs, FileSystem destFs, String srcName, String filetype) throws IOException {
        int counter = 1;
        while (destFs.exists(destf)) {
            destf = new Path(destf.getParent(), srcName + "_copy_" + counter + filetype);
            ++counter;
        }
        if (isSrcLocal) {
            destFs.copyFromLocalFile(srcf, destf);
        } else {
            LOG.info((Object)("Copying source " + srcf + " to " + destf + " because HDFS encryption zones are different."));
            FileUtils.copy(srcFs, srcf, destFs, destf, true, false, conf);
        }
        return destf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(final HiveConf conf, Path srcf, Path destf, boolean replace, boolean isSrcLocal) throws HiveException {
        FileSystem srcFs;
        FileSystem destFs;
        try {
            destFs = destf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new HiveException(e.getMessage(), e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new HiveException(e.getMessage(), e);
        }
        final boolean inheritPerms = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        HadoopShims shims = ShimLoader.getHadoopShims();
        HadoopShims.HdfsFileStatus destStatus = null;
        boolean shouldRenameDirectoryInParallel = BlobStorageUtils.shouldRenameDirectoryInParallel(conf, srcFs, destFs);
        boolean destIsSubDir = Hive.isSubDir(srcf, destf, srcFs, destFs, isSrcLocal);
        String msg = "Unable to move source " + srcf + " to destination " + destf;
        try {
            block29: {
                if (inheritPerms || replace) {
                    try {
                        destStatus = shims.getFullFileStatus(conf, destFs, destf);
                        if (replace && !destIsSubDir) {
                            destFs.delete(destf, true);
                            LOG.debug((Object)("The path " + destf.toString() + " is deleted"));
                        }
                    }
                    catch (FileNotFoundException ignore) {
                        if (!inheritPerms) break block29;
                        destStatus = shims.getFullFileStatus(conf, destFs, destf.getParent());
                    }
                }
            }
            final HadoopShims.HdfsFileStatus desiredStatus = destStatus;
            final SessionState parentSession = SessionState.get();
            if (isSrcLocal) {
                destFs.copyFromLocalFile(srcf, destf);
                if (inheritPerms) {
                    ShimLoader.getHadoopShims().setFullFileStatus(conf, destStatus, null, destFs, destf, true);
                }
                return true;
            }
            if (Hive.needToCopy(srcf, destf, srcFs, destFs)) {
                LOG.debug((Object)("Copying source " + srcf + " to " + destf + " because HDFS encryption zones are different."));
                return FileUtils.copy(srcf.getFileSystem((Configuration)conf), srcf, destf.getFileSystem((Configuration)conf), destf, true, replace, conf);
            }
            if (destIsSubDir) {
                FileStatus[] srcs = destFs.listStatus(srcf, FileUtils.HIDDEN_FILES_PATH_FILTER);
                LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
                ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
                for (final FileStatus srcStatus : srcs) {
                    final Path destFile = new Path(destf, srcStatus.getPath().getName());
                    final String poolMsg = "Unable to move source " + srcStatus.getPath() + " to destination " + destFile;
                    if (null == pool) {
                        if (destFs.rename(srcStatus.getPath(), destFile)) continue;
                        throw new IOException("rename for src path: " + srcStatus.getPath() + " to dest:" + destf + " returned false");
                    }
                    futures.add(pool.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws HiveException {
                            block4: {
                                SessionState.setCurrentSessionState(parentSession);
                                String group = srcStatus.getGroup();
                                try {
                                    if (destFs.rename(srcStatus.getPath(), destFile)) {
                                        if (inheritPerms) {
                                            ShimLoader.getHadoopShims().setFullFileStatus(conf, desiredStatus, group, destFs, destFile, false);
                                        }
                                        break block4;
                                    }
                                    throw new IOException("rename for src path: " + srcStatus.getPath() + " to dest path:" + destFile + " returned false");
                                }
                                catch (Exception e) {
                                    throw Hive.getHiveException(e, poolMsg);
                                }
                            }
                            return null;
                        }
                    }));
                }
                if (null == pool) {
                    if (inheritPerms) {
                        ShimLoader.getHadoopShims().setFullFileStatus(conf, desiredStatus, null, destFs, destf, true);
                    }
                } else {
                    pool.shutdown();
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            throw Hive.handlePoolException(pool, e);
                        }
                    }
                }
                return true;
            }
            if (shouldRenameDirectoryInParallel && conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0) {
                ExecutorService pool = null;
                try {
                    pool = Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build());
                    ParallelDirectoryRenamer.renameDirectoryInParallel(conf, srcFs, destFs, srcf, destf, inheritPerms, SessionState.get(), pool);
                }
                finally {
                    if (pool != null) {
                        pool.shutdownNow();
                    }
                }
                return true;
            }
            if (destFs.rename(srcf, destf)) {
                if (inheritPerms) {
                    ShimLoader.getHadoopShims().setFullFileStatus(conf, destStatus, null, destFs, destf, true);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw Hive.getHiveException(e, msg);
        }
    }

    private static HiveException getHiveException(Exception e, String msg) {
        return Hive.getHiveException(e, msg, null);
    }

    private static HiveException handlePoolException(ExecutorService pool, Exception e) {
        HiveException he = null;
        if (e instanceof HiveException) {
            he = (HiveException)e;
            if (he.getCanonicalErrorMsg() != ErrorMsg.GENERIC_ERROR) {
                if (he.getCanonicalErrorMsg() == ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
                    LOG.error((Object)String.format("Failed to move: {}", he.getMessage()));
                } else {
                    LOG.info((Object)String.format("Failed to move: {}", he.getRemoteErrorMsg()));
                }
            }
        } else {
            LOG.error((Object)String.format("Failed to move: {}", e.getMessage()));
            he = new HiveException(e.getCause());
        }
        pool.shutdownNow();
        return he;
    }

    private static HiveException getHiveException(Exception e, String msg, String logMsg) {
        String hiveErrMsg = null;
        hiveErrMsg = e.getMessage() != null ? String.format("%s%s%s", msg, ": ", Splitter.on(System.getProperty("line.separator")).split(e.getMessage()).iterator().next()) : msg;
        ErrorMsg errorMsg = ErrorMsg.getErrorMsg(e);
        if (logMsg != null) {
            LOG.info((Object)String.format(logMsg, e.getMessage()));
        }
        if (errorMsg != ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
            return new HiveException((Throwable)e, e.getMessage(), errorMsg, hiveErrMsg);
        }
        return new HiveException(msg, e);
    }

    protected static boolean needToCopy(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs) throws HiveException {
        if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
            return true;
        }
        HadoopShims.HdfsEncryptionShim srcHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(srcFs);
        HadoopShims.HdfsEncryptionShim destHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(destFs);
        try {
            return srcHdfsEncryptionShim != null && destHdfsEncryptionShim != null && (srcHdfsEncryptionShim.isPathEncrypted(srcf) || destHdfsEncryptionShim.isPathEncrypted(destf)) && !srcHdfsEncryptionShim.arePathsOnSameEncryptionZone(srcf, destf, destHdfsEncryptionShim);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    protected static void copyFiles(HiveConf conf, Path srcf, Path destf, FileSystem fs, boolean isSrcLocal, boolean isAcid, List<Path> newFiles) throws HiveException {
        FileStatus[] srcs;
        FileSystem srcFs;
        boolean inheritPerms = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        try {
            if (!fs.exists(destf)) {
                FileUtils.mkdir(fs, destf, inheritPerms, conf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
            srcs = srcFs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException("addFiles: filesystem error in check phase. " + e.getMessage(), e);
        }
        if (srcs == null) {
            LOG.info((Object)("No sources specified to move: " + srcf));
            return;
        }
        if (isAcid) {
            Hive.moveAcidFiles(srcFs, srcs, destf, newFiles);
        } else {
            Hive.copyFiles(conf, fs, srcs, srcFs, destf, isSrcLocal, newFiles);
        }
    }

    private static void moveAcidFiles(FileSystem fs, FileStatus[] stats, Path dst, List<Path> newFiles) throws HiveException {
        HashSet<Path> createdDeltaDirs = new HashSet<Path>();
        for (FileStatus stat : stats) {
            Path srcPath = stat.getPath();
            LOG.debug((Object)("Acid move Looking for original buckets in " + srcPath));
            FileStatus[] origBucketStats = null;
            try {
                origBucketStats = fs.listStatus(srcPath, AcidUtils.originalBucketFilter);
            }
            catch (IOException e) {
                String msg = "Unable to look for bucket files in src path " + srcPath.toUri().toString();
                LOG.error((Object)msg);
                throw new HiveException(msg, e);
            }
            LOG.debug((Object)("Acid move found " + origBucketStats.length + " original buckets"));
            for (FileStatus origBucketStat : origBucketStats) {
                Path origBucketPath = origBucketStat.getPath();
                LOG.debug((Object)("Acid move looking for delta files in bucket " + origBucketPath));
                FileStatus[] deltaStats = null;
                try {
                    deltaStats = fs.listStatus(origBucketPath, AcidUtils.deltaFileFilter);
                }
                catch (IOException e) {
                    throw new HiveException("Unable to look for delta files in original bucket " + origBucketPath.toUri().toString(), e);
                }
                LOG.debug((Object)("Acid move found " + deltaStats.length + " delta files"));
                for (FileStatus deltaStat : deltaStats) {
                    Path deltaPath = deltaStat.getPath();
                    Path deltaDest = new Path(dst, deltaPath.getName());
                    try {
                        if (!createdDeltaDirs.contains(deltaDest)) {
                            try {
                                fs.mkdirs(deltaDest);
                                createdDeltaDirs.add(deltaDest);
                            }
                            catch (IOException swallowIt) {
                                LOG.info((Object)("Unable to create delta directory " + deltaDest + ", assuming it already exists: " + swallowIt.getMessage()));
                            }
                        }
                        FileStatus[] bucketStats = fs.listStatus(deltaPath, AcidUtils.bucketFileFilter);
                        LOG.debug((Object)("Acid move found " + bucketStats.length + " bucket files"));
                        for (FileStatus bucketStat : bucketStats) {
                            Path bucketSrc = bucketStat.getPath();
                            Path bucketDest = new Path(deltaDest, bucketSrc.getName());
                            String msg = "Unable to move source " + bucketSrc + " to destination " + bucketDest;
                            LOG.info((Object)("Moving bucket " + bucketSrc.toUri().toString() + " to " + bucketDest.toUri().toString()));
                            try {
                                fs.rename(bucketSrc, bucketDest);
                                if (newFiles == null) continue;
                                newFiles.add(bucketDest);
                            }
                            catch (Exception e) {
                                throw Hive.getHiveException(e, msg);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new HiveException("Error moving acid files " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected static void replaceFiles(Path tablePath, Path srcf, Path destf, Path oldPath, HiveConf conf, boolean isSrcLocal) throws HiveException {
        try {
            boolean destfExist;
            FileStatus[] srcs;
            FileSystem destFs = destf.getFileSystem((Configuration)conf);
            try {
                FileSystem srcFs = srcf.getFileSystem((Configuration)conf);
                srcs = srcFs.globStatus(srcf);
            }
            catch (IOException e) {
                throw new HiveException("Getting globStatus " + srcf.toString(), e);
            }
            if (srcs == null) {
                LOG.info((Object)("No sources specified to move: " + srcf));
                return;
            }
            if (oldPath != null) {
                boolean oldPathDeleted = false;
                boolean isOldPathUnderDestf = false;
                try {
                    FileSystem fs2 = oldPath.getFileSystem((Configuration)conf);
                    if (fs2.exists(oldPath) && (isOldPathUnderDestf = FileUtils.isSubDir(oldPath, destf, fs2))) {
                        oldPathDeleted = Hive.trashFilesUnderDir(fs2, oldPath, conf);
                    }
                }
                catch (IOException e) {
                    if (isOldPathUnderDestf) {
                        throw new HiveException("Directory " + oldPath.toString() + " could not be cleaned up.", e);
                    }
                    LOG.warn((Object)("Directory " + oldPath.toString() + " cannot be cleaned: " + e), (Throwable)e);
                }
                if (isOldPathUnderDestf && !oldPathDeleted) {
                    throw new HiveException("Destination directory " + destf + " has not be cleaned up.");
                }
            }
            if (!(destfExist = FileUtils.mkdir(destFs, destf, true, conf))) {
                throw new IOException("Directory " + destf.toString() + " does not exist and could not be created.");
            }
            if (srcs.length == 1 && srcs[0].isDirectory()) {
                if (!Hive.moveFile(conf, srcs[0].getPath(), destf, true, isSrcLocal)) {
                    throw new IOException("Error moving: " + srcf + " into: " + destf);
                }
            } else {
                for (FileStatus src : srcs) {
                    if (Hive.moveFile(conf, src.getPath(), new Path(destf, src.getPath().getName()), true, isSrcLocal)) continue;
                    throw new IOException("Error moving: " + srcf + " into: " + destf);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    private static boolean trashFilesUnderDir(final FileSystem fs, Path f, final Configuration conf) throws IOException {
        FileStatus[] statuses = fs.listStatus(f, FileUtils.HIDDEN_FILES_PATH_FILTER);
        boolean result = true;
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Delete-Thread-%d").build()) : null;
        final SessionState parentSession = SessionState.get();
        for (final FileStatus status : statuses) {
            if (null == pool) {
                result &= FileUtils.moveToTrash(fs, status.getPath(), conf);
                continue;
            }
            futures.add(pool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SessionState.setCurrentSessionState(parentSession);
                    return FileUtils.moveToTrash(fs, status.getPath(), conf);
                }
            }));
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    result &= ((Boolean)future.get()).booleanValue();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Object)"Failed to delete: ", (Throwable)e);
                    pool.shutdownNow();
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public static boolean isHadoop1() {
        return ShimLoader.getMajorVersion().startsWith("0.20");
    }

    public List<Partition> exchangeTablePartitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws HiveException {
        try {
            List partitions = this.getMSC().exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
            return Hive.convertFromMetastore(this.getTable(destDb, destinationTableName), partitions);
        }
        catch (Exception ex) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            throw new HiveException(ex);
        }
    }

    private IMetaStoreClient createMetaStoreClient() throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
                try {
                    if (tbl == null) {
                        return null;
                    }
                    HiveStorageHandler storageHandler = HiveUtils.getStorageHandler(Hive.this.conf, (String)tbl.getParameters().get("storage_handler"));
                    if (storageHandler == null) {
                        return null;
                    }
                    return storageHandler.getMetaHook();
                }
                catch (HiveException ex) {
                    LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
                    throw new MetaException("Failed to load storage handler:  " + ex.getMessage());
                }
            }
        };
        return RetryingMetaStoreClient.getProxy((HiveConf)this.conf, (HiveMetaHookLoader)hookLoader, this.metaCallTimeMap, (String)SessionHiveMetaStoreClient.class.getName());
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC() throws MetaException {
        if (this.metaStoreClient == null) {
            try {
                this.owner = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                String msg = "Error getting current user: " + e.getMessage();
                LOG.error((Object)msg, (Throwable)e);
                throw new MetaException(msg + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            this.metaStoreClient = this.createMetaStoreClient();
            String metaStoreUris = this.conf.getVar(HiveConf.ConfVars.METASTOREURIS);
            if (!org.apache.commons.lang3.StringUtils.isEmpty(metaStoreUris)) {
                this.metaStoreClient = HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)this.metaStoreClient);
            }
        }
        return this.metaStoreClient;
    }

    private String getUserName() {
        return SessionState.getUserFromAuthenticator();
    }

    private List<String> getGroupNames() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getGroupNames();
        }
        return null;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde) throws HiveException {
        try {
            return MetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), e);
        }
    }

    public List<Index> getIndexes(String dbName, String tblName, short max) throws HiveException {
        List indexes = null;
        try {
            indexes = this.getMSC().listIndexes(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return indexes;
    }

    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws HiveException {
        try {
            return this.getMSC().updateTableColumnStatistics(statsObj);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws HiveException {
        try {
            return this.getMSC().updatePartitionColumnStatistics(statsObj);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws HiveException {
        try {
            return this.getMSC().setPartitionColumnStatistics(request);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws HiveException {
        try {
            return this.getMSC().getTableColumnStatistics(dbName, tableName, colNames);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws HiveException {
        try {
            return this.getMSC().getPartitionColumnStatistics(dbName, tableName, partNames, colNames);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) {
        try {
            return this.getMSC().getAggrColStatsFor(dbName, tblName, colNames, partName);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return new AggrStats(new ArrayList(), 0L);
        }
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws HiveException {
        try {
            return this.getMSC().deleteTableColumnStatistics(dbName, tableName, colName);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws HiveException {
        try {
            return this.getMSC().deletePartitionColumnStatistics(dbName, tableName, partName, colName);
        }
        catch (Exception e) {
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Table newTable(String tableName) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        return new Table(names[0], names[1]);
    }

    public String getDelegationToken(String owner, String renewer) throws HiveException {
        try {
            return this.getMSC().getDelegationToken(owner, renewer);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void cancelDelegationToken(String tokenStrForm) throws HiveException {
        try {
            this.getMSC().cancelDelegationToken(tokenStrForm);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void compact(String dbname, String tableName, String partName, String compactType) throws HiveException {
        try {
            CompactionType cr = null;
            if ("major".equals(compactType)) {
                cr = CompactionType.MAJOR;
            } else if ("minor".equals(compactType)) {
                cr = CompactionType.MINOR;
            } else {
                throw new RuntimeException("Unknown compaction type " + compactType);
            }
            this.getMSC().compact(dbname, tableName, partName, cr);
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public ShowCompactResponse showCompactions() throws HiveException {
        try {
            return this.getMSC().showCompactions();
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public GetOpenTxnsInfoResponse showTransactions() throws HiveException {
        try {
            return this.getMSC().showTxns();
        }
        catch (Exception e) {
            LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createFunction(Function func) throws HiveException {
        try {
            this.getMSC().createFunction(func);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void alterFunction(String dbName, String funcName, Function newFunction) throws HiveException {
        try {
            this.getMSC().alterFunction(dbName, funcName, newFunction);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void dropFunction(String dbName, String funcName) throws HiveException {
        try {
            this.getMSC().dropFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public Function getFunction(String dbName, String funcName) throws HiveException {
        try {
            return this.getMSC().getFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<Function> getAllFunctions() throws HiveException {
        try {
            List functions = this.getMSC().getAllFunctions().getFunctions();
            return functions == null ? new ArrayList() : functions;
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws HiveException {
        try {
            return this.getMSC().getFunctions(dbName, pattern);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void setMetaConf(String propName, String propValue) throws HiveException {
        try {
            this.getMSC().setMetaConf(propName, propValue);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public String getMetaConf(String propName) throws HiveException {
        try {
            return this.getMSC().getMetaConf(propName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void clearMetaCallTiming() {
        this.metaCallTimeMap.clear();
    }

    public ImmutableMap<String, Long> dumpAndClearMetaCallTiming(String phase) {
        boolean phaseInfoLogged = false;
        if (LOG.isDebugEnabled()) {
            phaseInfoLogged = this.logDumpPhase(phase);
            LOG.debug((Object)("Total time spent in each metastore function (ms): " + this.metaCallTimeMap));
        }
        if (LOG.isInfoEnabled()) {
            for (Map.Entry<String, Long> callTime : this.metaCallTimeMap.entrySet()) {
                if (callTime.getValue() <= 1000L) continue;
                if (!phaseInfoLogged) {
                    phaseInfoLogged = this.logDumpPhase(phase);
                }
                LOG.info((Object)("Total time spent in this metastore function was greater than 1000ms : " + callTime));
            }
        }
        ImmutableMap<String, Long> result = ImmutableMap.copyOf(this.metaCallTimeMap);
        this.metaCallTimeMap.clear();
        return result;
    }

    private boolean logDumpPhase(String phase) {
        LOG.info((Object)("Dumping metastore api call timing information for : " + phase + " phase"));
        return true;
    }
}

