/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import pt.webdetails.cgg.ScriptExecuteException;
import pt.webdetails.cgg.datasources.DataSourceFactory;
import pt.webdetails.cgg.scripts.BaseScope;
import pt.webdetails.cgg.scripts.Script;
import pt.webdetails.cgg.scripts.ScriptFactory;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;

public abstract class BaseScript
implements Script {
    private static final Log logger = LogFactory.getLog(BaseScript.class);
    private String source;
    private boolean isMultiPage;
    private BaseScope scope;
    private DataSourceFactory dataSourceFactory;
    private ScriptFactory scriptFactory;

    protected BaseScript(String source, boolean isMultiPage) {
        this.source = source;
        this.isMultiPage = isMultiPage;
    }

    @Override
    public void configure(int width, int height, DataSourceFactory dataSourceFactory, ScriptFactory scriptFactory) throws ScriptExecuteException {
        this.dataSourceFactory = dataSourceFactory;
        this.scriptFactory = scriptFactory;
        this.initializeObjects(dataSourceFactory);
    }

    protected DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    protected ScriptFactory getScriptFactory() {
        return this.scriptFactory;
    }

    public BaseScope getScope() {
        return this.scope;
    }

    public boolean getIsMultiPage() {
        return this.isMultiPage;
    }

    private void initializeObjects(DataSourceFactory dataSourceFactory) throws ScriptExecuteException {
        if (Context.getCurrentContext() == null) {
            throw new ScriptExecuteException();
        }
        Object wrappedFactory = Context.javaToJS((Object)dataSourceFactory, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"datasourceFactory", (Object)wrappedFactory);
    }

    @Override
    public void setScope(BaseScope scope) {
        this.scope = scope;
    }

    protected void executeScript(Map<String, Object> params) throws ScriptExecuteException {
        if (params == null) {
            throw new NullPointerException();
        }
        if (Context.getCurrentContext() == null) {
            throw new ScriptExecuteException();
        }
        Context cx = Context.getCurrentContext();
        cx.setOptimizationLevel(-1);
        Object wrappedParams = Context.javaToJS(params, (Scriptable)this.scope);
        ScriptableObject.defineProperty((Scriptable)this.scope, (String)"params", (Object)wrappedParams, (int)0);
        try {
            this.scope.loadScript(cx, this.source);
        }
        catch (ScriptResourceNotFoundException e) {
            logger.error((Object)("Failed to read " + this.source + ": " + e.toString()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to read " + this.source + ": " + e.toString()), (Throwable)e);
        }
    }
}

