/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.hadoop.hive.ql.hooks;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.hooks.Redactor;
import org.cloudera.log4j.redactor.StringRedactor;

public class QueryRedactor
extends Redactor {
    private StringRedactor redactor;

    @Override
    public void setConf(Configuration conf) {
        String logRedactorPath = conf.get("hive.query.redaction.rules", "").trim();
        if (!logRedactorPath.isEmpty()) {
            try {
                this.redactor = StringRedactor.createFromJsonFile((String)logRedactorPath);
            }
            catch (Exception e) {
                String msg = "Error loading from " + logRedactorPath + ": " + e;
                throw new IllegalStateException(msg, e);
            }
        }
    }

    @Override
    public String redactQuery(String query) {
        if (this.redactor != null) {
            return this.redactor.redact(query);
        }
        return query;
    }
}

