/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.io.IOException;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayInputStream;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayOutputStream;

public class ByteStream {

    public static interface RandomAccessOutput {
        public void writeInt(long var1, int var3);

        public void reserve(int var1);

        public void write(int var1);

        public void write(byte[] var1) throws IOException;

        public void write(byte[] var1, int var2, int var3);

        public int getLength();
    }

    public static final class Output
    extends NonSyncByteArrayOutputStream
    implements RandomAccessOutput {
        @Override
        public byte[] getData() {
            return this.buf;
        }

        public Output() {
        }

        public Output(int size) {
            super(size);
        }

        @Override
        public void writeInt(long offset, int value) {
            int offset2 = (int)offset;
            this.getData()[offset2++] = (byte)(value >> 24);
            this.getData()[offset2++] = (byte)(value >> 16);
            this.getData()[offset2++] = (byte)(value >> 8);
            this.getData()[offset2] = (byte)value;
        }

        @Override
        public void reserve(int byteCount) {
            for (int i = 0; i < byteCount; ++i) {
                this.write(0);
            }
        }
    }

    public static class Input
    extends NonSyncByteArrayInputStream {
        public byte[] getData() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        public void reset(byte[] argBuf, int argCount) {
            this.buf = argBuf;
            this.pos = 0;
            this.mark = 0;
            this.count = argCount;
        }

        public Input() {
            super(new byte[1]);
        }

        public Input(byte[] buf) {
            super(buf);
        }

        public Input(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }
    }
}

