/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.ql.stats.jdbc.JDBCStatsUtils;

public class JDBCStatsPublisher
implements StatsPublisher {
    private Connection conn;
    private String connectionString;
    private Configuration hiveconf;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private PreparedStatement updStmt;
    private PreparedStatement insStmt;
    private int timeout;
    private final String comment = "Hive stats publishing: " + this.getClass().getName();
    private int maxRetries;
    private long waitWindow;
    private final Random r = new Random();

    @Override
    public boolean connect(StatsCollectionContext context) {
        this.hiveconf = context.getHiveConf();
        this.maxRetries = HiveConf.getIntVar(this.hiveconf, HiveConf.ConfVars.HIVE_STATS_RETRIES_MAX);
        this.waitWindow = HiveConf.getTimeVar(this.hiveconf, HiveConf.ConfVars.HIVE_STATS_RETRIES_WAIT, TimeUnit.MILLISECONDS);
        this.connectionString = HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING);
        this.timeout = (int)HiveConf.getTimeVar(this.hiveconf, HiveConf.ConfVars.HIVE_STATS_JDBC_TIMEOUT, TimeUnit.SECONDS);
        String driver = HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSJDBCDRIVER);
        try {
            JavaUtils.loadClass(driver).newInstance();
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error during instantiating JDBC driver " + driver + ". "), (Throwable)e);
            return false;
        }
        DriverManager.setLoginTimeout(this.timeout);
        Utilities.SQLCommand<Void> setQueryTimeout = new Utilities.SQLCommand<Void>(){

            @Override
            public Void run(PreparedStatement stmt) throws SQLException {
                stmt.setQueryTimeout(JDBCStatsPublisher.this.timeout);
                return null;
            }
        };
        int failures = 0;
        while (true) {
            try {
                this.conn = Utilities.connectWithRetry(this.connectionString, this.waitWindow, this.maxRetries);
                this.updStmt = Utilities.prepareWithRetry(this.conn, JDBCStatsUtils.getUpdate(this.comment), this.waitWindow, this.maxRetries);
                this.insStmt = Utilities.prepareWithRetry(this.conn, JDBCStatsUtils.getInsert(this.comment), this.waitWindow, this.maxRetries);
                Utilities.executeWithRetry(setQueryTimeout, this.updStmt, this.waitWindow, this.maxRetries);
                Utilities.executeWithRetry(setQueryTimeout, this.insStmt, this.waitWindow, this.maxRetries);
                return true;
            }
            catch (SQLRecoverableException e) {
                if (failures >= this.maxRetries) {
                    this.LOG.error((Object)("Error during JDBC connection to " + this.connectionString + ". "), (Throwable)e);
                    return false;
                }
                long waitTime = Utilities.getRandomWaitTime(this.waitWindow, failures, this.r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (SQLException e) {
                this.LOG.error((Object)("Error during JDBC connection to " + this.connectionString + ". "), (Throwable)e);
                return false;
            }
            ++failures;
        }
    }

    @Override
    public boolean publishStat(String fileID, Map<String, String> stats) {
        if (stats.isEmpty()) {
            return true;
        }
        if (this.conn == null) {
            this.LOG.error((Object)"JDBC connection is null. Cannot publish stats without JDBC connection.");
            return false;
        }
        if (!JDBCStatsUtils.isValidStatisticSet(stats.keySet())) {
            this.LOG.warn((Object)("Invalid statistic:" + stats.keySet().toString() + ", supported " + " stats: " + JDBCStatsUtils.getSupportedStatistics()));
            return false;
        }
        JDBCStatsUtils.validateRowId(fileID);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)("Stats publishing for key " + fileID));
        }
        Utilities.SQLCommand<Void> execUpdate = new Utilities.SQLCommand<Void>(){

            @Override
            public Void run(PreparedStatement stmt) throws SQLException {
                stmt.executeUpdate();
                return null;
            }
        };
        List<String> supportedStatistics = JDBCStatsUtils.getSupportedStatistics();
        int failures = 0;
        while (true) {
            try {
                this.insStmt.setString(1, fileID);
                for (int i = 0; i < JDBCStatsUtils.getSupportedStatistics().size(); ++i) {
                    this.insStmt.setString(i + 2, stats.get(supportedStatistics.get(i)));
                }
                Utilities.executeWithRetry(execUpdate, this.insStmt, this.waitWindow, this.maxRetries);
                return true;
            }
            catch (SQLIntegrityConstraintViolationException e) {
                int updateFailures = 0;
                while (true) {
                    try {
                        for (int i = 0; i < JDBCStatsUtils.getSupportedStatistics().size(); ++i) {
                            this.updStmt.setString(i + 1, stats.get(supportedStatistics.get(i)));
                        }
                        this.updStmt.setString(supportedStatistics.size() + 1, fileID);
                        this.updStmt.setString(supportedStatistics.size() + 2, stats.get(JDBCStatsUtils.getBasicStat()));
                        this.updStmt.setString(supportedStatistics.size() + 3, fileID);
                        Utilities.executeWithRetry(execUpdate, this.updStmt, this.waitWindow, this.maxRetries);
                        return true;
                    }
                    catch (SQLRecoverableException ue) {
                        if (!this.handleSQLRecoverableException(ue, updateFailures)) {
                            return false;
                        }
                    }
                    catch (SQLException ue) {
                        this.LOG.error((Object)"Error during publishing statistics. ", (Throwable)e);
                        return false;
                    }
                    ++updateFailures;
                }
            }
            catch (SQLRecoverableException e) {
                if (!this.handleSQLRecoverableException(e, failures)) {
                    return false;
                }
            }
            catch (SQLException e) {
                this.LOG.error((Object)"Error during publishing statistics. ", (Throwable)e);
                return false;
            }
            ++failures;
        }
    }

    private boolean handleSQLRecoverableException(Exception e, int failures) {
        if (failures >= this.maxRetries) {
            return false;
        }
        StatsCollectionContext sCntxt = new StatsCollectionContext(this.hiveconf);
        this.closeConnection(sCntxt);
        long waitTime = Utilities.getRandomWaitTime(this.waitWindow, failures, this.r);
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        if (!this.connect(sCntxt)) {
            this.LOG.error((Object)("Error during publishing aggregation. " + e));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnection(StatsCollectionContext context) {
        if (this.conn == null) {
            return true;
        }
        try {
            if (this.updStmt != null) {
                this.updStmt.close();
            }
            if (this.insStmt != null) {
                this.insStmt.close();
            }
            this.conn.close();
            if (HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase("jdbc:derby")) {
                try {
                    Class<DriverManager> clazz = DriverManager.class;
                    synchronized (DriverManager.class) {
                        DriverManager.getConnection(this.connectionString + ";shutdown=true");
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            {
                return true;
            }
        }
        catch (SQLException e) {
            this.LOG.error((Object)"Error during JDBC termination. ", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StatsCollectionContext context) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.hiveconf = context.getHiveConf();
            this.connectionString = HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING);
            String driver = HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSJDBCDRIVER);
            JavaUtils.loadClass(driver).newInstance();
            Class<DriverManager> clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                DriverManager.setLoginTimeout(this.timeout);
                this.conn = DriverManager.getConnection(this.connectionString);
                stmt = this.conn.createStatement();
                stmt.setQueryTimeout(this.timeout);
                DatabaseMetaData dbm = this.conn.getMetaData();
                String tableName = JDBCStatsUtils.getStatTableName();
                rs = dbm.getTables(null, null, tableName, null);
                boolean tblExists = rs.next();
                if (!tblExists) {
                    String createTable = JDBCStatsUtils.getCreate("");
                    stmt.executeUpdate(createTable);
                } else {
                    String idColName = JDBCStatsUtils.getIdColumnName();
                    int colSize = -1;
                    try {
                        rs.close();
                        rs = dbm.getColumns(null, null, tableName, idColName);
                        if (rs.next()) {
                            colSize = rs.getInt("COLUMN_SIZE");
                            if (colSize < 4000) {
                                String alterTable = JDBCStatsUtils.getAlterIdColumn();
                                stmt.executeUpdate(alterTable);
                            }
                        } else {
                            this.LOG.warn((Object)("Failed to update " + idColName + " - column not found"));
                        }
                    }
                    catch (Throwable t) {
                        this.LOG.warn((Object)("Failed to update " + idColName + " (size " + (colSize == -1 ? "unknown" : Integer.valueOf(colSize)) + ")"), t);
                    }
                }
                // ** MonitorExit[var5_8] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error during JDBC initialization. ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            this.closeConnection(context);
        }
        {
            return true;
        }
    }
}

