/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;

public class ClearDanglingScratchDir
implements Runnable {
    private static final Log LOG = LogFactory.getLog((String)ClearDanglingScratchDir.class.getName());
    boolean dryRun = false;
    boolean verbose = false;
    boolean useConsole = false;
    String rootHDFSDir;
    HiveConf conf;

    public static void main(String[] args) throws Exception {
        Options opts = ClearDanglingScratchDir.createOptions();
        CommandLine cli = new GnuParser().parse(opts, args);
        if (cli.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("cleardanglingscratchdir (clear scratch dir left behind by dead HiveCli or HiveServer2)", opts);
            return;
        }
        boolean dryRun = false;
        boolean verbose = false;
        if (cli.hasOption("r")) {
            dryRun = true;
        }
        if (cli.hasOption("v")) {
            verbose = true;
        }
        HiveConf conf = new HiveConf();
        String rootHDFSDir = cli.hasOption("s") ? cli.getOptionValue("s") : HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIR);
        ClearDanglingScratchDir clearDanglingScratchDirMain = new ClearDanglingScratchDir(dryRun, verbose, true, rootHDFSDir, conf);
        clearDanglingScratchDirMain.run();
    }

    public ClearDanglingScratchDir(boolean dryRun, boolean verbose, boolean useConsole, String rootHDFSDir, HiveConf conf) {
        this.dryRun = dryRun;
        this.verbose = verbose;
        this.useConsole = useConsole;
        this.rootHDFSDir = rootHDFSDir;
        this.conf = conf;
    }

    @Override
    public void run() {
        try {
            Path rootHDFSDirPath = new Path(this.rootHDFSDir);
            FileSystem fs = FileSystem.get((URI)rootHDFSDirPath.toUri(), (Configuration)this.conf);
            FileStatus[] userHDFSDirList = fs.listStatus(rootHDFSDirPath);
            ArrayList<Path> scratchDirToRemove = new ArrayList<Path>();
            for (FileStatus userHDFSDir : userHDFSDirList) {
                FileStatus[] scratchDirList;
                for (FileStatus scratchDir : scratchDirList = fs.listStatus(userHDFSDir.getPath())) {
                    Path lockFilePath = new Path(scratchDir.getPath(), "inuse.lck");
                    if (!fs.exists(lockFilePath)) {
                        String message = "Skipping " + scratchDir.getPath() + " since it does not contain " + "inuse.lck";
                        if (!this.verbose) continue;
                        this.consoleMessage(message);
                        continue;
                    }
                    try {
                        IOUtils.closeStream((Closeable)fs.append(lockFilePath));
                        scratchDirToRemove.add(scratchDir.getPath());
                    }
                    catch (RemoteException e) {
                        if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                            String message = scratchDir.getPath() + " is being used by live process";
                            if (this.verbose) {
                                this.consoleMessage(message);
                                continue;
                            }
                            this.consoleMessage(message);
                            continue;
                        }
                        this.consoleMessage("Unexpected error:" + e.getMessage());
                    }
                }
            }
            if (scratchDirToRemove.size() == 0) {
                this.consoleMessage("Cannot find any scratch directory to clear");
                return;
            }
            this.consoleMessage("Removing " + scratchDirToRemove.size() + " scratch directories");
            for (Path scratchDir : scratchDirToRemove) {
                if (this.dryRun) {
                    System.out.println(scratchDir);
                    continue;
                }
                boolean succ = fs.delete(scratchDir, true);
                if (!succ) {
                    this.consoleMessage("Cannot remove " + scratchDir);
                    continue;
                }
                String message = scratchDir + " removed";
                if (!this.verbose) continue;
                this.consoleMessage(message);
            }
        }
        catch (IOException e) {
            this.consoleMessage("Unexpected exception " + e.getMessage());
        }
    }

    private void consoleMessage(String message) {
        if (this.useConsole) {
            SessionState.getConsole().printInfo(message);
        } else {
            LOG.info((Object)message);
        }
    }

    static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"dry-run");
        OptionBuilder.withDescription((String)"Generate a list of dangling scratch dir, printed on console");
        result.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"scratchdir");
        OptionBuilder.withDescription((String)"Specify a non-default location of the scratch dir");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"Print verbose message");
        result.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        result.addOption(OptionBuilder.create((char)'h'));
        return result;
    }
}

