/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;

@Explain(displayName="PTF Operator")
public class PTFDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)PTFDesc.class.getName());
    PartitionedTableFunctionDef funcDef;
    LeadLagInfo llInfo;
    boolean isMapSide = false;
    transient Configuration cfg;

    public PartitionedTableFunctionDef getFuncDef() {
        return this.funcDef;
    }

    public void setFuncDef(PartitionedTableFunctionDef funcDef) {
        this.funcDef = funcDef;
    }

    public PartitionedTableFunctionDef getStartOfChain() {
        return this.funcDef == null ? null : this.funcDef.getStartOfChain();
    }

    @Explain(displayName="Function definitions")
    public List<PTFInputDef> getFuncDefExplain() {
        if (this.funcDef == null) {
            return null;
        }
        ArrayList<PTFInputDef> inputs = new ArrayList<PTFInputDef>();
        for (PTFInputDef current = this.funcDef; current != null; current = ((PTFInputDef)current).getInput()) {
            inputs.add(current);
        }
        Collections.reverse(inputs);
        return inputs;
    }

    public LeadLagInfo getLlInfo() {
        return this.llInfo;
    }

    public void setLlInfo(LeadLagInfo llInfo) {
        this.llInfo = llInfo;
    }

    @Explain(displayName="Lead/Lag information")
    public String getLlInfoExplain() {
        if (this.llInfo != null && this.llInfo.getLeadLagExprs() != null) {
            return PlanUtils.getExprListString(this.llInfo.getLeadLagExprs());
        }
        return null;
    }

    public boolean forWindowing() {
        return this.funcDef instanceof WindowTableFunctionDef;
    }

    @Explain(displayName="Map-side function", displayOnlyOnTrue=true)
    public boolean isMapSide() {
        return this.isMapSide;
    }

    public void setMapSide(boolean isMapSide) {
        this.isMapSide = isMapSide;
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public void setCfg(Configuration cfg) {
        this.cfg = cfg;
    }

    static {
        PTFUtils.makeTransient(PTFDesc.class, "llInfo");
        PTFUtils.makeTransient(PTFDesc.class, "cfg");
    }
}

