/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveTableScan
extends TableScan
implements HiveRelNode {
    private final boolean insideView;

    public HiveTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptHiveTable table, RelDataType rowtype, boolean insideView) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), (RelOptTable)table);
        assert (this.getConvention() == HiveRelNode.CONVENTION);
        this.insideView = insideView;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return HiveCost.FACTORY.makeZeroCost();
    }

    public void register(RelOptPlanner planner) {
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public double getRows() {
        return ((RelOptHiveTable)this.table).getRowCount();
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst) {
        return ((RelOptHiveTable)this.table).getColStat(projIndxLst);
    }

    public boolean isInsideView() {
        return this.insideView;
    }

    public String computeDigest() {
        String digest = super.computeDigest();
        return digest + "[" + this.isInsideView() + "]";
    }
}

