/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.hive.common.io.FetchConverter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;

public class PreExecutePrinter
implements ExecuteWithHookContext {
    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.PRE_EXEC_HOOK);
        SessionState ss = SessionState.get();
        if (ss != null && ss.out instanceof FetchConverter) {
            boolean foundQuery = ss.getHiveOperation() == HiveOperation.QUERY && !hookContext.getQueryPlan().isForExplain();
            ((FetchConverter)ss.out).foundQuery(foundQuery);
        }
        Set<ReadEntity> inputs = hookContext.getInputs();
        Set<WriteEntity> outputs = hookContext.getOutputs();
        UserGroupInformation ugi = hookContext.getUgi();
        this.run(hookContext.getConf().get(HiveConf.ConfVars.HIVEQUERYSTRING.varname), hookContext.getQueryPlan().getOperationName(), inputs, outputs, ugi);
    }

    public void run(String query, String type, Set<ReadEntity> inputs, Set<WriteEntity> outputs, UserGroupInformation ugi) throws Exception {
        SessionState.LogHelper console = SessionState.getConsole();
        if (console == null) {
            return;
        }
        if (query != null) {
            console.printInfo("PREHOOK: query: " + query.trim(), false);
        }
        if (type != null) {
            console.printInfo("PREHOOK: type: " + type, false);
        }
        PreExecutePrinter.printEntities(console, inputs, "PREHOOK: Input: ");
        PreExecutePrinter.printEntities(console, outputs, "PREHOOK: Output: ");
    }

    static void printEntities(SessionState.LogHelper console, Set<?> entities, String prefix) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object o : entities) {
            strings.add(o.toString());
        }
        Collections.sort(strings);
        for (String s : strings) {
            console.printInfo(prefix + s, false);
        }
    }
}

