/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.geo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.geo.LocationRole;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.ui.xul.util.AbstractModelList;

public class GeoContext
extends AbstractModelList<GeoRole> {
    private static final long serialVersionUID = 7328118800436710452L;
    protected static final String GEO_PREFIX = "geo.";
    protected static final String GEO_DIM_NAME = "geo.dimension.name";
    protected static final String GEO_ROLE_KEY = "geo.roles";
    protected static final String GEO_MATCH_SEPARATOR = "geo.matchSeparator";
    protected static final String ALIAS_SUFFIX = ".aliases";
    protected static final String REQUIRED_PARENTS_SUFFIX = ".required-parents";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ANNOTATION_DATA_ROLE = "Data.Role";
    public static final String ANNOTATION_GEO_ROLE = "Geo.Role";
    public static final String ANNOTATION_GEO_PARENTS = "Geo.RequiredParents";
    protected String dimensionName = "Geography";

    public GeoRole getGeoRole(int index) {
        if (index >= 0 && this.children.size() >= index) {
            return (GeoRole)this.children.get(index);
        }
        return null;
    }

    public void addGeoRole(GeoRole geoRole) {
        if (geoRole != null) {
            this.children.add(geoRole);
        }
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public GeoRole matchFieldToGeoRole(AvailableField field) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            GeoRole role = (GeoRole)iterator.next();
            if (role.evaluate(field.getPhysicalColumn().getId())) {
                return role;
            }
            if (!field.getPhysicalColumn().getId().startsWith("pc__") || !role.evaluate(field.getPhysicalColumn().getId().substring(4))) continue;
            return role;
        }
        return null;
    }

    public GeoRole matchColumnToGeoRole(IPhysicalColumn column) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            GeoRole role = (GeoRole)iterator.next();
            if (!role.evaluate(column.getId())) continue;
            return role;
        }
        return null;
    }

    public List<DimensionMetaData> buildDimensions(ModelerWorkspace workspace) {
        ArrayList<DimensionMetaData> geoDims = new ArrayList<DimensionMetaData>();
        List<AvailableTable> tableList = workspace.getAvailableTables().getAsAvailableTablesList();
        for (AvailableTable table : tableList) {
            if (table.isFactTable()) continue;
            String dimName = tableList.size() == 1 ? this.getDimensionName() : table.getName() + ((GeoRole)this.get(0)).getMatchSeparator() + this.getDimensionName();
            for (IPhysicalColumn col : table.getPhysicalTable().getPhysicalColumns()) {
                if (!col.getId().equalsIgnoreCase(this.getDimensionName())) continue;
                dimName = dimName + "2";
            }
            DimensionMetaData dim = new DimensionMetaData(dimName);
            dim.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, new GeoRole());
            HierarchyMetaData hier = new HierarchyMetaData(dimName);
            hier.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, new GeoRole());
            ArrayList<LevelMetaData> levels = new ArrayList<LevelMetaData>();
            AvailableField locationField = null;
            LocationRole locationRole = this.getLocationRole();
            boolean locationFieldDetected = false;
            int latColIndex = 0;
            int lonColIndex = 0;
            int count = 0;
            for (IPhysicalColumn col : table.getPhysicalTable().getPhysicalColumns()) {
                AvailableField field = table.findFieldByPhysicalColumn(col);
                GeoRole role = this.matchFieldToGeoRole(field);
                String fieldName = col.getId();
                if (role != null) {
                    if (role instanceof LocationRole) {
                        locationFieldDetected = true;
                        if (locationRole.evaluateLatitude(fieldName)) {
                            latColIndex = count;
                        } else if (locationRole.evaluateLongitude(fieldName)) {
                            lonColIndex = count;
                        }
                    } else {
                        ColumnBackedNode node = workspace.createColumnBackedNode(field, ModelerPerspective.ANALYSIS);
                        LevelMetaData level = workspace.createLevelForParentWithNode(hier, node);
                        level.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, role);
                        level.getMemberAnnotations().put(ANNOTATION_GEO_ROLE, role);
                        levels.add(level);
                    }
                }
                ++count;
            }
            if (locationFieldDetected) {
                locationField = this.determineLocationField(table, locationRole, latColIndex, lonColIndex, workspace.getWorkspaceHelper().getLocale());
            }
            if (levels.size() > 0) {
                for (int i = 0; i < this.size(); ++i) {
                    GeoRole knownRole = (GeoRole)this.get(i);
                    for (LevelMetaData level : levels) {
                        if (!knownRole.equals(level.getMemberAnnotations().get(ANNOTATION_GEO_ROLE))) continue;
                        if (locationFieldDetected && locationField != null && locationRole != null && latColIndex > -1 && lonColIndex > -1 && locationField.isSameUnderlyingPhysicalColumn(level.getLogicalColumn().getPhysicalColumn())) {
                            level.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, locationRole);
                            level.getMemberAnnotations().put(ANNOTATION_GEO_ROLE, locationRole);
                            this.setLocationMemberProperties(workspace, table, level, latColIndex, lonColIndex);
                        }
                        if (hier.contains(level)) continue;
                        hier.add(level);
                    }
                }
                hier.setParent(dim);
                dim.add(hier);
                geoDims.add(dim);
            }
            if (!locationFieldDetected || locationField == null || locationRole == null) continue;
            Iterator iterator = workspace.getModel().getDimensions().iterator();
            while (iterator.hasNext()) {
                DimensionMetaData existingDim = (DimensionMetaData)iterator.next();
                Iterator iterator2 = existingDim.iterator();
                while (iterator2.hasNext()) {
                    HierarchyMetaData existingHier = (HierarchyMetaData)iterator2.next();
                    Iterator iterator3 = existingHier.iterator();
                    while (iterator3.hasNext()) {
                        LevelMetaData existingLevel = (LevelMetaData)iterator3.next();
                        if (!locationField.isSameUnderlyingPhysicalColumn(existingLevel.getLogicalColumn().getPhysicalColumn())) continue;
                        this.setLocationMemberAnnotations(existingLevel, locationRole);
                        AvailableField latField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(latColIndex));
                        AvailableField lonField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(lonColIndex));
                        ColumnBackedNode tmp = workspace.createColumnBackedNode(latField, ModelerPerspective.ANALYSIS);
                        tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LATITUDE));
                        MemberPropertyMetaData memberProp = workspace.createMemberPropertyForParentWithNode(existingLevel, tmp);
                        memberProp.setName(LATITUDE);
                        existingLevel.add(memberProp);
                        tmp = workspace.createColumnBackedNode(lonField, ModelerPerspective.ANALYSIS);
                        tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LONGITUDE));
                        memberProp = workspace.createMemberPropertyForParentWithNode(existingLevel, tmp);
                        memberProp.setName(LONGITUDE);
                        existingLevel.add(memberProp);
                    }
                }
            }
        }
        if (geoDims.size() == 1) {
            String resetDimName = this.getDimensionName();
            if (((DimensionMetaData)geoDims.get(0)).getName().endsWith(resetDimName + "2")) {
                resetDimName = resetDimName + "2";
            }
            ((DimensionMetaData)geoDims.get(0)).setName(resetDimName);
            ((HierarchyMetaData)((DimensionMetaData)geoDims.get(0)).get(0)).setName(resetDimName);
        }
        return geoDims;
    }

    public LocationRole getLocationRole() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!(this.get(i) instanceof LocationRole)) continue;
            return (LocationRole)this.get(i);
        }
        return null;
    }

    protected AvailableField determineLocationField(AvailableTable table, LocationRole locationRole, int latColIndex, int lonColIndex, String locale) {
        IPhysicalColumn col;
        AvailableField locationField = null;
        int count = table.getAvailableFields().size();
        String prefix = locationRole.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            for (AvailableField field : table.getAvailableFields()) {
                col = field.getPhysicalColumn();
                if (!prefix.equalsIgnoreCase(col.getName(locale))) continue;
                locationField = field;
            }
        }
        if (locationField == null) {
            int min = Math.min(latColIndex, lonColIndex);
            int max = Math.max(latColIndex, lonColIndex);
            if (min > 0) {
                col = (IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(min - 1);
                locationField = table.findFieldByPhysicalColumn(col);
            } else if (max < count) {
                col = (IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(max + 1);
                locationField = table.findFieldByPhysicalColumn(col);
            }
        }
        return locationField;
    }

    public GeoRole getGeoRoleByName(String name) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            GeoRole role = (GeoRole)iterator.next();
            if (!role.getName().equalsIgnoreCase(name)) continue;
            return role;
        }
        return null;
    }

    public void setLocationFields(ModelerWorkspace workspace, LevelMetaData locationLevel) {
        List<AvailableTable> tableList = workspace.getAvailableTables().getAsAvailableTablesList();
        for (AvailableTable table : tableList) {
            if (table.isFactTable()) continue;
            LocationRole locationRole = this.getLocationRole();
            boolean locationFieldDetected = false;
            int latColIndex = -1;
            int lonColIndex = -1;
            int count = 0;
            for (IPhysicalColumn col : table.getPhysicalTable().getPhysicalColumns()) {
                AvailableField field = table.findFieldByPhysicalColumn(col);
                GeoRole role = this.matchFieldToGeoRole(field);
                String fieldName = col.getId();
                if (role != null && role instanceof LocationRole) {
                    locationFieldDetected = true;
                    if (locationRole.evaluateLatitude(fieldName)) {
                        latColIndex = count;
                    } else if (locationRole.evaluateLongitude(fieldName)) {
                        lonColIndex = count;
                    }
                }
                ++count;
            }
            if (!locationFieldDetected || locationLevel == null || locationRole == null || latColIndex <= -1 || lonColIndex <= -1) continue;
            this.setLocationMemberAnnotations(locationLevel, locationRole);
            this.setLocationMemberProperties(workspace, table, locationLevel, latColIndex, lonColIndex);
        }
    }

    public void setLocationFields(ModelerWorkspace workspace, LevelMetaData locationLevel, String latitudeFieldName, String longitudeFieldName) {
        boolean foundLatLongColumn = false;
        int latColIndex = -1;
        int lonColIndex = -1;
        List<AvailableTable> tableList = workspace.getAvailableTables().getAsAvailableTablesList();
        for (AvailableTable table : tableList) {
            int count = 0;
            for (IPhysicalColumn col : table.getPhysicalTable().getPhysicalColumns()) {
                String fieldName = col.getId();
                if (fieldName.equalsIgnoreCase(latitudeFieldName)) {
                    foundLatLongColumn = true;
                    latColIndex = count;
                } else if (fieldName.equalsIgnoreCase(longitudeFieldName)) {
                    foundLatLongColumn = true;
                    lonColIndex = count;
                }
                ++count;
            }
            if (!foundLatLongColumn || locationLevel == null || latColIndex <= -1 || lonColIndex <= -1) continue;
            this.setLocationMemberAnnotations(locationLevel, this.getLocationRole());
            this.setLocationMemberProperties(workspace, table, locationLevel, latColIndex, lonColIndex);
        }
    }

    private void setLocationMemberAnnotations(LevelMetaData locationLevel, LocationRole locationRole) {
        locationLevel.getMemberAnnotations().put(ANNOTATION_DATA_ROLE, locationRole);
        locationLevel.getMemberAnnotations().put(ANNOTATION_GEO_ROLE, locationRole);
    }

    private void setLocationMemberProperties(ModelerWorkspace workspace, AvailableTable table, LevelMetaData locationLevel, int latColIndex, int lonColIndex) {
        AvailableField latField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(latColIndex));
        AvailableField lonField = table.findFieldByPhysicalColumn((IPhysicalColumn)table.getPhysicalTable().getPhysicalColumns().get(lonColIndex));
        ColumnBackedNode tmp = workspace.createColumnBackedNode(latField, ModelerPerspective.ANALYSIS);
        tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LATITUDE));
        MemberPropertyMetaData memberProp = workspace.createMemberPropertyForParentWithNode(locationLevel, tmp);
        memberProp.setName(LATITUDE);
        locationLevel.add(memberProp);
        tmp = workspace.createColumnBackedNode(lonField, ModelerPerspective.ANALYSIS);
        tmp.getLogicalColumn().setName(new LocalizedString(workspace.getWorkspaceHelper().getLocale(), LONGITUDE));
        memberProp = workspace.createMemberPropertyForParentWithNode(locationLevel, tmp);
        memberProp.setName(LONGITUDE);
        locationLevel.add(memberProp);
    }
}

