/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.Collection;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableItemCollection;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.IAvailableItem;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ColResolverController
extends AbstractXulEventHandler {
    private ModelerWorkspace workspace;
    private XulDialog dialog;
    private ColumnBackedNode node;
    private String columnType;
    private IAvailableItem[] selectedFields = new IAvailableItem[0];
    private AvailableItemCollection items = new AvailableItemCollection();
    BindingFactory bf;

    public void show(ModelerWorkspace workspace, ColumnBackedNode node, String columnType, AvailableTable restrictedToTable) {
        this.workspace = workspace;
        this.columnType = columnType;
        this.items.clear();
        if (restrictedToTable != null) {
            this.items.add(restrictedToTable);
        } else {
            this.items.addAll((Collection)((Object)workspace.getAvailableTables()));
        }
        this.node = node;
        this.dialog.setTitle(ModelerMessagesHolder.getMessages().getString("ColResolverController." + columnType + "_column_selection_dialog", new String[0]));
        this.dialog.show();
    }

    public void show(ModelerWorkspace workspace, ColumnBackedNode node, String columnType) {
        this.show(workspace, node, columnType, null);
    }

    public void init() {
        this.bf.setDocument(this.document);
        this.dialog = (XulDialog)this.document.getElementById("resolveColumnsDialog");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.items, "children", "resolveColumnsTree", "elements", new BindingConvertor[0]);
        this.bf.createBinding("resolveColumnsTree", "selectedItem", (Object)this, "selectedFieldsChanged", new BindingConvertor[0]);
    }

    @Bindable
    public void done() {
        if (this.selectedFields.length != 1) {
            return;
        }
        AvailableField field = (AvailableField)this.selectedFields[0];
        ColumnBackedNode cnode = this.workspace.createColumnBackedNode(field, this.workspace.getCurrentModelerPerspective());
        LogicalColumn lCol = cnode.getLogicalColumn();
        if ("source".equals(this.columnType)) {
            this.node.setLogicalColumn(lCol);
        } else if ("ordinal".equals(this.columnType)) {
            this.node.setLogicalOrdinalColumn(lCol);
        } else if ("caption".equals(this.columnType)) {
            this.node.setLogicalCaptionColumn(lCol);
        }
        this.workspace.setDirty(true);
        this.dialog.hide();
    }

    @Bindable
    public void cancel() {
        this.dialog.hide();
    }

    public String getName() {
        return "colResolver";
    }

    @Bindable
    public void setSelectedFieldsChanged(Object selected) {
        if (selected != null && selected instanceof AvailableField) {
            this.selectedFields = new IAvailableItem[]{(IAvailableItem)selected};
        }
    }

    public BindingFactory getBindingFactory() {
        return this.bf;
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }
}

