/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;

public abstract class GenericUDFFloorCeilBase
extends GenericUDF {
    private final String opName;
    protected String opDisplayName;
    private transient PrimitiveObjectInspector inputOI;
    private transient PrimitiveObjectInspector resultOI;
    private transient ObjectInspectorConverters.Converter converter;
    protected LongWritable longWritable = new LongWritable();
    protected HiveDecimalWritable decimalWritable = new HiveDecimalWritable();

    public GenericUDFFloorCeilBase() {
        this.opName = this.getClass().getSimpleName();
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException(this.opName + " requires one argument.");
        }
        ObjectInspector.Category category = arguments[0].getCategory();
        if (category != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "The " + GenericUDFUtils.getOrdinal(1) + " argument of " + this.opName + "  is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.inputOI = (PrimitiveObjectInspector)arguments[0];
        if (!FunctionRegistry.isNumericType(this.inputOI.getTypeInfo())) {
            throw new UDFArgumentTypeException(0, "The " + GenericUDFUtils.getOrdinal(1) + " argument of " + this.opName + "  is expected to a " + "numeric type, but " + this.inputOI.getTypeName() + " is found");
        }
        PrimitiveTypeInfo resultTypeInfo = null;
        PrimitiveTypeInfo inputTypeInfo = this.inputOI.getTypeInfo();
        if (inputTypeInfo instanceof DecimalTypeInfo) {
            DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)inputTypeInfo;
            resultTypeInfo = TypeInfoFactory.getDecimalTypeInfo((int)(decTypeInfo.precision() - decTypeInfo.scale() + 1), (int)0);
            AbstractPrimitiveWritableObjectInspector decimalOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)decTypeInfo);
            this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)decimalOI);
        } else {
            resultTypeInfo = TypeInfoFactory.longTypeInfo;
            WritableDoubleObjectInspector doubleObjectInspector = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
            this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.inputOI, (ObjectInspector)doubleObjectInspector);
        }
        this.resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)resultTypeInfo);
        return this.resultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0] == null) {
            return null;
        }
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        if ((input = this.converter.convert(input)) == null) {
            return null;
        }
        switch (this.resultOI.getPrimitiveCategory()) {
            case LONG: {
                return this.evaluate((DoubleWritable)input);
            }
            case DECIMAL: {
                return this.evaluate((HiveDecimalWritable)input);
            }
        }
        throw new IllegalStateException("Unexpected type in evaluating " + this.opName + ": " + this.inputOI.getPrimitiveCategory());
    }

    protected abstract LongWritable evaluate(DoubleWritable var1);

    protected abstract HiveDecimalWritable evaluate(HiveDecimalWritable var1);

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return this.getStandardDisplayString(this.opDisplayName, children);
    }
}

