/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveAuthorizationProviderBase
implements HiveAuthorizationProvider {
    protected HiveProxy hive_db;
    protected HiveAuthenticationProvider authenticator;
    private Configuration conf;
    public static final Logger LOG = LoggerFactory.getLogger(HiveAuthorizationProvider.class);

    public void setConf(Configuration conf) {
        this.conf = conf;
        try {
            this.init(conf);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public HiveAuthenticationProvider getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(HiveAuthenticationProvider authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public HivePolicyProvider getHivePolicyProvider() throws HiveAuthzPluginException {
        return null;
    }

    protected class HiveProxy {
        private final boolean hasHiveClient;
        private final HiveConf conf;
        private IHMSHandler handler;

        public HiveProxy(Hive hive) {
            this.hasHiveClient = hive != null;
            this.conf = hive.getConf();
            this.handler = null;
        }

        public HiveProxy() {
            this.hasHiveClient = false;
            this.conf = null;
            this.handler = null;
        }

        public void setHandler(IHMSHandler handler) {
            this.handler = handler;
        }

        public boolean isRunFromMetaStore() {
            return !this.hasHiveClient;
        }

        public PrincipalPrivilegeSet get_privilege_set(HiveObjectType column, String dbName, String tableName, List<String> partValues, String col, String userName, List<String> groupNames) throws HiveException {
            if (!this.isRunFromMetaStore()) {
                return Hive.getWithFastCheck(this.conf).get_privilege_set(column, dbName, tableName, partValues, col, userName, groupNames);
            }
            HiveObjectRef hiveObj = new HiveObjectRef(column, dbName, tableName, partValues, col);
            try {
                return this.handler.get_privilege_set(hiveObj, userName, groupNames);
            }
            catch (MetaException e) {
                throw new HiveException(e);
            }
            catch (TException e) {
                throw new HiveException(e);
            }
        }

        public Database getDatabase(String catName, String dbName) throws HiveException {
            String string = catName = catName == null ? MetaStoreUtils.getDefaultCatalog((Configuration)this.conf) : catName;
            if (!this.isRunFromMetaStore()) {
                return Hive.getWithFastCheck(this.conf).getDatabase(catName, dbName);
            }
            try {
                return this.handler.get_database_core(catName, dbName);
            }
            catch (NoSuchObjectException e) {
                throw new HiveException(e);
            }
            catch (MetaException e) {
                throw new HiveException(e);
            }
        }
    }
}

