/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerialized;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkCommonOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hive.common.util.HashCodeUtil;

public abstract class VectorReduceSinkUniformHashOperator
extends VectorReduceSinkCommonOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkUniformHashOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private transient byte[] nullBytes;
    private transient int nullKeyHashCode;
    protected transient VectorKeySeriesSerialized serializedKeySeries;

    protected VectorReduceSinkUniformHashOperator() {
    }

    public VectorReduceSinkUniformHashOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkUniformHashOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        Preconditions.checkState((!this.isEmptyKey ? 1 : 0) != 0);
        try {
            ByteStream.Output nullKeyOutput = new ByteStream.Output();
            this.keyBinarySortableSerializeWrite.set(nullKeyOutput);
            for (int i = 0; i < this.reduceSinkKeyColumnMap.length; ++i) {
                this.keyBinarySortableSerializeWrite.writeNull();
            }
            int nullBytesLength = nullKeyOutput.getLength();
            this.nullBytes = new byte[nullBytesLength];
            System.arraycopy(nullKeyOutput.getData(), 0, this.nullBytes, 0, nullBytesLength);
            this.nullKeyHashCode = HashCodeUtil.calculateBytesHashCode((byte[])this.nullBytes, (int)0, (int)nullBytesLength);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            ++this.batchCounter;
            if (batch.size == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.reduceSinkKeyExpressions != null) {
                for (VectorExpression ve : this.reduceSinkKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkValueExpressions != null) {
                for (VectorExpression ve : this.reduceSinkValueExpressions) {
                    ve.evaluate(batch);
                }
            }
            this.serializedKeySeries.processBatch(batch);
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            do {
                if (this.serializedKeySeries.getCurrentIsAllNull()) {
                    if (tag == -1 || this.reduceSkipTag) {
                        this.keyWritable.set(this.nullBytes, 0, this.nullBytes.length);
                    } else {
                        this.keyWritable.setSize(this.nullBytes.length + 1);
                        System.arraycopy(this.nullBytes, 0, this.keyWritable.get(), 0, this.nullBytes.length);
                        this.keyWritable.get()[this.nullBytes.length] = this.reduceTagByte;
                    }
                    this.keyWritable.setDistKeyLength(this.nullBytes.length);
                    this.keyWritable.setHashCode(this.nullKeyHashCode);
                } else {
                    int keyLength = this.serializedKeySeries.getSerializedLength();
                    if (tag == -1 || this.reduceSkipTag) {
                        this.keyWritable.set(this.serializedKeySeries.getSerializedBytes(), this.serializedKeySeries.getSerializedStart(), keyLength);
                    } else {
                        this.keyWritable.setSize(keyLength + 1);
                        System.arraycopy(this.serializedKeySeries.getSerializedBytes(), this.serializedKeySeries.getSerializedStart(), this.keyWritable.get(), 0, keyLength);
                        this.keyWritable.get()[keyLength] = this.reduceTagByte;
                    }
                    this.keyWritable.setDistKeyLength(keyLength);
                    this.keyWritable.setHashCode(this.serializedKeySeries.getCurrentHashCode());
                }
                int logical = this.serializedKeySeries.getCurrentLogical();
                int end = logical + this.serializedKeySeries.getCurrentDuplicateCount();
                if (!this.isEmptyValue) {
                    if (selectedInUse) {
                        do {
                            int batchIndex = selected[logical];
                            this.valueLazyBinarySerializeWrite.reset();
                            this.valueVectorSerializeRow.serializeWrite(batch, batchIndex);
                            this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
                            this.collect(this.keyWritable, this.valueBytesWritable);
                        } while (++logical < end);
                        continue;
                    }
                    do {
                        this.valueLazyBinarySerializeWrite.reset();
                        this.valueVectorSerializeRow.serializeWrite(batch, logical);
                        this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
                        this.collect(this.keyWritable, this.valueBytesWritable);
                    } while (++logical < end);
                    continue;
                }
                do {
                    this.collect(this.keyWritable, this.valueBytesWritable);
                } while (++logical < end);
            } while (this.serializedKeySeries.next());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

