/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayInputStream;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.common.util.BloomKFilter;

public class VectorInBloomFilterColDynamicValue
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final int colNum;
    protected final DynamicValue bloomFilterDynamicValue;
    protected transient boolean initialized = false;
    protected transient BloomKFilter bloomFilter;
    protected transient BloomFilterCheck bfCheck;
    protected transient ColumnVector.Type colVectorType;

    public VectorInBloomFilterColDynamicValue(int colNum, DynamicValue bloomFilterDynamicValue) {
        this.colNum = colNum;
        this.bloomFilterDynamicValue = bloomFilterDynamicValue;
    }

    public VectorInBloomFilterColDynamicValue() {
        this.colNum = -1;
        this.bloomFilterDynamicValue = null;
    }

    @Override
    public void transientInit() throws HiveException {
        super.transientInit();
        this.colVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(this.inputTypeInfos[0]);
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.bloomFilterDynamicValue.setConf(conf);
        switch (this.colVectorType) {
            case LONG: 
            case DECIMAL_64: {
                this.bfCheck = new LongBloomFilterCheck();
                break;
            }
            case DOUBLE: {
                this.bfCheck = new DoubleBloomFilterCheck();
                break;
            }
            case DECIMAL: {
                this.bfCheck = new DecimalBloomFilterCheck();
                break;
            }
            case BYTES: {
                this.bfCheck = new BytesBloomFilterCheck();
                break;
            }
            case TIMESTAMP: {
                this.bfCheck = new TimestampBloomFilterCheck();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type " + this.colVectorType);
            }
        }
    }

    private void initValue() {
        NonSyncByteArrayInputStream in = null;
        try {
            Object val = this.bloomFilterDynamicValue.getValue();
            if (val != null) {
                BinaryObjectInspector boi = (BinaryObjectInspector)this.bloomFilterDynamicValue.getObjectInspector();
                byte[] bytes = boi.getPrimitiveJavaObject(val);
                in = new NonSyncByteArrayInputStream(bytes);
                this.bloomFilter = BloomKFilter.deserialize((InputStream)in);
            } else {
                this.bloomFilter = null;
            }
            this.initialized = true;
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
        finally {
            IOUtils.closeStream(in);
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (!this.initialized) {
            this.initValue();
        }
        ColumnVector inputColVector = batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.bloomFilter == null) {
            batch.size = 0;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.bfCheck.checkValue(inputColVector, 0)) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.bfCheck.checkValue(inputColVector, i)) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.bfCheck.checkValue(inputColVector, i)) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.bfCheck.checkValue(inputColVector, 0)) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.bfCheck.checkValue(inputColVector, i)) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.bfCheck.checkValue(inputColVector, i)) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.ALL_FAMILY, VectorExpressionDescriptor.ArgumentType.BINARY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.DYNAMICVALUE);
        return b.build();
    }

    @Override
    public String vectorExpressionParameters() {
        return null;
    }

    class TimestampBloomFilterCheck
    extends BloomFilterCheck {
        TimestampBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            TimestampColumnVector col = (TimestampColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testLong(col.time[idx]);
        }
    }

    class DecimalBloomFilterCheck
    extends BloomFilterCheck {
        private byte[] scratchBuffer;

        DecimalBloomFilterCheck() {
            this.scratchBuffer = new byte[79];
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            DecimalColumnVector col = (DecimalColumnVector)columnVector;
            int startIdx = col.vector[idx].toBytes(this.scratchBuffer);
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testBytes(this.scratchBuffer, startIdx, this.scratchBuffer.length - startIdx);
        }
    }

    class DoubleBloomFilterCheck
    extends BloomFilterCheck {
        DoubleBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            DoubleColumnVector col = (DoubleColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testDouble(col.vector[idx]);
        }
    }

    class LongBloomFilterCheck
    extends BloomFilterCheck {
        LongBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            LongColumnVector col = (LongColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testLong(col.vector[idx]);
        }
    }

    class BytesBloomFilterCheck
    extends BloomFilterCheck {
        BytesBloomFilterCheck() {
        }

        @Override
        public boolean checkValue(ColumnVector columnVector, int idx) {
            BytesColumnVector col = (BytesColumnVector)columnVector;
            return VectorInBloomFilterColDynamicValue.this.bloomFilter.testBytes(col.vector[idx], col.start[idx], col.length[idx]);
        }
    }

    abstract class BloomFilterCheck {
        BloomFilterCheck() {
        }

        public abstract boolean checkValue(ColumnVector var1, int var2);
    }
}

