/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.tablecompare;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tablecompare.TableCompare;
import org.pentaho.di.trans.steps.tablecompare.TableCompareMeta;
import org.pentaho.di.ui.core.widget.LabelCombo;
import org.pentaho.di.ui.core.widget.LabelText;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class TableCompareDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = TableCompare.class;
    private TableCompareMeta input;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private RowMetaInterface prevFields = null;
    private LabelCombo wReferenceDB;
    private LabelCombo wReferenceSchema;
    private LabelCombo wReferenceTable;
    private LabelCombo wCompareDB;
    private LabelCombo wCompareSchema;
    private LabelCombo wCompareTable;
    private LabelCombo wKeyFields;
    private LabelCombo wExcludeFields;
    private LabelText wNrErrors;
    private LabelText wNrRecordsReference;
    private LabelText wNrRecordsCompare;
    private LabelText wNrErrorsLeftJoin;
    private LabelText wNrErrorsInnerJoin;
    private LabelText wNrErrorsRightJoin;
    private LabelCombo wKeyDesc;
    private LabelCombo wReferenceValue;
    private LabelCombo wCompareValue;

    public TableCompareDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (TableCompareMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableCompareDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.Shell.Title", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(this.middle, -this.margin);
        this.fdlStepname.top = new FormAttachment(0, this.margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(this.middle, 0);
        this.fdStepname.top = new FormAttachment(0, this.margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Object lastControl = this.wStepname;
        this.wReferenceDB = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceDB.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceDB.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceDB);
        FormData fdReferenceDB = new FormData();
        fdReferenceDB.left = new FormAttachment(0, 0);
        fdReferenceDB.top = new FormAttachment((Control)lastControl, this.margin);
        fdReferenceDB.right = new FormAttachment(100, 0);
        this.wReferenceDB.setLayoutData(fdReferenceDB);
        lastControl = this.wReferenceDB;
        this.wReferenceSchema = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceSchemaField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceSchemaField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceSchema);
        FormData fdReferenceSchema = new FormData();
        fdReferenceSchema.left = new FormAttachment(0, 0);
        fdReferenceSchema.top = new FormAttachment((Control)lastControl, this.margin);
        fdReferenceSchema.right = new FormAttachment(100, 0);
        this.wReferenceSchema.setLayoutData(fdReferenceSchema);
        lastControl = this.wReferenceSchema;
        this.wReferenceTable = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceTableField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceTableField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceTable);
        FormData fdReferenceTable = new FormData();
        fdReferenceTable.left = new FormAttachment(0, 0);
        fdReferenceTable.top = new FormAttachment((Control)lastControl, this.margin);
        fdReferenceTable.right = new FormAttachment(100, 0);
        this.wReferenceTable.setLayoutData(fdReferenceTable);
        lastControl = this.wReferenceTable;
        this.wCompareDB = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareDB.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareDB.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareDB);
        FormData fdCompareDB = new FormData();
        fdCompareDB.left = new FormAttachment(0, 0);
        fdCompareDB.top = new FormAttachment((Control)lastControl, this.margin);
        fdCompareDB.right = new FormAttachment(100, 0);
        this.wCompareDB.setLayoutData(fdCompareDB);
        lastControl = this.wCompareDB;
        this.wCompareSchema = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareSchemaField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareSchemaField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareSchema);
        FormData fdCompareSchema = new FormData();
        fdCompareSchema.left = new FormAttachment(0, 0);
        fdCompareSchema.top = new FormAttachment((Control)lastControl, this.margin);
        fdCompareSchema.right = new FormAttachment(100, 0);
        this.wCompareSchema.setLayoutData(fdCompareSchema);
        lastControl = this.wCompareSchema;
        this.wCompareTable = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareTableField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareTableField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareTable);
        FormData fdCompareTable = new FormData();
        fdCompareTable.left = new FormAttachment(0, 0);
        fdCompareTable.top = new FormAttachment((Control)lastControl, this.margin);
        fdCompareTable.right = new FormAttachment(100, 0);
        this.wCompareTable.setLayoutData(fdCompareTable);
        lastControl = this.wCompareTable;
        this.wKeyFields = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyFieldsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyFieldsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyFields);
        FormData fdKeyFields = new FormData();
        fdKeyFields.left = new FormAttachment(0, 0);
        fdKeyFields.top = new FormAttachment((Control)lastControl, this.margin);
        fdKeyFields.right = new FormAttachment(100, 0);
        this.wKeyFields.setLayoutData(fdKeyFields);
        lastControl = this.wKeyFields;
        this.wExcludeFields = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ExcludeFieldsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ExcludeFieldsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExcludeFields);
        FormData fdExcludeFields = new FormData();
        fdExcludeFields.left = new FormAttachment(0, 0);
        fdExcludeFields.top = new FormAttachment((Control)lastControl, this.margin);
        fdExcludeFields.right = new FormAttachment(100, 0);
        this.wExcludeFields.setLayoutData(fdExcludeFields);
        lastControl = this.wExcludeFields;
        this.wNrErrors = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrors);
        FormData fdNrErrors = new FormData();
        fdNrErrors.left = new FormAttachment(0, 0);
        fdNrErrors.top = new FormAttachment((Control)lastControl, this.margin * 3);
        fdNrErrors.right = new FormAttachment(100, 0);
        this.wNrErrors.setLayoutData(fdNrErrors);
        lastControl = this.wNrErrors;
        this.wNrRecordsReference = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsReferenceField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsReferenceField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrRecordsReference);
        FormData fdNrRecordsReference = new FormData();
        fdNrRecordsReference.left = new FormAttachment(0, 0);
        fdNrRecordsReference.top = new FormAttachment((Control)lastControl, this.margin);
        fdNrRecordsReference.right = new FormAttachment(100, 0);
        this.wNrRecordsReference.setLayoutData(fdNrRecordsReference);
        lastControl = this.wNrRecordsReference;
        this.wNrRecordsCompare = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsCompareField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsCompareField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrRecordsCompare);
        FormData fdNrRecordsCompare = new FormData();
        fdNrRecordsCompare.left = new FormAttachment(0, 0);
        fdNrRecordsCompare.top = new FormAttachment((Control)lastControl, this.margin);
        fdNrRecordsCompare.right = new FormAttachment(100, 0);
        this.wNrRecordsCompare.setLayoutData(fdNrRecordsCompare);
        lastControl = this.wNrRecordsCompare;
        this.wNrErrorsLeftJoin = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsLeftJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsLeftJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsLeftJoin);
        FormData fdNrErrorsLeftJoin = new FormData();
        fdNrErrorsLeftJoin.left = new FormAttachment(0, 0);
        fdNrErrorsLeftJoin.top = new FormAttachment((Control)lastControl, this.margin);
        fdNrErrorsLeftJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsLeftJoin.setLayoutData(fdNrErrorsLeftJoin);
        lastControl = this.wNrErrorsLeftJoin;
        this.wNrErrorsInnerJoin = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsInnerJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsInnerJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsInnerJoin);
        FormData fdNrErrorsInnerJoin = new FormData();
        fdNrErrorsInnerJoin.left = new FormAttachment(0, 0);
        fdNrErrorsInnerJoin.top = new FormAttachment((Control)lastControl, this.margin);
        fdNrErrorsInnerJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsInnerJoin.setLayoutData(fdNrErrorsInnerJoin);
        lastControl = this.wNrErrorsInnerJoin;
        this.wNrErrorsRightJoin = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsRightJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsRightJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsRightJoin);
        FormData fdNrErrorsRightJoin = new FormData();
        fdNrErrorsRightJoin.left = new FormAttachment(0, 0);
        fdNrErrorsRightJoin.top = new FormAttachment((Control)lastControl, this.margin);
        fdNrErrorsRightJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsRightJoin.setLayoutData(fdNrErrorsRightJoin);
        lastControl = this.wNrErrorsRightJoin;
        this.wKeyDesc = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyDescField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyDescField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyDesc);
        FormData fdKeyDesc = new FormData();
        fdKeyDesc.left = new FormAttachment(0, 0);
        fdKeyDesc.top = new FormAttachment((Control)lastControl, this.margin * 3);
        fdKeyDesc.right = new FormAttachment(100, 0);
        this.wKeyDesc.setLayoutData(fdKeyDesc);
        lastControl = this.wKeyDesc;
        this.wReferenceValue = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceValue);
        FormData fdReferenceValue = new FormData();
        fdReferenceValue.left = new FormAttachment(0, 0);
        fdReferenceValue.top = new FormAttachment((Control)lastControl, this.margin);
        fdReferenceValue.right = new FormAttachment(100, 0);
        this.wReferenceValue.setLayoutData(fdReferenceValue);
        lastControl = this.wReferenceValue;
        this.wCompareValue = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareValue);
        FormData fdCompareValue = new FormData();
        fdCompareValue.left = new FormAttachment(0, 0);
        fdCompareValue.top = new FormAttachment((Control)lastControl, this.margin);
        fdCompareValue.right = new FormAttachment(100, 0);
        this.wCompareValue.setLayoutData(fdCompareValue);
        lastControl = this.wCompareValue;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, this.margin, (Control)lastControl);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TableCompareDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TableCompareDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableCompareDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wNrErrors.addSelectionListener((SelectionListener)this.lsDef);
        this.wNrRecordsReference.addSelectionListener((SelectionListener)this.lsDef);
        this.wNrRecordsCompare.addSelectionListener((SelectionListener)this.lsDef);
        this.wNrErrorsLeftJoin.addSelectionListener((SelectionListener)this.lsDef);
        this.wNrErrorsInnerJoin.addSelectionListener((SelectionListener)this.lsDef);
        this.wNrErrorsRightJoin.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TableCompareDialog.this.cancel();
            }
        });
        this.getData();
        this.setSize();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                try {
                    TableCompareDialog.this.prevFields = TableCompareDialog.this.transMeta.getPrevStepFields(TableCompareDialog.this.stepname);
                }
                catch (KettleException e) {
                    String msg = BaseMessages.getString((Class)PKG, (String)"TableCompareDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                    TableCompareDialog.this.log.logError(this.toString(), new Object[]{msg});
                }
                Object[] prevStepFieldNames = TableCompareDialog.this.prevFields.getFieldNames();
                if (prevStepFieldNames != null) {
                    Arrays.sort(prevStepFieldNames);
                    TableCompareDialog.this.wReferenceSchema.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wReferenceTable.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wCompareSchema.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wCompareTable.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wKeyFields.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wExcludeFields.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wKeyDesc.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wReferenceValue.setItems((String[])prevStepFieldNames);
                    TableCompareDialog.this.wCompareValue.setItems((String[])prevStepFieldNames);
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        for (DatabaseMeta dbMeta : this.transMeta.getDatabases()) {
            this.wReferenceDB.add(dbMeta.getName());
            this.wCompareDB.add(dbMeta.getName());
        }
        this.wReferenceDB.setText(this.input.getReferenceConnection() != null ? this.input.getReferenceConnection().getName() : "");
        this.wReferenceSchema.setText(Const.NVL((String)this.input.getReferenceSchemaField(), (String)""));
        this.wReferenceTable.setText(Const.NVL((String)this.input.getReferenceTableField(), (String)""));
        this.wCompareDB.setText(this.input.getCompareConnection() != null ? this.input.getCompareConnection().getName() : "");
        this.wCompareSchema.setText(Const.NVL((String)this.input.getCompareSchemaField(), (String)""));
        this.wCompareTable.setText(Const.NVL((String)this.input.getCompareTableField(), (String)""));
        this.wKeyFields.setText(Const.NVL((String)this.input.getKeyFieldsField(), (String)""));
        this.wExcludeFields.setText(Const.NVL((String)this.input.getExcludeFieldsField(), (String)""));
        this.wNrErrors.setText(Const.NVL((String)this.input.getNrErrorsField(), (String)""));
        this.wNrRecordsReference.setText(Const.NVL((String)this.input.getNrRecordsReferenceField(), (String)""));
        this.wNrRecordsCompare.setText(Const.NVL((String)this.input.getNrRecordsCompareField(), (String)""));
        this.wNrErrorsLeftJoin.setText(Const.NVL((String)this.input.getNrErrorsLeftJoinField(), (String)""));
        this.wNrErrorsInnerJoin.setText(Const.NVL((String)this.input.getNrErrorsInnerJoinField(), (String)""));
        this.wNrErrorsRightJoin.setText(Const.NVL((String)this.input.getNrErrorsRightJoinField(), (String)""));
        this.wKeyDesc.setText(Const.NVL((String)this.input.getKeyDescriptionField(), (String)""));
        this.wReferenceValue.setText(Const.NVL((String)this.input.getValueReferenceField(), (String)""));
        this.wCompareValue.setText(Const.NVL((String)this.input.getValueCompareField(), (String)""));
        this.setComboValues();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setReferenceConnection(this.transMeta.findDatabase(this.wReferenceDB.getText()));
        this.input.setReferenceSchemaField(this.wReferenceSchema.getText());
        this.input.setReferenceTableField(this.wReferenceTable.getText());
        this.input.setCompareConnection(this.transMeta.findDatabase(this.wCompareDB.getText()));
        this.input.setCompareSchemaField(this.wCompareSchema.getText());
        this.input.setCompareTableField(this.wCompareTable.getText());
        this.input.setKeyFieldsField(this.wKeyFields.getText());
        this.input.setExcludeFieldsField(this.wExcludeFields.getText());
        this.input.setNrErrorsField(this.wNrErrors.getText());
        this.input.setNrRecordsReferenceField(this.wNrRecordsReference.getText());
        this.input.setNrRecordsCompareField(this.wNrRecordsCompare.getText());
        this.input.setNrErrorsLeftJoinField(this.wNrErrorsLeftJoin.getText());
        this.input.setNrErrorsInnerJoinField(this.wNrErrorsInnerJoin.getText());
        this.input.setNrErrorsRightJoinField(this.wNrErrorsRightJoin.getText());
        this.input.setKeyDescriptionField(this.wKeyDesc.getText());
        this.input.setValueReferenceField(this.wReferenceValue.getText());
        this.input.setValueCompareField(this.wCompareValue.getText());
        this.dispose();
    }
}

