/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.symmetriccrypto.secretkeygenerator;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator.SecretKeyGeneratorMeta;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCryptoMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SecretKeyGeneratorDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SecretKeyGeneratorMeta.class;
    private Label wlStepname;
    private Text wStepname;
    private FormData fdlStepname;
    private FormData fdStepname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Group wOutputFields;
    private Label wlSecretKeyField;
    private FormData fdlSecretKeyField;
    private Text wSecretKeyField;
    private FormData fdSecretKeyField;
    private Label wlSecretKeyLengthField;
    private FormData fdlSecretKeyLengthField;
    private Label wlAlgorithmField;
    private FormData fdlAlgorithmField;
    private Text wSecretKeyLengthField;
    private FormData fdSecretKeyLengthField;
    private Text wAlgorithmField;
    private FormData fdAlgorithmField;
    private Label wlOutputKeyAsByinary;
    private Button wOutputKeyAsByinary;
    private FormData fdlOutputKeyAsByinary;
    private FormData fdOutputKeyAsByinary;
    private SecretKeyGeneratorMeta input;
    private boolean isReceivingInput = false;

    public SecretKeyGeneratorDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SecretKeyGeneratorMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SecretKeyGeneratorDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.isReceivingInput = this.transMeta.findNrPrevSteps(this.stepMeta) > 0;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wOutputFields = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wOutputFields);
        this.wOutputFields.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.wOutputFields.Label", (String[])new String[0]));
        FormLayout OutputFieldsgroupLayout = new FormLayout();
        OutputFieldsgroupLayout.marginWidth = 10;
        OutputFieldsgroupLayout.marginHeight = 10;
        this.wOutputFields.setLayout((Layout)OutputFieldsgroupLayout);
        this.wlSecretKeyField = new Label((Composite)this.wOutputFields, 131072);
        this.wlSecretKeyField.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.SecretKeyFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSecretKeyField);
        this.fdlSecretKeyField = new FormData();
        this.fdlSecretKeyField.left = new FormAttachment(0, 0);
        this.fdlSecretKeyField.right = new FormAttachment(middle, -margin);
        this.fdlSecretKeyField.top = new FormAttachment((Control)this.wStepname, margin * 2);
        this.wlSecretKeyField.setLayoutData((Object)this.fdlSecretKeyField);
        this.wSecretKeyField = new Text((Composite)this.wOutputFields, 18436);
        this.wSecretKeyField.setToolTipText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.SecretKeyFieldName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSecretKeyField);
        this.wSecretKeyField.addModifyListener(lsMod);
        this.fdSecretKeyField = new FormData();
        this.fdSecretKeyField.left = new FormAttachment(middle, 0);
        this.fdSecretKeyField.top = new FormAttachment((Control)this.wStepname, margin * 2);
        this.fdSecretKeyField.right = new FormAttachment(100, 0);
        this.wSecretKeyField.setLayoutData((Object)this.fdSecretKeyField);
        this.wlAlgorithmField = new Label((Composite)this.wOutputFields, 131072);
        this.wlAlgorithmField.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.Algorithm.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAlgorithmField);
        this.fdlAlgorithmField = new FormData();
        this.fdlAlgorithmField.left = new FormAttachment(0, 0);
        this.fdlAlgorithmField.right = new FormAttachment(middle, -margin);
        this.fdlAlgorithmField.top = new FormAttachment((Control)this.wSecretKeyField, margin);
        this.wlAlgorithmField.setLayoutData((Object)this.fdlAlgorithmField);
        this.wAlgorithmField = new Text((Composite)this.wOutputFields, 18436);
        this.wAlgorithmField.setToolTipText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.Algorithm.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAlgorithmField);
        this.wAlgorithmField.addModifyListener(lsMod);
        this.fdAlgorithmField = new FormData();
        this.fdAlgorithmField.left = new FormAttachment(middle, 0);
        this.fdAlgorithmField.top = new FormAttachment((Control)this.wSecretKeyField, margin);
        this.fdAlgorithmField.right = new FormAttachment(100, 0);
        this.wAlgorithmField.setLayoutData((Object)this.fdAlgorithmField);
        this.wlSecretKeyLengthField = new Label((Composite)this.wOutputFields, 131072);
        this.wlSecretKeyLengthField.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.SecretKeyLength.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSecretKeyLengthField);
        this.fdlSecretKeyLengthField = new FormData();
        this.fdlSecretKeyLengthField.left = new FormAttachment(0, 0);
        this.fdlSecretKeyLengthField.right = new FormAttachment(middle, -margin);
        this.fdlSecretKeyLengthField.top = new FormAttachment((Control)this.wAlgorithmField, margin);
        this.wlSecretKeyLengthField.setLayoutData((Object)this.fdlSecretKeyLengthField);
        this.wSecretKeyLengthField = new Text((Composite)this.wOutputFields, 18436);
        this.wSecretKeyLengthField.setToolTipText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.SecretKeyLength.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSecretKeyLengthField);
        this.wSecretKeyLengthField.addModifyListener(lsMod);
        this.fdSecretKeyLengthField = new FormData();
        this.fdSecretKeyLengthField.left = new FormAttachment(middle, 0);
        this.fdSecretKeyLengthField.top = new FormAttachment((Control)this.wAlgorithmField, margin);
        this.fdSecretKeyLengthField.right = new FormAttachment(100, 0);
        this.wSecretKeyLengthField.setLayoutData((Object)this.fdSecretKeyLengthField);
        this.wlOutputKeyAsByinary = new Label((Composite)this.wOutputFields, 131072);
        this.wlOutputKeyAsByinary.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.OutputKeyAsByinary.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutputKeyAsByinary);
        this.fdlOutputKeyAsByinary = new FormData();
        this.fdlOutputKeyAsByinary.left = new FormAttachment(0, 0);
        this.fdlOutputKeyAsByinary.top = new FormAttachment((Control)this.wSecretKeyLengthField, margin);
        this.fdlOutputKeyAsByinary.right = new FormAttachment(middle, -margin);
        this.wlOutputKeyAsByinary.setLayoutData((Object)this.fdlOutputKeyAsByinary);
        this.wOutputKeyAsByinary = new Button((Composite)this.wOutputFields, 32);
        this.wOutputKeyAsByinary.setToolTipText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.OutputKeyAsByinary.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOutputKeyAsByinary);
        this.fdOutputKeyAsByinary = new FormData();
        this.fdOutputKeyAsByinary.left = new FormAttachment(middle, 0);
        this.fdOutputKeyAsByinary.top = new FormAttachment((Control)this.wSecretKeyLengthField, margin);
        this.fdOutputKeyAsByinary.right = new FormAttachment(100, 0);
        this.wOutputKeyAsByinary.setLayoutData((Object)this.fdOutputKeyAsByinary);
        this.wOutputKeyAsByinary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecretKeyGeneratorDialog.this.input.setChanged();
            }
        });
        FormData fdOutputFields = new FormData();
        fdOutputFields.left = new FormAttachment(0, margin);
        fdOutputFields.top = new FormAttachment((Control)this.wStepname, 2 * margin);
        fdOutputFields.right = new FormAttachment(100, -margin);
        this.wOutputFields.setLayoutData((Object)fdOutputFields);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wOutputFields, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 4;
        int FieldsRows = this.input.getAlgorithm().length;
        ColumnInfo[] colinf = new ColumnInfo[4];
        colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.AlgorithmColumn.Column", (String[])new String[0]), 2, SymmetricCryptoMeta.TYPE_ALGORYTHM_CODE);
        colinf[0].setReadOnly(true);
        colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.SchemeColumn.Column", (String[])new String[0]), 1, false);
        colinf[1].setUsingVariables(true);
        colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.SecretKeyLengthColumn.Column", (String[])new String[0]), 1, false);
        colinf[2].setUsingVariables(true);
        colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.HowMany.Column", (String[])new String[0]), 1, false);
        colinf[3].setUsingVariables(true);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SecretKeyGeneratorDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SecretKeyGeneratorDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                SecretKeyGeneratorDialog.this.preview();
            }
        };
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SecretKeyGeneratorDialog.this.ok();
            }
        };
        this.wPreview.addListener(13, this.lsPreview);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SecretKeyGeneratorDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wStepname.setText(this.stepname);
        for (int i = 0; i < this.input.getAlgorithm().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            String algorithm = this.input.getAlgorithm()[i];
            String scheme = this.input.getScheme()[i];
            String len = this.input.getSecretKeyLength()[i];
            String size = this.input.getSecretKeyCount()[i];
            if (algorithm != null) {
                item.setText(1, algorithm);
            }
            if (scheme != null) {
                item.setText(2, scheme);
            } else {
                item.setText(2, algorithm);
            }
            if (len != null) {
                item.setText(3, len);
            }
            if (size == null) continue;
            item.setText(4, size);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        if (this.input.getSecretKeyFieldName() != null) {
            this.wSecretKeyField.setText(this.input.getSecretKeyFieldName());
        }
        if (this.input.getAlgorithmFieldName() != null) {
            this.wAlgorithmField.setText(this.input.getAlgorithmFieldName());
        }
        if (this.input.getSecretKeyLengthFieldName() != null) {
            this.wSecretKeyLengthField.setText(this.input.getSecretKeyLengthFieldName());
        }
        this.wOutputKeyAsByinary.setSelection(this.input.isOutputKeyInBinary());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, "Error", "Error saving step informations", (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(SecretKeyGeneratorMeta in) throws KettleException {
        this.stepname = this.wStepname.getText();
        int count = this.wFields.nrNonEmpty();
        in.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            in.getAlgorithm()[i] = item.getText(1);
            in.getScheme()[i] = item.getText(2);
            in.getSecretKeyLength()[i] = item.getText(3);
            in.getSecretKeyCount()[i] = item.getText(4);
        }
        in.setSecretKeyFieldName(this.wSecretKeyField.getText());
        in.setAlgorithmFieldName(this.wAlgorithmField.getText());
        in.setSecretKeyLengthFieldName(this.wSecretKeyLengthField.getText());
        in.setOutputKeyInBinary(this.wOutputKeyAsByinary.getSelection());
    }

    private void preview() {
        try {
            SecretKeyGeneratorMeta oneMeta = new SecretKeyGeneratorMeta();
            this.getInfo(oneMeta);
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Trans trans = progressDialog.getTrans();
                    String loggingText = progressDialog.getLoggingText();
                    if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SecretKeyGeneratorDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

