/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.pentaho.di.core.AddUndoPositionInterface;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.dnd.DragAndDropContainer;
import org.pentaho.di.core.dnd.XMLTransfer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.BasePainter;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.Redrawable;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.gui.SnapAllignDistribute;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.HasLogChannelInterface;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LogParentProvidedInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.lineage.TransDataLineage;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPainter;
import org.pentaho.di.trans.TransSupplier;
import org.pentaho.di.trans.debug.BreakPointListener;
import org.pentaho.di.trans.debug.StepDebugMeta;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.pentaho.di.trans.debug.TransDebugMetaWrapper;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.RowDistributionPluginType;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.DialogClosedListener;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterStringDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.StepFieldsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.CheckBoxToolTip;
import org.pentaho.di.ui.core.widget.CheckBoxToolTipListener;
import org.pentaho.di.ui.repository.RepositorySecurityUI;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryRevisionBrowserDialogInterface;
import org.pentaho.di.ui.spoon.AbstractGraph;
import org.pentaho.di.ui.spoon.SWTGC;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.di.ui.spoon.SpoonUiExtenderPluginInterface;
import org.pentaho.di.ui.spoon.SpoonUiExtenderPluginType;
import org.pentaho.di.ui.spoon.SwtScrollBar;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.dialog.EnterPreviewRowsDialog;
import org.pentaho.di.ui.spoon.dialog.NotePadDialog;
import org.pentaho.di.ui.spoon.dialog.SearchFieldsProgressDialog;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.DelayListener;
import org.pentaho.di.ui.spoon.trans.DelayTimer;
import org.pentaho.di.ui.spoon.trans.SelectedStepListener;
import org.pentaho.di.ui.spoon.trans.StepMenuExtension;
import org.pentaho.di.ui.spoon.trans.StepSelectionListener;
import org.pentaho.di.ui.spoon.trans.TransGraphExtension;
import org.pentaho.di.ui.spoon.trans.TransGridDelegate;
import org.pentaho.di.ui.spoon.trans.TransHistoryDelegate;
import org.pentaho.di.ui.spoon.trans.TransLogDelegate;
import org.pentaho.di.ui.spoon.trans.TransMetricsDelegate;
import org.pentaho.di.ui.spoon.trans.TransPainterFlyoutTooltipExtension;
import org.pentaho.di.ui.spoon.trans.TransPerfDelegate;
import org.pentaho.di.ui.spoon.trans.TransPreviewDelegate;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.jface.tags.JfaceMenuitem;
import org.pentaho.ui.xul.jface.tags.JfaceMenupopup;

public class TransGraph
extends AbstractGraph
implements XulEventHandler,
Redrawable,
TabItemInterface,
LogParentProvidedInterface,
MouseListener,
MouseMoveListener,
MouseTrackListener,
MouseWheelListener,
KeyListener {
    private static Class<?> PKG = Spoon.class;
    private LogChannelInterface log;
    private static final int HOP_SEL_MARGIN = 9;
    private static final String XUL_FILE_TRANS_TOOLBAR = "ui/trans-toolbar.xul";
    public static final String LOAD_TAB = "loadTab";
    public static final String PREVIEW_TRANS = "previewTrans";
    public static final String START_TEXT = BaseMessages.getString(PKG, (String)"TransLog.Button.StartTransformation", (String[])new String[0]);
    public static final String PAUSE_TEXT = BaseMessages.getString(PKG, (String)"TransLog.Button.PauseTransformation", (String[])new String[0]);
    public static final String RESUME_TEXT = BaseMessages.getString(PKG, (String)"TransLog.Button.ResumeTransformation", (String[])new String[0]);
    public static final String STOP_TEXT = BaseMessages.getString(PKG, (String)"TransLog.Button.StopTransformation", (String[])new String[0]);
    public static final String TRANS_GRAPH_ENTRY_SNIFF = "trans-graph-entry-sniff";
    public static final String TRANS_GRAPH_ENTRY_AGAIN = "trans-graph-entry-align";
    private static final int TOOLTIP_HIDE_DELAY_SHORT = 5000;
    private static final int TOOLTIP_HIDE_DELAY_LONG = 10000;
    private TransMeta transMeta;
    public Trans trans;
    private Shell shell;
    private Composite mainComposite;
    private DefaultToolTip toolTip;
    private CheckBoxToolTip helpTip;
    private XulToolbar toolbar;
    private int iconsize;
    private org.pentaho.di.core.gui.Point lastclick;
    private org.pentaho.di.core.gui.Point lastMove;
    private org.pentaho.di.core.gui.Point[] previous_step_locations;
    private org.pentaho.di.core.gui.Point[] previous_note_locations;
    private List<StepMeta> selectedSteps;
    private StepMeta selectedStep;
    private List<StepMeta> mouseOverSteps;
    private List<NotePadMeta> selectedNotes;
    private NotePadMeta selectedNote;
    private TransHopMeta candidate;
    private org.pentaho.di.core.gui.Point drop_candidate;
    private Spoon spoon;
    private boolean split_hop;
    private int lastButton;
    private TransHopMeta last_hop_split;
    private Rectangle selectionRegion;
    private List<CheckResultInterface> remarks;
    private List<DatabaseImpact> impact;
    private boolean impactFinished;
    private TransDebugMeta lastTransDebugMeta;
    private Map<String, XulMenupopup> menuMap = new HashMap<String, XulMenupopup>();
    protected int currentMouseX = 0;
    protected int currentMouseY = 0;
    protected NotePadMeta ni = null;
    protected TransHopMeta currentHop;
    protected StepMeta currentStep;
    private List<AreaOwner> areaOwners;
    private SashForm sashForm;
    public Composite extraViewComposite;
    public CTabFolder extraViewTabFolder;
    private boolean initialized;
    private boolean running;
    private boolean halted;
    private boolean halting;
    private boolean safeStopping;
    private boolean debug;
    private boolean pausing;
    public TransLogDelegate transLogDelegate;
    public TransGridDelegate transGridDelegate;
    public TransHistoryDelegate transHistoryDelegate;
    public TransPerfDelegate transPerfDelegate;
    public TransMetricsDelegate transMetricsDelegate;
    public TransPreviewDelegate transPreviewDelegate;
    public List<SelectedStepListener> stepListeners;
    public List<StepSelectionListener> currentStepListeners = new ArrayList<StepSelectionListener>();
    private Map<StepMeta, String> stepLogMap;
    private StepMeta startHopStep;
    private org.pentaho.di.core.gui.Point endHopLocation;
    private boolean startErrorHopStep;
    private StepMeta noInputStep;
    private StepMeta endHopStep;
    private StreamInterface.StreamType candidateHopType;
    private Map<StepMeta, DelayTimer> delayTimers;
    private StepMeta showTargetStreamsStep;
    Timer redrawTimer;
    private ToolItem stopItem;
    private Label closeButton;
    private Label minMaxButton;
    private static double dampningConstant = 0.5;
    private static double timeStep = 1.0;
    private static double nodeMass = 1.0;
    private StepMeta lastChained = null;

    public void setCurrentNote(NotePadMeta ni) {
        this.ni = ni;
    }

    public NotePadMeta getCurrentNote() {
        return this.ni;
    }

    public TransHopMeta getCurrentHop() {
        return this.currentHop;
    }

    public void setCurrentHop(TransHopMeta currentHop) {
        this.currentHop = currentHop;
    }

    public StepMeta getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(StepMeta currentStep) {
        this.currentStep = currentStep;
    }

    public void addSelectedStepListener(SelectedStepListener selectedStepListener) {
        this.stepListeners.add(selectedStepListener);
    }

    public void addCurrentStepListener(StepSelectionListener stepSelectionListener) {
        this.currentStepListeners.add(stepSelectionListener);
    }

    public TransGraph(Composite parent, final Spoon spoon, final TransMeta transMeta) {
        super(parent, 0);
        this.shell = parent.getShell();
        this.spoon = spoon;
        this.transMeta = transMeta;
        this.areaOwners = new ArrayList<AreaOwner>();
        this.log = spoon.getLog();
        spoon.clearSearchFilter();
        this.mouseOverSteps = new ArrayList<StepMeta>();
        this.delayTimers = new HashMap<StepMeta, DelayTimer>();
        this.transLogDelegate = new TransLogDelegate(spoon, this);
        this.transGridDelegate = new TransGridDelegate(spoon, this);
        this.transHistoryDelegate = new TransHistoryDelegate(spoon, this);
        this.transPerfDelegate = new TransPerfDelegate(spoon, this);
        this.transMetricsDelegate = new TransMetricsDelegate(spoon, this);
        this.transPreviewDelegate = new TransPreviewDelegate(spoon, this);
        this.stepListeners = new ArrayList<SelectedStepListener>();
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setIconsSize(16, 16);
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(Spoon.class);
            XulDomContainer container = loader.loadXul(XUL_FILE_TRANS_TOOLBAR, bundle);
            container.addEventHandler((XulEventHandler)this);
            SpoonPluginManager.getInstance().applyPluginsForContainer("trans-graph", this.xulDomContainer);
            this.setXulDomContainer(container);
        }
        catch (XulException e1) {
            this.log.logError("Error loading XUL resource bundle for Spoon", (Throwable)e1);
        }
        this.setLayout((Layout)new FormLayout());
        this.setLayoutData(new GridData(1808));
        this.addToolBar();
        this.setControlStates();
        this.mainComposite = new Composite((Composite)this, 0);
        this.mainComposite.setLayout((Layout)new FillLayout());
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        FormData toolbarFd = new FormData();
        toolbarFd.left = new FormAttachment(0, 0);
        toolbarFd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)toolbarFd);
        toolbarControl.setParent((Composite)this);
        FormData fdMainComposite = new FormData();
        fdMainComposite.left = new FormAttachment(0, 0);
        fdMainComposite.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdMainComposite.right = new FormAttachment(100, 0);
        fdMainComposite.bottom = new FormAttachment(100, 0);
        this.mainComposite.setLayoutData((Object)fdMainComposite);
        this.sashForm = new SashForm(this.mainComposite, 512);
        this.canvas = new Canvas((Composite)this.sashForm, 264960);
        this.sashForm.setWeights(new int[]{100});
        try {
            this.menuMap.put("trans-graph-hop", (XulMenupopup)this.getXulDomContainer().getDocumentRoot().getElementById("trans-graph-hop"));
            this.menuMap.put("trans-graph-entry", (XulMenupopup)this.getXulDomContainer().getDocumentRoot().getElementById("trans-graph-entry"));
            this.menuMap.put("trans-graph-background", (XulMenupopup)this.getXulDomContainer().getDocumentRoot().getElementById("trans-graph-background"));
            this.menuMap.put("trans-graph-note", (XulMenupopup)this.getXulDomContainer().getDocumentRoot().getElementById("trans-graph-note"));
        }
        catch (Throwable t) {
            this.log.logError("Error parsing XUL XML", t);
        }
        this.toolTip = new DefaultToolTip((Control)this.canvas, 2, true);
        this.toolTip.setRespectMonitorBounds(true);
        this.toolTip.setRespectDisplayBounds(true);
        this.toolTip.setPopupDelay(350);
        this.toolTip.setHideDelay(5000);
        this.toolTip.setShift(new Point(5, 5));
        this.helpTip = new CheckBoxToolTip((Control)this.canvas);
        this.helpTip.addCheckBoxToolTipListener(new CheckBoxToolTipListener(){

            @Override
            public void checkBoxSelected(boolean enabled) {
                spoon.props.setShowingHelpToolTips(enabled);
            }
        });
        this.iconsize = spoon.props.getIconSize();
        this.clearSettings();
        this.remarks = new ArrayList<CheckResultInterface>();
        this.impact = new ArrayList<DatabaseImpact>();
        this.impactFinished = false;
        this.hori = this.canvas.getHorizontalBar();
        this.vert = this.canvas.getVerticalBar();
        this.hori.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransGraph.this.redraw();
            }
        });
        this.vert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransGraph.this.redraw();
            }
        });
        this.hori.setThumb(100);
        this.vert.setThumb(100);
        this.hori.setVisible(true);
        this.vert.setVisible(true);
        this.setVisible(true);
        this.newProps();
        this.canvas.setBackground(GUIResource.getInstance().getColorBackground());
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!spoon.isStopped()) {
                    TransGraph.this.paintControl(e);
                }
            }
        });
        this.selectedSteps = null;
        this.lastclick = null;
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvas.addMouseTrackListener((MouseTrackListener)this);
        this.canvas.addMouseWheelListener((MouseWheelListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        Transfer[] ttypes = new Transfer[]{XMLTransfer.getInstance()};
        DropTarget ddTarget = new DropTarget((Control)this.canvas, 2);
        ddTarget.setTransfer(ttypes);
        ddTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                TransGraph.this.clearSettings();
                TransGraph.this.drop_candidate = PropsUI.calculateGridPosition(TransGraph.this.getRealPosition((Composite)TransGraph.this.canvas, event.x, event.y));
                TransGraph.this.redraw();
            }

            public void dragLeave(DropTargetEvent event) {
                TransGraph.this.drop_candidate = null;
                TransGraph.this.redraw();
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                TransGraph.this.drop_candidate = PropsUI.calculateGridPosition(TransGraph.this.getRealPosition((Composite)TransGraph.this.canvas, event.x, event.y));
                TransGraph.this.redraw();
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                org.pentaho.di.core.gui.Point p = TransGraph.this.getRealPosition((Composite)TransGraph.this.canvas, event.x, event.y);
                try {
                    DragAndDropContainer container = (DragAndDropContainer)event.data;
                    StepMeta stepMeta = null;
                    boolean newstep = false;
                    switch (container.getType()) {
                        case 1: {
                            stepMeta = transMeta.findStep(container.getData());
                            if (stepMeta != null) {
                                if (!stepMeta.isDrawn() && !transMeta.isStepUsedInTransHops(stepMeta)) break;
                                TransGraph.this.modalMessageDialog(TransGraph.this.getString("TransGraph.Dialog.StepIsAlreadyOnCanvas.Title"), TransGraph.this.getString("TransGraph.Dialog.StepIsAlreadyOnCanvas.Message"), 32);
                                return;
                            }
                            return;
                        }
                        case 2: {
                            String id = container.getId();
                            String name = container.getData();
                            stepMeta = spoon.newStep(transMeta, id, name, name, false, true);
                            if (stepMeta != null) {
                                newstep = true;
                                break;
                            }
                            return;
                        }
                        case 3: {
                            newstep = true;
                            String connectionName = container.getData();
                            TableInputMeta tii = new TableInputMeta();
                            tii.setDatabaseMeta(transMeta.findDatabase(connectionName));
                            PluginRegistry registry = PluginRegistry.getInstance();
                            String stepID = registry.getPluginId(StepPluginType.class, (Object)tii);
                            PluginInterface stepPlugin = registry.findPluginWithId(StepPluginType.class, stepID);
                            String stepName = transMeta.getAlternativeStepname(stepPlugin.getName());
                            stepMeta = new StepMeta(stepID, stepName, (StepMetaInterface)tii);
                            if (spoon.editStep(transMeta, stepMeta) != null) {
                                transMeta.addStep(stepMeta);
                                spoon.refreshTree();
                                spoon.refreshGraph();
                                break;
                            }
                            return;
                        }
                        case 4: {
                            TransGraph.this.newHop();
                            return;
                        }
                        default: {
                            TransGraph.this.modalMessageDialog(TransGraph.this.getString("TransGraph.Dialog.ItemCanNotBePlacedOnCanvas.Title"), TransGraph.this.getString("TransGraph.Dialog.ItemCanNotBePlacedOnCanvas.Message"), 32);
                            return;
                        }
                    }
                    transMeta.unselectAll();
                    StepMeta before = null;
                    if (!newstep) {
                        before = (StepMeta)stepMeta.clone();
                    }
                    stepMeta.drawStep();
                    stepMeta.setSelected(true);
                    PropsUI.setLocation((GUIPositionInterface)stepMeta, p.x, p.y);
                    if (newstep) {
                        spoon.addUndoNew((UndoInterface)transMeta, new StepMeta[]{stepMeta}, new int[]{transMeta.indexOfStep(stepMeta)});
                    } else {
                        spoon.addUndoChange((UndoInterface)transMeta, new StepMeta[]{before}, new StepMeta[]{(StepMeta)stepMeta.clone()}, new int[]{transMeta.indexOfStep(stepMeta)});
                    }
                    TransGraph.this.canvas.forceFocus();
                    TransGraph.this.redraw();
                    if (newstep && transMeta.nrSteps() > 1 && transMeta.nrSteps() < 5 && spoon.props.isShowingHelpToolTips()) {
                        TransGraph.this.showHelpTip(p.x, p.y, BaseMessages.getString((Class)PKG, (String)"TransGraph.HelpToolTip.CreatingHops.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"TransGraph.HelpToolTip.CreatingHops.Message", (String[])new String[0]));
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(TransGraph.this.shell, BaseMessages.getString((Class)PKG, (String)"TransGraph.Dialog.ErrorDroppingObject.Message", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"TransGraph.Dialog.ErrorDroppingObject.Title", (String[])new String[0]), e);
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.setBackground(GUIResource.getInstance().getColorBackground());
        final Timer timer = new Timer("TransGraph.setControlStates Timer: " + this.getMeta().getName());
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                block2: {
                    try {
                        TransGraph.this.setControlStates();
                    }
                    catch (KettleRepositoryLostException krle) {
                        if (!TransGraph.this.log.isBasic()) break block2;
                        TransGraph.this.log.logBasic(krle.getLocalizedMessage());
                    }
                }
            }
        };
        timer.schedule(timerTask, 2000L, 1000L);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                timer.cancel();
            }
        });
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.clearSettings();
        org.pentaho.di.core.gui.Point real = this.screen2real(e.x, e.y);
        this.hideToolTips();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransGraphMouseDoubleClick.id, (Object)new TransGraphExtension(this, e, real));
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling TransGraphMouseDoubleClick extension point", (Throwable)ex);
        }
        StepMeta stepMeta = this.transMeta.getStep(real.x, real.y, this.iconsize);
        if (stepMeta != null) {
            if (e.button == 1) {
                this.editStep(stepMeta);
            } else {
                this.editDescription(stepMeta);
            }
        } else {
            TransHopMeta online = this.findHop(real.x, real.y);
            if (online != null) {
                this.editHop(online);
            } else {
                NotePadMeta ni = this.transMeta.getNote(real.x, real.y);
                if (ni != null) {
                    this.selectedNote = null;
                    this.editNote(ni);
                } else {
                    boolean hit = false;
                    for (AreaOwner areaOwner : this.areaOwners) {
                        if (!areaOwner.contains(real.x, real.y) || !(areaOwner.getParent() instanceof StepMeta) || !areaOwner.getOwner().equals("PartitioningCurrentStep")) continue;
                        StepMeta step = (StepMeta)areaOwner.getParent();
                        this.spoon.editPartitioning(this.transMeta, step);
                        hit = true;
                        break;
                    }
                    if (!hit) {
                        this.settings();
                    }
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        boolean alt = (e.stateMask & 0x10000) != 0;
        boolean control = (e.stateMask & SWT.MOD1) != 0;
        boolean shift = (e.stateMask & 0x20000) != 0;
        this.lastButton = e.button;
        org.pentaho.di.core.gui.Point real = this.screen2real(e.x, e.y);
        this.lastclick = new org.pentaho.di.core.gui.Point(real.x, real.y);
        this.hideToolTips();
        if (e.button == 3) {
            this.setMenu(real.x, real.y);
            return;
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransGraphMouseDown.id, (Object)new TransGraphExtension(this, e, real));
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling TransGraphMouseDown extension point", (Throwable)ex);
        }
        if (e.button == 1 || e.button == 2) {
            AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
            if (areaOwner != null && areaOwner.getAreaType() != null) {
                switch (areaOwner.getAreaType()) {
                    case STEP_OUTPUT_HOP_ICON: {
                        this.selectedStep = null;
                        this.startHopStep = (StepMeta)areaOwner.getParent();
                        this.candidateHopType = null;
                        this.startErrorHopStep = false;
                        break;
                    }
                    case STEP_INPUT_HOP_ICON: {
                        this.selectedStep = null;
                        this.startHopStep = null;
                        this.endHopStep = (StepMeta)areaOwner.getParent();
                        this.candidateHopType = null;
                        this.startErrorHopStep = false;
                        break;
                    }
                    case HOP_ERROR_ICON: {
                        StepMeta stepMeta = (StepMeta)areaOwner.getParent();
                        this.spoon.editStepErrorHandling(this.transMeta, stepMeta);
                        break;
                    }
                    case STEP_TARGET_HOP_ICON_OPTION: {
                        break;
                    }
                    case STEP_EDIT_ICON: {
                        this.clearSettings();
                        this.currentStep = (StepMeta)areaOwner.getParent();
                        this.stopStepMouseOverDelayTimer(this.currentStep);
                        this.editStep();
                        break;
                    }
                    case STEP_INJECT_ICON: {
                        this.modalMessageDialog(this.getString("TransGraph.StepInjectionSupported.Title"), this.getString("TransGraph.StepInjectionSupported.Tooltip"), 34);
                        break;
                    }
                    case STEP_MENU_ICON: {
                        this.clearSettings();
                        StepMeta stepMeta = (StepMeta)areaOwner.getParent();
                        this.setMenu(stepMeta.getLocation().x, stepMeta.getLocation().y);
                        break;
                    }
                    case STEP_ICON: {
                        StepMeta stepMeta;
                        this.currentStep = stepMeta = (StepMeta)areaOwner.getOwner();
                        for (StepSelectionListener listener : this.currentStepListeners) {
                            listener.onUpdateSelection(this.currentStep);
                        }
                        if (this.candidate != null) {
                            this.addCandidateAsHop(e.x, e.y);
                        } else if (this.transPreviewDelegate.isActive()) {
                            this.transPreviewDelegate.setSelectedStep(this.currentStep);
                            for (SelectedStepListener stepListener : this.stepListeners) {
                                if (this.extraViewComposite == null || this.extraViewComposite.isDisposed()) continue;
                                stepListener.onSelect(this.currentStep);
                            }
                            this.transPreviewDelegate.refreshView();
                        }
                        if (e.button == 1 && alt && stepMeta.supportsErrorHandling()) {
                            this.spoon.editStepErrorHandling(this.transMeta, stepMeta);
                            return;
                        }
                        if (e.button == 2 || e.button == 1 && shift) {
                            this.startHopStep = stepMeta;
                        } else {
                            this.selectedSteps = this.transMeta.getSelectedSteps();
                            this.selectedStep = stepMeta;
                            this.previous_step_locations = this.transMeta.getSelectedStepLocations();
                            org.pentaho.di.core.gui.Point p = stepMeta.getLocation();
                            this.iconoffset = new org.pentaho.di.core.gui.Point(real.x - p.x, real.y - p.y);
                        }
                        this.redraw();
                        break;
                    }
                    case NOTE: {
                        this.ni = (NotePadMeta)areaOwner.getOwner();
                        this.selectedNotes = this.transMeta.getSelectedNotes();
                        this.selectedNote = this.ni;
                        org.pentaho.di.core.gui.Point loc = this.ni.getLocation();
                        this.previous_note_locations = this.transMeta.getSelectedNoteLocations();
                        this.noteoffset = new org.pentaho.di.core.gui.Point(real.x - loc.x, real.y - loc.y);
                        this.redraw();
                        break;
                    }
                    case STEP_COPIES_TEXT: {
                        this.copies((StepMeta)areaOwner.getOwner());
                        break;
                    }
                    case STEP_DATA_SERVICE: {
                        TransGraph.editProperties(this.transMeta, this.spoon, this.spoon.getRepository(), true, TransDialog.Tabs.EXTRA_TAB);
                        break;
                    }
                }
            } else {
                TransHopMeta hop = this.findHop(real.x, real.y);
                if (hop != null) {
                    TransHopMeta before = (TransHopMeta)hop.clone();
                    this.setHopEnabled(hop, !hop.isEnabled());
                    if (hop.isEnabled() && this.transMeta.hasLoop(hop.getToStep())) {
                        this.setHopEnabled(hop, false);
                        this.modalMessageDialog(this.getString("TransGraph.Dialog.HopCausesLoop.Title"), this.getString("TransGraph.Dialog.HopCausesLoop.Message"), 33);
                    }
                    TransHopMeta after = (TransHopMeta)hop.clone();
                    this.spoon.addUndoChange((UndoInterface)this.transMeta, new TransHopMeta[]{before}, new TransHopMeta[]{after}, new int[]{this.transMeta.indexOfTransHop(hop)});
                    this.redraw();
                    this.spoon.setShellText();
                } else {
                    this.startHopStep = null;
                    if (!control) {
                        this.selectionRegion = new Rectangle(real.x, real.y, 0, 0);
                    }
                    this.redraw();
                }
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        try {
            TransGraphExtension ext = new TransGraphExtension(null, e, this.getArea());
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransGraphMouseUp.id, (Object)ext);
            if (ext.isPreventDefault()) {
                this.redraw();
                this.clearSettings();
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling TransGraphMouseUp extension point", (Throwable)ex);
        }
        boolean control = (e.stateMask & SWT.MOD1) != 0;
        TransHopMeta selectedHop = this.findHop(e.x, e.y);
        this.updateErrorMetaForHop(selectedHop);
        if (this.iconoffset == null) {
            this.iconoffset = new org.pentaho.di.core.gui.Point(0, 0);
        }
        org.pentaho.di.core.gui.Point real = this.screen2real(e.x, e.y);
        org.pentaho.di.core.gui.Point icon = new org.pentaho.di.core.gui.Point(real.x - this.iconoffset.x, real.y - this.iconoffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        try {
            TransGraphExtension ext = new TransGraphExtension(this, e, real);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransGraphMouseUp.id, (Object)ext);
            if (ext.isPreventDefault()) {
                this.redraw();
                this.clearSettings();
                return;
            }
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling TransGraphMouseUp extension point", (Throwable)ex);
        }
        if (this.candidate != null && areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case STEP_ICON: {
                    this.currentStep = (StepMeta)areaOwner.getOwner();
                    break;
                }
                case STEP_INPUT_HOP_ICON: {
                    this.currentStep = (StepMeta)areaOwner.getParent();
                    break;
                }
            }
            this.addCandidateAsHop(e.x, e.y);
            this.redraw();
        } else if (this.selectionRegion != null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            this.transMeta.unselectAll();
            this.selectInRect(this.transMeta, this.selectionRegion);
            this.selectionRegion = null;
            this.stopStepMouseOverDelayTimers();
            this.redraw();
        } else if (this.selectedStep != null && this.startHopStep == null) {
            if (e.button == 1) {
                org.pentaho.di.core.gui.Point realclick = this.screen2real(e.x, e.y);
                if (this.lastclick.x == realclick.x && this.lastclick.y == realclick.y) {
                    if (control) {
                        this.selectedStep.flipSelected();
                    } else {
                        this.transMeta.unselectAll();
                        this.selectedStep.setSelected(true);
                    }
                } else {
                    int[] indexes;
                    this.selectedSteps = this.transMeta.getSelectedSteps();
                    this.selectedNotes = this.transMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && this.selectedNotes.size() > 0 && this.previous_note_locations != null) {
                        indexes = this.transMeta.getNoteIndexes(this.selectedNotes);
                        this.addUndoPosition(this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previous_note_locations, this.transMeta.getSelectedNoteLocations(), also);
                        boolean bl = also = this.selectedSteps != null && this.selectedSteps.size() > 0;
                    }
                    if (this.selectedSteps != null && this.previous_step_locations != null) {
                        indexes = this.transMeta.getStepIndexes(this.selectedSteps);
                        this.addUndoPosition(this.selectedSteps.toArray(new StepMeta[this.selectedSteps.size()]), indexes, this.previous_step_locations, this.transMeta.getSelectedStepLocations(), also);
                    }
                }
            }
            if (this.split_hop) {
                TransHopMeta hi = this.findHop(icon.x + this.iconsize / 2, icon.y + this.iconsize / 2, this.selectedStep);
                if (hi != null) {
                    this.splitHop(hi);
                }
                this.split_hop = false;
            }
            this.selectedSteps = null;
            this.selectedNotes = null;
            this.selectedStep = null;
            this.selectedNote = null;
            this.startHopStep = null;
            this.endHopLocation = null;
            this.redraw();
            this.spoon.setShellText();
        } else if (this.selectedNote != null) {
            if (e.button == 1) {
                if (this.lastclick.x == e.x && this.lastclick.y == e.y) {
                    if (control) {
                        this.selectedNote.flipSelected();
                    } else {
                        this.transMeta.unselectAll();
                        this.selectedNote.setSelected(true);
                    }
                } else {
                    int[] indexes;
                    this.selectedSteps = this.transMeta.getSelectedSteps();
                    this.selectedNotes = this.transMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && this.selectedNotes.size() > 0 && this.previous_note_locations != null) {
                        indexes = this.transMeta.getNoteIndexes(this.selectedNotes);
                        this.addUndoPosition(this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previous_note_locations, this.transMeta.getSelectedNoteLocations(), also);
                        boolean bl = also = this.selectedSteps != null && this.selectedSteps.size() > 0;
                    }
                    if (this.selectedSteps != null && this.selectedSteps.size() > 0 && this.previous_step_locations != null) {
                        indexes = this.transMeta.getStepIndexes(this.selectedSteps);
                        this.addUndoPosition(this.selectedSteps.toArray(new StepMeta[this.selectedSteps.size()]), indexes, this.previous_step_locations, this.transMeta.getSelectedStepLocations(), also);
                    }
                }
            }
            this.selectedNotes = null;
            this.selectedSteps = null;
            this.selectedStep = null;
            this.selectedNote = null;
            this.startHopStep = null;
            this.endHopLocation = null;
        } else if (areaOwner == null && this.selectionRegion == null) {
            this.clearSettings();
        }
        this.lastButton = 0;
    }

    private void splitHop(TransHopMeta hi) {
        int id = 0;
        if (!this.spoon.props.getAutoSplit()) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.SplitHop.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.SplitHop.Message", (String[])new String[0]) + Const.CR + hi.toString(), 3, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.Option.SplitHop.DoNotAskAgain", (String[])new String[0]), this.spoon.props.getAutoSplit());
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            id = md.open();
            this.spoon.props.setAutoSplit(md.getToggleState());
        }
        if ((id & 0xFF) == 0) {
            boolean bcExists;
            boolean caExists = this.transMeta.findTransHop(this.selectedStep, hi.getFromStep()) != null;
            boolean bl = bcExists = this.transMeta.findTransHop(hi.getToStep(), this.selectedStep) != null;
            if (!caExists && !bcExists) {
                TransHopMeta newhop2;
                TransHopMeta newhop1;
                StepMeta fromStep = hi.getFromStep();
                StepMeta toStep = hi.getToStep();
                StepIOMetaInterface fromIo = fromStep.getStepMetaInterface().getStepIOMeta();
                for (Object stream : fromIo.getTargetStreams()) {
                    if (stream.getStepMeta() == null || !stream.getStepMeta().equals((Object)toStep)) continue;
                    stream.setStepMeta(this.selectedStep);
                    fromStep.getStepMetaInterface().handleStreamSelection((StreamInterface)stream);
                }
                StepIOMetaInterface toIo = toStep.getStepMetaInterface().getStepIOMeta();
                for (StreamInterface stream : toIo.getInfoStreams()) {
                    if (stream.getStepMeta() == null || !stream.getStepMeta().equals((Object)fromStep)) continue;
                    stream.setStepMeta(this.selectedStep);
                    toStep.getStepMetaInterface().handleStreamSelection(stream);
                }
                StepErrorMeta errorMeta = fromStep.getStepErrorMeta();
                if (fromStep.isDoingErrorHandling() && toStep.equals((Object)errorMeta.getTargetStep())) {
                    errorMeta.setTargetStep(this.selectedStep);
                }
                if (this.transMeta.findTransHop(newhop1 = new TransHopMeta(hi.getFromStep(), this.selectedStep)) == null) {
                    this.transMeta.addTransHop(newhop1);
                    this.spoon.addUndoNew((UndoInterface)this.transMeta, new TransHopMeta[]{newhop1}, new int[]{this.transMeta.indexOfTransHop(newhop1)}, true);
                }
                if (this.transMeta.findTransHop(newhop2 = new TransHopMeta(this.selectedStep, hi.getToStep())) == null) {
                    this.transMeta.addTransHop(newhop2);
                    this.spoon.addUndoNew((UndoInterface)this.transMeta, new TransHopMeta[]{newhop2}, new int[]{this.transMeta.indexOfTransHop(newhop2)}, true);
                }
                int idx = this.transMeta.indexOfTransHop(hi);
                this.spoon.addUndoDelete((UndoInterface)this.transMeta, new TransHopMeta[]{hi}, new int[]{idx}, true);
                this.transMeta.removeTransHop(idx);
                this.spoon.refreshTree();
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        int dy;
        StepMeta stepMeta;
        org.pentaho.di.core.gui.Point real;
        boolean shift = (e.stateMask & 0x20000) != 0;
        this.noInputStep = null;
        this.toolTip.hide();
        this.toolTip.setHideDelay(5000);
        this.lastMove = real = this.screen2real(e.x, e.y);
        if (this.iconoffset == null) {
            this.iconoffset = new org.pentaho.di.core.gui.Point(0, 0);
        }
        org.pentaho.di.core.gui.Point icon = new org.pentaho.di.core.gui.Point(real.x - this.iconoffset.x, real.y - this.iconoffset.y);
        if (this.noteoffset == null) {
            this.noteoffset = new org.pentaho.di.core.gui.Point(0, 0);
        }
        org.pentaho.di.core.gui.Point note = new org.pentaho.di.core.gui.Point(real.x - this.noteoffset.x, real.y - this.noteoffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case STEP_ICON: {
                    stepMeta = (StepMeta)areaOwner.getOwner();
                    this.resetDelayTimer(stepMeta);
                    break;
                }
                case MINI_ICONS_BALLOON: {
                    stepMeta = (StepMeta)areaOwner.getParent();
                    this.resetDelayTimer(stepMeta);
                    break;
                }
            }
        }
        try {
            TransGraphExtension ext = new TransGraphExtension(this, e, real);
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransGraphMouseMoved.id, (Object)ext);
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling TransGraphMouseMoved extension point", (Throwable)ex);
        }
        if (this.selectedStep != null && !this.selectedStep.isSelected()) {
            this.transMeta.unselectAll();
            this.selectedStep.setSelected(true);
            this.selectedSteps = new ArrayList<StepMeta>();
            this.selectedSteps.add(this.selectedStep);
            this.previous_step_locations = new org.pentaho.di.core.gui.Point[]{this.selectedStep.getLocation()};
            this.redraw();
        } else if (this.selectedNote != null && !this.selectedNote.isSelected()) {
            this.transMeta.unselectAll();
            this.selectedNote.setSelected(true);
            this.selectedNotes = new ArrayList<NotePadMeta>();
            this.selectedNotes.add(this.selectedNote);
            this.previous_note_locations = new org.pentaho.di.core.gui.Point[]{this.selectedNote.getLocation()};
            this.redraw();
        } else if (this.selectionRegion != null && this.startHopStep == null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            this.redraw();
        } else if (this.selectedStep != null && this.lastButton == 1 && !shift && this.startHopStep == null) {
            int i;
            int dx = icon.x - this.selectedStep.getLocation().x;
            dy = icon.y - this.selectedStep.getLocation().y;
            TransHopMeta hi = this.findHop(icon.x + this.iconsize / 2, icon.y + this.iconsize / 2, this.selectedStep);
            if (hi != null) {
                if (!hi.getFromStep().equals((Object)this.selectedStep) && !hi.getToStep().equals((Object)this.selectedStep)) {
                    this.split_hop = true;
                    this.last_hop_split = hi;
                    hi.split = true;
                }
            } else if (this.last_hop_split != null) {
                this.last_hop_split.split = false;
                this.last_hop_split = null;
                this.split_hop = false;
            }
            this.selectedNotes = this.transMeta.getSelectedNotes();
            this.selectedSteps = this.transMeta.getSelectedSteps();
            if (this.selectedSteps != null) {
                for (i = 0; i < this.selectedSteps.size(); ++i) {
                    StepMeta stepMeta2 = this.selectedSteps.get(i);
                    PropsUI.setLocation((GUIPositionInterface)stepMeta2, stepMeta2.getLocation().x + dx, stepMeta2.getLocation().y + dy);
                    this.stopStepMouseOverDelayTimer(stepMeta2);
                }
            }
            if (this.selectedNotes != null) {
                for (i = 0; i < this.selectedNotes.size(); ++i) {
                    NotePadMeta ni = this.selectedNotes.get(i);
                    PropsUI.setLocation((GUIPositionInterface)ni, ni.getLocation().x + dx, ni.getLocation().y + dy);
                }
            }
            this.redraw();
        } else if (this.startHopStep != null && this.endHopStep == null || this.endHopStep != null && this.startHopStep == null) {
            stepMeta = this.transMeta.getStep(real.x, real.y, this.iconsize);
            this.endHopLocation = new org.pentaho.di.core.gui.Point(real.x, real.y);
            if (stepMeta != null && (this.startHopStep != null && !this.startHopStep.equals((Object)stepMeta) || this.endHopStep != null && !this.endHopStep.equals((Object)stepMeta))) {
                StepIOMetaInterface ioMeta = stepMeta.getStepMetaInterface().getStepIOMeta();
                if (this.candidate == null) {
                    if (this.startHopStep != null) {
                        if (ioMeta.isInputAcceptor()) {
                            this.candidate = new TransHopMeta(this.startHopStep, stepMeta);
                            this.endHopLocation = null;
                        } else {
                            this.noInputStep = stepMeta;
                            this.toolTip.setImage(null);
                            this.toolTip.setText("This step does not accept any input from other steps");
                            this.toolTip.show(new Point(real.x, real.y));
                        }
                    } else if (this.endHopStep != null) {
                        if (ioMeta.isOutputProducer()) {
                            this.candidate = new TransHopMeta(stepMeta, this.endHopStep);
                            this.endHopLocation = null;
                        } else {
                            this.noInputStep = stepMeta;
                            this.toolTip.setImage(null);
                            this.toolTip.setText("This step doesn't pass any output to other steps. (except perhaps for targetted output)");
                            this.toolTip.show(new Point(real.x, real.y));
                        }
                    }
                }
            } else if (this.candidate != null) {
                this.candidate = null;
                this.redraw();
            }
            this.redraw();
        }
        if (this.selectedNote != null && this.lastButton == 1 && !shift) {
            int dx = note.x - this.selectedNote.getLocation().x;
            dy = note.y - this.selectedNote.getLocation().y;
            this.selectedNotes = this.transMeta.getSelectedNotes();
            this.selectedSteps = this.transMeta.getSelectedSteps();
            if (this.selectedSteps != null) {
                for (int i = 0; i < this.selectedSteps.size(); ++i) {
                    StepMeta stepMeta3 = this.selectedSteps.get(i);
                    PropsUI.setLocation((GUIPositionInterface)stepMeta3, stepMeta3.getLocation().x + dx, stepMeta3.getLocation().y + dy);
                }
            }
            if (this.selectedNotes != null) {
                for (int i = 0; i < this.selectedNotes.size(); ++i) {
                    NotePadMeta ni = this.selectedNotes.get(i);
                    PropsUI.setLocation((GUIPositionInterface)ni, ni.getLocation().x + dx, ni.getLocation().y + dy);
                }
            }
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
        boolean tip = true;
        boolean isDeprecated = false;
        this.toolTip.hide();
        this.toolTip.setHideDelay(5000);
        org.pentaho.di.core.gui.Point real = this.screen2real(e.x, e.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            switch (areaOwner.getAreaType()) {
                case STEP_ICON: {
                    StepMeta stepMeta = (StepMeta)areaOwner.getOwner();
                    isDeprecated = stepMeta.isDeprecated();
                    if (stepMeta.isMissing() || this.mouseOverSteps.contains(stepMeta)) break;
                    this.addStepMouseOverDelayTimer(stepMeta);
                    this.redraw();
                    tip = false;
                    break;
                }
            }
        }
        if (tip && !this.helpTip.isVisible() || isDeprecated) {
            this.setToolTip(real.x, real.y, e.x, e.y);
        }
    }

    public void mouseScrolled(MouseEvent e) {
    }

    private void addCandidateAsHop(int mouseX, int mouseY) {
        boolean forward = this.startHopStep != null;
        StepMeta fromStep = this.candidate.getFromStep();
        StepMeta toStep = this.candidate.getToStep();
        ArrayList<Stream> streams = new ArrayList<Stream>();
        StepIOMetaInterface fromIoMeta = fromStep.getStepMetaInterface().getStepIOMeta();
        List targetStreams = fromIoMeta.getTargetStreams();
        if (forward) {
            streams.addAll(targetStreams);
        }
        StepIOMetaInterface toIoMeta = toStep.getStepMetaInterface().getStepIOMeta();
        List infoStreams = toIoMeta.getInfoStreams();
        if (!forward) {
            streams.addAll(infoStreams);
        }
        if (forward) {
            if (fromIoMeta.isOutputProducer() && toStep.equals((Object)this.currentStep)) {
                streams.add(new Stream(StreamInterface.StreamType.OUTPUT, fromStep, BaseMessages.getString(PKG, (String)"Spoon.Hop.MainOutputOfStep", (String[])new String[0]), StreamIcon.OUTPUT, null));
            }
            if (fromStep.supportsErrorHandling() && toStep.equals((Object)this.currentStep)) {
                streams.add(new Stream(StreamInterface.StreamType.ERROR, fromStep, BaseMessages.getString(PKG, (String)"Spoon.Hop.ErrorHandlingOfStep", (String[])new String[0]), StreamIcon.ERROR, null));
            }
        } else {
            if (toIoMeta.isInputAcceptor() && fromStep.equals((Object)this.currentStep)) {
                streams.add(new Stream(StreamInterface.StreamType.INPUT, toStep, BaseMessages.getString(PKG, (String)"Spoon.Hop.MainInputOfStep", (String[])new String[0]), StreamIcon.INPUT, null));
            }
            if (fromStep.supportsErrorHandling() && fromStep.equals((Object)this.currentStep)) {
                streams.add(new Stream(StreamInterface.StreamType.ERROR, fromStep, BaseMessages.getString(PKG, (String)"Spoon.Hop.ErrorHandlingOfStep", (String[])new String[0]), StreamIcon.ERROR, null));
            }
        }
        if (forward) {
            streams.addAll(fromStep.getStepMetaInterface().getOptionalStreams());
        } else {
            streams.addAll(toStep.getStepMetaInterface().getOptionalStreams());
        }
        if (streams.size() > 1) {
            Menu menu = new Menu((Control)this.canvas);
            for (final StreamInterface streamInterface : streams) {
                MenuItem item = new MenuItem(menu, 0);
                item.setText(Const.NVL((String)streamInterface.getDescription(), (String)""));
                item.setImage(this.getImageFor(streamInterface));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TransGraph.this.addHop(streamInterface);
                    }
                });
            }
            menu.setLocation(this.canvas.toDisplay(mouseX, mouseY));
            menu.setVisible(true);
            return;
        }
        if (streams.size() != 1) {
            return;
        }
        this.addHop((StreamInterface)streams.get(0));
        this.candidate = null;
        this.selectedSteps = null;
        this.startHopStep = null;
        this.endHopLocation = null;
        this.startErrorHopStep = false;
    }

    private Image getImageFor(StreamInterface stream) {
        Display disp = this.shell.getDisplay();
        SwtUniversalImage swtImage = SWTGC.getNativeImage(BasePainter.getStreamIconImage((StreamIcon)stream.getStreamIcon()));
        return swtImage.getAsBitmapForSize((Device)disp, 16, 16);
    }

    protected void addHop(StreamInterface stream) {
        switch (stream.getStreamType()) {
            case ERROR: {
                this.addErrorHop();
                this.candidate.setErrorHop(true);
                this.spoon.newHop(this.transMeta, this.candidate);
                break;
            }
            case INPUT: {
                this.spoon.newHop(this.transMeta, this.candidate);
                break;
            }
            case OUTPUT: {
                StepErrorMeta stepErrorMeta = this.candidate.getFromStep().getStepErrorMeta();
                if (stepErrorMeta != null && stepErrorMeta.getTargetStep() != null && stepErrorMeta.getTargetStep().equals((Object)this.candidate.getToStep())) {
                    this.candidate.getFromStep().setStepErrorMeta(null);
                }
                this.spoon.newHop(this.transMeta, this.candidate);
                break;
            }
            case INFO: {
                stream.setStepMeta(this.candidate.getFromStep());
                this.candidate.getToStep().getStepMetaInterface().handleStreamSelection(stream);
                this.spoon.newHop(this.transMeta, this.candidate);
                break;
            }
            case TARGET: {
                stream.setStepMeta(this.candidate.getToStep());
                this.candidate.getFromStep().getStepMetaInterface().handleStreamSelection(stream);
                this.spoon.newHop(this.transMeta, this.candidate);
                break;
            }
        }
        this.clearSettings();
    }

    private void addErrorHop() {
        if (this.candidate == null || this.candidate.getFromStep() == null) {
            return;
        }
        StepErrorMeta errorMeta = this.candidate.getFromStep().getStepErrorMeta();
        if (errorMeta == null) {
            errorMeta = new StepErrorMeta((VariableSpace)this.transMeta, this.candidate.getFromStep());
        }
        errorMeta.setEnabled(true);
        errorMeta.setTargetStep(this.candidate.getToStep());
        this.candidate.getFromStep().setStepErrorMeta(errorMeta);
    }

    private void resetDelayTimer(StepMeta stepMeta) {
        DelayTimer delayTimer = this.delayTimers.get(stepMeta);
        if (delayTimer != null) {
            delayTimer.reset();
        }
    }

    public void mouseEnter(MouseEvent arg0) {
    }

    public void mouseExit(MouseEvent arg0) {
    }

    private synchronized void addStepMouseOverDelayTimer(final StepMeta stepMeta) {
        if (this.mouseOverSteps.contains(stepMeta)) {
            return;
        }
        this.mouseOverSteps.add(stepMeta);
        DelayTimer delayTimer = new DelayTimer(500, new DelayListener(){

            @Override
            public void expired() {
                TransGraph.this.mouseOverSteps.remove(stepMeta);
                TransGraph.this.delayTimers.remove(stepMeta);
                TransGraph.this.showTargetStreamsStep = null;
                TransGraph.this.asyncRedraw();
            }
        }, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AreaOwner areaOwner;
                org.pentaho.di.core.gui.Point cursor = TransGraph.this.getLastMove();
                if (cursor != null && (areaOwner = TransGraph.this.getVisibleAreaOwner(cursor.x, cursor.y)) != null) {
                    AreaOwner.AreaType areaType = areaOwner.getAreaType();
                    if (areaType == AreaOwner.AreaType.STEP_ICON) {
                        StepMeta selectedStepMeta = (StepMeta)areaOwner.getOwner();
                        return selectedStepMeta == stepMeta;
                    }
                    if (areaType != null && areaType.belongsToTransContextMenu()) {
                        StepMeta selectedStepMeta = (StepMeta)areaOwner.getParent();
                        return selectedStepMeta == stepMeta;
                    }
                    if (areaOwner.getExtensionAreaType() != null) {
                        return true;
                    }
                }
                return false;
            }
        });
        new Thread(delayTimer).start();
        this.delayTimers.put(stepMeta, delayTimer);
    }

    private void stopStepMouseOverDelayTimer(StepMeta stepMeta) {
        DelayTimer delayTimer = this.delayTimers.get(stepMeta);
        if (delayTimer != null) {
            delayTimer.stop();
        }
    }

    private void stopStepMouseOverDelayTimers() {
        for (DelayTimer timer : this.delayTimers.values()) {
            timer.stop();
        }
    }

    protected void asyncRedraw() {
        this.spoon.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TransGraph.this.isDisposed()) {
                    TransGraph.this.redraw();
                }
            }
        });
    }

    private void addToolBar() {
        try {
            this.toolbar = (XulToolbar)this.getXulDomContainer().getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolbar = (ToolBar)this.toolbar.getManagedObject();
            swtToolbar.setBackground(GUIResource.getInstance().getColorDemoGray());
            swtToolbar.pack();
            ToolItem runItem = new ToolItem(swtToolbar, 4, 0);
            runItem.setImage(GUIResource.getInstance().getImage("ui/images/run.svg"));
            runItem.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Tooltip.RunTranformation", (String[])new String[0]));
            runItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Menu menu = new Menu((Decorations)TransGraph.this.shell, 8);
                        MenuItem item1 = new MenuItem(menu, 8);
                        item1.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Run.Run", (String[])new String[0]));
                        item1.setAccelerator(0x1000012);
                        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e1) {
                                TransGraph.this.runTransformation();
                            }
                        });
                        MenuItem item2 = new MenuItem(menu, 8);
                        item2.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Run.RunOptions", (String[])new String[0]));
                        item2.setAccelerator(0x1000011);
                        item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e2) {
                                TransGraph.this.runOptionsTransformation();
                            }
                        });
                        menu.setLocation(TransGraph.this.shell.getDisplay().map((Control)TransGraph.this.mainComposite.getParent(), null, TransGraph.this.mainComposite.getLocation()));
                        menu.setVisible(true);
                    } else {
                        TransGraph.this.runTransformation();
                    }
                }
            });
            this.stopItem = new ToolItem(swtToolbar, 4, 2);
            this.stopItem.setImage(GUIResource.getInstance().getImage("ui/images/stop.svg"));
            this.stopItem.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Tooltip.StopTranformation", (String[])new String[0]));
            this.stopItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Menu menu = new Menu((Decorations)TransGraph.this.shell, 8);
                        MenuItem item1 = new MenuItem(menu, 8);
                        item1.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Menu.StopTranformation", (String[])new String[0]));
                        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e1) {
                                TransGraph.this.stopTransformation();
                            }
                        });
                        MenuItem item2 = new MenuItem(menu, 8);
                        item2.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Menu.SafeStopTranformation", (String[])new String[0]));
                        item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e2) {
                                TransGraph.this.safeStop();
                            }
                        });
                        menu.setLocation(TransGraph.this.shell.getDisplay().map((Control)TransGraph.this.mainComposite.getParent(), null, TransGraph.this.mainComposite.getLocation()));
                        menu.setVisible(true);
                    } else {
                        TransGraph.this.stopTransformation();
                    }
                }
            });
            ToolItem sep = new ToolItem(swtToolbar, 2);
            this.zoomLabel = new Combo((Composite)swtToolbar, 4);
            this.zoomLabel.setItems(TransPainter.magnificationDescriptions);
            this.zoomLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TransGraph.this.readMagnification();
                }
            });
            this.zoomLabel.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\r') {
                        TransGraph.this.readMagnification();
                    }
                }
            });
            this.setZoomLabel();
            this.zoomLabel.pack();
            sep.setWidth(80);
            sep.setControl((Control)this.zoomLabel);
            swtToolbar.pack();
        }
        catch (Throwable t) {
            this.log.logError("Error loading the navigation toolbar for Spoon", t);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_TOOLBAR}), new Exception(t));
        }
    }

    private void readMagnification() {
        String possibleText = this.zoomLabel.getText();
        possibleText = possibleText.replace("%", "");
        try {
            float possibleFloatMagnification;
            this.magnification = possibleFloatMagnification = Float.parseFloat(possibleText) / 100.0f;
            if (this.zoomLabel.getText().indexOf(37) < 0) {
                this.zoomLabel.setText(this.zoomLabel.getText().concat("%"));
            }
        }
        catch (Exception e) {
            this.modalMessageDialog(this.getString("TransGraph.Dialog.InvalidZoomMeasurement.Title"), this.getString("TransGraph.Dialog.InvalidZoomMeasurement.Message", this.zoomLabel.getText()), 65);
        }
        this.redraw();
    }

    protected void hideToolTips() {
        this.toolTip.hide();
        this.helpTip.hide();
        this.toolTip.setHideDelay(5000);
    }

    private void showHelpTip(int x, int y, String tipTitle, String tipMessage) {
        this.helpTip.setTitle(tipTitle);
        this.helpTip.setMessage(tipMessage.replaceAll("\n", Const.CR));
        this.helpTip.setCheckBoxMessage(BaseMessages.getString(PKG, (String)"TransGraph.HelpToolTip.DoNotShowAnyMoreCheckBox.Message", (String[])new String[0]));
        Point location = new Point(x - 5, y - 5);
        this.helpTip.show(location);
    }

    public void selectInRect(TransMeta transMeta, Rectangle rect) {
        org.pentaho.di.core.gui.Point a;
        int i;
        if (rect.height < 0 || rect.width < 0) {
            Rectangle rectified = new Rectangle(rect.x, rect.y, rect.width, rect.height);
            if (rectified.height < 0) {
                rectified.y += rectified.height;
                rectified.height = -rectified.height;
            }
            if (rectified.width < 0) {
                rectified.x += rectified.width;
                rectified.width = -rectified.width;
            }
            rect = rectified;
        }
        for (i = 0; i < transMeta.nrSteps(); ++i) {
            StepMeta stepMeta = transMeta.getStep(i);
            a = stepMeta.getLocation();
            if (!rect.contains(a.x, a.y)) continue;
            stepMeta.setSelected(true);
        }
        for (i = 0; i < transMeta.nrNotes(); ++i) {
            NotePadMeta ni = transMeta.getNote(i);
            a = ni.getLocation();
            org.pentaho.di.core.gui.Point b = new org.pentaho.di.core.gui.Point(a.x + ni.width, a.y + ni.height);
            if (!rect.contains(a.x, a.y) || !rect.contains(b.x, b.y)) continue;
            ni.setSelected(true);
        }
    }

    public void keyPressed(KeyEvent e) {
        List stepMeta;
        if (e.keyCode == 27) {
            this.clearSettings();
            this.redraw();
        }
        if (e.keyCode == 127 && (stepMeta = this.transMeta.getSelectedSteps()) != null && stepMeta.size() > 0) {
            this.delSelected(null);
        }
        if (e.keyCode == 0x100000A) {
            this.spoon.browseVersionHistory();
        }
        if (e.keyCode == 0x100000B) {
            this.spoon.editKettlePropertiesFile();
        }
        if (e.keyCode == 0x1000001 && (e.stateMask & SWT.MOD1) != 0) {
            this.alligntop();
        }
        if (e.keyCode == 0x1000002 && (e.stateMask & SWT.MOD1) != 0) {
            this.allignbottom();
        }
        if (e.keyCode == 0x1000003 && (e.stateMask & SWT.MOD1) != 0) {
            this.allignleft();
        }
        if (e.keyCode == 0x1000004 && (e.stateMask & SWT.MOD1) != 0) {
            this.allignright();
        }
        if (e.keyCode == 0x1000004 && (e.stateMask & 0x10000) != 0) {
            this.distributehorizontal();
        }
        if (e.keyCode == 0x1000001 && (e.stateMask & 0x10000) != 0) {
            this.distributevertical();
        }
        if (e.keyCode == 0x1000007 && (e.stateMask & 0x10000) != 0) {
            this.snaptogrid(16);
        }
        if (e.character == 'E' && (e.stateMask & 0x40000) != 0) {
            this.checkErrorVisuals();
        }
        if (e.keyCode == 119 && (e.stateMask & SWT.MOD1) != 0 || e.keyCode == 0x100000D && (e.stateMask & SWT.MOD1) != 0) {
            this.spoon.tabCloseSelected();
        }
        if (e.character == 'A') {
            this.autoLayout();
        }
        if (e.character == ' ' && this.lastMove != null) {
            org.pentaho.di.core.gui.Point real = this.lastMove;
            this.hideToolTips();
            StepMeta stepMeta2 = this.transMeta.getStep(real.x, real.y, this.iconsize);
            if (stepMeta2 != null) {
                this.inputOutputFields(stepMeta2, false);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public boolean setFocus() {
        return this.canvas != null ? this.canvas.setFocus() : false;
    }

    public void renameStep(StepMeta stepMeta, String stepname) {
        String newname = stepname;
        StepMeta smeta = this.transMeta.findStep(newname, stepMeta);
        int nr = 2;
        while (smeta != null) {
            newname = stepname + " " + nr;
            smeta = this.transMeta.findStep(newname);
            ++nr;
        }
        if (nr > 2) {
            stepname = newname;
            this.modalMessageDialog(this.getString("Spoon.Dialog.StepnameExists.Title"), this.getString("Spoon.Dialog.StepnameExists.Message", stepname), 34);
        }
        stepMeta.setName(stepname);
        stepMeta.setChanged();
        this.spoon.refreshTree();
        this.spoon.refreshGraph();
    }

    public void clearSettings() {
        this.selectedStep = null;
        this.noInputStep = null;
        this.selectedNote = null;
        this.selectedSteps = null;
        this.selectionRegion = null;
        this.candidate = null;
        this.last_hop_split = null;
        this.lastButton = 0;
        this.iconoffset = null;
        this.startHopStep = null;
        this.endHopStep = null;
        this.endHopLocation = null;
        this.mouseOverSteps.clear();
        for (int i = 0; i < this.transMeta.nrTransHops(); ++i) {
            this.transMeta.getTransHop((int)i).split = false;
        }
        this.stopStepMouseOverDelayTimers();
    }

    public String[] getDropStrings(String str, String sep) {
        StringTokenizer strtok = new StringTokenizer(str, sep);
        String[] retval = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreElements()) {
            retval[i] = strtok.nextToken();
            ++i;
        }
        return retval;
    }

    public org.pentaho.di.core.gui.Point getRealPosition(Composite canvas, int x, int y) {
        org.pentaho.di.core.gui.Point p = new org.pentaho.di.core.gui.Point(0, 0);
        for (Composite follow = canvas; follow != null; follow = follow.getParent()) {
            Point loc = follow.getLocation();
            org.pentaho.di.core.gui.Point xy = new org.pentaho.di.core.gui.Point(loc.x, loc.y);
            p.x += xy.x;
            p.y += xy.y;
        }
        int offsetX = -16;
        int offsetY = -64;
        if (Const.isOSX()) {
            offsetX = -2;
            offsetY = -24;
        }
        p.x = x - p.x + offsetX;
        p.y = y - p.y + offsetY;
        return this.screen2real(p.x, p.y);
    }

    protected TransHopMeta findHop(int x, int y) {
        return this.findHop(x, y, null);
    }

    private TransHopMeta findHop(int x, int y, StepMeta exclude) {
        TransHopMeta online = null;
        for (int i = 0; i < this.transMeta.nrTransHops(); ++i) {
            int[] line;
            TransHopMeta hi = this.transMeta.getTransHop(i);
            StepMeta fs = hi.getFromStep();
            StepMeta ts = hi.getToStep();
            if (fs == null || ts == null) {
                return null;
            }
            if (exclude != null && (exclude.equals((Object)fs) || exclude.equals((Object)ts)) || !this.pointOnLine(x, y, line = this.getLine(fs, ts))) continue;
            online = hi;
        }
        return online;
    }

    private int[] getLine(StepMeta fs, StepMeta ts) {
        org.pentaho.di.core.gui.Point from = fs.getLocation();
        org.pentaho.di.core.gui.Point to = ts.getLocation();
        this.offset = this.getOffset();
        int x1 = from.x + this.iconsize / 2;
        int y1 = from.y + this.iconsize / 2;
        int x2 = to.x + this.iconsize / 2;
        int y2 = to.y + this.iconsize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    public void hideStep() {
        for (int i = 0; i < this.transMeta.nrSteps(); ++i) {
            StepMeta sti = this.transMeta.getStep(i);
            if (!sti.isDrawn() || !sti.isSelected()) continue;
            sti.hideStep();
            this.spoon.refreshTree();
        }
        this.getCurrentStep().hideStep();
        this.spoon.refreshTree();
        this.redraw();
    }

    public void checkSelectedSteps() {
        this.spoon.checkTrans(this.transMeta, true);
    }

    public void detachStep() {
        this.detach(this.getCurrentStep());
        this.selectedSteps = null;
    }

    public void generateMappingToThisStep() {
        this.spoon.generateFieldMapping(this.transMeta, this.getCurrentStep());
    }

    public void partitioning() {
        this.spoon.editPartitioning(this.transMeta, this.getCurrentStep());
    }

    public void clustering() {
        List selected = this.transMeta.getSelectedSteps();
        if (selected != null && selected.size() > 0) {
            this.spoon.editClustering(this.transMeta, this.transMeta.getSelectedSteps());
        } else {
            this.spoon.editClustering(this.transMeta, this.getCurrentStep());
        }
    }

    public void errorHandling() {
        this.spoon.editStepErrorHandling(this.transMeta, this.getCurrentStep());
    }

    public void newHopChoice() {
        this.selectedSteps = null;
        this.newHop();
    }

    public void editStep() {
        this.selectedSteps = null;
        this.editStep(this.getCurrentStep());
    }

    public void editDescription() {
        this.editDescription(this.getCurrentStep());
    }

    public void setDistributes() {
        this.getCurrentStep().setDistributes(true);
        this.getCurrentStep().setRowDistribution(null);
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
    }

    public void setCustomRowDistribution() {
        RowDistributionInterface rowDistribution = this.askUserForCustomDistributionMethod();
        this.getCurrentStep().setDistributes(true);
        this.getCurrentStep().setRowDistribution(rowDistribution);
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
    }

    public RowDistributionInterface askUserForCustomDistributionMethod() {
        List plugins = PluginRegistry.getInstance().getPlugins(RowDistributionPluginType.class);
        if (Utils.isEmpty((List)plugins)) {
            return null;
        }
        ArrayList<String> choices = new ArrayList<String>();
        for (PluginInterface plugin : plugins) {
            choices.add(plugin.getName() + " : " + plugin.getDescription());
        }
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, choices.toArray(new String[choices.size()]), "Select distribution method", "Please select the row distribution method:");
        if (dialog.open() != null) {
            PluginInterface plugin;
            plugin = (PluginInterface)plugins.get(dialog.getSelectionNr());
            try {
                return (RowDistributionInterface)PluginRegistry.getInstance().loadClass(plugin);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error loading row distribution plugin class", e);
                return null;
            }
        }
        return null;
    }

    public void setCopies() {
        this.getCurrentStep().setDistributes(false);
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
    }

    public void copies() {
        this.copies(this.getCurrentStep());
    }

    public void copies(StepMeta stepMeta) {
        boolean multipleOK = this.checkNumberOfCopies(this.transMeta, stepMeta);
        this.selectedSteps = null;
        String tt = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.NrOfCopiesOfStep.Title", (String[])new String[0]);
        String mt = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.NrOfCopiesOfStep.Message", (String[])new String[0]);
        EnterStringDialog nd = new EnterStringDialog(this.shell, stepMeta.getCopiesString(), tt, mt, true, this.transMeta);
        String cop = nd.open();
        if (!Utils.isEmpty((CharSequence)cop)) {
            String cps;
            int copies = Const.toInt((String)this.transMeta.environmentSubstitute(cop), (int)-1);
            if (copies > 1 && !multipleOK) {
                cop = "1";
                this.modalMessageDialog(this.getString("TransGraph.Dialog.MultipleCopiesAreNotAllowedHere.Title"), this.getString("TransGraph.Dialog.MultipleCopiesAreNotAllowedHere.Message"), 72);
            }
            if ((cps = stepMeta.getCopiesString()) != null && !cps.equals(cop) || cps == null && cop != null) {
                stepMeta.setChanged();
            }
            stepMeta.setCopiesString(cop);
            this.spoon.refreshGraph();
        }
    }

    public void dupeStep() {
        try {
            List steps = this.transMeta.getSelectedSteps();
            if (steps.size() <= 1) {
                this.spoon.dupeStep(this.transMeta, this.getCurrentStep());
            } else {
                for (StepMeta stepMeta : steps) {
                    this.spoon.dupeStep(this.transMeta, stepMeta);
                }
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.ErrorDuplicatingStep.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.Dialog.ErrorDuplicatingStep.Message", (String[])new String[0]), ex);
        }
    }

    public void copyStep() {
        this.spoon.copySelected(this.transMeta, this.transMeta.getSelectedSteps(), this.transMeta.getSelectedNotes());
    }

    public void delSelected() {
        this.delSelected(this.getCurrentStep());
    }

    public void fieldsBefore() {
        this.selectedSteps = null;
        this.inputOutputFields(this.getCurrentStep(), true);
    }

    public void fieldsAfter() {
        this.selectedSteps = null;
        this.inputOutputFields(this.getCurrentStep(), false);
    }

    public void fieldsLineage() {
        TransDataLineage tdl = new TransDataLineage(this.transMeta);
        try {
            tdl.calculateLineage();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Lineage error", "Unexpected lineage calculation error", e);
        }
    }

    public void editHop() {
        this.selectionRegion = null;
        this.editHop(this.getCurrentHop());
    }

    public void flipHopDirection() {
        this.selectionRegion = null;
        TransHopMeta hi = this.getCurrentHop();
        hi.flip();
        if (this.transMeta.hasLoop(hi.getToStep())) {
            this.spoon.refreshGraph();
            this.modalMessageDialog(this.getString("TransGraph.Dialog.LoopsAreNotAllowed.Title"), this.getString("TransGraph.Dialog.LoopsAreNotAllowed.Message"), 33);
            hi.flip();
            this.spoon.refreshGraph();
        } else {
            hi.setChanged();
            this.spoon.refreshGraph();
            this.spoon.refreshTree();
            this.spoon.setShellText();
        }
    }

    public void enableHop() {
        this.selectionRegion = null;
        TransHopMeta hi = this.getCurrentHop();
        TransHopMeta before = (TransHopMeta)hi.clone();
        this.setHopEnabled(hi, !hi.isEnabled());
        if (hi.isEnabled() && this.transMeta.hasLoop(hi.getToStep())) {
            this.setHopEnabled(hi, false);
            this.modalMessageDialog(this.getString("TransGraph.Dialog.LoopAfterHopEnabled.Title"), this.getString("TransGraph.Dialog.LoopAfterHopEnabled.Message"), 33);
        } else {
            TransHopMeta after = (TransHopMeta)hi.clone();
            this.spoon.addUndoChange((UndoInterface)this.transMeta, new TransHopMeta[]{before}, new TransHopMeta[]{after}, new int[]{this.transMeta.indexOfTransHop(hi)});
            this.spoon.refreshGraph();
            this.spoon.refreshTree();
        }
        this.updateErrorMetaForHop(hi);
    }

    public void deleteHop() {
        this.selectionRegion = null;
        TransHopMeta hi = this.getCurrentHop();
        this.spoon.delHop(this.transMeta, hi);
    }

    private void updateErrorMetaForHop(TransHopMeta hop) {
        StepErrorMeta errorMeta;
        if (hop != null && hop.isErrorHop() && (errorMeta = hop.getFromStep().getStepErrorMeta()) != null) {
            errorMeta.setEnabled(hop.isEnabled());
        }
    }

    public void enableHopsBetweenSelectedSteps() {
        this.enableHopsBetweenSelectedSteps(true);
    }

    public void disableHopsBetweenSelectedSteps() {
        this.enableHopsBetweenSelectedSteps(false);
    }

    public void enableHopsBetweenSelectedSteps(boolean enabled) {
        List list = this.transMeta.getSelectedSteps();
        boolean hasLoop = false;
        for (int i = 0; i < this.transMeta.nrTransHops(); ++i) {
            TransHopMeta hop = this.transMeta.getTransHop(i);
            if (!list.contains(hop.getFromStep()) || !list.contains(hop.getToStep())) continue;
            TransHopMeta before = (TransHopMeta)hop.clone();
            this.setHopEnabled(hop, enabled);
            TransHopMeta after = (TransHopMeta)hop.clone();
            this.spoon.addUndoChange((UndoInterface)this.transMeta, new TransHopMeta[]{before}, new TransHopMeta[]{after}, new int[]{this.transMeta.indexOfTransHop(hop)});
            if (!this.transMeta.hasLoop(hop.getToStep())) continue;
            hasLoop = true;
            this.setHopEnabled(hop, false);
        }
        if (enabled && hasLoop) {
            this.modalMessageDialog(this.getString("TransGraph.Dialog.HopCausesLoop.Title"), this.getString("TransGraph.Dialog.HopCausesLoop.Message"), 33);
        }
        this.spoon.refreshGraph();
    }

    public void enableHopsDownstream() {
        this.enableDisableHopsDownstream(true);
    }

    public void disableHopsDownstream() {
        this.enableDisableHopsDownstream(false);
    }

    public void enableDisableHopsDownstream(boolean enabled) {
        if (this.currentHop == null) {
            return;
        }
        TransHopMeta before = (TransHopMeta)this.currentHop.clone();
        this.setHopEnabled(this.currentHop, enabled);
        TransHopMeta after = (TransHopMeta)this.currentHop.clone();
        this.spoon.addUndoChange((UndoInterface)this.transMeta, new TransHopMeta[]{before}, new TransHopMeta[]{after}, new int[]{this.transMeta.indexOfTransHop(this.currentHop)});
        Set<StepMeta> checkedEntries = this.enableDisableNextHops(this.currentHop.getToStep(), enabled, new HashSet<StepMeta>());
        if (checkedEntries.stream().anyMatch(entry -> this.transMeta.hasLoop(entry))) {
            this.modalMessageDialog(this.getString("TransGraph.Dialog.HopCausesLoop.Title"), this.getString("TransGraph.Dialog.HopCausesLoop.Message"), 33);
        }
        this.spoon.refreshGraph();
    }

    private Set<StepMeta> enableDisableNextHops(StepMeta from, boolean enabled, Set<StepMeta> checkedEntries) {
        checkedEntries.add(from);
        this.transMeta.getTransHops().stream().filter(hop -> from.equals((Object)hop.getFromStep())).forEach(hop -> {
            if (hop.isEnabled() != enabled) {
                TransHopMeta before = (TransHopMeta)hop.clone();
                this.setHopEnabled((TransHopMeta)hop, enabled);
                TransHopMeta after = (TransHopMeta)hop.clone();
                this.spoon.addUndoChange((UndoInterface)this.transMeta, new TransHopMeta[]{before}, new TransHopMeta[]{after}, new int[]{this.transMeta.indexOfTransHop(hop)});
            }
            if (!checkedEntries.contains(hop.getToStep())) {
                this.enableDisableNextHops(hop.getToStep(), enabled, checkedEntries);
            }
        });
        return checkedEntries;
    }

    public void editNote() {
        this.selectionRegion = null;
        this.editNote(this.getCurrentNote());
    }

    public void deleteNote() {
        this.selectionRegion = null;
        int idx = this.transMeta.indexOfNote(this.ni);
        if (idx >= 0) {
            this.transMeta.removeNote(idx);
            this.spoon.addUndoDelete((UndoInterface)this.transMeta, new NotePadMeta[]{(NotePadMeta)this.ni.clone()}, new int[]{idx});
            this.redraw();
        }
    }

    public void raiseNote() {
        this.selectionRegion = null;
        int idx = this.transMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.transMeta.raiseNote(idx);
        }
        this.redraw();
    }

    public void lowerNote() {
        this.selectionRegion = null;
        int idx = this.transMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.transMeta.lowerNote(idx);
        }
        this.redraw();
    }

    public void newNote() {
        this.selectionRegion = null;
        String title = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.NoteEditor.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog((VariableSpace)this.transMeta, this.shell, title);
        NotePadMeta n = dd.open();
        if (n != null) {
            NotePadMeta npi = new NotePadMeta(n.getNote(), this.lastclick.x, this.lastclick.y, 20, 20, n.getFontName(), n.getFontSize(), n.isFontBold(), n.isFontItalic(), n.getFontColorRed(), n.getFontColorGreen(), n.getFontColorBlue(), n.getBackGroundColorRed(), n.getBackGroundColorGreen(), n.getBackGroundColorBlue(), n.getBorderColorRed(), n.getBorderColorGreen(), n.getBorderColorBlue(), n.isDrawShadow());
            this.transMeta.addNote(npi);
            this.spoon.addUndoNew((UndoInterface)this.transMeta, new NotePadMeta[]{npi}, new int[]{this.transMeta.indexOfNote(npi)});
            this.redraw();
        }
    }

    public void paste() {
        String clipcontent = this.spoon.fromClipboard();
        org.pentaho.di.core.gui.Point loc = new org.pentaho.di.core.gui.Point(this.currentMouseX, this.currentMouseY);
        this.spoon.pasteXML(this.transMeta, clipcontent, loc);
    }

    public void settings() {
        TransGraph.editProperties(this.transMeta, this.spoon, this.spoon.getRepository(), true);
    }

    public void newStep(String description) {
        StepMeta stepMeta = this.spoon.newStep(this.transMeta, description, description, false, true);
        PropsUI.setLocation((GUIPositionInterface)stepMeta, this.currentMouseX, this.currentMouseY);
        stepMeta.setDraw(true);
        this.redraw();
    }

    private synchronized void setMenu(int x, int y) {
        block21: {
            try {
                this.currentMouseX = x;
                this.currentMouseY = y;
                final StepMeta stepMeta = this.transMeta.getStep(x, y, this.iconsize);
                if (stepMeta != null) {
                    this.setCurrentStep(stepMeta);
                    XulMenupopup menu = this.menuMap.get("trans-graph-entry");
                    try {
                        ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransStepRightClick.id, (Object)new StepMenuExtension(this, menu));
                    }
                    catch (Exception ex) {
                        LogChannel.GENERAL.logError("Error calling TransStepRightClick extension point", (Throwable)ex);
                    }
                    if (menu != null) {
                        List selection = this.transMeta.getSelectedSteps();
                        this.doRightClickSelection(stepMeta, selection);
                        int sels = selection.size();
                        Document doc = this.getXulDomContainer().getDocumentRoot();
                        List rowDistributionPlugins = PluginRegistry.getInstance().getPlugins(RowDistributionPluginType.class);
                        JfaceMenupopup customRowDistMenu = (JfaceMenupopup)doc.getElementById("trans-graph-entry-data-movement-popup");
                        customRowDistMenu.setDisabled(false);
                        customRowDistMenu.removeChildren();
                        Action action = new Action("RoundRobinRowDistribution", 2){

                            public void run() {
                                stepMeta.setRowDistribution(null);
                                stepMeta.setDistributes(true);
                            }
                        };
                        boolean selected = stepMeta.isDistributes() && stepMeta.getRowDistribution() == null;
                        action.setChecked(selected);
                        JfaceMenuitem child = new JfaceMenuitem(null, (XulComponent)customRowDistMenu, this.xulDomContainer, "Round Robin row distribution", 0, action);
                        child.setLabel(BaseMessages.getString(PKG, (String)"TransGraph.PopupMenu.RoundRobin", (String[])new String[0]));
                        child.setDisabled(false);
                        child.setSelected(selected);
                        for (int p = 0; p < rowDistributionPlugins.size(); ++p) {
                            final PluginInterface rowDistributionPlugin = (PluginInterface)rowDistributionPlugins.get(p);
                            selected = stepMeta.isDistributes() && stepMeta.getRowDistribution() != null && stepMeta.getRowDistribution().getCode().equals(rowDistributionPlugin.getIds()[0]);
                            action = new Action(rowDistributionPlugin.getIds()[0], 2){

                                public void run() {
                                    try {
                                        stepMeta.setRowDistribution((RowDistributionInterface)PluginRegistry.getInstance().loadClass(rowDistributionPlugin));
                                    }
                                    catch (Exception e) {
                                        LogChannel.GENERAL.logError("Error loading row distribution plugin class: ", (Throwable)e);
                                    }
                                }
                            };
                            action.setChecked(selected);
                            child = new JfaceMenuitem(null, (XulComponent)customRowDistMenu, this.xulDomContainer, rowDistributionPlugin.getName(), p + 1, action);
                            child.setLabel(rowDistributionPlugin.getName());
                            child.setDisabled(false);
                            child.setSelected(selected);
                        }
                        action = new Action("CopyRowsDistribution", 2){

                            public void run() {
                                stepMeta.setDistributes(false);
                            }
                        };
                        selected = !stepMeta.isDistributes();
                        action.setChecked(selected);
                        child = new JfaceMenuitem(null, (XulComponent)customRowDistMenu, this.xulDomContainer, "Copy rows distribution", 0, action);
                        child.setLabel(BaseMessages.getString(PKG, (String)"TransGraph.PopupMenu.CopyData", (String[])new String[0]));
                        child.setDisabled(false);
                        child.setSelected(selected);
                        JfaceMenupopup launchMenu = (JfaceMenupopup)doc.getElementById("trans-graph-entry-launch-popup");
                        CharSequence[] referencedObjects = stepMeta.getStepMetaInterface().getReferencedObjectDescriptions();
                        boolean[] enabledObjects = stepMeta.getStepMetaInterface().isReferencedObjectEnabled();
                        launchMenu.setDisabled(Utils.isEmpty((CharSequence[])referencedObjects));
                        launchMenu.removeChildren();
                        int childIndex = 0;
                        StepMetaInterface stepMetaInterface = stepMeta.getStepMetaInterface();
                        String activeReferencedObjectDescription = stepMetaInterface.getActiveReferencedObjectDescription();
                        if (this.getActiveSubtransformation(this, stepMeta) != null && activeReferencedObjectDescription != null) {
                            action = new Action(activeReferencedObjectDescription, 4){

                                public void run() {
                                    TransGraph.this.openMapping(stepMeta, -1);
                                }
                            };
                            child = new JfaceMenuitem(null, (XulComponent)launchMenu, this.xulDomContainer, activeReferencedObjectDescription, childIndex++, action);
                            child.setLabel(activeReferencedObjectDescription);
                            child.setDisabled(false);
                        }
                        if (!Utils.isEmpty((CharSequence[])referencedObjects)) {
                            for (int i = 0; i < referencedObjects.length; ++i) {
                                final int index = i;
                                CharSequence referencedObject = referencedObjects[i];
                                action = new Action((String)referencedObject, 4){

                                    public void run() {
                                        TransGraph.this.openMapping(stepMeta, index);
                                    }
                                };
                                child = new JfaceMenuitem(null, (XulComponent)launchMenu, this.xulDomContainer, (String)referencedObject, childIndex++, action);
                                child.setLabel((String)referencedObject);
                                child.setDisabled(!enabledObjects[i]);
                            }
                        }
                        this.initializeXulMenu(doc, selection, stepMeta);
                        ConstUI.displayMenu(menu, (Control)this.canvas);
                    }
                    break block21;
                }
                TransHopMeta hi = this.findHop(x, y);
                if (hi != null) {
                    XulMenupopup menu = this.menuMap.get("trans-graph-hop");
                    if (menu != null) {
                        this.setCurrentHop(hi);
                        XulMenuitem item = (XulMenuitem)this.getXulDomContainer().getDocumentRoot().getElementById("trans-graph-hop-enabled");
                        if (item != null) {
                            if (hi.isEnabled()) {
                                item.setLabel(BaseMessages.getString(PKG, (String)"TransGraph.PopupMenu.DisableHop", (String[])new String[0]));
                            } else {
                                item.setLabel(BaseMessages.getString(PKG, (String)"TransGraph.PopupMenu.EnableHop", (String[])new String[0]));
                            }
                        }
                        ConstUI.displayMenu(menu, (Control)this.canvas);
                    }
                } else {
                    NotePadMeta ni = this.transMeta.getNote(x, y);
                    this.setCurrentNote(ni);
                    if (ni != null) {
                        XulMenupopup menu = this.menuMap.get("trans-graph-note");
                        if (menu != null) {
                            ConstUI.displayMenu(menu, (Control)this.canvas);
                        }
                    } else {
                        XulMenupopup menu = this.menuMap.get("trans-graph-background");
                        if (menu != null) {
                            String clipcontent = this.spoon.fromClipboard();
                            XulMenuitem item = (XulMenuitem)this.getXulDomContainer().getDocumentRoot().getElementById("trans-graph-background-paste");
                            if (item != null) {
                                item.setDisabled(clipcontent == null);
                            }
                            ConstUI.displayMenu(menu, (Control)this.canvas);
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void selectAll() {
        this.spoon.editSelectAll();
    }

    public void clearSelection() {
        this.spoon.editUnselectAll();
    }

    protected void initializeXulMenu(Document doc, List<StepMeta> selection, StepMeta stepMeta) throws KettleException {
        XulMenuitem item = (XulMenuitem)doc.getElementById("trans-graph-entry-newhop");
        int sels = selection.size();
        item.setDisabled(sels != 2);
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-align-snap");
        item.setAcceltext("ALT-HOME");
        item.setLabel(BaseMessages.getString(PKG, (String)"TransGraph.PopupMenu.SnapToGrid", (String[])new String[0]));
        item.setAccesskey("alt-home");
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-open-mapping");
        XulMenu men = (XulMenu)doc.getElementById(TRANS_GRAPH_ENTRY_SNIFF);
        men.setDisabled(this.trans == null || !this.trans.isRunning());
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-sniff-input");
        item.setDisabled(this.trans == null || !this.trans.isRunning());
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-sniff-output");
        item.setDisabled(this.trans == null || !this.trans.isRunning());
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-sniff-error");
        item.setDisabled(!stepMeta.supportsErrorHandling() || stepMeta.getStepErrorMeta() == null || stepMeta.getStepErrorMeta().getTargetStep() == null || this.trans == null || !this.trans.isRunning());
        XulMenu aMenu = (XulMenu)doc.getElementById(TRANS_GRAPH_ENTRY_AGAIN);
        if (aMenu != null) {
            aMenu.setDisabled(sels < 2);
        }
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-partitioning");
        item.setDisabled(this.spoon.getPartitionSchemasNames(this.transMeta).isEmpty());
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-data-movement-copy");
        item.setSelected(!stepMeta.isDistributes());
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-hide");
        item.setDisabled(!stepMeta.isDrawn() || this.transMeta.isAnySelectedStepUsedInTransHops());
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-detach");
        item.setDisabled(!this.transMeta.isStepUsedInTransHops(stepMeta));
        item = (XulMenuitem)doc.getElementById("trans-graph-entry-errors");
        item.setDisabled(!stepMeta.supportsErrorHandling());
    }

    private boolean checkNumberOfCopies(TransMeta transMeta, StepMeta stepMeta) {
        boolean enabled = true;
        List prevSteps = transMeta.findPreviousSteps(stepMeta);
        for (StepMeta prevStep : prevSteps) {
            String[] targetSteps = prevStep.getStepMetaInterface().getStepIOMeta().getTargetStepnames();
            if (targetSteps == null) continue;
            for (int t = 0; t < targetSteps.length && enabled; ++t) {
                if (Utils.isEmpty((CharSequence)targetSteps[t]) || !targetSteps[t].equalsIgnoreCase(stepMeta.getName())) continue;
                enabled = false;
            }
        }
        return enabled;
    }

    private AreaOwner setToolTip(int x, int y, int screenX, int screenY) {
        AreaOwner subject = null;
        if (!this.spoon.getProperties().showToolTips()) {
            return subject;
        }
        this.canvas.setToolTipText(null);
        String newTip = null;
        Image tipImage = null;
        TransHopMeta hi = this.findHop(x, y);
        StringBuilder tip = new StringBuilder();
        AreaOwner areaOwner = this.getVisibleAreaOwner(x, y);
        AreaOwner.AreaType areaType = null;
        if (areaOwner != null && areaOwner.getAreaType() != null) {
            areaType = areaOwner.getAreaType();
            switch (areaType) {
                case REMOTE_INPUT_STEP: {
                    StepMeta step = (StepMeta)areaOwner.getParent();
                    tip.append("Remote input steps:").append(Const.CR).append("-----------------------").append(Const.CR);
                    for (RemoteStep remoteStep : step.getRemoteInputSteps()) {
                        tip.append(remoteStep.toString()).append(Const.CR);
                    }
                    break;
                }
                case REMOTE_OUTPUT_STEP: {
                    StepMeta step = (StepMeta)areaOwner.getParent();
                    tip.append("Remote output steps:").append(Const.CR).append("-----------------------").append(Const.CR);
                    for (RemoteStep remoteStep : step.getRemoteOutputSteps()) {
                        tip.append(remoteStep.toString()).append(Const.CR);
                    }
                    break;
                }
                case STEP_PARTITIONING: {
                    StepMeta step = (StepMeta)areaOwner.getParent();
                    tip.append("Step partitioning:").append(Const.CR).append("-----------------------").append(Const.CR);
                    tip.append(step.getStepPartitioningMeta().toString()).append(Const.CR);
                    if (step.getTargetStepPartitioningMeta() == null) break;
                    tip.append(Const.CR).append(Const.CR).append("TARGET: " + step.getTargetStepPartitioningMeta().toString()).append(Const.CR);
                    break;
                }
                case STEP_ERROR_ICON: {
                    String log = (String)areaOwner.getParent();
                    tip.append(log);
                    tipImage = GUIResource.getInstance().getImageStepError();
                    break;
                }
                case STEP_ERROR_RED_ICON: {
                    String redLog = (String)areaOwner.getParent();
                    tip.append(redLog);
                    tipImage = GUIResource.getInstance().getImageRedStepError();
                    break;
                }
                case HOP_COPY_ICON: {
                    StepMeta step = (StepMeta)areaOwner.getParent();
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.Hop.Tooltip.HopTypeCopy", (String[])new String[]{step.getName(), Const.CR}));
                    tipImage = GUIResource.getInstance().getImageCopyHop();
                    break;
                }
                case ROW_DISTRIBUTION_ICON: {
                    StepMeta step = (StepMeta)areaOwner.getParent();
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.Hop.Tooltip.RowDistribution", (String[])new String[]{step.getName(), step.getRowDistribution() == null ? "" : step.getRowDistribution().getDescription()}));
                    tip.append(Const.CR);
                    tipImage = GUIResource.getInstance().getImageBalance();
                    break;
                }
                case HOP_INFO_ICON: {
                    StepMeta from = (StepMeta)areaOwner.getParent();
                    StepMeta to = (StepMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.Hop.Tooltip.HopTypeInfo", (String[])new String[]{to.getName(), from.getName(), Const.CR}));
                    tipImage = GUIResource.getInstance().getImageInfoHop();
                    break;
                }
                case HOP_ERROR_ICON: {
                    StepMeta from = (StepMeta)areaOwner.getParent();
                    StepMeta to = (StepMeta)areaOwner.getOwner();
                    areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.Hop.Tooltip.HopTypeError", (String[])new String[]{from.getName(), to.getName(), Const.CR}));
                    tipImage = GUIResource.getInstance().getImageErrorHop();
                    break;
                }
                case HOP_INFO_STEP_COPIES_ERROR: {
                    StepMeta from = (StepMeta)areaOwner.getParent();
                    StepMeta to = (StepMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.Hop.Tooltip.InfoStepCopies", (String[])new String[]{from.getName(), to.getName(), Const.CR}));
                    tipImage = GUIResource.getInstance().getImageStepError();
                    break;
                }
                case STEP_INPUT_HOP_ICON: {
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepInputConnector.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageHopInput();
                    break;
                }
                case STEP_OUTPUT_HOP_ICON: {
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepOutputConnector.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageHopOutput();
                    break;
                }
                case STEP_INFO_HOP_ICON: {
                    StepIOMetaInterface ioMeta = (StepIOMetaInterface)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepInfoConnector.Tooltip", (String[])new String[0]) + Const.CR + ioMeta.toString());
                    tipImage = GUIResource.getInstance().getImageHopOutput();
                    break;
                }
                case STEP_TARGET_HOP_ICON: {
                    StreamInterface stream = (StreamInterface)areaOwner.getOwner();
                    tip.append(stream.getDescription());
                    tipImage = GUIResource.getInstance().getImageHopOutput();
                    break;
                }
                case STEP_ERROR_HOP_ICON: {
                    StepMeta stepMeta = (StepMeta)areaOwner.getParent();
                    if (stepMeta.supportsErrorHandling()) {
                        tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepSupportsErrorHandling.Tooltip", (String[])new String[0]));
                    } else {
                        tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepDoesNotSupportsErrorHandling.Tooltip", (String[])new String[0]));
                    }
                    tipImage = GUIResource.getInstance().getImageHopOutput();
                    break;
                }
                case STEP_EDIT_ICON: {
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.EditStep.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageEdit();
                    break;
                }
                case STEP_INJECT_ICON: {
                    Object injection = areaOwner.getOwner();
                    if (injection != null) {
                        tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepInjectionSupported.Tooltip", (String[])new String[0]));
                    } else {
                        tip.append(BaseMessages.getString(PKG, (String)"TransGraph.StepInjectionNotSupported.Tooltip", (String[])new String[0]));
                    }
                    tipImage = GUIResource.getInstance().getImageInject();
                    break;
                }
                case STEP_MENU_ICON: {
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.ShowMenu.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageContextMenu();
                    break;
                }
                case STEP_ICON: {
                    StepMeta iconStepMeta = (StepMeta)areaOwner.getOwner();
                    if (!iconStepMeta.isDeprecated()) break;
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.DeprecatedStep.Tooltip.Title", (String[])new String[0])).append(Const.CR);
                    String tipNext = BaseMessages.getString(PKG, (String)"TransGraph.DeprecatedStep.Tooltip.Message1", (String[])new String[]{iconStepMeta.getName()});
                    int length = tipNext.length() + 5;
                    for (int i = 0; i < length; ++i) {
                        tip.append("-");
                    }
                    tip.append(Const.CR).append(tipNext).append(Const.CR);
                    tip.append(BaseMessages.getString(PKG, (String)"TransGraph.DeprecatedStep.Tooltip.Message2", (String[])new String[0]));
                    if (!(Utils.isEmpty((CharSequence)iconStepMeta.getSuggestion()) || iconStepMeta.getSuggestion().startsWith("!") && iconStepMeta.getSuggestion().endsWith("!"))) {
                        tip.append(" ");
                        tip.append(BaseMessages.getString(PKG, (String)"TransGraph.DeprecatedStep.Tooltip.Message3", (String[])new String[]{iconStepMeta.getSuggestion()}));
                    }
                    tipImage = GUIResource.getInstance().getImageDeprecated();
                    this.toolTip.setHideDelay(10000);
                    break;
                }
            }
        }
        if (hi != null && tip.length() == 0) {
            newTip = hi.toString();
            tip.append(Const.CR).append(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo", (String[])new String[0])).append(newTip).append(Const.CR);
        }
        if ((newTip = tip.length() == 0 ? null : tip.toString()) == null) {
            this.toolTip.hide();
            if (hi != null) {
                newTip = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo.SourceStep", (String[])new String[0]) + " " + hi.getFromStep().getName() + Const.CR + BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo.TargetStep", (String[])new String[0]) + " " + hi.getToStep().getName() + Const.CR + BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo.Status", (String[])new String[0]) + " " + (hi.isEnabled() ? BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo.Enable", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo.Disable", (String[])new String[0]));
                this.toolTip.setText(newTip);
                if (hi.isEnabled()) {
                    this.toolTip.setImage(GUIResource.getInstance().getImageHop());
                } else {
                    this.toolTip.setImage(GUIResource.getInstance().getImageDisabledHop());
                }
                this.toolTip.show(new Point(screenX, screenY));
            } else {
                newTip = null;
            }
        } else if (!newTip.equalsIgnoreCase(this.getToolTipText())) {
            Image tooltipImage = null;
            tooltipImage = tipImage != null ? tipImage : GUIResource.getInstance().getImageSpoonLow();
            this.showTooltip(newTip, tooltipImage, screenX, screenY);
        }
        if (areaOwner != null && areaOwner.getExtensionAreaType() != null) {
            try {
                TransPainterFlyoutTooltipExtension extension = new TransPainterFlyoutTooltipExtension(areaOwner, this, new org.pentaho.di.core.gui.Point(screenX, screenY));
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.TransPainterFlyoutTooltip.id, (Object)extension);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error calling extension point(s) for the transformation painter step", (Throwable)e);
            }
        }
        return subject;
    }

    public void showTooltip(String label, Image image, int screenX, int screenY) {
        this.toolTip.setImage(image);
        this.toolTip.setText(label);
        this.toolTip.hide();
        this.toolTip.show(new Point(screenX, screenY));
    }

    public AreaOwner getVisibleAreaOwner(int x, int y) {
        for (int i = this.areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = this.areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    public void delSelected(StepMeta stMeta) {
        List selection = this.transMeta.getSelectedSteps();
        if (selection.size() == 0) {
            this.spoon.delStep(this.transMeta, stMeta);
            return;
        }
        if (this.currentStep != null && selection.contains(this.currentStep)) {
            this.currentStep = null;
            this.transPreviewDelegate.setSelectedStep(this.currentStep);
            this.transPreviewDelegate.refreshView();
            for (StepSelectionListener listener : this.currentStepListeners) {
                listener.onUpdateSelection(this.currentStep);
            }
        }
        StepMeta[] steps = selection.toArray(new StepMeta[selection.size()]);
        this.spoon.delSteps(this.transMeta, steps);
    }

    public void editDescription(StepMeta stepMeta) {
        String message;
        String title = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.StepDescription.Title", (String[])new String[0]);
        EnterTextDialog dd = new EnterTextDialog(this.shell, title, message = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.StepDescription.Message", (String[])new String[0]), stepMeta.getDescription());
        String d = dd.open();
        if (d != null) {
            stepMeta.setDescription(d);
            stepMeta.setChanged();
            this.spoon.setShellText();
        }
    }

    private void inputOutputFields(StepMeta stepMeta, boolean before) {
        this.spoon.refreshGraph();
        this.transMeta.setRepository(this.spoon.rep);
        SearchFieldsProgressDialog op = new SearchFieldsProgressDialog(this.transMeta, stepMeta, before);
        boolean alreadyThrownError = false;
        try {
            final ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            TransGraph.this.transMeta.cancelQueries();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.GettingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.Dialog.GettingFields.Message", (String[])new String[0]), e);
            alreadyThrownError = true;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.GettingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.Dialog.GettingFields.Message", (String[])new String[0]), e);
            alreadyThrownError = true;
        }
        RowMetaInterface fields = op.getFields();
        if (fields != null && fields.size() > 0) {
            StepMeta esi;
            StepFieldsDialog sfd = new StepFieldsDialog(this.shell, (VariableSpace)this.transMeta, 0, stepMeta.getName(), fields);
            String sn = (String)sfd.open();
            if (sn != null && (esi = this.transMeta.findStep(sn)) != null) {
                this.editStep(esi);
            }
        } else if (!alreadyThrownError) {
            this.modalMessageDialog(this.getString("TransGraph.Dialog.CouldntFindFields.Title"), this.getString("TransGraph.Dialog.CouldntFindFields.Message"), 34);
        }
    }

    public void paintControl(PaintEvent e) {
        org.pentaho.di.core.gui.Point area = this.getArea();
        if (area.x == 0 || area.y == 0) {
            return;
        }
        Display disp = this.shell.getDisplay();
        Image img = this.getTransformationImage((Device)disp, area.x, area.y, this.magnification);
        e.gc.drawImage(img, 0, 0);
        if (this.transMeta.nrSteps() == 0) {
            e.gc.setForeground(GUIResource.getInstance().getColorCrystalTextPentaho());
            e.gc.setFont(GUIResource.getInstance().getFontMedium());
            Image pentahoImage = GUIResource.getInstance().getImageTransCanvas();
            int leftPosition = (area.x - pentahoImage.getBounds().width) / 2;
            int topPosition = (area.y - pentahoImage.getBounds().height) / 2;
            e.gc.drawImage(pentahoImage, leftPosition, topPosition);
        }
        img.dispose();
    }

    public Image getTransformationImage(Device device, int x, int y, float magnificationFactor) {
        SWTGC gc = new SWTGC(device, new org.pentaho.di.core.gui.Point(x, y), this.iconsize);
        int gridSize = PropsUI.getInstance().isShowCanvasGridEnabled() ? PropsUI.getInstance().getCanvasGridSize() : 1;
        TransPainter transPainter = new TransPainter((GCInterface)gc, this.transMeta, new org.pentaho.di.core.gui.Point(x, y), (ScrollBarInterface)new SwtScrollBar(this.hori), (ScrollBarInterface)new SwtScrollBar(this.vert), this.candidate, this.drop_candidate, this.selectionRegion, this.areaOwners, this.mouseOverSteps, PropsUI.getInstance().getIconSize(), PropsUI.getInstance().getLineWidth(), gridSize, PropsUI.getInstance().getShadowSize(), PropsUI.getInstance().isAntiAliasingEnabled(), PropsUI.getInstance().getNoteFont().getName(), PropsUI.getInstance().getNoteFont().getHeight(), this.trans, PropsUI.getInstance().isIndicateSlowTransStepsEnabled());
        transPainter.setMagnification(magnificationFactor);
        transPainter.setStepLogMap(this.stepLogMap);
        transPainter.setStartHopStep(this.startHopStep);
        transPainter.setEndHopLocation(this.endHopLocation);
        transPainter.setNoInputStep(this.noInputStep);
        transPainter.setEndHopStep(this.endHopStep);
        transPainter.setCandidateHopType(this.candidateHopType);
        transPainter.setStartErrorHopStep(this.startErrorHopStep);
        transPainter.setShowTargetStreamsStep(this.showTargetStreamsStep);
        transPainter.buildTransformationImage();
        Image img = (Image)gc.getImage();
        gc.dispose();
        return img;
    }

    @Override
    protected org.pentaho.di.core.gui.Point getOffset() {
        org.pentaho.di.core.gui.Point area = this.getArea();
        org.pentaho.di.core.gui.Point max = this.transMeta.getMaximum();
        org.pentaho.di.core.gui.Point thumb = this.getThumb(area, max);
        return this.getOffset(thumb, area);
    }

    private void editStep(StepMeta stepMeta) {
        this.spoon.editStep(this.transMeta, stepMeta);
    }

    private void editNote(NotePadMeta ni) {
        NotePadMeta before = (NotePadMeta)ni.clone();
        String title = BaseMessages.getString(PKG, (String)"TransGraph.Dialog.EditNote.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog((VariableSpace)this.transMeta, this.shell, title, ni);
        NotePadMeta n = dd.open();
        if (n != null) {
            ni.setChanged();
            ni.setNote(n.getNote());
            ni.setFontName(n.getFontName());
            ni.setFontSize(n.getFontSize());
            ni.setFontBold(n.isFontBold());
            ni.setFontItalic(n.isFontItalic());
            ni.setFontColorRed(n.getFontColorRed());
            ni.setFontColorGreen(n.getFontColorGreen());
            ni.setFontColorBlue(n.getFontColorBlue());
            ni.setBackGroundColorRed(n.getBackGroundColorRed());
            ni.setBackGroundColorGreen(n.getBackGroundColorGreen());
            ni.setBackGroundColorBlue(n.getBackGroundColorBlue());
            ni.setBorderColorRed(n.getBorderColorRed());
            ni.setBorderColorGreen(n.getBorderColorGreen());
            ni.setBorderColorBlue(n.getBorderColorBlue());
            ni.setDrawShadow(n.isDrawShadow());
            ni.width = 20;
            ni.height = 20;
            NotePadMeta after = (NotePadMeta)ni.clone();
            this.spoon.addUndoChange((UndoInterface)this.transMeta, new NotePadMeta[]{before}, new NotePadMeta[]{after}, new int[]{this.transMeta.indexOfNote(ni)});
            this.spoon.refreshGraph();
        }
    }

    private void editHop(TransHopMeta transHopMeta) {
        String name = transHopMeta.toString();
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"TransGraph.Logging.EditingHop", (String[])new String[0]) + name);
        }
        this.spoon.editHop(this.transMeta, transHopMeta);
    }

    private void newHop() {
        List selection = this.transMeta.getSelectedSteps();
        if (selection.size() == 2) {
            StepMeta fr = (StepMeta)selection.get(0);
            StepMeta to = (StepMeta)selection.get(1);
            this.spoon.newHop(this.transMeta, fr, to);
        }
    }

    private boolean pointOnLine(int x, int y, int[] line) {
        int pm = 4;
        boolean retval = false;
        for (int dx = -pm; dx <= pm && !retval; ++dx) {
            for (int dy = -pm; dy <= pm && !retval; ++dy) {
                retval = this.pointOnThinLine(x + dx, y + dy, line);
            }
        }
        return retval;
    }

    private boolean pointOnThinLine(int x, int y, int[] line) {
        int x1 = line[0];
        int y1 = line[1];
        int x2 = line[2];
        int y2 = line[3];
        if (!((x >= x1 && x <= x2 || x >= x2 && x <= x1) && (y >= y1 && y <= y2 || y >= y2 && y <= y1))) {
            return false;
        }
        double angle_line = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        double angle_point = Math.atan2(y - y1, x - x1) + Math.PI;
        return angle_point >= angle_line - 0.01 && angle_point <= angle_line + 0.01;
    }

    private SnapAllignDistribute createSnapAllignDistribute() {
        List selection = this.transMeta.getSelectedSteps();
        int[] indices = this.transMeta.getStepIndexes(selection);
        return new SnapAllignDistribute((UndoInterface)this.transMeta, selection, indices, (AddUndoPositionInterface)this.spoon, (Redrawable)this);
    }

    public void snaptogrid() {
        this.snaptogrid(16);
    }

    private void snaptogrid(int size) {
        this.createSnapAllignDistribute().snaptogrid(size);
    }

    public void allignleft() {
        this.createSnapAllignDistribute().allignleft();
    }

    public void allignright() {
        this.createSnapAllignDistribute().allignright();
    }

    public void alligntop() {
        this.createSnapAllignDistribute().alligntop();
    }

    public void allignbottom() {
        this.createSnapAllignDistribute().allignbottom();
    }

    public void distributehorizontal() {
        this.createSnapAllignDistribute().distributehorizontal();
    }

    public void distributevertical() {
        this.createSnapAllignDistribute().distributevertical();
    }

    private void detach(StepMeta stepMeta) {
        for (int i = this.transMeta.nrTransHops() - 1; i >= 0; --i) {
            TransHopMeta hop = this.transMeta.getTransHop(i);
            if (!stepMeta.equals((Object)hop.getFromStep()) && !stepMeta.equals((Object)hop.getToStep())) continue;
            this.spoon.addUndoNew((UndoInterface)this.transMeta, new TransHopMeta[]{hop}, new int[]{i});
            this.transMeta.removeTransHop(i);
        }
        this.spoon.refreshTree();
        this.redraw();
    }

    public void preview() {
        this.spoon.previewTransformation();
    }

    public void newProps() {
        this.iconsize = this.spoon.props.getIconSize();
    }

    @Override
    public EngineMetaInterface getMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public void addUndoPosition(Object[] obj, int[] pos, org.pentaho.di.core.gui.Point[] prev, org.pentaho.di.core.gui.Point[] curr) {
        this.addUndoPosition(obj, pos, prev, curr, false);
    }

    public void addUndoPosition(Object[] obj, int[] pos, org.pentaho.di.core.gui.Point[] prev, org.pentaho.di.core.gui.Point[] curr, boolean nextAlso) {
        this.transMeta.addUndo(obj, null, pos, prev, curr, 4, nextAlso);
        this.spoon.setUndoMenu((UndoInterface)this.transMeta);
    }

    @Override
    public boolean applyChanges() throws KettleException {
        return this.spoon.saveToFile((EngineMetaInterface)this.transMeta);
    }

    @Override
    public boolean canBeClosed() {
        return !this.transMeta.hasChanged();
    }

    public TransMeta getManagedObject() {
        return this.transMeta;
    }

    @Override
    public boolean hasContentChanged() {
        return this.transMeta.hasChanged();
    }

    public List<CheckResultInterface> getRemarks() {
        return this.remarks;
    }

    public void setRemarks(List<CheckResultInterface> remarks) {
        this.remarks = remarks;
    }

    public List<DatabaseImpact> getImpact() {
        return this.impact;
    }

    public void setImpact(List<DatabaseImpact> impact) {
        this.impact = impact;
    }

    public boolean isImpactFinished() {
        return this.impactFinished;
    }

    public void setImpactFinished(boolean impactHasRun) {
        this.impactFinished = impactHasRun;
    }

    public org.pentaho.di.core.gui.Point getLastMove() {
        return this.lastMove;
    }

    public static boolean editProperties(TransMeta transMeta, Spoon spoon, Repository rep, boolean allowDirectoryChange) {
        return TransGraph.editProperties(transMeta, spoon, rep, allowDirectoryChange, null);
    }

    public static boolean editProperties(TransMeta transMeta, Spoon spoon, Repository rep, boolean allowDirectoryChange, TransDialog.Tabs currentTab) {
        if (transMeta == null) {
            return false;
        }
        TransDialog tid = new TransDialog(spoon.getShell(), 0, transMeta, rep, currentTab);
        tid.setDirectoryChangeAllowed(allowDirectoryChange);
        TransMeta ti = tid.open();
        if (tid.isSharedObjectsFileChanged()) {
            try {
                SharedObjects sharedObjects = rep != null ? rep.readTransSharedObjects(transMeta) : transMeta.readSharedObjects();
                spoon.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
            }
            catch (KettleException e) {
                new ErrorDialog(spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Message", (String[])new String[]{spoon.makeTabName((EngineMetaInterface)transMeta, true)}), (Exception)((Object)e));
            }
            spoon.setParametersAsVariablesInUI((NamedParams)transMeta, (VariableSpace)transMeta);
            spoon.refreshTree();
            spoon.delegates.tabs.renameTabs();
        }
        spoon.setShellText();
        return ti != null;
    }

    public void openFile() {
        this.spoon.openFile();
    }

    public void saveFile() throws KettleException {
        this.spoon.saveFile();
    }

    public void saveFileAs() throws KettleException {
        this.spoon.saveFileAs();
    }

    public void saveXMLFileToVfs() {
        this.spoon.saveXMLFileToVfs();
    }

    public void printFile() {
        this.spoon.printFile();
    }

    public void runTransformation() {
        this.spoon.runFile();
    }

    public void runOptionsTransformation() {
        this.spoon.runOptionsFile();
    }

    public void pauseTransformation() {
        this.pauseResume();
    }

    public void stopTransformation() {
        this.stop();
    }

    public void previewFile() {
        this.spoon.previewFile();
    }

    public void debugFile() {
        this.spoon.debugFile();
    }

    public void transReplay() {
        this.spoon.replayTransformation();
    }

    public void checkTrans() {
        this.spoon.checkTrans();
    }

    public void analyseImpact() {
        this.spoon.analyseImpact();
    }

    public void getSQL() {
        this.spoon.getSQL();
    }

    public void exploreDatabase() {
        this.spoon.exploreDatabase();
    }

    public boolean isExecutionResultsPaneVisible() {
        return this.extraViewComposite != null && !this.extraViewComposite.isDisposed();
    }

    public void showExecutionResults() {
        if (this.isExecutionResultsPaneVisible()) {
            this.disposeExtraView();
        } else {
            this.addAllTabs();
        }
    }

    public void browseVersionHistory() {
        try {
            if (this.spoon.rep.exists(this.transMeta.getName(), this.transMeta.getRepositoryDirectory(), RepositoryObjectType.TRANSFORMATION)) {
                RepositoryRevisionBrowserDialogInterface dialog = RepositoryExplorerDialog.getVersionBrowserDialog(this.shell, this.spoon.rep, (RepositoryElementInterface)this.transMeta);
                String versionLabel = dialog.open();
                if (versionLabel != null) {
                    this.spoon.loadObjectFromRepository(this.transMeta.getName(), this.transMeta.getRepositoryElementType(), this.transMeta.getRepositoryDirectory(), versionLabel);
                }
            } else {
                this.modalMessageDialog(this.getString("TransGraph.Sorry"), this.getString("TransGraph.VersionBrowser.CantFindInRepo"), 65);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.VersionBrowserException.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.VersionBrowserException.Message", (String[])new String[0]), e);
        }
    }

    public void checkEmptyExtraView() {
        if (this.extraViewTabFolder.getItemCount() == 0) {
            this.disposeExtraView();
        }
    }

    private void disposeExtraView() {
        this.extraViewComposite.dispose();
        this.sashForm.layout();
        this.sashForm.setWeights(new int[]{100});
        XulToolbarbutton button = (XulToolbarbutton)this.toolbar.getElementById("trans-show-results");
        button.setTooltiptext(BaseMessages.getString(PKG, (String)"Spoon.Tooltip.ShowExecutionResults", (String[])new String[0]));
        ToolItem toolItem = (ToolItem)button.getManagedObject();
        toolItem.setImage(GUIResource.getInstance().getImageShowResults());
    }

    private void minMaxExtraView() {
        boolean maximized;
        boolean bl = maximized = this.sashForm.getMaximizedControl() != null;
        if (maximized) {
            this.sashForm.setMaximizedControl(null);
            this.minMaxButton.setImage(GUIResource.getInstance().getImageMaximizePanel());
            this.minMaxButton.setToolTipText(BaseMessages.getString(PKG, (String)"TransGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        } else {
            this.sashForm.setMaximizedControl((Control)this.extraViewComposite);
            this.minMaxButton.setImage(GUIResource.getInstance().getImageMinimizePanel());
            this.minMaxButton.setToolTipText(BaseMessages.getString(PKG, (String)"TransGraph.ExecutionResultsPanel.MinButton.Tooltip", (String[])new String[0]));
        }
    }

    public XulToolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(XulToolbar toolbar) {
        this.toolbar = toolbar;
    }

    public void addExtraView() {
        this.extraViewComposite = new Composite((Composite)this.sashForm, 0);
        FormLayout extraCompositeFormLayout = new FormLayout();
        extraCompositeFormLayout.marginWidth = 2;
        extraCompositeFormLayout.marginHeight = 2;
        this.extraViewComposite.setLayout((Layout)extraCompositeFormLayout);
        this.closeButton = new Label(this.extraViewComposite, 0);
        this.closeButton.setImage(GUIResource.getInstance().getImageClosePanel());
        this.closeButton.setToolTipText(BaseMessages.getString(PKG, (String)"TransGraph.ExecutionResultsPanel.CloseButton.Tooltip", (String[])new String[0]));
        FormData fdClose = new FormData();
        fdClose.right = new FormAttachment(100, 0);
        fdClose.top = new FormAttachment(0, 0);
        this.closeButton.setLayoutData((Object)fdClose);
        this.closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TransGraph.this.disposeExtraView();
            }
        });
        this.minMaxButton = new Label(this.extraViewComposite, 0);
        this.minMaxButton.setImage(GUIResource.getInstance().getImageMaximizePanel());
        this.minMaxButton.setToolTipText(BaseMessages.getString(PKG, (String)"TransGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        FormData fdMinMax = new FormData();
        fdMinMax.right = new FormAttachment((Control)this.closeButton, -4);
        fdMinMax.top = new FormAttachment(0, 0);
        this.minMaxButton.setLayoutData((Object)fdMinMax);
        this.minMaxButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TransGraph.this.minMaxExtraView();
            }
        });
        Label wResultsLabel = new Label(this.extraViewComposite, 16384);
        wResultsLabel.setFont(GUIResource.getInstance().getFontMediumBold());
        wResultsLabel.setBackground(GUIResource.getInstance().getColorWhite());
        wResultsLabel.setText(BaseMessages.getString(PKG, (String)"TransLog.ResultsPanel.NameLabel", (String[])new String[0]));
        FormData fdResultsLabel = new FormData();
        fdResultsLabel.left = new FormAttachment(0, 0);
        fdResultsLabel.right = new FormAttachment((Control)this.minMaxButton, -4);
        fdResultsLabel.top = new FormAttachment(0, 0);
        wResultsLabel.setLayoutData((Object)fdResultsLabel);
        this.extraViewTabFolder = new CTabFolder(this.extraViewComposite, 2);
        this.spoon.props.setLook((Control)this.extraViewTabFolder, 5);
        this.extraViewTabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (TransGraph.this.sashForm.getMaximizedControl() == null) {
                    TransGraph.this.sashForm.setMaximizedControl((Control)TransGraph.this.extraViewComposite);
                } else {
                    TransGraph.this.sashForm.setMaximizedControl(null);
                }
            }
        });
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)wResultsLabel, 4);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        this.extraViewTabFolder.setLayoutData((Object)fdTabFolder);
        this.sashForm.setWeights(new int[]{60, 40});
    }

    @Deprecated
    public void checkErrors() {
        if (this.trans != null && !this.trans.isFinished() && this.trans.getErrors() != 0) {
            this.trans.killAll();
        }
    }

    public synchronized void start(TransExecutionConfiguration executionConfiguration) throws KettleException {
        this.handleTransMetaChanges(this.transMeta);
        if ((this.transMeta.getName() != null && this.transMeta.getObjectId() != null && this.spoon.rep != null || this.transMeta.getFilename() != null && this.spoon.rep == null) && !this.transMeta.hasChanged()) {
            if (this.trans == null || !this.running) {
                try {
                    DefaultLogLevel.setLogLevel((LogLevel)executionConfiguration.getLogLevel());
                    this.transMeta.injectVariables(executionConfiguration.getVariables());
                    Map paramMap = executionConfiguration.getParams();
                    Set keys = paramMap.keySet();
                    for (String key : keys) {
                        this.transMeta.setParameterValue(key, Const.NVL((String)((String)paramMap.get(key)), (String)""));
                    }
                    this.transMeta.activateParameters();
                    if (executionConfiguration.isClearingLog()) {
                        this.transLogDelegate.clearLog();
                    }
                    if (this.trans != null) {
                        KettleLogStore.discardLines((String)this.trans.getLogChannelId(), (boolean)true);
                    }
                    this.trans = new TransSupplier(this.transMeta, this.log, this::createLegacyTrans).get();
                    this.trans.setRepository(this.spoon.getRepository());
                    this.trans.setMetaStore((IMetaStore)this.spoon.getMetaStore());
                    String spoonLogObjectId = UUID.randomUUID().toString();
                    SimpleLoggingObject spoonLoggingObject = new SimpleLoggingObject("SPOON", LoggingObjectType.SPOON, null);
                    spoonLoggingObject.setContainerObjectId(spoonLogObjectId);
                    spoonLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                    this.trans.setParent((LoggingObjectInterface)spoonLoggingObject);
                    this.trans.setLogLevel(executionConfiguration.getLogLevel());
                    this.trans.setReplayDate(executionConfiguration.getReplayDate());
                    this.trans.setRepository(executionConfiguration.getRepository());
                    this.trans.setMonitored(true);
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"TransLog.Log.TransformationOpened", (String[])new String[0]));
                }
                catch (KettleException e) {
                    this.trans = null;
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransLog.Dialog.ErrorOpeningTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLog.Dialog.ErrorOpeningTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
                }
                if (this.trans != null) {
                    Map arguments = executionConfiguration.getArguments();
                    final String[] args = arguments != null ? this.convertArguments(arguments) : null;
                    this.log.logMinimal(BaseMessages.getString(PKG, (String)"TransLog.Log.LaunchingTransformation", (String[])new String[0]) + this.trans.getTransMeta().getName() + "]...");
                    this.trans.setSafeModeEnabled(executionConfiguration.isSafeModeEnabled());
                    this.trans.setGatheringMetrics(executionConfiguration.isGatheringMetrics());
                    final Thread parentThread = Thread.currentThread();
                    this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TransGraph.this.addAllTabs();
                            TransGraph.this.prepareTrans(parentThread, args);
                        }
                    });
                    this.log.logMinimal(BaseMessages.getString(PKG, (String)"TransLog.Log.StartedExecutionOfTransformation", (String[])new String[0]));
                    this.setControlStates();
                }
            } else {
                this.modalMessageDialog(this.getString("TransLog.Dialog.DoNoStartTransformationTwice.Title"), this.getString("TransLog.Dialog.DoNoStartTransformationTwice.Message"), 40);
            }
        } else if (this.transMeta.hasChanged()) {
            this.showSaveFileMessage();
        } else if (this.spoon.rep != null && this.transMeta.getName() == null) {
            this.modalMessageDialog(this.getString("TransLog.Dialog.GiveTransformationANameBeforeRunning.Title"), this.getString("TransLog.Dialog.GiveTransformationANameBeforeRunning.Message"), 40);
        } else {
            this.modalMessageDialog(this.getString("TransLog.Dialog.SaveTransformationBeforeRunning2.Title"), this.getString("TransLog.Dialog.SaveTransformationBeforeRunning2.Message"), 40);
        }
    }

    public void showSaveFileMessage() {
        this.modalMessageDialog(this.getString("TransLog.Dialog.SaveTransformationBeforeRunning.Title"), this.getString("TransLog.Dialog.SaveTransformationBeforeRunning.Message"), 40);
    }

    public void addAllTabs() {
        CTabItem tabItemSelection = null;
        if (this.extraViewTabFolder != null && !this.extraViewTabFolder.isDisposed()) {
            tabItemSelection = this.extraViewTabFolder.getSelection();
        }
        this.transHistoryDelegate.addTransHistory();
        this.transLogDelegate.addTransLog();
        this.transGridDelegate.addTransGrid();
        this.transPerfDelegate.addTransPerf();
        this.transMetricsDelegate.addTransMetrics();
        this.transPreviewDelegate.addTransPreview();
        List<SpoonUiExtenderPluginInterface> relevantExtenders = SpoonUiExtenderPluginType.getInstance().getRelevantExtenders(TransGraph.class, LOAD_TAB);
        for (SpoonUiExtenderPluginInterface relevantExtender : relevantExtenders) {
            relevantExtender.uiEvent(this, LOAD_TAB);
        }
        if (tabItemSelection != null) {
            this.extraViewTabFolder.setSelection(tabItemSelection);
        } else {
            this.extraViewTabFolder.setSelection(this.transGridDelegate.getTransGridTab());
        }
        XulToolbarbutton button = (XulToolbarbutton)this.toolbar.getElementById("trans-show-results");
        button.setTooltiptext(BaseMessages.getString(PKG, (String)"Spoon.Tooltip.HideExecutionResults", (String[])new String[0]));
        ToolItem toolItem = (ToolItem)button.getManagedObject();
        toolItem.setImage(GUIResource.getInstance().getImageHideResults());
    }

    public synchronized void debug(TransExecutionConfiguration executionConfiguration, TransDebugMeta transDebugMeta) {
        if (!this.running) {
            try {
                this.lastTransDebugMeta = transDebugMeta;
                this.log.setLogLevel(executionConfiguration.getLogLevel());
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"TransLog.Log.DoPreview", (String[])new String[0]));
                }
                String[] args = null;
                Map arguments = executionConfiguration.getArguments();
                if (arguments != null) {
                    args = this.convertArguments(arguments);
                }
                this.transMeta.injectVariables(executionConfiguration.getVariables());
                Map paramMap = executionConfiguration.getParams();
                Set keys = paramMap.keySet();
                for (String key : keys) {
                    this.transMeta.setParameterValue(key, Const.NVL((String)((String)paramMap.get(key)), (String)""));
                }
                this.transMeta.activateParameters();
                if (executionConfiguration.isClearingLog()) {
                    this.transLogDelegate.clearLog();
                }
                if (this.trans != null) {
                    KettleLogStore.discardLines((String)this.trans.getLogChannelId(), (boolean)false);
                    LoggingRegistry.getInstance().removeIncludingChildren(this.trans.getLogChannelId());
                }
                this.trans = new Trans(this.transMeta);
                this.trans.setSafeModeEnabled(executionConfiguration.isSafeModeEnabled());
                this.trans.setPreview(true);
                this.trans.setGatheringMetrics(executionConfiguration.isGatheringMetrics());
                this.trans.setMetaStore((IMetaStore)this.spoon.getMetaStore());
                this.trans.prepareExecution(args);
                this.trans.setRepository(this.spoon.rep);
                List<SpoonUiExtenderPluginInterface> relevantExtenders = SpoonUiExtenderPluginType.getInstance().getRelevantExtenders(TransDebugMetaWrapper.class, PREVIEW_TRANS);
                TransDebugMetaWrapper transDebugMetaWrapper = new TransDebugMetaWrapper(this.trans, transDebugMeta);
                for (SpoonUiExtenderPluginInterface relevantExtender : relevantExtenders) {
                    relevantExtender.uiEvent(transDebugMetaWrapper, PREVIEW_TRANS);
                }
                transDebugMeta.addRowListenersToTransformation(this.trans);
                transDebugMeta.addBreakPointListers(new BreakPointListener(){

                    public void breakPointHit(TransDebugMeta transDebugMeta, StepDebugMeta stepDebugMeta, RowMetaInterface rowBufferMeta, List<Object[]> rowBuffer) {
                        TransGraph.this.showPreview(transDebugMeta, stepDebugMeta, rowBufferMeta, rowBuffer);
                    }
                });
                if (this.transPreviewDelegate.isActive()) {
                    this.transPreviewDelegate.capturePreviewData(this.trans, this.transMeta.getSteps());
                }
                this.startThreads();
                this.debug = true;
                this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TransGraph.this.addAllTabs();
                    }
                });
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransLog.Dialog.UnexpectedErrorDuringPreview.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLog.Dialog.UnexpectedErrorDuringPreview.Message", (String[])new String[0]), e);
            }
        } else {
            this.modalMessageDialog(this.getString("TransLog.Dialog.DoNoPreviewWhileRunning.Title"), this.getString("TransLog.Dialog.DoNoPreviewWhileRunning.Message"), 40);
        }
        this.checkErrorVisuals();
    }

    public synchronized void showPreview(TransDebugMeta transDebugMeta, final StepDebugMeta stepDebugMeta, final RowMetaInterface rowBufferMeta, final List<Object[]> rowBuffer) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TransGraph.this.isDisposed()) {
                    return;
                }
                TransGraph.this.spoon.enableMenus();
                TransGraph.this.pausing = true;
                TransGraph.this.setControlStates();
                TransGraph.this.checkErrorVisuals();
                PreviewRowsDialog previewRowsDialog = new PreviewRowsDialog(TransGraph.this.shell, (VariableSpace)TransGraph.this.transMeta, 268504176, stepDebugMeta.getStepMeta().getName(), rowBufferMeta, rowBuffer);
                previewRowsDialog.setProposingToGetMoreRows(true);
                previewRowsDialog.setProposingToStop(true);
                previewRowsDialog.open();
                if (previewRowsDialog.isAskingForMoreRows()) {
                    rowBuffer.clear();
                    TransGraph.this.pauseResume();
                }
                if (previewRowsDialog.isAskingToStop()) {
                    TransGraph.this.stop();
                }
            }
        });
    }

    private String[] convertArguments(Map<String, String> arguments) {
        Object[] argumentNames = arguments.keySet().toArray(new String[arguments.size()]);
        Arrays.sort(argumentNames);
        String[] args = new String[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            Object argumentName = argumentNames[i];
            args[i] = arguments.get(argumentName);
        }
        return args;
    }

    public void stop() {
        if (this.safeStopping) {
            this.modalMessageDialog(this.getString("TransLog.Log.SafeStopAlreadyStarted.Title"), this.getString("TransLog.Log.SafeStopAlreadyStarted"), 33);
            return;
        }
        if (this.running && !this.halting) {
            this.halting = true;
            this.trans.stopAll();
            this.log.logMinimal(BaseMessages.getString(PKG, (String)"TransLog.Log.ProcessingOfTransformationStopped", (String[])new String[0]));
            this.running = false;
            this.initialized = false;
            this.halted = false;
            this.halting = false;
            this.setControlStates();
            this.transMeta.setInternalKettleVariables();
        }
    }

    public void safeStop() {
        if (this.running && !this.halting) {
            this.halting = true;
            this.safeStopping = true;
            this.trans.safeStop();
            this.log.logMinimal(BaseMessages.getString(PKG, (String)"TransLog.Log.TransformationSafeStopped", (String[])new String[0]));
            this.initialized = false;
            this.halted = false;
            this.setControlStates();
            this.transMeta.setInternalKettleVariables();
        }
    }

    public synchronized void pauseResume() {
        if (this.running) {
            if (!this.pausing) {
                this.pausing = true;
                this.trans.pauseRunning();
                this.setControlStates();
            } else {
                this.pausing = false;
                this.trans.resumeRunning();
                this.setControlStates();
            }
        }
    }

    private boolean controlDisposed(XulToolbarbutton button) {
        if (button.getManagedObject() instanceof Widget) {
            Widget widget = (Widget)button.getManagedObject();
            return widget.isDisposed();
        }
        return false;
    }

    @Override
    public synchronized void setControlStates() {
        if (this.isDisposed() || this.getDisplay().isDisposed()) {
            return;
        }
        if (((Control)this.toolbar.getManagedObject()).isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                XulToolbarbutton previewButton;
                XulToolbarbutton debugButton;
                XulToolbarbutton pauseButton;
                boolean operationsNotAllowed = false;
                try {
                    operationsNotAllowed = RepositorySecurityUI.verifyOperations(TransGraph.this.shell, ((TransGraph)TransGraph.this).spoon.rep, false, RepositoryOperation.EXECUTE_TRANSFORMATION);
                }
                catch (KettleRepositoryLostException krle) {
                    TransGraph.this.log.logError(krle.getLocalizedMessage());
                    TransGraph.this.spoon.handleRepositoryLost(krle);
                }
                XulToolbarbutton runButton = (XulToolbarbutton)TransGraph.this.toolbar.getElementById("trans-run");
                if (runButton != null && !TransGraph.this.controlDisposed(runButton) && !operationsNotAllowed && runButton.isDisabled() ^ TransGraph.this.running) {
                    runButton.setDisabled(TransGraph.this.running);
                }
                if ((pauseButton = (XulToolbarbutton)TransGraph.this.toolbar.getElementById("trans-pause")) != null && !TransGraph.this.controlDisposed(pauseButton) && pauseButton.isDisabled() ^ !TransGraph.this.running) {
                    pauseButton.setDisabled(!TransGraph.this.running);
                    pauseButton.setLabel(TransGraph.this.pausing ? RESUME_TEXT : PAUSE_TEXT);
                    pauseButton.setTooltiptext(TransGraph.this.pausing ? BaseMessages.getString((Class)PKG, (String)"Spoon.Tooltip.ResumeTranformation", (String[])new String[0]) : BaseMessages.getString((Class)PKG, (String)"Spoon.Tooltip.PauseTranformation", (String[])new String[0]));
                }
                if (!TransGraph.this.stopItem.isDisposed() && !TransGraph.this.stopItem.isEnabled() ^ !TransGraph.this.running) {
                    TransGraph.this.stopItem.setEnabled(TransGraph.this.running);
                }
                if ((debugButton = (XulToolbarbutton)TransGraph.this.toolbar.getElementById("trans-debug")) != null && !TransGraph.this.controlDisposed(debugButton) && !operationsNotAllowed && debugButton.isDisabled() ^ TransGraph.this.running) {
                    debugButton.setDisabled(TransGraph.this.running);
                }
                if ((previewButton = (XulToolbarbutton)TransGraph.this.toolbar.getElementById("trans-preview")) != null && !TransGraph.this.controlDisposed(previewButton) && !operationsNotAllowed && previewButton.isDisabled() ^ TransGraph.this.running) {
                    previewButton.setDisabled(TransGraph.this.running);
                }
            }
        });
    }

    private synchronized void prepareTrans(Thread parentThread, final String[] args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TransGraph.this.trans.prepareExecution(args);
                    if (TransGraph.this.transPreviewDelegate.isActive()) {
                        TransGraph.this.transPreviewDelegate.capturePreviewData(TransGraph.this.trans, TransGraph.this.transMeta.getSteps());
                    }
                    TransGraph.this.initialized = true;
                }
                catch (KettleException e) {
                    TransGraph.this.log.logError(TransGraph.this.trans.getName() + ": preparing transformation execution failed", (Throwable)e);
                    TransGraph.this.checkErrorVisuals();
                }
                TransGraph.this.halted = TransGraph.this.trans.hasHaltedSteps();
                if (TransGraph.this.trans.isReadyToStart()) {
                    TransGraph.this.checkStartThreads();
                } else {
                    TransGraph.this.initialized = false;
                    TransGraph.this.running = false;
                    TransGraph.this.checkErrorVisuals();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void checkStartThreads() {
        if (this.initialized && !this.running && this.trans != null) {
            this.startThreads();
        }
    }

    private synchronized void startThreads() {
        this.running = true;
        try {
            this.trans.addTransListener((TransListener)new TransAdapter(){

                public void transFinished(Trans trans) {
                    TransGraph.this.checkTransEnded();
                    TransGraph.this.checkErrorVisuals();
                    TransGraph.this.stopRedrawTimer();
                    TransGraph.this.transMetricsDelegate.resetLastRefreshTime();
                    TransGraph.this.transMetricsDelegate.updateGraph();
                }
            });
            this.trans.startThreads();
            this.startRedrawTimer();
            this.setControlStates();
        }
        catch (KettleException e) {
            this.log.logError("Error starting step threads", (Throwable)e);
            this.checkErrorVisuals();
            this.stopRedrawTimer();
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TransGraph.this.transPerfDelegate.getTransPerfTab() != null) {
                    TransGraph.this.transPerfDelegate.setupContent();
                    TransGraph.this.transPerfDelegate.layoutPerfComposite();
                }
            }
        });
    }

    private void startRedrawTimer() {
        this.redrawTimer = new Timer("TransGraph: redraw timer");
        TimerTask timtask = new TimerTask(){

            @Override
            public void run() {
                if (!TransGraph.this.spoon.getDisplay().isDisposed()) {
                    TransGraph.this.spoon.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TransGraph.this.canvas.isDisposed()) {
                                TransGraph.this.canvas.redraw();
                            }
                        }
                    });
                }
            }
        };
        this.redrawTimer.schedule(timtask, 0L, 1000L);
    }

    protected void stopRedrawTimer() {
        if (this.redrawTimer != null) {
            this.redrawTimer.cancel();
            this.redrawTimer.purge();
            this.redrawTimer = null;
        }
    }

    private void checkTransEnded() {
        if (this.trans != null && this.trans.isFinished() && (this.running || this.halted)) {
            this.log.logMinimal(BaseMessages.getString(PKG, (String)"TransLog.Log.TransformationHasFinished", (String[])new String[0]));
            this.running = false;
            this.initialized = false;
            this.halted = false;
            this.halting = false;
            this.safeStopping = false;
            this.setControlStates();
            if (this.debug && this.lastTransDebugMeta != null && this.lastTransDebugMeta.getTotalNumberOfHits() == 0) {
                this.debug = false;
                this.showLastPreviewResults();
            }
            this.debug = false;
            this.checkErrorVisuals();
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransGraph.this.spoon.fireMenuControlers();
                    TransGraph.this.redraw();
                }
            });
        }
    }

    private void checkErrorVisuals() {
        if (this.trans.getErrors() > 0) {
            this.stepLogMap = new HashMap<StepMeta, String>();
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    for (StepMetaDataCombi combi : TransGraph.this.trans.getSteps()) {
                        if (combi.step.getErrors() <= 0L) continue;
                        String channelId = combi.step.getLogChannel().getLogChannelId();
                        List eventList = KettleLogStore.getLogBufferFromTo((String)channelId, (boolean)false, (int)0, (int)KettleLogStore.getLastBufferLineNr());
                        StringBuilder logText = new StringBuilder();
                        for (KettleLoggingEvent event : eventList) {
                            LogMessage logMessage;
                            Object message = event.getMessage();
                            if (!(message instanceof LogMessage) || !(logMessage = (LogMessage)message).isError()) continue;
                            logText.append(logMessage.getMessage()).append(Const.CR);
                        }
                        TransGraph.this.stepLogMap.put(combi.stepMeta, logText.toString());
                    }
                }
            });
        } else {
            this.stepLogMap = null;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TransGraph.this.redraw();
            }
        });
    }

    public synchronized void showLastPreviewResults() {
        if (this.lastTransDebugMeta == null || this.lastTransDebugMeta.getStepDebugMetaMap().isEmpty()) {
            return;
        }
        final ArrayList<String> stepnames = new ArrayList<String>();
        final ArrayList<RowMetaInterface> rowMetas = new ArrayList<RowMetaInterface>();
        final ArrayList<List> rowBuffers = new ArrayList<List>();
        for (StepMeta stepMeta : this.lastTransDebugMeta.getStepDebugMetaMap().keySet()) {
            StepDebugMeta stepDebugMeta = (StepDebugMeta)this.lastTransDebugMeta.getStepDebugMetaMap().get(stepMeta);
            stepnames.add(stepMeta.getName());
            rowMetas.add(stepDebugMeta.getRowBufferMeta());
            rowBuffers.add(stepDebugMeta.getRowBuffer());
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EnterPreviewRowsDialog dialog = new EnterPreviewRowsDialog(TransGraph.this.shell, 0, stepnames, rowMetas, rowBuffers);
                dialog.open();
            }
        });
    }

    public void openMapping() {
    }

    public void openMapping(StepMeta stepMeta, int index) {
        try {
            Object referencedMeta = null;
            Trans subTrans = this.getActiveSubtransformation(this, stepMeta);
            if (subTrans != null && (stepMeta.getStepMetaInterface().getActiveReferencedObjectDescription() == null || index < 0)) {
                TransMeta subTransMeta;
                referencedMeta = subTransMeta = subTrans.getTransMeta();
                Object[] objectArray = new Object[4];
                objectArray[0] = stepMeta;
                objectArray[1] = subTransMeta;
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.OpenMapping.id, (Object)objectArray);
            } else {
                StepMetaInterface meta = stepMeta.getStepMetaInterface();
                if (!Utils.isEmpty((CharSequence[])meta.getReferencedObjectDescriptions())) {
                    referencedMeta = meta.loadReferencedObject(index, this.spoon.rep, (IMetaStore)this.spoon.metaStore, (VariableSpace)this.transMeta);
                }
            }
            if (referencedMeta == null) {
                return;
            }
            if (referencedMeta instanceof TransMeta) {
                TransMeta mappingMeta = referencedMeta;
                mappingMeta.clearChanged();
                this.spoon.addTransGraph(mappingMeta);
                TransGraph subTransGraph = this.spoon.getActiveTransGraph();
                this.attachActiveTrans(subTransGraph, this.currentStep);
            }
            if (referencedMeta instanceof JobMeta) {
                JobMeta jobMeta = (JobMeta)referencedMeta;
                jobMeta.clearChanged();
                this.spoon.addJobGraph(jobMeta);
                JobGraph jobGraph = this.spoon.getActiveJobGraph();
                this.attachActiveJob(jobGraph, this.currentStep);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Exception.UnableToLoadMapping.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.Exception.UnableToLoadMapping.Message", (String[])new String[0]), e);
        }
    }

    private void attachActiveTrans(TransGraph transGraph, StepMeta stepMeta) {
        if (this.trans != null && transGraph != null) {
            Trans subTransformation = this.trans.getActiveSubTransformation(stepMeta.getName());
            transGraph.setTrans(subTransformation);
            if (!transGraph.isExecutionResultsPaneVisible()) {
                transGraph.showExecutionResults();
            }
            transGraph.setControlStates();
        }
    }

    private Trans getActiveSubtransformation(TransGraph transGraph, StepMeta stepMeta) {
        if (this.trans != null && transGraph != null) {
            return this.trans.getActiveSubTransformation(stepMeta.getName());
        }
        return null;
    }

    private void attachActiveJob(JobGraph jobGraph, StepMeta stepMeta) {
        if (this.trans != null && jobGraph != null) {
            Job subJob = (Job)this.trans.getActiveSubjobs().get(stepMeta.getName());
            jobGraph.setJob(subJob);
            if (!jobGraph.isExecutionResultsPaneVisible()) {
                jobGraph.showExecutionResults();
            }
            jobGraph.setControlStates();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public TransDebugMeta getLastTransDebugMeta() {
        return this.lastTransDebugMeta;
    }

    public boolean isHalting() {
        return this.halting;
    }

    public void setHalting(boolean halting) {
        this.halting = halting;
    }

    public Map<StepMeta, String> getStepLogMap() {
        return this.stepLogMap;
    }

    public void setStepLogMap(Map<StepMeta, String> stepLogMap) {
        this.stepLogMap = stepLogMap;
    }

    public void dumpLoggingRegistry() {
        LoggingRegistry registry = LoggingRegistry.getInstance();
        Map loggingMap = registry.getMap();
        for (LoggingObjectInterface loggingObject : loggingMap.values()) {
            System.out.println(loggingObject.getLogChannelId() + " - " + loggingObject.getObjectName() + " - " + loggingObject.getObjectType());
        }
    }

    public HasLogChannelInterface getLogChannelProvider() {
        return new HasLogChannelInterface(){

            public LogChannelInterface getLogChannel() {
                return TransGraph.this.getTrans() != null ? TransGraph.this.getTrans().getLogChannel() : TransGraph.this.getTransMeta().getLogChannel();
            }
        };
    }

    public synchronized void setTrans(Trans trans) {
        this.trans = trans;
        if (trans != null) {
            this.pausing = trans.isPaused();
            this.initialized = trans.isInitializing();
            this.running = trans.isRunning();
            this.halted = trans.isStopped();
            if (this.running) {
                trans.addTransListener((TransListener)new TransAdapter(){

                    public void transFinished(Trans trans) {
                        TransGraph.this.checkTransEnded();
                        TransGraph.this.checkErrorVisuals();
                    }
                });
            }
        }
    }

    public void sniffInput() {
        this.sniff(true, false, false);
    }

    public void sniffOutput() {
        this.sniff(false, true, false);
    }

    public void sniffError() {
        this.sniff(false, false, true);
    }

    public void sniff(final boolean input, final boolean output, final boolean error) {
        StepMeta stepMeta = this.getCurrentStep();
        if (stepMeta == null || this.trans == null) {
            return;
        }
        final StepInterface runThread = this.trans.findRunThread(stepMeta.getName());
        if (runThread != null) {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            final PreviewRowsDialog dialog = new PreviewRowsDialog(this.shell, (VariableSpace)this.trans, 0, stepMeta.getName(), null, rows);
            dialog.setDynamic(true);
            final RowListener rowListener = new RowListener(){

                public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    if (input) {
                        try {
                            dialog.addDataRow(rowMeta, rowMeta.cloneRow(row));
                        }
                        catch (KettleValueException e) {
                            throw new KettleStepException((Throwable)e);
                        }
                    }
                }

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    if (output) {
                        try {
                            dialog.addDataRow(rowMeta, rowMeta.cloneRow(row));
                        }
                        catch (KettleValueException e) {
                            throw new KettleStepException((Throwable)e);
                        }
                    }
                }

                public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    if (error) {
                        try {
                            dialog.addDataRow(rowMeta, rowMeta.cloneRow(row));
                        }
                        catch (KettleValueException e) {
                            throw new KettleStepException((Throwable)e);
                        }
                    }
                }
            };
            dialog.addDialogClosedListener(new DialogClosedListener(){

                @Override
                public void dialogClosed() {
                    runThread.removeRowListener(rowListener);
                }
            });
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
            runThread.addRowListener(rowListener);
        }
    }

    public String getName() {
        return "transgraph";
    }

    public XulDomContainer getXulDomContainer() {
        return this.xulDomContainer;
    }

    public void setName(String arg0) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        this.xulDomContainer = xulDomContainer;
    }

    @Override
    public boolean canHandleSave() {
        return true;
    }

    @Override
    public int showChangedWarning() throws KettleException {
        return this.showChangedWarning(this.transMeta.getName());
    }

    public void autoLayout() {
        HashMap<StepMeta, StepVelocity> speeds = new HashMap<StepMeta, StepVelocity>();
        HashMap<StepMeta, StepLocation> locations = new HashMap<StepMeta, StepLocation>();
        for (StepMeta stepMeta : this.transMeta.getSteps()) {
            speeds.put(stepMeta, new StepVelocity(0.0, 0.0));
            StepLocation location = new StepLocation(stepMeta.getLocation().x, stepMeta.getLocation().y);
            locations.put(stepMeta, location);
        }
        StepLocation center = this.calculateCenter(locations);
        double totalKineticEngergy = 0.0;
        do {
            StepLocation location;
            totalKineticEngergy = 0.0;
            for (StepMeta stepMeta : this.transMeta.getSteps()) {
                Force netForce = new Force(0.0, 0.0);
                StepVelocity velocity = (StepVelocity)speeds.get(stepMeta);
                location = (StepLocation)locations.get(stepMeta);
                for (StepMeta otherStep : this.transMeta.getSteps()) {
                    if (stepMeta.equals((Object)otherStep)) continue;
                    netForce.add(this.getCoulombRepulsion(stepMeta, otherStep, locations));
                }
                for (int i = 0; i < this.transMeta.nrTransHops(); ++i) {
                    TransHopMeta hopMeta = this.transMeta.getTransHop(i);
                    if (!hopMeta.getFromStep().equals((Object)stepMeta) && !hopMeta.getToStep().equals((Object)stepMeta)) continue;
                    netForce.add(this.getHookeAttraction(hopMeta, locations));
                }
                this.adjustVelocity(velocity, netForce);
                this.adjustLocation(location, velocity);
                totalKineticEngergy += nodeMass * (velocity.dx * velocity.dx + velocity.dy * velocity.dy);
            }
            StepLocation newCenter = this.calculateCenter(locations);
            StepLocation diff = new StepLocation(center.x - newCenter.x, center.y - newCenter.y);
            for (StepMeta stepMeta : this.transMeta.getSteps()) {
                location = (StepLocation)locations.get(stepMeta);
                location.x += diff.x;
                location.y += diff.y;
                stepMeta.setLocation((int)Math.round(location.x), (int)Math.round(location.y));
            }
            this.redraw();
        } while (totalKineticEngergy < 0.01);
    }

    private StepLocation calculateCenter(Map<StepMeta, StepLocation> locations) {
        StepLocation center = new StepLocation(0.0, 0.0);
        for (StepLocation location : locations.values()) {
            center.add(location);
        }
        center.x /= (double)locations.size();
        center.y /= (double)locations.size();
        return center;
    }

    private Force getCoulombRepulsion(StepMeta step1, StepMeta step2, Map<StepMeta, StepLocation> locations) {
        double q1 = 4.0;
        double q2 = 4.0;
        double Ke = -3.0;
        StepLocation loc1 = locations.get(step1);
        StepLocation loc2 = locations.get(step2);
        double fx = Ke * q1 * q2 / Math.abs(loc1.x - loc2.x);
        double fy = Ke * q1 * q2 / Math.abs(loc1.y - loc2.y);
        return new Force(fx, fy);
    }

    private Force getHookeAttraction(TransHopMeta hopMeta, Map<StepMeta, StepLocation> locations) {
        StepLocation loc1 = locations.get(hopMeta.getFromStep());
        StepLocation loc2 = locations.get(hopMeta.getToStep());
        double springConstant = 0.01;
        double fx = springConstant * Math.abs(loc1.x - loc2.x);
        double fy = springConstant * Math.abs(loc1.y - loc2.y);
        return new Force(fx * fx, fy * fy);
    }

    private void adjustVelocity(StepVelocity velocity, Force netForce) {
        velocity.dx = (velocity.dx + timeStep * netForce.fx) * dampningConstant;
        velocity.dy = (velocity.dy + timeStep * netForce.fy) * dampningConstant;
    }

    private void adjustLocation(StepLocation location, StepVelocity velocity) {
        location.x += nodeMass * velocity.dx * velocity.dx;
        location.y += nodeMass * velocity.dy * velocity.dy;
    }

    public void handleTransMetaChanges(TransMeta transMeta) throws KettleException {
        if (transMeta.hasChanged()) {
            if (this.spoon.props.getAutoSave()) {
                this.spoon.saveToFile((EngineMetaInterface)transMeta);
            } else {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"TransLog.Dialog.FileHasChanged.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"TransLog.Dialog.FileHasChanged1.Message", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"TransLog.Dialog.FileHasChanged2.Message", (String[])new String[0]) + Const.CR, 3, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"TransLog.Dialog.Option.AutoSaveTransformation", (String[])new String[0]), this.spoon.props.getAutoSave());
                MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                int answer = md.open();
                if ((answer & 0xFF) == 0) {
                    this.spoon.saveToFile((EngineMetaInterface)transMeta);
                }
                this.spoon.props.setAutoSave(md.getToggleState());
            }
        }
    }

    public void addStepToChain(PluginInterface stepPlugin, boolean shift) {
        List sel;
        TransMeta transMeta = this.spoon.getActiveTransformation();
        if (transMeta == null) {
            return;
        }
        if (this.lastChained != null && transMeta.findStep(this.lastChained.getName()) == null) {
            this.lastChained = null;
        }
        if ((sel = transMeta.getSelectedSteps()).size() == 1) {
            this.lastChained = (StepMeta)sel.get(0);
        }
        org.pentaho.di.core.gui.Point p = null;
        if (this.lastChained == null) {
            p = transMeta.getMaximum();
            p.x -= 100;
        } else {
            p = new org.pentaho.di.core.gui.Point(this.lastChained.getLocation().x, this.lastChained.getLocation().y);
        }
        p.x += 200;
        StepMeta newStep = this.spoon.newStep(transMeta, stepPlugin.getIds()[0], stepPlugin.getName(), stepPlugin.getName(), false, true);
        if (newStep == null) {
            return;
        }
        newStep.setLocation(p.x, p.y);
        newStep.setDraw(true);
        if (this.lastChained != null) {
            TransHopMeta hop = new TransHopMeta(this.lastChained, newStep);
            this.spoon.newHop(transMeta, hop);
        }
        this.lastChained = newStep;
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
        if (shift) {
            this.editStep(newStep);
        }
        transMeta.unselectAll();
        newStep.setSelected(true);
    }

    public Spoon getSpoon() {
        return this.spoon;
    }

    public void setSpoon(Spoon spoon) {
        this.spoon = spoon;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public Trans getTrans() {
        return this.trans;
    }

    private Trans createLegacyTrans() {
        try {
            return new Trans((VariableSpace)this.transMeta, this.spoon.rep, this.transMeta.getName(), this.transMeta.getRepositoryDirectory().getPath(), this.transMeta.getFilename());
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    private void setHopEnabled(TransHopMeta hop, boolean enabled) {
        hop.setEnabled(enabled);
        this.transMeta.clearCaches();
    }

    private void modalMessageDialog(String title, String message, int swtFlags) {
        MessageBox messageBox = new MessageBox(this.shell, swtFlags);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    private String getString(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    private String getString(String key, String ... params) {
        return BaseMessages.getString(PKG, (String)key, (String[])params);
    }

    private class Force {
        public double fx;
        public double fy;

        public Force(double fx, double fy) {
            this.fx = fx;
            this.fy = fy;
        }

        public void add(Force force) {
            this.fx += force.fx;
            this.fy += force.fy;
        }
    }

    private class StepLocation {
        public double x;
        public double y;

        public StepLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void add(StepLocation loc) {
            this.x += loc.x;
            this.y += loc.y;
        }
    }

    private class StepVelocity {
        public double dx;
        public double dy;

        public StepVelocity(double dx, double dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }
}

