/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.UriParser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.VfsFileChooserDialog;
import org.pentaho.vfs.util.VFSScheme;

public class VfsFileChooserControls
extends Composite {
    private static final Class<?> PKG = VfsFileChooserControls.class;
    protected static final String[] FILES_FILTERS = new String[]{"*.*"};
    protected static final String[] fileFilterNames = new String[]{BaseMessages.getString((String)"System.FileType.AllFiles")};
    private static final String DEFAULT_LOCAL_PATH = "file:///C:/";
    private static final String HDFS_SCHEME = "hdfs";
    public static final int MARGIN = 15;
    public static final int FIELDS_SEP = 10;
    public static final int FIELD_LABEL_SEP = 5;
    public static final int FIELD_SMALL = 150;
    public static final int FIELD_LARGE = 350;
    protected static final int VAR_EXTRA_WIDTH = GUIResource.getInstance().getImageVariable().getBounds().width;
    public TextVar wPath;
    public VariableSpace space;
    protected VFSScheme selectedVFSScheme;
    public CCombo wLocation;
    protected LogChannel log;
    public Button wbBrowse;
    private ModifyListener lsMod;

    public VfsFileChooserControls(VariableSpace space, Composite composite, int i, ModifyListener lsMod) {
        super(composite, i);
        this.space = space;
        this.lsMod = lsMod;
        FormLayout noMarginLayout = new FormLayout();
        noMarginLayout.marginWidth = 0;
        noMarginLayout.marginHeight = 0;
        noMarginLayout.marginTop = 0;
        noMarginLayout.marginBottom = 0;
        this.setLayout((Layout)noMarginLayout);
        this.addFileWidgets();
    }

    protected FileObject getInitialFile(String filePath) throws KettleFileException {
        String fileName;
        FileObject initialFile = null;
        if (filePath != null && !filePath.isEmpty() && (fileName = this.space.environmentSubstitute(filePath)) != null && !fileName.isEmpty()) {
            initialFile = KettleVFS.getFileObject((String)fileName);
        }
        if (initialFile == null) {
            initialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
        }
        return initialFile;
    }

    protected void addFileWidgets() {
        Label wlLocation = new Label((Composite)this, 131072);
        wlLocation.setText(BaseMessages.getString(PKG, (String)"VfsFileChooserControls.Location.Label", (String[])new String[0]));
        wlLocation.setLayoutData((Object)new FormDataBuilder().left(0, 0).top(0, 0).result());
        this.wLocation = new CCombo((Composite)this, 2056);
        List<VFSScheme> availableVFSSchemes = this.getAvailableVFSSchemes();
        availableVFSSchemes.forEach(scheme -> this.wLocation.add(scheme.schemeName));
        this.wLocation.addListener(13, event -> {
            this.selectedVFSScheme = (VFSScheme)availableVFSSchemes.get(this.wLocation.getSelectionIndex());
            this.wPath.setText("");
        });
        if (!availableVFSSchemes.isEmpty()) {
            this.wLocation.select(0);
            this.selectedVFSScheme = availableVFSSchemes.get(this.wLocation.getSelectionIndex());
        }
        this.wLocation.addModifyListener(this.lsMod);
        this.wLocation.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)wlLocation, 5).width(150).result());
        Label wlPath = new Label((Composite)this, 131072);
        wlPath.setText(BaseMessages.getString(PKG, (String)"VfsFileChooserControls.Filename.Label", (String[])new String[0]));
        wlPath.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)this.wLocation, 10).result());
        this.wPath = new TextVar(this.space, this, 18436);
        this.wPath.addModifyListener(this.lsMod);
        this.wPath.setLayoutData(new FormDataBuilder().left(0, 0).top((Control)wlPath, 5).width(350 + VAR_EXTRA_WIDTH).result());
        this.wbBrowse = new Button((Composite)this, 8);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbBrowse.addListener(13, event -> this.browseForFileInputPath());
        int bOffset = (this.wbBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        this.wbBrowse.setLayoutData((Object)new FormDataBuilder().left((Control)this.wPath, 5).top((Control)wlPath, 5 - bOffset).result());
    }

    protected void browseForFileInputPath() {
        try {
            String filePath;
            String fileName;
            VfsFileChooserDialog fileChooserDialog;
            String path = this.space.environmentSubstitute(this.wPath.getText());
            if (path == null || path.length() == 0) {
                fileChooserDialog = this.getVfsFileChooserDialog(null, null);
                fileName = this.selectedVFSScheme.scheme + "://";
            } else {
                FileObject initialFile = this.getInitialFile(this.wPath.getText());
                FileObject rootFile = initialFile.getFileSystem().getRoot();
                fileChooserDialog = this.getVfsFileChooserDialog(rootFile, initialFile);
                fileName = null;
            }
            FileObject selectedFile = fileChooserDialog.open(this.getParent().getShell(), null, this.selectedVFSScheme.scheme, true, fileName, FILES_FILTERS, fileFilterNames, true, 2, true, true);
            if (selectedFile != null && !DEFAULT_LOCAL_PATH.equals(filePath = selectedFile.getURL().toString())) {
                this.wPath.setText(filePath);
                this.updateLocation();
            }
        }
        catch (FileSystemException | KettleFileException ex) {
            this.log.logError(ex.getMessage());
        }
    }

    protected List<VFSScheme> getAvailableVFSSchemes() {
        VfsFileChooserDialog fileChooserDialog = this.getVfsFileChooserDialog(null, null);
        List customVfsUiPanels = fileChooserDialog.getCustomVfsUiPanels();
        ArrayList<VFSScheme> vfsSchemes = new ArrayList<VFSScheme>();
        customVfsUiPanels.forEach(vfsPanel -> {
            VFSScheme scheme = new VFSScheme(vfsPanel.getVfsScheme(), vfsPanel.getVfsSchemeDisplayText());
            vfsSchemes.add(scheme);
        });
        return vfsSchemes;
    }

    private void updateLocation() {
        String scheme;
        String pathText = this.wPath.getText();
        String string = scheme = pathText.isEmpty() ? HDFS_SCHEME : UriParser.extractScheme((String)pathText);
        if (scheme != null) {
            List<VFSScheme> availableVFSSchemes = this.getAvailableVFSSchemes();
            for (int i = 0; i < availableVFSSchemes.size(); ++i) {
                VFSScheme s = availableVFSSchemes.get(i);
                if (!scheme.equals(s.scheme)) continue;
                this.wLocation.select(i);
                this.selectedVFSScheme = s;
            }
        }
    }

    protected VfsFileChooserDialog getVfsFileChooserDialog(FileObject rootFile, FileObject initialFile) {
        return this.getSpoon().getVfsFileChooserDialog(rootFile, initialFile);
    }

    private Spoon getSpoon() {
        return Spoon.getInstance();
    }
}

