/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EditRowsDialog {
    private static Class<?> PKG = EditRowsDialog.class;
    public static final int MAX_BINARY_STRING_PREVIEW_SIZE = 1000000;
    private Label wlMessage;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wOK;
    private Button wCancel;
    private Shell shell;
    private List<Object[]> rowBuffer;
    private PropsUI props;
    private String title;
    private String message;
    private Rectangle bounds;
    private int hscroll;
    private int vscroll;
    private int hmax;
    private int vmax;
    private RowMetaInterface rowMeta;
    private LogChannelInterface log;
    protected int lineNr;
    private int style = 3312;
    private Shell parentShell;
    private List<Object[]> outputList;
    private RowMetaInterface stringRowMeta;

    public EditRowsDialog(Shell parent, int style, String title, String message, RowMetaInterface rowMeta, List<Object[]> rowBuffer) {
        this.title = title;
        this.message = message;
        this.rowBuffer = rowBuffer;
        this.rowMeta = rowMeta;
        this.parentShell = parent;
        this.style = style != 0 ? style : this.style;
        this.props = PropsUI.getInstance();
        this.bounds = null;
        this.hscroll = -1;
        this.vscroll = -1;
        title = null;
        message = null;
        this.log = LogChannel.GENERAL;
    }

    public void setTitleMessage(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public List<Object[]> open() {
        this.shell = new Shell(this.parentShell, this.style);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EditRowsDialog.this.ok();
            }
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EditRowsDialog.this.cancel();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, 4, null);
        if (this.addFields()) {
            return null;
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EditRowsDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.outputList;
    }

    private boolean addFields() {
        int margin = 4;
        if (this.wlMessage == null) {
            this.wlMessage = new Label((Composite)this.shell, 16384);
            this.wlMessage.setText(this.message);
            this.props.setLook((Control)this.wlMessage);
            this.fdlFields = new FormData();
            this.fdlFields.left = new FormAttachment(0, 0);
            this.fdlFields.right = new FormAttachment(100, 0);
            this.fdlFields.top = new FormAttachment(0, margin);
            this.wlMessage.setLayoutData((Object)this.fdlFields);
        } else {
            this.wFields.dispose();
        }
        if (this.rowMeta == null || this.rowMeta.size() == 0) {
            ShowMessageDialog dialog = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"EditRowsDialog.NoRowMeta.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"EditRowsDialog.NoRowMeta.Message", (String[])new String[0]));
            dialog.open();
            this.shell.dispose();
            return true;
        }
        ColumnInfo[] colinf = new ColumnInfo[this.rowMeta.size()];
        for (int i = 0; i < this.rowMeta.size(); ++i) {
            ValueMetaInterface v = this.rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, v.isNumeric());
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setValueMeta(v);
        }
        this.wFields = new TableView((VariableSpace)new Variables(), (Composite)this.shell, 67586, colinf, this.rowBuffer.size(), null, this.props);
        this.wFields.setShowingBlueNullValues(true);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlMessage, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.shell.layout(true, true);
        return false;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.bounds = this.shell.getBounds();
        this.hscroll = this.wFields.getHorizontalBar().getSelection();
        this.vscroll = this.wFields.getVerticalBar().getSelection();
        this.shell.dispose();
    }

    private void getData() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditRowsDialog.this.lineNr = 0;
                for (int i = 0; i < EditRowsDialog.this.rowBuffer.size(); ++i) {
                    TableItem item = ((EditRowsDialog)EditRowsDialog.this).wFields.table.getItem(i);
                    Object[] row = (Object[])EditRowsDialog.this.rowBuffer.get(i);
                    EditRowsDialog.this.getDataForRow(item, row);
                }
                EditRowsDialog.this.wFields.optWidth(true, 200);
            }
        });
    }

    protected int getDataForRow(TableItem item, Object[] row) {
        String strNr;
        int nrErrors = 0;
        ++this.lineNr;
        try {
            strNr = this.wFields.getNumberColumn().getValueMeta().getString((Object)new Long(this.lineNr));
        }
        catch (Exception e) {
            strNr = Integer.toString(this.lineNr);
        }
        item.setText(0, strNr);
        for (int c = 0; c < this.rowMeta.size(); ++c) {
            String show;
            ValueMetaInterface v = this.rowMeta.getValueMeta(c);
            try {
                show = v.getString(row[c]);
                if (v.isBinary() && show != null && show.length() > 1000000) {
                    show = show.substring(0, 1000000);
                }
            }
            catch (KettleValueException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            if (show != null) {
                item.setText(c + 1, show);
                item.setForeground(c + 1, GUIResource.getInstance().getColorBlack());
                continue;
            }
            item.setText(c + 1, "<null>");
            item.setForeground(c + 1, GUIResource.getInstance().getColorBlue());
        }
        return nrErrors;
    }

    @VisibleForTesting
    Object[] getRowForData(TableItem item, int rowNr) throws KettleException {
        try {
            Object[] row = RowDataUtil.allocateRowData((int)this.rowMeta.size());
            for (int i = 0; i < this.rowMeta.size(); ++i) {
                ValueMetaInterface valueMeta = this.rowMeta.getValueMeta(i);
                ValueMetaInterface stringValueMeta = this.stringRowMeta.getValueMeta(i);
                int colnr = i + 1;
                if (this.isDisplayingNullValue(item, colnr)) {
                    row[i] = null;
                    continue;
                }
                String string = item.getText(colnr);
                if (stringValueMeta.isNull((Object)string)) {
                    string = null;
                }
                row[i] = valueMeta.convertDataFromString(string, stringValueMeta, null, null, 0);
            }
            return row;
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"EditRowsDialog.Error.ErrorGettingRowForData", (String[])new String[]{Integer.toString(rowNr)}), (Throwable)e);
        }
    }

    @VisibleForTesting
    boolean isDisplayingNullValue(TableItem item, int column) throws KettleException {
        return GUIResource.getInstance().getColorBlue().equals((Object)item.getForeground(column));
    }

    private void ok() {
        try {
            this.stringRowMeta = new RowMeta();
            for (ValueMetaInterface valueMeta : this.rowMeta.getValueMetaList()) {
                ValueMetaInterface stringValueMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2);
                this.stringRowMeta.addValueMeta(stringValueMeta);
            }
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (int i = 0; i < this.wFields.getItemCount(); ++i) {
                TableItem item = this.wFields.getTable().getItem(i);
                Object[] row = this.getRowForData(item, i + 1);
                list.add(row);
            }
            this.outputList = list;
            this.dispose();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", BaseMessages.getString(PKG, (String)"EditRowsDialog.ErrorConvertingData", (String[])new String[0]), e);
        }
    }

    private void cancel() {
        this.outputList = null;
        this.dispose();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle b) {
        this.bounds = b;
    }

    public int getHScroll() {
        return this.hscroll;
    }

    public void setHScroll(int s) {
        this.hscroll = s;
    }

    public int getVScroll() {
        return this.vscroll;
    }

    public void setVScroll(int s) {
        this.vscroll = s;
    }

    public int getHMax() {
        return this.hmax;
    }

    public void setHMax(int m) {
        this.hmax = m;
    }

    public int getVMax() {
        return this.vmax;
    }

    public void setVMax(int m) {
        this.vmax = m;
    }

    @VisibleForTesting
    void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    @VisibleForTesting
    void setStringRowMeta(RowMetaInterface stringRowMeta) {
        this.stringRowMeta = stringRowMeta;
    }
}

