/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class SlotFuture<V>
implements Future<V> {
    private V value;
    private Throwable throwable;
    private boolean done;
    private boolean cancelled;
    private final CountDownLatch dataGate = new CountDownLatch(1);
    private final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
    private static final Logger LOG = Logger.getLogger(SlotFuture.class);
    private final String thisString = super.toString();

    public String toString() {
        return this.thisString;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.stateLock.writeLock().lock();
        try {
            if (!this.done) {
                this.cancelled = true;
                this.done = true;
                this.dataGate.countDown();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        this.stateLock.readLock().lock();
        try {
            boolean bl = this.cancelled;
            return bl;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Override
    public boolean isDone() {
        this.stateLock.readLock().lock();
        try {
            boolean bl = this.done || this.cancelled || this.throwable != null;
            return bl;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Override
    public V get() throws ExecutionException, InterruptedException {
        this.dataGate.await();
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (!this.dataGate.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.value;
    }

    public void put(V value) {
        this.stateLock.writeLock().lock();
        try {
            if (this.done) {
                String message = "Future is already done (cancelled=" + this.cancelled + ", value=" + this.value + ", throwable=" + this.throwable + ")";
                LOG.error((Object)message);
                throw new IllegalArgumentException(message);
            }
            this.value = value;
            this.done = true;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
        this.dataGate.countDown();
    }

    public void fail(Throwable throwable) {
        this.stateLock.writeLock().lock();
        try {
            if (this.done) {
                throw new IllegalArgumentException("Future is already done (cancelled=" + this.cancelled + ", value=" + this.value + ", throwable=" + this.throwable + ")");
            }
            this.throwable = throwable;
            this.done = true;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
        this.dataGate.countDown();
    }
}

