/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.format;

import mondrian.olap.MondrianDef;
import mondrian.olap.Util;

public class FormatterCreateContext {
    private String formatterClassName;
    private String scriptText;
    private String scriptLanguage;
    private String elementName;

    private FormatterCreateContext(Builder builder) {
        this.formatterClassName = builder.formatterClassName;
        this.scriptText = builder.scriptText;
        this.scriptLanguage = builder.scriptLanguage;
        this.elementName = builder.elementName;
    }

    public String getFormatterClassName() {
        return this.formatterClassName;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getElementName() {
        return this.elementName;
    }

    public static class Builder {
        private String formatterClassName;
        private String scriptText;
        private String scriptLanguage;
        private String elementName;
        private boolean formatterAsElement;

        public Builder(String elementName) {
            this.elementName = elementName;
        }

        public Builder formatterDef(MondrianDef.ElementFormatter formatterDef) {
            if (formatterDef != null) {
                Builder.checkIfFormatterSpecifiedCorrectly(formatterDef.className, formatterDef.script);
                this.formatterAsElement = true;
                this.formatterClassName = formatterDef.className;
                return this.script(formatterDef.script);
            }
            return this;
        }

        public Builder formatterAttr(String formatterClassName) {
            if (!this.formatterAsElement) {
                this.formatterClassName = formatterClassName;
            }
            return this;
        }

        public Builder script(String scriptText, String scriptLanguage) {
            this.scriptText = scriptText;
            this.scriptLanguage = scriptLanguage;
            return this;
        }

        public Builder script(MondrianDef.Script script) {
            if (script != null) {
                this.scriptText = script.cdata;
                this.scriptLanguage = script.language;
            }
            return this;
        }

        public FormatterCreateContext build() {
            return new FormatterCreateContext(this);
        }

        private static void checkIfFormatterSpecifiedCorrectly(String className, MondrianDef.Script script) {
            if (className == null && script == null) {
                throw Util.newError("Must specify either className attribute or Script element");
            }
            if (className != null && script != null) {
                throw Util.newError("Must not specify both className attribute and Script element");
            }
        }
    }
}

