/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mondrian.olap.Evaluator;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

class MemberExcludeConstraint
implements TupleConstraint {
    private final List<RolapMember> excludes;
    private final Object cacheKey;
    private final RolapLevel level;
    private final RolapNativeSet.SetConstraint csc;
    private final Map<RolapLevel, List<RolapMember>> roles;

    public MemberExcludeConstraint(List<RolapMember> excludes, RolapLevel level, RolapNativeSet.SetConstraint csc) {
        this.excludes = excludes;
        this.cacheKey = Arrays.asList(MemberExcludeConstraint.class, excludes, csc);
        this.level = level;
        this.csc = csc;
        this.roles = csc == null ? Collections.emptyMap() : SqlConstraintUtils.getRolesConstraints(csc.getEvaluator());
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MemberExcludeConstraint && this.getCacheKey().equals(((MemberExcludeConstraint)obj).getCacheKey());
    }

    @Override
    public void addLevelConstraint(SqlQuery query, RolapCube baseCube, AggStar aggStar, RolapLevel level) {
        if (level.equals(this.level)) {
            SqlConstraintUtils.addMemberConstraint(query, baseCube, aggStar, this.excludes, true, false, true);
        }
        if (this.csc != null) {
            for (CrossJoinArg cja : this.csc.args) {
                if (!cja.getLevel().equals(level)) continue;
                cja.addConstraint(query, baseCube, aggStar);
            }
        }
        if (this.roles.containsKey(level)) {
            List<RolapMember> members = this.roles.get(level);
            SqlConstraintUtils.addMemberConstraint(query, baseCube, aggStar, members, true, false, false);
        }
    }

    public String toString() {
        return "MemberExcludeConstraint(" + this.excludes + ")";
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return DefaultMemberChildrenConstraint.instance();
    }

    @Override
    public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
    }

    @Override
    public Evaluator getEvaluator() {
        if (this.csc != null) {
            return this.csc.getEvaluator();
        }
        return null;
    }

    @Override
    public boolean supportsAggTables() {
        return true;
    }
}

