/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

class StrToSetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    private StrToSetFunDef(int[] parameterTypes) {
        super("StrToSet", "<Set> StrToSet(<String>[, <Hierarchy>...])", "Constructs a set from a string expression.", Syntax.Function, 8, parameterTypes);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final StringCalc stringCalc = compiler.compileString(call.getArg(0));
        SetType type = (SetType)call.getType();
        Type elementType = type.getElementType();
        if (elementType instanceof MemberType) {
            final Hierarchy hierarchy = elementType.getHierarchy();
            return new AbstractListCalc(call, new Calc[]{stringCalc}){

                @Override
                public TupleList evaluateList(Evaluator evaluator) {
                    String string = stringCalc.evaluateString(evaluator);
                    if (string == null) {
                        throw FunUtil.newEvalException(MondrianResource.instance().NullValue.ex());
                    }
                    return new UnaryTupleList(FunUtil.parseMemberList(evaluator, string, hierarchy));
                }
            };
        }
        TupleType tupleType = (TupleType)elementType;
        final List<Hierarchy> hierarchyList = tupleType.getHierarchies();
        return new AbstractListCalc(call, new Calc[]{stringCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                String string = stringCalc.evaluateString(evaluator);
                if (string == null) {
                    throw FunUtil.newEvalException(MondrianResource.instance().NullValue.ex());
                }
                return FunUtil.parseTupleList(evaluator, string, hierarchyList);
            }
        };
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        int argCount = args.length;
        if (argCount <= 1) {
            throw MondrianResource.instance().MdxFuncArgumentsNum.ex(this.getName());
        }
        for (int i = 1; i < argCount; ++i) {
            Exp arg = args[i];
            if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                Dimension dimension = dimensionExpr.getDimension();
                args[i] = new HierarchyExpr(dimension.getHierarchy());
                continue;
            }
            if (arg instanceof HierarchyExpr) continue;
            throw MondrianResource.instance().MdxFuncNotHier.ex(i + 1, this.getName());
        }
        return super.createCall(validator, args);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        switch (args.length) {
            case 1: {
                return new SetType(null);
            }
            case 2: {
                Type argType = args[1].getType();
                return new SetType(new MemberType(argType.getDimension(), argType.getHierarchy(), argType.getLevel(), null));
            }
        }
        ArrayList<MemberType> list = new ArrayList<MemberType>();
        for (int i = 1; i < args.length; ++i) {
            Exp arg = args[i];
            Type argType = arg.getType();
            list.add(TypeUtil.toMemberType(argType));
        }
        Type[] types = list.toArray(new MemberType[list.size()]);
        TupleType.checkHierarchies((MemberType[])types);
        return new SetType(new TupleType(types));
    }

    private static class ResolverImpl
    extends ResolverBase {
        ResolverImpl() {
            super("StrToSet", "StrToSet(<String Expression>)", "Constructs a set from a string expression.", Syntax.Function);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 1) {
                return null;
            }
            Type type = args[0].getType();
            if (!(type instanceof StringType) && !(type instanceof NullType)) {
                return null;
            }
            for (int i = 1; i < args.length; ++i) {
                Exp exp = args[i];
                if (exp instanceof DimensionExpr || exp instanceof HierarchyExpr) continue;
                return null;
            }
            int[] argTypes = new int[args.length];
            argTypes[0] = 9;
            for (int i = 1; i < argTypes.length; ++i) {
                argTypes[i] = 3;
            }
            return new StrToSetFunDef(argTypes);
        }

        @Override
        public FunDef getFunDef() {
            return new StrToSetFunDef(new int[]{9});
        }
    }
}

