/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.olap.Category;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Id;
import mondrian.olap.Literal;
import mondrian.olap.Parameter;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ParameterFunDef
extends FunDefBase {
    public final String parameterName;
    private final Type type;
    public final Exp exp;
    public final String parameterDescription;

    ParameterFunDef(FunDef funDef, String parameterName, Type type, int returnCategory, Exp exp, String description) {
        super(funDef.getName(), funDef.getSignature(), funDef.getDescription(), funDef.getSyntax(), returnCategory, funDef.getParameterCategories());
        ParameterFunDef.assertPrecondition(this.getName().equals("Parameter") || this.getName().equals("ParamRef"));
        this.parameterName = parameterName;
        this.type = type;
        this.exp = exp;
        this.parameterDescription = description;
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        Parameter parameter = validator.createOrLookupParam(this.getName().equals("Parameter"), this.parameterName, this.type, this.exp, this.parameterDescription);
        return new ParameterExpr(parameter);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        return this.type;
    }

    private static boolean isConstant(Exp typeArg) {
        FunCall currentMemberCall;
        FunCall hierarchyCall;
        if (typeArg instanceof LevelExpr) {
            return true;
        }
        if (typeArg instanceof HierarchyExpr) {
            return true;
        }
        if (typeArg instanceof DimensionExpr) {
            return true;
        }
        return typeArg instanceof FunCall && (hierarchyCall = (FunCall)typeArg).getFunName().equals("Hierarchy") && hierarchyCall.getArgCount() > 0 && hierarchyCall.getArg(0) instanceof FunCall && (currentMemberCall = (FunCall)hierarchyCall.getArg(0)).getFunName().equals("CurrentMember") && currentMemberCall.getArgCount() > 0 && currentMemberCall.getArg(0) instanceof DimensionExpr;
    }

    public static String getParameterName(Exp[] args) {
        if (args[0] instanceof Literal && args[0].getCategory() == 9) {
            return (String)((Literal)args[0]).getValue();
        }
        throw Util.newInternal("Parameter name must be a string constant");
    }

    public static Type getParameterType(Exp[] args) {
        if (args[1] instanceof Id) {
            Id id = (Id)args[1];
            String[] names = id.toStringArray();
            if (names.length == 1) {
                String name = names[0];
                if (name.equals("NUMERIC")) {
                    return new NumericType();
                }
                if (name.equals("STRING")) {
                    return new StringType();
                }
            }
        } else if (args[1] instanceof Literal) {
            Literal literal = (Literal)args[1];
            if (literal.getValue().equals("NUMERIC")) {
                return new NumericType();
            }
            if (literal.getValue().equals("STRING")) {
                return new StringType();
            }
        } else if (args[1] instanceof MemberExpr) {
            return new MemberType(null, null, null, null);
        }
        return new StringType();
    }

    public static class ParamRefResolver
    extends MultiResolver {
        public ParamRefResolver() {
            super("ParamRef", "ParamRef(<Name>)", "Returns the current value of this parameter. If it is null, returns the default value.", new String[]{"fv#"});
        }

        @Override
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            String parameterName = ParameterFunDef.getParameterName(args);
            return new ParameterFunDef(dummyFunDef, parameterName, null, 0, null, null);
        }
    }

    public static class ParameterResolver
    extends MultiResolver {
        private static final String[] SIGNATURES = new String[]{"fS#yS#", "fS#yS", "fn#yn#", "fn#yn", "fm#hm#", "fm#hm", "fx#hx#", "fx#hx"};

        public ParameterResolver() {
            super("Parameter", "Parameter(<Name>, <Type>, <DefaultValue>, <Description>, <Set>)", "Returns default value of parameter.", SIGNATURES);
        }

        @Override
        public String[] getReservedWords() {
            return new String[]{"NUMERIC", "STRING"};
        }

        @Override
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            int category;
            String parameterName = ParameterFunDef.getParameterName(args);
            Exp typeArg = args[1];
            Type type = typeArg.getType();
            switch (typeArg.getCategory()) {
                case 2: 
                case 3: 
                case 4: {
                    Dimension dimension = type.getDimension();
                    if (!ParameterFunDef.isConstant(typeArg)) {
                        throw ParameterResolver.newEvalException(dummyFunDef, "Invalid parameter '" + parameterName + "'. Type must be a NUMERIC, STRING, or a dimension, hierarchy or level");
                    }
                    if (dimension == null) {
                        throw ParameterResolver.newEvalException(dummyFunDef, "Invalid dimension for parameter '" + parameterName + "'");
                    }
                    type = new MemberType(type.getDimension(), type.getHierarchy(), type.getLevel(), null);
                    category = 6;
                    break;
                }
                case 11: {
                    String s = (String)((Literal)typeArg).getValue();
                    if (s.equalsIgnoreCase("NUMERIC")) {
                        category = 7;
                        type = new NumericType();
                        break;
                    }
                    if (s.equalsIgnoreCase("STRING")) {
                        category = 9;
                        type = new StringType();
                        break;
                    }
                }
                default: {
                    throw ParameterResolver.newEvalException(dummyFunDef, "Invalid type for parameter '" + parameterName + "'; expecting NUMERIC, STRING or a hierarchy");
                }
            }
            Exp exp = args[2];
            Validator validator = ParameterResolver.createSimpleValidator(BuiltinFunTable.instance());
            ArrayList<Resolver.Conversion> conversionList = new ArrayList<Resolver.Conversion>();
            String typeName = Category.instance.getName(category).toUpperCase();
            if (!validator.canConvert(2, exp, category, conversionList)) {
                throw ParameterResolver.newEvalException(dummyFunDef, "Default value of parameter '" + parameterName + "' is inconsistent with its type, " + typeName);
            }
            if (exp.getCategory() == 8 && category == 6) {
                type = new SetType(type);
            }
            if (category == 6) {
                Type expType = exp.getType();
                if (expType instanceof SetType) {
                    expType = ((SetType)expType).getElementType();
                }
                if (ParameterResolver.distinctFrom(type.getDimension(), expType.getDimension()) || ParameterResolver.distinctFrom(type.getHierarchy(), expType.getHierarchy()) || ParameterResolver.distinctFrom(type.getLevel(), expType.getLevel())) {
                    throw ParameterResolver.newEvalException(dummyFunDef, "Default value of parameter '" + parameterName + "' is not consistent with the parameter type '" + type);
                }
            }
            String parameterDescription = null;
            if (args.length > 3) {
                if (args[3] instanceof Literal && args[3].getCategory() == 9) {
                    parameterDescription = (String)((Literal)args[3]).getValue();
                } else {
                    throw ParameterResolver.newEvalException(dummyFunDef, "Description of parameter '" + parameterName + "' must be a string constant");
                }
            }
            return new ParameterFunDef(dummyFunDef, parameterName, type, category, exp, parameterDescription);
        }

        private static <T> boolean distinctFrom(T t1, T t2) {
            return t1 != null && t2 != null && !t1.equals(t2);
        }
    }
}

