/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.wizard.utility.report;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.pentaho.jfreereport.castormodel.reportspec.Chart;
import org.pentaho.jfreereport.castormodel.reportspec.Field;
import org.pentaho.jfreereport.castormodel.reportspec.FieldMapping;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;
import org.pentaho.jfreereport.castormodel.reportspec.Series;
import org.pentaho.jfreereport.castormodel.reportspec.types.ChartType;
import org.pentaho.jfreereport.wizard.utility.report.ReportSpecUtility;

public class ReportGenerationUtility {
    private static final String PROPERTY_ELEMENT_NAME = "property";
    private static final String CONFIGURATION_ELEMENT_NAME = "configuration";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static String RE_DISPLAY_NAME_PARTS = "^([^$]*)\\$\\((\\w+)\\)$";
    private static final Pattern DISPLAY_NAME_PARTS_PATTERN = Pattern.compile(RE_DISPLAY_NAME_PARTS);

    public static Log getLogger() {
        return LogFactory.getLog(ReportGenerationUtility.class);
    }

    public static void setGroupHeaderFont(ReportSpec reportSpec, Element groupHeader, boolean setHeight) {
        groupHeader.addAttribute("color", reportSpec.getGroupHeaderFontColor());
        groupHeader.addAttribute("fontname", reportSpec.getGroupHeaderFontName());
        groupHeader.addAttribute("fontsize", reportSpec.getGroupHeaderFontSize() + "");
        groupHeader.addAttribute("fontstyle", ReportSpecUtility.getFontStyleString(reportSpec.getGroupHeaderFontStyle()));
        if (setHeight) {
            groupHeader.addAttribute("height", reportSpec.getColumnHeaderHeight() + reportSpec.getColumnHeaderGap() + "");
        }
    }

    public static void setGroupFooterFont(ReportSpec reportSpec, Element groupFooter) {
        groupFooter.addAttribute("color", reportSpec.getGroupFooterFontColor());
        groupFooter.addAttribute("fontname", reportSpec.getGroupFooterFontName());
        groupFooter.addAttribute("fontsize", reportSpec.getGroupFooterFontSize() + "");
        groupFooter.addAttribute("fontstyle", ReportSpecUtility.getFontStyleString(reportSpec.getGroupFooterFontStyle()));
    }

    public static void setColumnHeaderFont(ReportSpec reportSpec, Element columnHeader) {
        columnHeader.addAttribute("color", reportSpec.getColumnHeaderFontColor());
        columnHeader.addAttribute("fontname", reportSpec.getColumnHeaderFontName());
        columnHeader.addAttribute("fontsize", reportSpec.getColumnHeaderFontSize() + "");
        columnHeader.addAttribute("fontstyle", ReportSpecUtility.getFontStyleString(reportSpec.getColumnHeaderFontStyle()));
    }

    public static void setItemsFont(ReportSpec reportSpec, Element items) {
        items.addAttribute("color", reportSpec.getItemsFontColor());
        items.addAttribute("fontname", reportSpec.getItemsFontName());
        items.addAttribute("fontsize", reportSpec.getItemsFontSize() + "");
        items.addAttribute("fontstyle", ReportSpecUtility.getFontStyleString(reportSpec.getItemsFontStyle()));
    }

    public static void setItemFont(ReportSpec reportSpec, Field itemField, Element itemElement) {
        if (itemField.getIsRowHeader()) {
            itemElement.addAttribute("color", reportSpec.getColumnHeaderFontColor());
            itemElement.addAttribute("fontname", reportSpec.getColumnHeaderFontName());
            itemElement.addAttribute("fontsize", reportSpec.getColumnHeaderFontSize() + "");
            itemElement.addAttribute("fontstyle", ReportSpecUtility.getFontStyleString(reportSpec.getColumnHeaderFontStyle()));
        } else {
            if (itemField.getFontColor() != null) {
                itemElement.addAttribute("color", itemField.getFontColor());
            } else {
                itemElement.addAttribute("color", reportSpec.getItemsFontColor());
            }
            if (itemField.getFontName() != null) {
                itemElement.addAttribute("fontname", itemField.getFontName());
            } else {
                itemElement.addAttribute("fontname", reportSpec.getItemsFontName());
            }
            if (itemField.getFontSize() != -1) {
                itemElement.addAttribute("fontsize", itemField.getFontSize() + "");
            } else {
                itemElement.addAttribute("fontsize", reportSpec.getItemsFontSize() + "");
            }
            int style = itemField.getFontStyle() != -1 ? itemField.getFontStyle() : reportSpec.getItemsFontStyle();
            itemElement.addAttribute("fontstyle", ReportSpecUtility.getFontStyleString(style));
        }
    }

    public static void setAttributeWithRequiredValue(Element element, String attribute, String value) {
        if (element != null && attribute != null && value != null && !value.equals("")) {
            element.addAttribute(attribute, value);
        }
    }

    public static void addTrafficLighting(ReportSpec reportSpec, Field f, String trafficLightElementName, Element functionNode) {
        Element trafficLightFunctionNode = functionNode.addElement("expression");
        trafficLightFunctionNode.addAttribute("class", "org.jfree.report.function.ElementTrafficLightFunction");
        trafficLightFunctionNode.addAttribute(NAME_ATTRIBUTE_NAME, "trafficLight" + f.getName());
        Element propertiesNode = trafficLightFunctionNode.addElement("properties");
        Element property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "element");
        property.setText(trafficLightElementName);
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "field");
        property.setText(f.getName());
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "color[0]");
        property.setText(f.getTrafficLightingRedColor());
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "color[1]");
        property.setText(f.getTrafficLightingYellowColor());
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "color[2]");
        property.setText(f.getTrafficLightingGreenColor());
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "limit[0]");
        property.setText(String.valueOf(f.getTrafficLightingYellowValue()));
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "limit[1]");
        property.setText(String.valueOf(f.getTrafficLightingGreenValue()));
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "useAbsoluteValue");
        property.setText(String.valueOf(f.getTrafficLightingUseAbsoluteValue()));
        property = propertiesNode.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "useOppositeLogic");
        property.setText(String.valueOf(f.getTrafficLightingUseOppositeLogic()));
    }

    public static void addHorizontalGridLines(ReportSpec reportSpec, Field[] groups, Field[] details, Element itemsNode, int itemRowHeight) {
        if (reportSpec.getUseHorizontalGridlines()) {
            int percentSum = 0;
            Element lineElement = itemsNode.addElement("line");
            lineElement.addAttribute("color", reportSpec.getHorizontalGridlinesColor());
            lineElement.addAttribute("weight", ".5");
            if (details[0].getIsWidthPercent()) {
                lineElement.addAttribute("x1", reportSpec.getHorizontalOffset() + percentSum + "%");
            } else {
                lineElement.addAttribute("x1", reportSpec.getHorizontalOffset() + percentSum + "");
            }
            lineElement.addAttribute("y1", "0");
            lineElement.addAttribute("x2", "100%");
            lineElement.addAttribute("y2", "0");
            lineElement = itemsNode.addElement("line");
            lineElement.addAttribute("color", reportSpec.getHorizontalGridlinesColor());
            lineElement.addAttribute("weight", ".5");
            if (details[0].getIsWidthPercent()) {
                lineElement.addAttribute("x1", reportSpec.getHorizontalOffset() + percentSum + "%");
            } else {
                lineElement.addAttribute("x1", reportSpec.getHorizontalOffset() + percentSum + "");
            }
            lineElement.addAttribute("y1", itemRowHeight + "");
            lineElement.addAttribute("x2", "100%");
            lineElement.addAttribute("y2", itemRowHeight + "");
        }
    }

    public static void addVerticalGridLines(ReportSpec reportSpec, Field[] groups, Field[] details, Element itemsNode, int itemRowHeight) {
        if (reportSpec.getUseVerticalGridlines()) {
            double percentSum = 0.0;
            for (int i = 0; i < details.length; ++i) {
                Element lineElement;
                Field f = details[i];
                BigDecimal width = f.getWidth();
                if (i == 0) {
                    lineElement = itemsNode.addElement("line");
                    lineElement.addAttribute("color", reportSpec.getVerticalGridlinesColor());
                    lineElement.addAttribute("weight", ".5");
                    lineElement.addAttribute("x1", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                    lineElement.addAttribute("y1", "0");
                    lineElement.addAttribute("x2", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                    lineElement.addAttribute("y2", itemRowHeight + "");
                }
                percentSum += width.doubleValue();
                lineElement = itemsNode.addElement("line");
                lineElement.addAttribute("color", reportSpec.getVerticalGridlinesColor());
                lineElement.addAttribute("weight", ".5");
                if (i == details.length - 1) {
                    lineElement.addAttribute("x1", "100%");
                } else {
                    lineElement.addAttribute("x1", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                }
                lineElement.addAttribute("y1", "0");
                if (i == details.length - 1) {
                    lineElement.addAttribute("x2", "100%");
                } else {
                    lineElement.addAttribute("x2", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                }
                lineElement.addAttribute("y2", itemRowHeight + "");
            }
        }
    }

    public static void createColumnHeaders(ReportSpec reportSpec, Field[] groups, Field[] details, Element columnHeaderElement, double startingX, int startingY) {
        double percentSum = startingX;
        if (reportSpec.getIsMDX()) {
            int depth = 0;
            int height = reportSpec.getColumnHeaderFontSize() + 2;
            for (int i = 0; i < details.length; ++i) {
                StringTokenizer st = new StringTokenizer(details[i].getName(), "/");
                depth = Math.max(depth, st.countTokens() - 1);
            }
            if (depth == 1) {
                height = reportSpec.getColumnHeaderHeight();
            }
            for (int row = 0; row < depth; ++row) {
                percentSum = startingX;
                for (int i = 0; i < details.length; ++i) {
                    Field f = details[i];
                    BigDecimal width = f.getWidth();
                    String horizontalAlignment = f.getHorizontalAlignment();
                    StringTokenizer st = new StringTokenizer(details[i].getName(), "/");
                    String displayName = f.getDisplayName();
                    if (!f.getIsRowHeader()) {
                        for (int x = 0; x < depth - row; ++x) {
                            displayName = st.nextToken();
                        }
                    }
                    int spanAmount = 1;
                    double spanWidth = width.doubleValue();
                    for (int spanCounter = i + 1; spanCounter < details.length; ++spanCounter) {
                        Field spanField = details[spanCounter];
                        st = new StringTokenizer(spanField.getName(), "/");
                        String spanDisplayName = spanField.getDisplayName();
                        if (!spanField.getIsRowHeader()) {
                            for (int x = 0; x < depth - row; ++x) {
                                spanDisplayName = st.nextToken();
                            }
                        }
                        if (!spanDisplayName.equals(displayName)) break;
                        ++spanAmount;
                        spanWidth += spanField.getWidth().doubleValue();
                        ++i;
                    }
                    Element label = columnHeaderElement.addElement("label");
                    ReportGenerationUtility.setColumnHeaderFont(reportSpec, label);
                    label.addAttribute("height", String.valueOf(height));
                    label.addAttribute("vertical-alignment", f.getVerticalAlignment());
                    label.addAttribute("alignment", horizontalAlignment);
                    label.addAttribute("width", String.valueOf(spanWidth) + (f.getIsWidthPercent() ? "%" : ""));
                    label.addAttribute("x", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                    int y = (depth - row - 1) * height;
                    if (groups != null && groups.length > 0) {
                        label.addAttribute("y", y + reportSpec.getGroupHeaderFontSize() + 5 + "");
                    } else {
                        label.addAttribute("y", y + "");
                    }
                    if (!f.getIsRowHeader()) {
                        label.setText(displayName);
                    } else if (row == 0) {
                        label.setText(f.getDisplayName());
                    }
                    percentSum += spanWidth;
                }
            }
        } else {
            for (int j = 0; j < details.length; ++j) {
                Field f = details[j];
                double width = f.getWidth().doubleValue();
                Element label = columnHeaderElement.addElement("label");
                ReportGenerationUtility.setColumnHeaderFont(reportSpec, label);
                label.addAttribute("height", String.valueOf(reportSpec.getColumnHeaderHeight()));
                label.addAttribute("vertical-alignment", f.getVerticalAlignment());
                label.addAttribute("alignment", f.getHorizontalAlignment());
                label.addAttribute("width", String.valueOf(width) + (f.getIsWidthPercent() ? "%" : ""));
                label.addAttribute("x", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                label.addAttribute("y", startingY + "");
                label.setText(f.getDisplayName());
                percentSum += width;
            }
        }
    }

    public static void mergeTemplate(File templateFile, File generatedJFreeReportFile, OutputStream mergeStream) {
        if (!templateFile.exists() || !generatedJFreeReportFile.exists()) {
            return;
        }
        SAXReader reader = new SAXReader(false);
        try {
            Document templateDoc = reader.read(templateFile);
            Document generatedDoc = reader.read(generatedJFreeReportFile);
            ReportGenerationUtility.mergeTemplate(templateDoc, generatedDoc, mergeStream);
        }
        catch (Exception e) {
            ReportGenerationUtility.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void mergeTemplateAsStream(Document templateDoc, Document generatedDoc, OutputStream jfreeMergedOutputStream) {
        ReportGenerationUtility.mergeTemplate(templateDoc, generatedDoc, jfreeMergedOutputStream);
    }

    public static void mergeTemplate(Document templateDoc, Document generatedDoc, OutputStream mergeStream) {
        try {
            Element itemsElement;
            Element templateReportNode = (Element)templateDoc.selectSingleNode("/report");
            Element generatedReportNode = (Element)generatedDoc.selectSingleNode("/report");
            List templateAttributes = templateReportNode.attributes();
            for (int i = templateAttributes.size() - 1; i >= 0; --i) {
                Attribute attribute = (Attribute)templateAttributes.get(i);
                templateReportNode.remove(attribute);
            }
            List generatedAttributes = generatedReportNode.attributes();
            for (int i = generatedAttributes.size() - 1; i >= 0; --i) {
                Attribute attribute = (Attribute)generatedAttributes.get(i);
                generatedReportNode.remove(attribute);
                templateReportNode.add(attribute);
            }
            List templateParserConfigProps = templateReportNode.selectNodes("parser-config/*");
            List generatedParserConfigProps = generatedReportNode.selectNodes("parser-config/*");
            Element templateParserConfigElement = (Element)templateReportNode.selectSingleNode("parser-config");
            Element generatedParserConfigElement = (Element)generatedReportNode.selectSingleNode("parser-config");
            for (int i = 0; i < generatedParserConfigProps.size(); ++i) {
                Element generatedParserConfigProp = (Element)generatedParserConfigProps.get(i);
                Element templateParserConfigProp = (Element)templateParserConfigProps.get(i);
                String generatedText = generatedParserConfigProp.getText();
                if (StringUtils.isEmpty((CharSequence)generatedText)) continue;
                generatedParserConfigElement.remove(generatedParserConfigProp);
                templateParserConfigElement.remove(templateParserConfigProp);
                templateParserConfigElement.add(generatedParserConfigProp);
            }
            if (templateReportNode.selectSingleNode("items") != null) {
                templateReportNode.remove(templateReportNode.selectSingleNode("items"));
            }
            if ((itemsElement = (Element)generatedReportNode.selectSingleNode("items")) != null) {
                generatedReportNode.remove(itemsElement);
                templateReportNode.add(itemsElement);
            }
            List groups = templateReportNode.selectNodes("groups/*");
            if (ReportSpecUtility.getNumberOfGroupsInTemplate(templateDoc) == 0) {
                Element groupElement;
                if (templateReportNode.selectSingleNode("groups") != null) {
                    templateReportNode.remove(templateReportNode.selectSingleNode("groups"));
                }
                if (generatedReportNode.selectSingleNode("groups") == null) {
                    generatedReportNode.addElement("groups");
                }
                if ((groupElement = (Element)generatedReportNode.selectSingleNode("groups")) != null) {
                    generatedReportNode.remove(groupElement);
                    templateReportNode.add(groupElement);
                }
            } else {
                List generatedGroups = generatedReportNode.selectNodes("groups/*");
                for (int i = 0; i < groups.size(); ++i) {
                    Element templateGroup = (Element)groups.get(i);
                    for (int j = i + 1; j < generatedGroups.size(); ++j) {
                        Element generatedGroup = (Element)generatedGroups.get(j);
                        Element templateGroupHeader = (Element)templateGroup.selectSingleNode("groupheader");
                        Element generatedGroupHeader = (Element)generatedGroup.selectSingleNode("groupheader");
                        Element templateGroupFooter = (Element)templateGroup.selectSingleNode("groupfooter");
                        Element generatedGroupFooter = (Element)generatedGroup.selectSingleNode("groupfooter");
                        try {
                            if (templateGroupHeader.attribute("pagebreak-before-print") != null) {
                                templateGroupHeader.attribute("pagebreak-before-print").detach();
                            }
                            templateGroupHeader.addAttribute("pagebreak-before-print", generatedGroupHeader.attributeValue("pagebreak-before-print") + "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (templateGroupHeader.attribute("pagebreak-after-print") != null) {
                                templateGroupHeader.attribute("pagebreak-after-print").detach();
                            }
                            templateGroupHeader.addAttribute("pagebreak-after-print", generatedGroupHeader.attributeValue("pagebreak-after-print") + "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (templateGroupFooter.attribute("pagebreak-before-print") != null) {
                                templateGroupFooter.attribute("pagebreak-before-print").detach();
                            }
                            templateGroupFooter.addAttribute("pagebreak-before-print", generatedGroupFooter.attributeValue("pagebreak-before-print") + "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (templateGroupFooter.attribute("pagebreak-after-print") != null) {
                                templateGroupFooter.attribute("pagebreak-after-print").detach();
                            }
                            templateGroupFooter.addAttribute("pagebreak-after-print", generatedGroupFooter.attributeValue("pagebreak-after-print") + "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (templateGroupHeader.attribute("repeat") != null) {
                                templateGroupHeader.attribute("repeat").detach();
                            }
                            templateGroupHeader.addAttribute("repeat", generatedGroupHeader.attributeValue("repeat") + "");
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (groups != null) {
                    Element innermostGroup = null;
                    int innermostFieldsInGroup = 0;
                    for (int i = 0; i < groups.size(); ++i) {
                        Element groupElement = (Element)groups.get(i);
                        List fields = groupElement.selectNodes("fields/*");
                        if (fields == null || fields.size() <= 0 || fields.size() <= innermostFieldsInGroup) continue;
                        innermostFieldsInGroup = fields.size();
                        innermostGroup = groupElement;
                    }
                    Element generatedInnermostGroup = null;
                    if (generatedGroups != null) {
                        int generatedInnermostFieldsInGroup = 0;
                        for (int i = 0; i < generatedGroups.size(); ++i) {
                            Element groupElement = (Element)generatedGroups.get(i);
                            List fields = groupElement.selectNodes("fields/*");
                            if (fields == null || fields.size() <= 0 || fields.size() <= generatedInnermostFieldsInGroup) continue;
                            generatedInnermostFieldsInGroup = fields.size();
                            generatedInnermostGroup = groupElement;
                        }
                    }
                    if (innermostGroup != null) {
                        Element groupHeader = (Element)innermostGroup.selectSingleNode("groupheader");
                        if (groupHeader == null) {
                            Element headerElement = (Element)generatedInnermostGroup.selectSingleNode("groupheader");
                            if (headerElement != null) {
                                generatedInnermostGroup.remove(headerElement);
                                innermostGroup.add(headerElement);
                            }
                        } else {
                            Element element;
                            int i;
                            List groupHeaderNodes = innermostGroup.selectNodes("groupheader/*");
                            List generatedGroupHeaderNodes = generatedInnermostGroup.selectNodes("groupheader/*");
                            Element generatedGroupHeader = (Element)generatedInnermostGroup.selectSingleNode("groupheader");
                            int y = 0;
                            for (i = 0; i < groupHeaderNodes.size(); ++i) {
                                element = (Element)groupHeaderNodes.get(i);
                                try {
                                    y = Math.max(y, Integer.parseInt(element.attributeValue("y")) + Integer.parseInt(element.attributeValue("height")));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    y = Math.max(y, Integer.parseInt(element.attributeValue("y1")) + Integer.parseInt(element.attributeValue("height")));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    y = Math.max(y, Integer.parseInt(element.attributeValue("y2")) + Integer.parseInt(element.attributeValue("height")));
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            for (i = 0; i < generatedGroupHeaderNodes.size(); ++i) {
                                int yValue;
                                element = (Element)generatedGroupHeaderNodes.get(i);
                                generatedGroupHeader.remove(element);
                                if (element.attribute("y") != null) {
                                    yValue = Integer.parseInt(element.attributeValue("y"));
                                    element.attribute("y").detach();
                                    element.addAttribute("y", y + yValue + "");
                                } else if (element.attribute("y1") != null) {
                                    yValue = Integer.parseInt(element.attributeValue("y1"));
                                    element.attribute("y1").detach();
                                    element.addAttribute("y1", y + yValue + "");
                                } else if (element.attribute("y2") != null) {
                                    yValue = Integer.parseInt(element.attributeValue("y2"));
                                    element.attribute("y2").detach();
                                    element.addAttribute("y2", y + yValue + "");
                                }
                                groupHeader.add(element);
                            }
                        }
                        Element groupFooter = (Element)innermostGroup.selectSingleNode("groupfooter");
                        if (groupFooter == null) {
                            Element footerElement = (Element)generatedInnermostGroup.selectSingleNode("groupfooter");
                            if (footerElement != null) {
                                generatedInnermostGroup.remove(footerElement);
                                innermostGroup.add(footerElement);
                            }
                        } else {
                            int i;
                            List groupFooterNodes = groupFooter.selectNodes("*");
                            for (int i2 = 0; i2 < groupFooterNodes.size(); ++i2) {
                                groupFooter.remove((Element)groupFooterNodes.get(i2));
                            }
                            List generatedGroupFooterNodes = generatedInnermostGroup.selectNodes("groupfooter/*");
                            Element generatedGroupFooter = (Element)generatedInnermostGroup.selectSingleNode("groupfooter");
                            int y = 0;
                            for (i = 0; i < generatedGroupFooterNodes.size(); ++i) {
                                Element element = (Element)generatedGroupFooterNodes.get(i);
                                generatedGroupFooter.remove(element);
                                groupFooter.add(element);
                                try {
                                    y = Math.max(y, Integer.parseInt(element.attributeValue("y")) + Integer.parseInt(element.attributeValue("height")));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    y = Math.max(y, Integer.parseInt(element.attributeValue("y1")) + Integer.parseInt(element.attributeValue("height")));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    y = Math.max(y, Integer.parseInt(element.attributeValue("y2")) + Integer.parseInt(element.attributeValue("height")));
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            for (i = 0; i < groupFooterNodes.size(); ++i) {
                                int yValue;
                                Element element = (Element)groupFooterNodes.get(i);
                                if (element.attribute("y") != null) {
                                    yValue = Integer.parseInt(element.attributeValue("y"));
                                    element.attribute("y").detach();
                                    element.addAttribute("y", y + yValue + "");
                                } else if (element.attribute("y1") != null) {
                                    yValue = Integer.parseInt(element.attributeValue("y1"));
                                    element.attribute("y1").detach();
                                    element.addAttribute("y1", y + yValue + "");
                                } else if (element.attribute("y2") != null) {
                                    yValue = Integer.parseInt(element.attributeValue("y2"));
                                    element.attribute("y2").detach();
                                    element.addAttribute("y2", y + yValue + "");
                                }
                                groupFooter.add((Element)groupFooterNodes.get(i));
                            }
                        }
                    }
                }
                for (int i = 0; i < generatedGroups.size(); ++i) {
                    Element generatedGroup = (Element)generatedGroups.get(i);
                    if (!generatedGroup.attributeValue(NAME_ATTRIBUTE_NAME).equals("dummy")) continue;
                    for (int j = 0; j < groups.size(); ++j) {
                        Element group = (Element)groups.get(j);
                        if (!group.attributeValue(NAME_ATTRIBUTE_NAME).equals("dummy")) continue;
                        Element groupsElement = (Element)templateReportNode.selectSingleNode("groups");
                        generatedGroup.detach();
                        group.detach();
                        groupsElement.add(generatedGroup);
                    }
                }
            }
            Element functionsElement = (Element)templateReportNode.selectSingleNode("functions");
            Element generatedFunctionsElement = (Element)generatedReportNode.selectSingleNode("functions");
            if (generatedFunctionsElement != null) {
                List functionList = generatedFunctionsElement.selectNodes("function");
                for (int i = 0; i < functionList.size(); ++i) {
                    Element functionElement = (Element)functionList.get(i);
                    generatedFunctionsElement.remove(functionElement);
                    functionsElement.add(functionElement);
                }
            }
            Element expressionsElement = (Element)templateReportNode.selectSingleNode("functions");
            Element generatedExpressionsElement = (Element)generatedReportNode.selectSingleNode("functions");
            if (generatedExpressionsElement != null) {
                List expressionsList = generatedExpressionsElement.selectNodes("expression");
                for (int i = 0; i < expressionsList.size(); ++i) {
                    Element expressionElement = (Element)expressionsList.get(i);
                    generatedExpressionsElement.remove(expressionElement);
                    expressionsElement.add(expressionElement);
                }
            }
            if (generatedReportNode.selectSingleNode("watermark") != null) {
                Element watermarkNode = (Element)generatedReportNode.selectSingleNode("watermark");
                Element templateWatermarkNode = (Element)templateReportNode.selectSingleNode("watermark");
                if (templateWatermarkNode != null) {
                    templateWatermarkNode.detach();
                }
                if (watermarkNode != null) {
                    watermarkNode.detach();
                }
                templateReportNode.add(watermarkNode);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(mergeStream, format);
            writer.write(templateDoc);
            writer.close();
        }
        catch (Exception e) {
            ReportGenerationUtility.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void addParserConfig(ReportSpec reportSpec, Element reportNode) {
        FieldMapping[] fieldMappings = reportSpec.getFieldMapping();
        if (fieldMappings != null) {
            Element parserConfigElement = reportNode.addElement("parser-config");
            for (int i = 0; i < fieldMappings.length; ++i) {
                FieldMapping fieldMap = fieldMappings[i];
                Element property = parserConfigElement.addElement(PROPERTY_ELEMENT_NAME);
                property.addAttribute(NAME_ATTRIBUTE_NAME, fieldMap.getKey());
                property.setText(fieldMap.getValue());
            }
        }
    }

    public static void addChartElement(ReportSpec reportSpec, Field groupField, Element functionNode, Element parentElement, int y) {
        Chart chart = reportSpec.getChart();
        if (groupField != null) {
            chart = groupField.getChart();
        }
        Element drawableField = parentElement.addElement("drawable-field");
        drawableField.addAttribute("x", reportSpec.getHorizontalOffset() + chart.getHorizontalOffset() + "%");
        drawableField.addAttribute("y", y + "");
        drawableField.addAttribute("height", chart.getHeight() + "");
        drawableField.addAttribute("width", chart.getWidth() + "");
        String chartName = groupField != null ? groupField.getName() + "Chart" : "ReportChart";
        String dataSourceName = groupField != null ? groupField.getName() + "ChartDataSource" : "ReportChartDataSource";
        drawableField.addAttribute("fieldname", chartName);
        Element collectorFunctionElement = functionNode.addElement("expression");
        collectorFunctionElement.addAttribute(NAME_ATTRIBUTE_NAME, dataSourceName);
        Element collectorFunctionProperties = collectorFunctionElement.addElement("properties");
        Element chartExpressionElement = functionNode.addElement("expression");
        chartExpressionElement.addAttribute(NAME_ATTRIBUTE_NAME, chartName);
        Element chartFunctionProperties = chartExpressionElement.addElement("properties");
        ChartType type = chart.getType();
        if (type == ChartType.AREA || type == ChartType.BAR || type == ChartType.LINE || type == ChartType.PIE_MULTI || type == ChartType.WATERFALL) {
            collectorFunctionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.CategorySetCollectorFunction");
            Element categoryColumnProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
            categoryColumnProperty.addAttribute(NAME_ATTRIBUTE_NAME, "categoryColumn");
            categoryColumnProperty.setText(chart.getCategoryColumn());
            String[] series = ReportSpecUtility.getSeriesColumns(chart);
            for (int i = 0; i < series.length; ++i) {
                Element seriesProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                seriesProperty.addAttribute(NAME_ATTRIBUTE_NAME, "seriesName[" + i + "]");
                seriesProperty.setText(series[i]);
            }
            String[] values = chart.getValuesColumn();
            for (int i = 0; i < values.length; ++i) {
                Element valuesProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                valuesProperty.addAttribute(NAME_ATTRIBUTE_NAME, "valueColumn[" + i + "]");
                valuesProperty.setText(values[i]);
            }
            if (type == ChartType.AREA || type == ChartType.BAR) {
                Element stackedProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                stackedProperty.addAttribute(NAME_ATTRIBUTE_NAME, "stacked");
                stackedProperty.setText(chart.getIsStacked() + "");
            }
            if (type != ChartType.PIE_MULTI) {
                Element isHorizontalProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                isHorizontalProperty.addAttribute(NAME_ATTRIBUTE_NAME, "horizontal");
                isHorizontalProperty.setText(chart.getIsHorizontal() + "");
                Element labelRotationProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                labelRotationProperty.addAttribute(NAME_ATTRIBUTE_NAME, "labelRotation");
                labelRotationProperty.setText(chart.getLabelRotation() + "");
            }
            Series[] seriesArray = chart.getSeries();
            for (int i = 0; i < seriesArray.length; ++i) {
                if (seriesArray[i].getSeriesColor() == null || seriesArray[i].getSeriesColor().equals("")) continue;
                Element seriesProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                seriesProperty.addAttribute(NAME_ATTRIBUTE_NAME, "seriesColor[" + i + "]");
                seriesProperty.setText(seriesArray[i].getSeriesColor());
            }
            if (type == ChartType.AREA) {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.AreaChartExpression");
            } else if (type == ChartType.BAR) {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.BarChartExpression");
            } else if (type == ChartType.LINE) {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.LineChartExpression");
            } else if (type == ChartType.PIE_MULTI) {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.MultiPieChartExpression");
            } else if (type == ChartType.WATERFALL) {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.WaterfallChartExpressions");
            }
        }
        if (type == ChartType.PIE || type == ChartType.RING) {
            String[] values;
            collectorFunctionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.PieSetCollectorFunction");
            if (type == ChartType.PIE) {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.PieChartExpression");
            } else {
                chartExpressionElement.addAttribute("class", "org.pentaho.plugin.jfreereport.reportcharts.RingChartExpression");
            }
            String[] series = ReportSpecUtility.getSeriesColumns(chart);
            if (series.length > 0) {
                Element seriesProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                seriesProperty.addAttribute(NAME_ATTRIBUTE_NAME, "seriesColumn");
                seriesProperty.setText(series[0]);
            }
            if ((values = chart.getValuesColumn()).length > 0) {
                Element valuesProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
                valuesProperty.addAttribute(NAME_ATTRIBUTE_NAME, "valueColumn");
                valuesProperty.setText(values[0]);
            }
            Element ignoreNullsProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
            ignoreNullsProperty.addAttribute(NAME_ATTRIBUTE_NAME, "ignoreNulls");
            ignoreNullsProperty.setText("true");
            Element ignoreZerosProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
            ignoreZerosProperty.addAttribute(NAME_ATTRIBUTE_NAME, "ignoreZeros");
            ignoreZerosProperty.setText("true");
        } else if (chart.getType() == ChartType.PIE_MULTI) {
            Element multipieByRowProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
            multipieByRowProperty.addAttribute(NAME_ATTRIBUTE_NAME, "multipieByRow");
            multipieByRowProperty.setText("false");
        }
        if (groupField != null) {
            Element groupProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
            groupProperty.addAttribute(NAME_ATTRIBUTE_NAME, "group");
            groupProperty.setText(groupField.getName());
        }
        if (chart.getResetGroup() != null && !chart.getResetGroup().equals("")) {
            Element resetGroupProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
            resetGroupProperty.addAttribute(NAME_ATTRIBUTE_NAME, "resetGroup");
            resetGroupProperty.setText(chart.getResetGroup());
        }
        Element is3DProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        is3DProperty.addAttribute(NAME_ATTRIBUTE_NAME, "threeD");
        is3DProperty.setText(chart.getIsThreeDimensional() + "");
        Element summaryOnlyProperty = collectorFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        summaryOnlyProperty.addAttribute(NAME_ATTRIBUTE_NAME, "summaryOnly");
        summaryOnlyProperty.setText(chart.getIsSummaryOnly() + "");
        Element datasourceProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        datasourceProperty.addAttribute(NAME_ATTRIBUTE_NAME, "dataSource");
        datasourceProperty.setText(dataSourceName);
        Element titleProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        titleProperty.addAttribute(NAME_ATTRIBUTE_NAME, "title");
        titleProperty.setText(chart.getTitle());
        Element backgroundColorProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        backgroundColorProperty.addAttribute(NAME_ATTRIBUTE_NAME, "backgroundColor");
        backgroundColorProperty.setText(chart.getBackgroundColor());
        Element showBorderProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        showBorderProperty.addAttribute(NAME_ATTRIBUTE_NAME, "showBorder");
        showBorderProperty.setText(chart.getShowBorder() + "");
        Element showLegendProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        showLegendProperty.addAttribute(NAME_ATTRIBUTE_NAME, "showLegend");
        showLegendProperty.setText(chart.getShowLegend() + "");
        Element drawLegendBorderProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        drawLegendBorderProperty.addAttribute(NAME_ATTRIBUTE_NAME, "drawLegendBorder");
        drawLegendBorderProperty.setText(chart.getDrawLegendBorder() + "");
        Element legendLocationProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        legendLocationProperty.addAttribute(NAME_ATTRIBUTE_NAME, "legendLocation");
        legendLocationProperty.setText(chart.getLegendLocation().toString());
        Element heightProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        heightProperty.addAttribute(NAME_ATTRIBUTE_NAME, "chartHeight");
        heightProperty.setText(chart.getHeight() + "");
        Element widthProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        widthProperty.addAttribute(NAME_ATTRIBUTE_NAME, "chartWidth");
        widthProperty.setText(chart.getWidth() + "");
        Element useDrawableProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        useDrawableProperty.addAttribute(NAME_ATTRIBUTE_NAME, "useDrawable");
        useDrawableProperty.setText("true");
        Element titleFontProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        titleFontProperty.addAttribute(NAME_ATTRIBUTE_NAME, "titleFont");
        titleFontProperty.setText("Arial-BOLD-14");
        Element labelFontProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        labelFontProperty.addAttribute(NAME_ATTRIBUTE_NAME, "labelFont");
        labelFontProperty.setText("Arial--8");
        Element legendFontProperty = chartFunctionProperties.addElement(PROPERTY_ELEMENT_NAME);
        legendFontProperty.addAttribute(NAME_ATTRIBUTE_NAME, "legendFont");
        legendFontProperty.setText("Arial--6");
    }

    public static void setupDetailFieldWidths(ReportSpec reportSpec, Field[] details) {
        int numAutoWidthDetails = 0;
        double totalWidth = reportSpec.getHorizontalOffset();
        for (int i = 0; i < details.length; ++i) {
            Field f = details[i];
            if (f.getWidthLocked()) {
                totalWidth += f.getWidth().doubleValue();
                continue;
            }
            ++numAutoWidthDetails;
        }
        double remainderWidth = 100.0 - totalWidth;
        double autoWidth = 0.0;
        if (numAutoWidthDetails > 0) {
            autoWidth = remainderWidth / (double)numAutoWidthDetails;
        }
        double finalTotalWidth = 0.0;
        for (int i = 0; i < details.length; ++i) {
            Field f = details[i];
            if (!f.getWidthLocked()) {
                if (i == details.length - 1) {
                    f.setWidth(new BigDecimal(100.0 - finalTotalWidth - (double)reportSpec.getHorizontalOffset()));
                    continue;
                }
                f.setWidth(new BigDecimal(autoWidth));
                finalTotalWidth += autoWidth;
                continue;
            }
            finalTotalWidth += f.getWidth().doubleValue();
        }
    }

    public static List setupSpaceFields(Field[] fields) {
        LinkedList<Field> spaceFields = new LinkedList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getName().startsWith("_SPACE_")) continue;
            f.setName("");
            f.setDisplayName("");
            spaceFields.add(f);
        }
        return spaceFields;
    }

    public static void setPageFormat(ReportSpec reportSpec, Element reportNode, int pageWidth, int pageHeight) {
        if (reportSpec.getPageFormat() != null && !reportSpec.getUseCustomPageFormat()) {
            reportNode.addAttribute("pageformat", reportSpec.getPageFormat());
        } else if (reportSpec.getUseCustomPageFormat()) {
            reportNode.addAttribute("width", String.valueOf(reportSpec.getCustomPageFormatWidth()));
            reportNode.addAttribute("height", String.valueOf(reportSpec.getCustomPageFormatHeight()));
        } else {
            reportNode.addAttribute("width", String.valueOf(pageWidth));
            reportNode.addAttribute("height", String.valueOf(pageHeight));
        }
    }

    public static void setMargins(ReportSpec reportSpec, Element reportNode) {
        reportNode.addAttribute("leftmargin", String.valueOf(reportSpec.getLeftMargin()));
        reportNode.addAttribute("rightmargin", String.valueOf(reportSpec.getRightMargin()));
        reportNode.addAttribute("topmargin", String.valueOf(reportSpec.getTopMargin()));
        reportNode.addAttribute("bottommargin", String.valueOf(reportSpec.getBottomMargin()));
    }

    public static void setWatermark(ReportSpec reportSpec, Element reportNode) {
        if (reportSpec.getWatermark() != null && reportSpec.getWatermark().getUseWatermark() && reportSpec.getWatermark().getSrc() != null && !reportSpec.getWatermark().getSrc().equals("")) {
            Element watermarkElement = reportNode.addElement("watermark");
            Element imagerefElement = watermarkElement.addElement("imageref");
            imagerefElement.addAttribute("width", reportSpec.getWatermark().getWidth() + "%");
            imagerefElement.addAttribute("height", reportSpec.getWatermark().getHeight() + "%");
            imagerefElement.addAttribute("x", reportSpec.getWatermark().getX() + "%");
            imagerefElement.addAttribute("y", reportSpec.getWatermark().getY() + "%");
            imagerefElement.addAttribute("scale", String.valueOf(reportSpec.getWatermark().getScale()));
            imagerefElement.addAttribute("keepAspectRatio", String.valueOf(reportSpec.getWatermark().getKeepAspectRatio()));
            imagerefElement.addAttribute(NAME_ATTRIBUTE_NAME, "watermark");
            File wmf = new File(reportSpec.getWatermark().getSrc());
            try {
                String watermarkSrc = "file://" + wmf.getCanonicalPath().replace('\\', '/');
                imagerefElement.addAttribute("src", watermarkSrc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void createRowBanding(ReportSpec reportSpec, Field[] details, Element itemsNode, Element functionNode, int itemRowHeight) {
        if (reportSpec.getUseRowBanding() && details.length > 0) {
            Element rectangleElement = itemsNode.addElement("rectangle");
            rectangleElement.addAttribute(NAME_ATTRIBUTE_NAME, "rowBandingElement");
            rectangleElement.addAttribute("color", reportSpec.getRowBandingColor());
            rectangleElement.addAttribute("draw", "false");
            rectangleElement.addAttribute("fill", "true");
            rectangleElement.addAttribute("height", itemRowHeight + "");
            rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
            rectangleElement.addAttribute("width", "100%");
            rectangleElement.addAttribute("y", "0");
            Element bandingFunctionField = functionNode.addElement("function");
            bandingFunctionField.addAttribute(NAME_ATTRIBUTE_NAME, "backgroundTrigger");
            bandingFunctionField.addAttribute("class", "org.jfree.report.function.ElementVisibilitySwitchFunction");
            Element properties = bandingFunctionField.addElement("properties");
            Element property = properties.addElement(PROPERTY_ELEMENT_NAME);
            property.addAttribute(NAME_ATTRIBUTE_NAME, "element");
            property.setText("rowBandingElement");
            property = properties.addElement(PROPERTY_ELEMENT_NAME);
            property.addAttribute(NAME_ATTRIBUTE_NAME, "numberOfElements");
            property.setText("1");
            property = properties.addElement(PROPERTY_ELEMENT_NAME);
            property.addAttribute(NAME_ATTRIBUTE_NAME, "initialState");
            property.setText(reportSpec.getRowBandingInitialState() ? "true" : "false");
        }
    }

    public static void processDetailsSection(ReportSpec reportSpec, Field[] details, Field[] groups, Element itemsNode, Element functionNode, int itemRowHeight) {
        double percentSum = 0.0;
        for (int i = 0; i < details.length; ++i) {
            Field f = details[i];
            String detailFieldName = f.getName();
            if (f.getIsCalculatedColumn()) {
                ReportGenerationUtility.createCalculatedColumnExpression(reportSpec, functionNode, f);
                detailFieldName = f.getName() + "_calc_column_expression";
            }
            double width = f.getWidth().doubleValue();
            if (f.getUseBackgroundColor() || f.getUseTrafficLighting()) {
                Element rectangleElement = itemsNode.addElement("rectangle");
                rectangleElement.addAttribute(NAME_ATTRIBUTE_NAME, f.getName() + "BackgroundElement");
                if (!f.getUseTrafficLighting()) {
                    rectangleElement.addAttribute("color", f.getBackgroundColor());
                }
                rectangleElement.addAttribute("draw", "false");
                rectangleElement.addAttribute("fill", "true");
                rectangleElement.addAttribute("height", itemRowHeight + "");
                rectangleElement.addAttribute("x", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
                rectangleElement.addAttribute("width", width + (f.getIsWidthPercent() ? "%" : ""));
                rectangleElement.addAttribute("y", "0");
                if (f.getUseTrafficLighting()) {
                    ReportGenerationUtility.addTrafficLighting(reportSpec, f, f.getName() + "BackgroundElement", functionNode);
                }
            }
            String elementType = StringUtils.isEmpty((CharSequence)f.getName()) ? "message-field" : ReportSpecUtility.getFieldType(f.getType());
            Element detailField = itemsNode.addElement(elementType);
            detailField.addAttribute(NAME_ATTRIBUTE_NAME, f.getName() + "Element");
            detailField.addAttribute("nullstring", f.getNullString());
            if (elementType != "message-field") {
                detailField.addAttribute("fieldname", detailFieldName);
                String format = details[i].getFormat();
                ReportGenerationUtility.setAttributeWithRequiredValue(detailField, "format", format);
            } else {
                detailField.setText("");
            }
            detailField.addAttribute("vertical-alignment", f.getVerticalAlignment());
            detailField.addAttribute("alignment", f.getHorizontalAlignment());
            detailField.addAttribute("width", width + (f.getIsWidthPercent() ? "%" : ""));
            detailField.addAttribute("x", (double)reportSpec.getHorizontalOffset() + percentSum + (f.getIsWidthPercent() ? "%" : ""));
            detailField.addAttribute("y", "0");
            detailField.addAttribute("height", itemRowHeight + "");
            ReportGenerationUtility.setItemFont(reportSpec, f, detailField);
            if (f.getUseItemHide()) {
                Element functionField = functionNode.addElement("function");
                functionField.addAttribute(NAME_ATTRIBUTE_NAME, "headerEVSF_" + f.getName());
                functionField.addAttribute("class", "org.jfree.report.function.ItemHideFunction");
                Element properties = functionField.addElement("properties");
                Element elementProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                elementProperty.addAttribute(NAME_ATTRIBUTE_NAME, "element");
                elementProperty.setText(f.getName() + "Element");
                Element fieldProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                fieldProperty.addAttribute(NAME_ATTRIBUTE_NAME, "field");
                fieldProperty.setText(detailFieldName);
                Element ignoreGroupBreaksProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                ignoreGroupBreaksProperty.addAttribute(NAME_ATTRIBUTE_NAME, "ignoreGroupBreaks");
                ignoreGroupBreaksProperty.setText("true");
                Element ignorePageBreaksProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                ignorePageBreaksProperty.addAttribute(NAME_ATTRIBUTE_NAME, "ignorePageBreaks");
                ignorePageBreaksProperty.setText("true");
            }
            percentSum += width;
        }
        if (details.length > 0) {
            ReportGenerationUtility.addVerticalGridLines(reportSpec, groups, details, itemsNode, itemRowHeight);
            ReportGenerationUtility.addHorizontalGridLines(reportSpec, groups, details, itemsNode, itemRowHeight);
        }
    }

    public static void processDummyGroup(ReportSpec reportSpec, Field[] details, Field[] groups, Element groupsNode, Element functionNode, int itemRowHeight, boolean expressionExists, int spacerWidth) {
        Element groupElement = groupsNode.addElement("group");
        groupElement.addAttribute(NAME_ATTRIBUTE_NAME, "dummy");
        Element dummyGroupHeader = groupElement.addElement("groupheader");
        Element noDataBandElement = dummyGroupHeader.addElement("band");
        noDataBandElement.addAttribute(NAME_ATTRIBUTE_NAME, "DummyGroupNoDataBandElement");
        Element noDataLabelElement = noDataBandElement.addElement("label");
        noDataLabelElement.addAttribute("height", itemRowHeight + "");
        noDataLabelElement.addAttribute("vertical-alignment", "middle");
        noDataLabelElement.addAttribute("alignment", "left");
        noDataLabelElement.addAttribute("width", "100%");
        noDataLabelElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
        noDataLabelElement.addAttribute("y", "0");
        noDataLabelElement.setText("No Data Available");
        ReportGenerationUtility.addShowIfNoData(noDataBandElement, functionNode);
        Element dataBandElement = dummyGroupHeader.addElement("band");
        dataBandElement.addAttribute(NAME_ATTRIBUTE_NAME, "DummyGroupDataBandElement");
        dataBandElement.addAttribute("y", reportSpec.getColumnHeaderTopGap() + "");
        dataBandElement.addAttribute("height", reportSpec.getColumnHeaderHeight() + reportSpec.getColumnHeaderGap() + "");
        ReportGenerationUtility.addHideIfNoData("DummyGroupDataBandElement", functionNode);
        Element rectangleElement = dataBandElement.addElement("rectangle");
        rectangleElement.addAttribute("color", reportSpec.getColumnHeaderBackgroundColor());
        rectangleElement.addAttribute("draw", "false");
        rectangleElement.addAttribute("fill", reportSpec.getUseColumnHeaderBackgroundColor() ? "true" : "false");
        rectangleElement.addAttribute("height", String.valueOf(reportSpec.getColumnHeaderHeight()));
        rectangleElement.addAttribute("width", "100%");
        rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
        rectangleElement.addAttribute("y", "0");
        ReportGenerationUtility.createColumnHeaders(reportSpec, groups, details, dataBandElement, 0.0, 0);
        dummyGroupHeader.addAttribute("repeat", "true");
        dummyGroupHeader.addAttribute("height", reportSpec.getColumnHeaderTopGap() + reportSpec.getColumnHeaderHeight() + reportSpec.getColumnHeaderGap() + "");
        ReportGenerationUtility.setGroupHeaderFont(reportSpec, dummyGroupHeader, true);
        Element dummyGroupFooter = groupElement.addElement("groupfooter");
        dummyGroupFooter.addAttribute(NAME_ATTRIBUTE_NAME, "dummyGroupFooter");
        ReportGenerationUtility.addHideIfNoData("dummyGroupFooter", functionNode);
        ReportGenerationUtility.setGroupFooterFont(reportSpec, dummyGroupFooter);
        if (expressionExists && reportSpec.getCalculateGrandTotals()) {
            Element dummyFooterRectangleElement = null;
            if (reportSpec.getUseDummyGroupFooterBackgroundColor()) {
                dummyFooterRectangleElement = dummyGroupFooter.addElement("rectangle");
                dummyFooterRectangleElement.addAttribute("color", reportSpec.getDummyGroupFooterBackgroundColor());
                dummyFooterRectangleElement.addAttribute("draw", "false");
                dummyFooterRectangleElement.addAttribute("fill", "true");
                dummyFooterRectangleElement.addAttribute("height", reportSpec.getGroupFooterFontSize() + 5 + "");
                dummyFooterRectangleElement.addAttribute("width", "100%");
                dummyFooterRectangleElement.addAttribute("y", "1");
            }
            String xStr = ReportGenerationUtility.addExpressions(reportSpec, details, groups, null, -1, dummyGroupFooter, functionNode, true, 0);
            if (dummyFooterRectangleElement != null) {
                dummyFooterRectangleElement.addAttribute("x", xStr);
            }
        }
    }

    public static void processNormalGroups(ReportSpec reportSpec, Field[] details, Field[] groups, Element groupsNode, Element functionNode, int itemRowHeight, boolean expressionExists, int spacerWidth) {
        Element groupElement = groupsNode.addElement("group");
        groupElement.addAttribute(NAME_ATTRIBUTE_NAME, "dummy");
        Element dummyGroupHeader = groupElement.addElement("groupheader");
        dummyGroupHeader.addAttribute(NAME_ATTRIBUTE_NAME, "dummyGroupHeader");
        Element noDataLabelElement = dummyGroupHeader.addElement("label");
        noDataLabelElement.addAttribute(NAME_ATTRIBUTE_NAME, "noDataLabelElement");
        noDataLabelElement.addAttribute("height", itemRowHeight + "");
        noDataLabelElement.addAttribute("vertical-alignment", "middle");
        noDataLabelElement.addAttribute("alignment", "left");
        noDataLabelElement.addAttribute("width", "100%");
        noDataLabelElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
        noDataLabelElement.addAttribute("y", "0");
        noDataLabelElement.addAttribute("visible", "false");
        noDataLabelElement.setText("No Data Available");
        ReportGenerationUtility.addShowIfNoData(noDataLabelElement, functionNode);
        ReportGenerationUtility.setGroupHeaderFont(reportSpec, dummyGroupHeader, false);
        dummyGroupHeader.addAttribute("repeat", "false");
        Element dummyGroupFooter = groupElement.addElement("groupfooter");
        dummyGroupFooter.addAttribute(NAME_ATTRIBUTE_NAME, "dummyGroupFooter");
        ReportGenerationUtility.addHideIfNoData("dummyGroupFooter", functionNode);
        ReportGenerationUtility.setGroupFooterFont(reportSpec, dummyGroupFooter);
        Field innermostGroupField = groups[0];
        Field outermostGroupField = groups[groups.length - 1];
        int yShift = 0;
        if (outermostGroupField.getPageBreakAfterFooter() || innermostGroupField.getPageBreakAfterFooter()) {
            yShift = reportSpec.getColumnHeaderHeight();
            Element rectangleElement = dummyGroupFooter.addElement("rectangle");
            rectangleElement.addAttribute("color", reportSpec.getColumnHeaderBackgroundColor());
            rectangleElement.addAttribute("draw", "false");
            rectangleElement.addAttribute("fill", reportSpec.getUseColumnHeaderBackgroundColor() ? "true" : "false");
            rectangleElement.addAttribute("height", String.valueOf(reportSpec.getColumnHeaderHeight()));
            rectangleElement.addAttribute("width", "100%");
            rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
            rectangleElement.addAttribute("y", "0");
            ReportGenerationUtility.createColumnHeaders(reportSpec, groups, details, dummyGroupFooter, 0.0, 0);
        }
        if (expressionExists && reportSpec.getCalculateGrandTotals()) {
            Element dummyFooterRectangleElement = null;
            if (reportSpec.getUseDummyGroupFooterBackgroundColor()) {
                dummyFooterRectangleElement = dummyGroupFooter.addElement("rectangle");
                dummyFooterRectangleElement.addAttribute("color", reportSpec.getDummyGroupFooterBackgroundColor());
                dummyFooterRectangleElement.addAttribute("draw", "false");
                dummyFooterRectangleElement.addAttribute("fill", "true");
                dummyFooterRectangleElement.addAttribute("height", reportSpec.getGroupFooterFontSize() + 5 + "");
                dummyFooterRectangleElement.addAttribute("width", "100%");
                dummyFooterRectangleElement.addAttribute("y", "1");
            }
            String xStr = ReportGenerationUtility.addExpressions(reportSpec, details, groups, null, -1, dummyGroupFooter, functionNode, true, yShift);
            if (dummyFooterRectangleElement != null) {
                dummyFooterRectangleElement.addAttribute("x", xStr);
            }
        }
        for (int i = 0; i < groups.length; ++i) {
            Field group = groups[i];
            groupElement = groupsNode.addElement("group");
            groupElement.addAttribute(NAME_ATTRIBUTE_NAME, group.getName());
            Element fieldsElement = groupElement.addElement("fields");
            for (int j = 0; j <= i; ++j) {
                Element fieldElement = fieldsElement.addElement("field");
                fieldElement.setText(groups[j].getName());
            }
            Element groupHeader = null;
            groupHeader = groupElement.addElement("groupheader");
            groupHeader.addAttribute(NAME_ATTRIBUTE_NAME, group.getName() + "GroupHeader");
            ReportGenerationUtility.addHideIfNoData(group.getName() + "GroupHeader", functionNode);
            groupHeader.addAttribute("repeat", group.getRepeatGroupHeader() ? "true" : "false");
            groupHeader.addAttribute("pagebreak-before-print", String.valueOf(group.getPageBreakBeforeHeader()));
            groupHeader.addAttribute("pagebreak-after-print", String.valueOf(group.getPageBreakAfterHeader()));
            int chartHeight = 0;
            boolean chartAboveHeader = group.getShowChartAboveGroupHeader();
            if (group.getUseChart() && group.getChart() != null) {
                chartHeight = group.getChart().getHeight();
            }
            int lineHeight = reportSpec.getGroupHeaderFontSize() + 5;
            if (i == groups.length - 1) {
                Element rectangleElement;
                int y = 0;
                boolean x = false;
                ReportGenerationUtility.setGroupHeaderFont(reportSpec, groupHeader, false);
                int groupHeaderHeight = chartHeight + reportSpec.getColumnHeaderHeight();
                if (group.getUseChart() && group.getChart() != null && chartAboveHeader) {
                    ReportGenerationUtility.addChartElement(reportSpec, group, functionNode, groupHeader, 0);
                }
                if (group.getCreateGroupHeader()) {
                    groupHeaderHeight += lineHeight;
                    if (!StringUtils.isEmpty((CharSequence)group.getLevelName())) {
                        ReportGenerationUtility.addLevelField(groupHeader, group, reportSpec.getHorizontalOffset() + spacerWidth + "%", Integer.toString(chartAboveHeader ? chartHeight : y), "100%", Integer.toString(lineHeight));
                        y += lineHeight;
                    }
                    rectangleElement = groupHeader.addElement("rectangle");
                    rectangleElement.addAttribute("color", group.getBackgroundColor());
                    rectangleElement.addAttribute("draw", "false");
                    rectangleElement.addAttribute("fill", group.getUseBackgroundColor() ? "true" : "false");
                    rectangleElement.addAttribute("height", String.valueOf(lineHeight));
                    rectangleElement.addAttribute("width", "100%");
                    rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
                    rectangleElement.addAttribute("y", (chartAboveHeader ? chartHeight : y) + "");
                    ReportGenerationUtility.addGroupHeaderField(groupHeader, group, reportSpec.getHorizontalOffset() + spacerWidth + "%", Integer.toString(chartAboveHeader ? chartHeight : y), "100%", Integer.toString(lineHeight));
                    Element topGapRectangleElement = null;
                    if (reportSpec.getGenerateReportLevelColumnHeaders()) {
                        rectangleElement = dummyGroupHeader.addElement("rectangle");
                        topGapRectangleElement = dummyGroupHeader.addElement("rectangle");
                    } else {
                        rectangleElement = groupHeader.addElement("rectangle");
                        topGapRectangleElement = groupHeader.addElement("rectangle");
                    }
                    topGapRectangleElement.addAttribute("draw", "false");
                    topGapRectangleElement.addAttribute("fill", "false");
                    topGapRectangleElement.addAttribute("height", reportSpec.getColumnHeaderTopGap() + "");
                    topGapRectangleElement.addAttribute("width", "100%");
                    topGapRectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
                    if (reportSpec.getGenerateReportLevelColumnHeaders()) {
                        topGapRectangleElement.addAttribute("y", (chartAboveHeader ? chartHeight : y) + "");
                    } else {
                        topGapRectangleElement.addAttribute("y", (chartAboveHeader ? chartHeight : y) + reportSpec.getGroupHeaderFontSize() + 5 + "");
                    }
                    rectangleElement.addAttribute("color", reportSpec.getColumnHeaderBackgroundColor());
                    rectangleElement.addAttribute("draw", "false");
                    rectangleElement.addAttribute("fill", reportSpec.getUseColumnHeaderBackgroundColor() ? "true" : "false");
                    rectangleElement.addAttribute("height", String.valueOf(reportSpec.getColumnHeaderHeight()));
                    rectangleElement.addAttribute("width", "100%");
                    rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
                    if (reportSpec.getGenerateReportLevelColumnHeaders()) {
                        rectangleElement.addAttribute("y", reportSpec.getColumnHeaderTopGap() + (chartAboveHeader ? chartHeight : y) + "");
                    } else {
                        rectangleElement.addAttribute("y", reportSpec.getColumnHeaderTopGap() + ((chartAboveHeader ? chartHeight : y) + reportSpec.getGroupHeaderFontSize() + 5) + "");
                        y += reportSpec.getColumnHeaderTopGap() + (chartAboveHeader ? chartHeight : 0) + reportSpec.getGroupHeaderFontSize() + 5;
                    }
                } else {
                    rectangleElement = null;
                    rectangleElement = reportSpec.getGenerateReportLevelColumnHeaders() ? dummyGroupHeader.addElement("rectangle") : groupHeader.addElement("rectangle");
                    rectangleElement.addAttribute("color", reportSpec.getColumnHeaderBackgroundColor());
                    rectangleElement.addAttribute("draw", "false");
                    rectangleElement.addAttribute("fill", reportSpec.getUseColumnHeaderBackgroundColor() ? "true" : "false");
                    rectangleElement.addAttribute("height", String.valueOf(reportSpec.getColumnHeaderHeight()));
                    rectangleElement.addAttribute("width", "100%");
                    rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
                    rectangleElement.addAttribute("y", (chartAboveHeader ? chartHeight : y) + "");
                }
                if (group.getUseChart() && group.getChart() != null && !chartAboveHeader) {
                    ReportGenerationUtility.addChartElement(reportSpec, group, functionNode, groupHeader, groupHeaderHeight - chartHeight);
                }
                if (reportSpec.getGenerateReportLevelColumnHeaders()) {
                    ReportGenerationUtility.createColumnHeaders(reportSpec, groups, details, dummyGroupHeader, (double)x, y);
                    dummyGroupHeader.addAttribute("height", reportSpec.getColumnHeaderTopGap() + groupHeaderHeight + reportSpec.getColumnHeaderGap() + "");
                } else {
                    ReportGenerationUtility.createColumnHeaders(reportSpec, groups, details, groupHeader, (double)x, y);
                    groupHeader.addAttribute("height", reportSpec.getColumnHeaderTopGap() + groupHeaderHeight + reportSpec.getColumnHeaderGap() + "");
                }
            } else if (group.getCreateGroupHeader()) {
                int y = 0;
                ReportGenerationUtility.setGroupHeaderFont(reportSpec, groupHeader, false);
                if (!StringUtils.isEmpty((CharSequence)group.getLevelName())) {
                    ReportGenerationUtility.addLevelField(groupHeader, group, reportSpec.getHorizontalOffset() + spacerWidth + "%", Integer.toString(chartAboveHeader ? chartHeight : y), "100%", Integer.toString(lineHeight));
                    y += lineHeight;
                }
                Element rectangleElement = groupHeader.addElement("rectangle");
                rectangleElement.addAttribute("color", group.getBackgroundColor());
                rectangleElement.addAttribute("draw", "false");
                rectangleElement.addAttribute("fill", group.getUseBackgroundColor() ? "true" : "false");
                rectangleElement.addAttribute("height", lineHeight + "");
                rectangleElement.addAttribute("width", "100%");
                rectangleElement.addAttribute("x", reportSpec.getHorizontalOffset() + "%");
                rectangleElement.addAttribute("y", (chartAboveHeader ? chartHeight : y) + "");
                ReportGenerationUtility.addGroupHeaderField(groupHeader, group, reportSpec.getHorizontalOffset() + spacerWidth + "%", Integer.toString(chartAboveHeader ? chartHeight : y), "100%", Integer.toString(lineHeight));
                if (group.getUseChart() && group.getChart() != null && chartAboveHeader) {
                    ReportGenerationUtility.addChartElement(reportSpec, group, functionNode, groupHeader, 0);
                } else if (group.getUseChart() && group.getChart() != null && !chartAboveHeader) {
                    ReportGenerationUtility.addChartElement(reportSpec, group, functionNode, groupHeader, reportSpec.getGroupHeaderFontSize() + 5);
                }
            }
            Element groupFooter = groupElement.addElement("groupfooter");
            groupFooter.addAttribute(NAME_ATTRIBUTE_NAME, group.getName() + "GroupFooter");
            ReportGenerationUtility.addHideIfNoData(group.getName() + "GroupFooter", functionNode);
            ReportGenerationUtility.setGroupFooterFont(reportSpec, groupFooter);
            groupFooter.addAttribute("pagebreak-before-print", String.valueOf(group.getPageBreakBeforeFooter()));
            groupFooter.addAttribute("pagebreak-after-print", String.valueOf(group.getPageBreakAfterFooter()));
            if (!expressionExists || !group.getCalculateGroupTotals()) continue;
            Element rectangleElement = null;
            if (group.getUseGroupFooterBackgroundColor()) {
                rectangleElement = groupFooter.addElement("rectangle");
                rectangleElement.addAttribute("color", group.getGroupFooterBackgroundColor());
                rectangleElement.addAttribute("draw", "false");
                rectangleElement.addAttribute("fill", "true");
                rectangleElement.addAttribute("height", reportSpec.getGroupFooterFontSize() + 5 + "");
                rectangleElement.addAttribute("width", "100%");
                rectangleElement.addAttribute("y", "1");
            }
            String xStr = ReportGenerationUtility.addExpressions(reportSpec, details, groups, group, i, groupFooter, functionNode, false, 0);
            if (rectangleElement == null) continue;
            rectangleElement.addAttribute("x", xStr);
        }
    }

    public static void processGroupsSection(ReportSpec reportSpec, Field[] details, Field[] groups, Element groupsNode, Element functionNode, int itemRowHeight, boolean expressionExists, int spacerWidth) {
        if (groups.length == 0) {
            ReportGenerationUtility.processDummyGroup(reportSpec, details, groups, groupsNode, functionNode, itemRowHeight, expressionExists, spacerWidth);
        } else {
            ReportGenerationUtility.processNormalGroups(reportSpec, details, groups, groupsNode, functionNode, itemRowHeight, expressionExists, spacerWidth);
        }
    }

    private static String getFormatTypeAsString(int fieldType) {
        switch (fieldType) {
            case 91: {
                return "date";
            }
            case 2: {
                return "number";
            }
            case 12: {
                return null;
            }
        }
        throw new RuntimeException("Invalid field type: (" + String.valueOf(fieldType) + ")");
    }

    private static String getGroupMessageFieldFormatText(Field group) {
        Matcher m;
        String format;
        String text = group.getDisplayName();
        int intFieldType = group.getType();
        String strFormatType = ReportGenerationUtility.getFormatTypeAsString(intFieldType);
        if (null != strFormatType && !StringUtils.isEmpty((CharSequence)(format = group.getFormat())) && (m = DISPLAY_NAME_PARTS_PATTERN.matcher(group.getDisplayName())).matches() && m.groupCount() == 2) {
            String label = m.group(1);
            String columnValue = m.group(2);
            if (!StringUtils.isEmpty((CharSequence)columnValue)) {
                text = label + "$(" + columnValue + "," + strFormatType + "," + format + ")";
            }
        }
        return text;
    }

    private static void addGroupHeaderField(Element ownerElement, Field group, String x, String y, String width, String height) {
        String msgText = ReportGenerationUtility.getGroupMessageFieldFormatText(group);
        Element messageField = ownerElement.addElement("message-field");
        ReportGenerationUtility.initMessageField(messageField, msgText, x, y, width, height, group.getHorizontalAlignment(), group.getVerticalAlignment(), group.getNullString());
    }

    private static void addLevelField(Element ownerElement, Field group, String x, String y, String width, String height) {
        Element messageField = ownerElement.addElement("message-field");
        ReportGenerationUtility.initMessageField(messageField, group.getLevelName(), x, y, width, height, group.getHorizontalAlignment(), group.getVerticalAlignment(), group.getNullString());
    }

    private static void initMessageField(Element messageField, String text, String x, String y, String width, String height, String horizontalAlignment, String verticalAlignment, String nullString) {
        messageField.setText(text);
        messageField.addAttribute("height", height);
        messageField.addAttribute("vertical-alignment", verticalAlignment);
        messageField.addAttribute("alignment", horizontalAlignment);
        messageField.addAttribute("width", width);
        messageField.addAttribute("x", x);
        messageField.addAttribute("y", y);
        messageField.addAttribute("nullstring", nullString);
    }

    public static void createCalculatedColumnExpression(ReportSpec reportSpec, Element functionNode, Field f) {
        String text;
        Element expression = functionNode.addElement("expression");
        expression.addAttribute("class", "org.jfree.report.modules.misc.beanshell.BSHExpression");
        expression.addAttribute(NAME_ATTRIBUTE_NAME, f.getName() + "_calc_column_expression");
        Element properties = expression.addElement("properties");
        Element property = properties.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "expression");
        StringBuffer nameArrayStrBuf = new StringBuffer();
        nameArrayStrBuf.append("{");
        for (int i = 0; i < f.getCalculatedColumnsCount(); ++i) {
            String column = f.getCalculatedColumns()[i];
            nameArrayStrBuf.append("\"" + column + "\"");
            if (i >= f.getCalculatedColumnsCount() - 1) continue;
            nameArrayStrBuf.append(", ");
        }
        nameArrayStrBuf.append("}");
        if ("sum".equals(f.getCalculatedColumnFunction())) {
            String calcString = "calc += ((Number)value).doubleValue();";
            text = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";double calc = 0; try {   for (int x=0;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) { " + calcString + "    }   }  return new Double(calc);} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text);
        } else if ("diff".equals(f.getCalculatedColumnFunction())) {
            String calcString = "calc -= ((Number)value).doubleValue();";
            text = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";double calc = ((Number)dataRow.get(names[0])).doubleValue(); try {   for (int x=1;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) { " + calcString + "    }   }  return new Double(calc);} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text);
        } else if ("absdiff".equals(f.getCalculatedColumnFunction())) {
            String calcString = "calc -= ((Number)value).doubleValue();";
            text = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";double calc = ((Number)dataRow.get(names[0])).doubleValue(); try {   for (int x=1;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) { " + calcString + "    }   }  return new Double(Math.abs(calc));} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text);
        } else if ("mult".equals(f.getCalculatedColumnFunction())) {
            String calcString = "calc *= ((Number)value).doubleValue();";
            text = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";double calc = ((Number)dataRow.get(names[0])).doubleValue(); try {   for (int x=1;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) { " + calcString + "    }   }  return new Double(calc);} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text);
        } else if ("avg".equals(f.getCalculatedColumnFunction())) {
            String calcString = "calc += ((Number)value).doubleValue();";
            text = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";int numSum = 0;double calc = 0; try {   for (int x=0;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) {       numSum++;" + calcString + "    }   }  return new Double(calc / numSum);} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text);
        } else if ("min".equals(f.getCalculatedColumnFunction())) {
            String text2 = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";double min = Double.MAX_VALUE;try {   for (int x=0;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) {       min = Math.min(min, ((Number)value).doubleValue());    }   }  return new Double(min);} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text2);
        } else if ("max".equals(f.getCalculatedColumnFunction())) {
            String text3 = "Object getValue() { String[] names = " + nameArrayStrBuf.toString() + ";double max = Double.MIN_VALUE;try {   for (int x=0;x < names.length; x++) {     Object value = dataRow.get(names[x]);     if (value != null && value instanceof Number) {       max = Math.max(max, ((Number)value).doubleValue());    }   }  return new Double(max);} catch (Exception e) {   e.prinStackTrace();}}";
            property.addCDATA(text3);
        }
    }

    public static void addHideIfNoData(String elementName, Element functionNode) {
        Element hideIfNullTriggerExpressionField = functionNode.addElement("expression");
        hideIfNullTriggerExpressionField.addAttribute("class", "org.jfree.report.function.ShowElementIfDataAvailableExpression");
        hideIfNullTriggerExpressionField.addAttribute(NAME_ATTRIBUTE_NAME, elementName + "HideIfNullTrigger");
        Element hideIfNullTriggerProperties = hideIfNullTriggerExpressionField.addElement("properties");
        Element hideIfNullTriggerProperty = hideIfNullTriggerProperties.addElement(PROPERTY_ELEMENT_NAME);
        hideIfNullTriggerProperty.addAttribute(NAME_ATTRIBUTE_NAME, "element");
        hideIfNullTriggerProperty.setText(elementName);
    }

    public static void addShowIfNoData(Element element, Element functionNode) {
        Element showIfNullTriggerExpressionField = functionNode.addElement("expression");
        showIfNullTriggerExpressionField.addAttribute("class", "org.jfree.report.function.HideElementIfDataAvailableExpression");
        showIfNullTriggerExpressionField.addAttribute(NAME_ATTRIBUTE_NAME, element.attributeValue(NAME_ATTRIBUTE_NAME) + "HideIfNullTrigger");
        Element showIfNullTriggerProperties = showIfNullTriggerExpressionField.addElement("properties");
        Element showIfNullTriggerProperty = showIfNullTriggerProperties.addElement(PROPERTY_ELEMENT_NAME);
        showIfNullTriggerProperty.addAttribute(NAME_ATTRIBUTE_NAME, "element");
        showIfNullTriggerProperty.setText(element.attributeValue(NAME_ATTRIBUTE_NAME));
    }

    public static String addExpressions(ReportSpec reportSpec, Field[] details, Field[] groups, Field group, int i, Element groupFooter, Element functionNode, boolean isSummary, int yShift) {
        double width = 0.0;
        double widthSum = 0.0;
        int fontSize = reportSpec.getGroupFooterFontSize();
        String totalHorizontalAlignment = null;
        double totalLabelWidth = widthSum;
        boolean foundCalc = false;
        for (int j = 0; j < details.length; ++j) {
            String expressionName = details[j].getExpression();
            Field f = details[j];
            width = f.getWidth().doubleValue();
            if (expressionName == null || expressionName.equals("none")) {
                if (totalHorizontalAlignment == null) {
                    totalHorizontalAlignment = f.getHorizontalAlignment();
                }
                if (!foundCalc) {
                    totalLabelWidth += width;
                }
            } else {
                Element groupProperty;
                foundCalc = true;
                String fieldName = (isSummary ? "Summary_" : (group == null ? "dummy" : group.getName())) + f.getName() + "Expression";
                Element numberField = groupFooter.addElement("number-field");
                numberField.addAttribute("fieldname", fieldName);
                numberField.addAttribute("height", fontSize + 4 + "");
                numberField.addAttribute("vertical-alignment", f.getVerticalAlignment());
                numberField.addAttribute("alignment", f.getHorizontalAlignment());
                numberField.addAttribute("width", width + (f.getIsWidthPercent() ? "%" : ""));
                numberField.addAttribute("x", (double)reportSpec.getHorizontalOffset() + widthSum + (f.getIsWidthPercent() ? "%" : ""));
                numberField.addAttribute("y", yShift + 2 + "");
                Element expressionField = functionNode.addElement("expression");
                expressionField.addAttribute("class", ReportSpecUtility.getJFreeExpressionClass(expressionName));
                expressionField.addAttribute(NAME_ATTRIBUTE_NAME, fieldName);
                Element properties = expressionField.addElement("properties");
                if (expressionName.equals("group-count")) {
                    groupProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                    groupProperty.addAttribute(NAME_ATTRIBUTE_NAME, "group");
                    groupProperty.setText(group == null ? "dummy" : group.getName());
                    if (i > 0) {
                        Element parentProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                        parentProperty.addAttribute(NAME_ATTRIBUTE_NAME, "parentGroup");
                        parentProperty.setText(group == null ? "dummy" : group.getName());
                    }
                } else if (expressionName.equals("item-count")) {
                    groupProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                    groupProperty.addAttribute(NAME_ATTRIBUTE_NAME, "group");
                    groupProperty.setText(group == null ? "dummy" : group.getName());
                } else {
                    String format = f.getFormat();
                    ReportGenerationUtility.setAttributeWithRequiredValue(numberField, "format", format);
                    Element fieldProperty = properties.addElement(PROPERTY_ELEMENT_NAME);
                    fieldProperty.addAttribute(NAME_ATTRIBUTE_NAME, "field");
                    if (f.getIsCalculatedColumn()) {
                        fieldProperty.setText(f.getName() + "_calc_column_expression");
                    } else {
                        fieldProperty.setText(f.getName());
                    }
                    if (!isSummary) {
                        Element groupProperty2 = properties.addElement(PROPERTY_ELEMENT_NAME);
                        groupProperty2.addAttribute(NAME_ATTRIBUTE_NAME, "group");
                        groupProperty2.setText(group == null ? "dummy" : group.getName());
                    }
                }
                if (reportSpec.getUseExpressionUnderlining()) {
                    Element lineElement;
                    String hAlign = details[j].getHorizontalAlignment();
                    if (groups.length > 0 && i == groups.length - 1) {
                        lineElement = groupFooter.addElement("line");
                        lineElement.addAttribute("color", "black");
                        lineElement.addAttribute("weight", ".5");
                        if (hAlign.equals("left")) {
                            lineElement.addAttribute("x1", (double)reportSpec.getHorizontalOffset() + widthSum + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y1", yShift + 1 + "");
                            lineElement.addAttribute("x2", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.9) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y2", yShift + 1 + "");
                        } else if (hAlign.equals("center")) {
                            lineElement.addAttribute("x1", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.1) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y1", yShift + 1 + "");
                            lineElement.addAttribute("x2", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.9) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y2", yShift + 1 + "");
                        } else if (hAlign.equals("right")) {
                            lineElement.addAttribute("x1", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.1) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y1", yShift + 1 + "");
                            lineElement.addAttribute("x2", (double)reportSpec.getHorizontalOffset() + widthSum + width + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y2", yShift + 1 + "");
                        }
                    }
                    lineElement = groupFooter.addElement("line");
                    lineElement.addAttribute("color", "black");
                    lineElement.addAttribute("weight", ".5");
                    if (hAlign.equals("left")) {
                        lineElement.addAttribute("x1", (double)reportSpec.getHorizontalOffset() + widthSum + (f.getIsWidthPercent() ? "%" : ""));
                        lineElement.addAttribute("y1", yShift + fontSize + 6 + "");
                        lineElement.addAttribute("x2", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.9) + (f.getIsWidthPercent() ? "%" : ""));
                        lineElement.addAttribute("y2", yShift + fontSize + 6 + "");
                    } else if (hAlign.equals("center")) {
                        lineElement.addAttribute("x1", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.1) + (f.getIsWidthPercent() ? "%" : ""));
                        lineElement.addAttribute("y1", yShift + fontSize + 6 + "");
                        lineElement.addAttribute("x2", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.9) + (f.getIsWidthPercent() ? "%" : ""));
                        lineElement.addAttribute("y2", yShift + fontSize + 6 + "");
                    } else if (hAlign.equals("right")) {
                        lineElement.addAttribute("x1", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.1) + (f.getIsWidthPercent() ? "%" : ""));
                        lineElement.addAttribute("y1", yShift + fontSize + 6 + "");
                        lineElement.addAttribute("x2", (double)reportSpec.getHorizontalOffset() + widthSum + width + (f.getIsWidthPercent() ? "%" : ""));
                        lineElement.addAttribute("y2", yShift + fontSize + 6 + "");
                    }
                    if (reportSpec.getDoubleUnderlineExpression()) {
                        lineElement = groupFooter.addElement("line");
                        lineElement.addAttribute("color", "black");
                        lineElement.addAttribute("weight", ".5");
                        if (hAlign.equals("left")) {
                            lineElement.addAttribute("x1", (double)reportSpec.getHorizontalOffset() + widthSum + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y1", yShift + fontSize + 8 + "");
                            lineElement.addAttribute("x2", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.9) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y2", yShift + fontSize + 8 + "");
                        } else if (hAlign.equals("center")) {
                            lineElement.addAttribute("x1", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.1) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y1", yShift + fontSize + 8 + "");
                            lineElement.addAttribute("x2", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.9) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y2", yShift + fontSize + 8 + "");
                        } else if (hAlign.equals("right")) {
                            lineElement.addAttribute("x1", (int)((double)reportSpec.getHorizontalOffset() + widthSum + width * 0.1) + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y1", fontSize + 8 + "");
                            lineElement.addAttribute("x2", (double)reportSpec.getHorizontalOffset() + widthSum + width + (f.getIsWidthPercent() ? "%" : ""));
                            lineElement.addAttribute("y2", fontSize + 8 + "");
                        }
                    }
                }
            }
            widthSum += width;
        }
        String xStr = "0";
        if (foundCalc) {
            Element messageField = groupFooter.addElement("message-field");
            messageField.addAttribute("height", fontSize + 4 + "");
            Field foundColumn = null;
            double cumulativeWidth = 0.0;
            if (details != null && group != null) {
                for (int x = 0; x < details.length; ++x) {
                    if (details[x].getName().equalsIgnoreCase(group.getName())) {
                        foundColumn = details[x];
                        break;
                    }
                    cumulativeWidth += details[x].getWidth().doubleValue();
                }
            }
            if (foundColumn != null) {
                double tmpwidth = (double)reportSpec.getHorizontalOffset() + cumulativeWidth;
                xStr = tmpwidth + (foundColumn.getIsWidthPercent() ? "%" : "");
                messageField.addAttribute("x", xStr);
                messageField.addAttribute("width", totalLabelWidth - tmpwidth + (details[0].getIsWidthPercent() ? "%" : ""));
            } else {
                xStr = reportSpec.getHorizontalOffset() + (details[0].getIsWidthPercent() ? "%" : "");
                messageField.addAttribute("x", xStr);
                messageField.addAttribute("width", totalLabelWidth + (details[0].getIsWidthPercent() ? "%" : ""));
            }
            messageField.addAttribute("y", (reportSpec.getUseExpressionUnderlining() ? yShift + 3 : yShift + 2) + "");
            messageField.addAttribute("alignment", group != null ? group.getGroupTotalsHorizontalAlignment() : reportSpec.getGrandTotalsHorizontalAlignment());
            messageField.addAttribute("vertical-alignment", "middle");
            messageField.setText(group != null ? group.getGroupTotalsLabel() : reportSpec.getGrandTotalsLabel());
        }
        return xStr;
    }

    private static void addEncoding(Element configuration, String encoding) {
        Element property = configuration.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "org.jfree.report.modules.output.table.html.Encoding");
        property.setText(encoding);
        property = configuration.addElement(PROPERTY_ELEMENT_NAME);
        property.addAttribute(NAME_ATTRIBUTE_NAME, "org.jfree.report.modules.output.pageable.pdf.Encoding");
        property.setText(encoding);
    }

    public static void createJFreeReportXMLAsStream(ReportSpec reportSpec, String encoding, OutputStream outputStream) {
        ReportGenerationUtility.createJFreeReportXML(reportSpec, outputStream, encoding, 0, 0, false, "", 0, 0);
    }

    public static String createJFreeReportXML(ReportSpec reportSpec, String encoding) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ReportGenerationUtility.createJFreeReportXMLAsStream(reportSpec, encoding, outputStream);
        return new String(outputStream.toByteArray());
    }

    public static void createJFreeReportXML(ReportSpec reportSpec, OutputStream outputStream, int pageWidth, int pageHeight, boolean createTotalColumn, String totalColumnName, int totalColumnWidth, int spacerWidth) {
        ReportGenerationUtility.createJFreeReportXML(reportSpec, outputStream, null, pageWidth, pageHeight, createTotalColumn, totalColumnName, totalColumnWidth, spacerWidth);
    }

    public static void createJFreeReportXML(ReportSpec reportSpec, OutputStream outputStream, String encoding, int pageWidth, int pageHeight, boolean createTotalColumn, String totalColumnName, int totalColumnWidth, int spacerWidth) {
        Field[] fields = reportSpec.getField();
        Field[] details = ReportSpecUtility.getDetails(fields);
        Field[] groups = ReportSpecUtility.getGroups(fields);
        List spaceFields = ReportGenerationUtility.setupSpaceFields(fields);
        try {
            boolean expressionExists = ReportSpecUtility.doesExpressionExist(fields);
            ReportGenerationUtility.setupDetailFieldWidths(reportSpec, details);
            int itemRowHeight = ReportSpecUtility.getRowHeight(reportSpec, details);
            Document document = DOMDocumentFactory.getInstance().createDocument();
            document.addDocType("report", "-//JFreeReport//DTD report definition//EN//simple/version 0.8.5", "http://jfreereport.sourceforge.net/report-085.dtd");
            Element reportNode = document.addElement("report");
            Element configuration = reportNode.addElement(CONFIGURATION_ELEMENT_NAME);
            if (null != encoding) {
                document.setXMLEncoding(encoding);
                ReportGenerationUtility.addEncoding(configuration, encoding);
            }
            ReportGenerationUtility.addParserConfig(reportSpec, reportNode);
            reportNode.addAttribute(NAME_ATTRIBUTE_NAME, StringEscapeUtils.escapeXml((String)reportSpec.getReportName()));
            reportNode.addAttribute("orientation", reportSpec.getOrientation());
            ReportGenerationUtility.setPageFormat(reportSpec, reportNode, pageWidth, pageHeight);
            ReportGenerationUtility.setMargins(reportSpec, reportNode);
            if (reportSpec.getIncludeSrc() != null && !"".equalsIgnoreCase(reportSpec.getIncludeSrc())) {
                Element includeElement = reportNode.addElement("include");
                includeElement.addAttribute("src", "file://" + reportSpec.getIncludeSrc().replace('\\', '/'));
            }
            ReportGenerationUtility.setWatermark(reportSpec, reportNode);
            Element groupsNode = reportNode.addElement("groups");
            Element itemsNode = reportNode.addElement("items");
            Element functionNode = reportNode.addElement("functions");
            if (reportSpec.getChart() != null && reportSpec.getUseChart()) {
                Element reportHeaderElement = reportNode.addElement("reportheader");
                ReportGenerationUtility.addChartElement(reportSpec, null, functionNode, reportHeaderElement, 0);
            }
            ReportGenerationUtility.setItemsFont(reportSpec, itemsNode);
            ReportGenerationUtility.createRowBanding(reportSpec, details, itemsNode, functionNode, itemRowHeight);
            ReportGenerationUtility.processDetailsSection(reportSpec, details, groups, itemsNode, functionNode, itemRowHeight);
            ReportGenerationUtility.processGroupsSection(reportSpec, details, groups, groupsNode, functionNode, itemRowHeight, expressionExists, spacerWidth);
            OutputFormat format = OutputFormat.createPrettyPrint();
            if (null != encoding) {
                format.setEncoding(encoding);
            }
            XMLWriter writer = new XMLWriter(outputStream, format);
            writer.write(document);
            writer.close();
            for (int i = 0; i < spaceFields.size(); ++i) {
                Field f = (Field)spaceFields.get(i);
                f.setName("_SPACE_" + (i + 1));
                f.setDisplayName("_SPACE_" + (i + 1));
            }
        }
        catch (Exception e) {
            ReportGenerationUtility.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

