/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.castormodel.reportspec;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.pentaho.jfreereport.castormodel.reportspec.Series;
import org.pentaho.jfreereport.castormodel.reportspec.types.ChartType;
import org.pentaho.jfreereport.castormodel.reportspec.types.LegendLocation;
import org.xml.sax.ContentHandler;

public class Chart
implements Serializable {
    private ChartType type = ChartType.fromValue("bar");
    private String categoryColumn;
    private String group;
    private String resetGroup;
    private String title = "Chart Title";
    private String backgroundColor = "#FFFFFF";
    private boolean isThreeDimensional = true;
    private boolean _hasisThreeDimensional;
    private boolean isStacked = false;
    private boolean _hasisStacked;
    private boolean isSummaryOnly = false;
    private boolean _hasisSummaryOnly;
    private boolean showLegend = true;
    private boolean _hasshowLegend;
    private boolean drawLegendBorder = true;
    private boolean _hasdrawLegendBorder;
    private LegendLocation legendLocation = LegendLocation.fromValue("bottom");
    private int labelRotation = 7;
    private boolean _haslabelRotation;
    private boolean showBorder = false;
    private boolean _hasshowBorder;
    private boolean isHorizontal = false;
    private boolean _hasisHorizontal;
    private int height = 400;
    private boolean _hasheight;
    private int width = 600;
    private boolean _haswidth;
    private int horizontalOffset = 0;
    private boolean _hashorizontalOffset;
    private List<Series> seriesList;
    private List<String> valuesColumnList;

    public Chart() {
        this.setType(ChartType.fromValue("bar"));
        this.setTitle("Chart Title");
        this.setBackgroundColor("#FFFFFF");
        this.setLegendLocation(LegendLocation.fromValue("bottom"));
        this.seriesList = new ArrayList<Series>();
        this.valuesColumnList = new ArrayList<String>();
    }

    public void addSeries(Series vSeries) throws IndexOutOfBoundsException {
        this.seriesList.add(vSeries);
    }

    public void addSeries(int index, Series vSeries) throws IndexOutOfBoundsException {
        this.seriesList.add(index, vSeries);
    }

    public void addValuesColumn(String vValuesColumn) throws IndexOutOfBoundsException {
        this.valuesColumnList.add(vValuesColumn);
    }

    public void addValuesColumn(int index, String vValuesColumn) throws IndexOutOfBoundsException {
        this.valuesColumnList.add(index, vValuesColumn);
    }

    public void deleteDrawLegendBorder() {
        this._hasdrawLegendBorder = false;
    }

    public void deleteHeight() {
        this._hasheight = false;
    }

    public void deleteHorizontalOffset() {
        this._hashorizontalOffset = false;
    }

    public void deleteIsHorizontal() {
        this._hasisHorizontal = false;
    }

    public void deleteIsStacked() {
        this._hasisStacked = false;
    }

    public void deleteIsSummaryOnly() {
        this._hasisSummaryOnly = false;
    }

    public void deleteIsThreeDimensional() {
        this._hasisThreeDimensional = false;
    }

    public void deleteLabelRotation() {
        this._haslabelRotation = false;
    }

    public void deleteShowBorder() {
        this._hasshowBorder = false;
    }

    public void deleteShowLegend() {
        this._hasshowLegend = false;
    }

    public void deleteWidth() {
        this._haswidth = false;
    }

    public Enumeration<? extends Series> enumerateSeries() {
        return Collections.enumeration(this.seriesList);
    }

    public Enumeration<? extends String> enumerateValuesColumn() {
        return Collections.enumeration(this.valuesColumnList);
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getCategoryColumn() {
        return this.categoryColumn;
    }

    public boolean getDrawLegendBorder() {
        return this.drawLegendBorder;
    }

    public String getGroup() {
        return this.group;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public boolean getIsHorizontal() {
        return this.isHorizontal;
    }

    public boolean getIsStacked() {
        return this.isStacked;
    }

    public boolean getIsSummaryOnly() {
        return this.isSummaryOnly;
    }

    public boolean getIsThreeDimensional() {
        return this.isThreeDimensional;
    }

    public int getLabelRotation() {
        return this.labelRotation;
    }

    public LegendLocation getLegendLocation() {
        return this.legendLocation;
    }

    public String getResetGroup() {
        return this.resetGroup;
    }

    public Series getSeries(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.seriesList.size()) {
            throw new IndexOutOfBoundsException("getSeries: Index value '" + index + "' not in range [0.." + (this.seriesList.size() - 1) + "]");
        }
        return this.seriesList.get(index);
    }

    public Series[] getSeries() {
        Series[] array = new Series[]{};
        return this.seriesList.toArray(array);
    }

    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public boolean getShowLegend() {
        return this.showLegend;
    }

    public String getTitle() {
        return this.title;
    }

    public ChartType getType() {
        return this.type;
    }

    public String getValuesColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.valuesColumnList.size()) {
            throw new IndexOutOfBoundsException("getValuesColumn: Index value '" + index + "' not in range [0.." + (this.valuesColumnList.size() - 1) + "]");
        }
        return this.valuesColumnList.get(index);
    }

    public String[] getValuesColumn() {
        String[] array = new String[]{};
        return this.valuesColumnList.toArray(array);
    }

    public int getValuesColumnCount() {
        return this.valuesColumnList.size();
    }

    public int getWidth() {
        return this.width;
    }

    public boolean hasDrawLegendBorder() {
        return this._hasdrawLegendBorder;
    }

    public boolean hasHeight() {
        return this._hasheight;
    }

    public boolean hasHorizontalOffset() {
        return this._hashorizontalOffset;
    }

    public boolean hasIsHorizontal() {
        return this._hasisHorizontal;
    }

    public boolean hasIsStacked() {
        return this._hasisStacked;
    }

    public boolean hasIsSummaryOnly() {
        return this._hasisSummaryOnly;
    }

    public boolean hasIsThreeDimensional() {
        return this._hasisThreeDimensional;
    }

    public boolean hasLabelRotation() {
        return this._haslabelRotation;
    }

    public boolean hasShowBorder() {
        return this._hasshowBorder;
    }

    public boolean hasShowLegend() {
        return this._hasshowLegend;
    }

    public boolean hasWidth() {
        return this._haswidth;
    }

    public boolean isDrawLegendBorder() {
        return this.drawLegendBorder;
    }

    public boolean isIsHorizontal() {
        return this.isHorizontal;
    }

    public boolean isIsStacked() {
        return this.isStacked;
    }

    public boolean isIsSummaryOnly() {
        return this.isSummaryOnly;
    }

    public boolean isIsThreeDimensional() {
        return this.isThreeDimensional;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Series> iterateSeries() {
        return this.seriesList.iterator();
    }

    public Iterator<? extends String> iterateValuesColumn() {
        return this.valuesColumnList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSeries() {
        this.seriesList.clear();
    }

    public void removeAllValuesColumn() {
        this.valuesColumnList.clear();
    }

    public boolean removeSeries(Series vSeries) {
        boolean removed = this.seriesList.remove(vSeries);
        return removed;
    }

    public Series removeSeriesAt(int index) {
        Series obj = this.seriesList.remove(index);
        return obj;
    }

    public boolean removeValuesColumn(String vValuesColumn) {
        boolean removed = this.valuesColumnList.remove(vValuesColumn);
        return removed;
    }

    public String removeValuesColumnAt(int index) {
        String obj = this.valuesColumnList.remove(index);
        return obj;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setCategoryColumn(String categoryColumn) {
        this.categoryColumn = categoryColumn;
    }

    public void setDrawLegendBorder(boolean drawLegendBorder) {
        this.drawLegendBorder = drawLegendBorder;
        this._hasdrawLegendBorder = true;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setHeight(int height) {
        this.height = height;
        this._hasheight = true;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
        this._hashorizontalOffset = true;
    }

    public void setIsHorizontal(boolean isHorizontal) {
        this.isHorizontal = isHorizontal;
        this._hasisHorizontal = true;
    }

    public void setIsStacked(boolean isStacked) {
        this.isStacked = isStacked;
        this._hasisStacked = true;
    }

    public void setIsSummaryOnly(boolean isSummaryOnly) {
        this.isSummaryOnly = isSummaryOnly;
        this._hasisSummaryOnly = true;
    }

    public void setIsThreeDimensional(boolean isThreeDimensional) {
        this.isThreeDimensional = isThreeDimensional;
        this._hasisThreeDimensional = true;
    }

    public void setLabelRotation(int labelRotation) {
        this.labelRotation = labelRotation;
        this._haslabelRotation = true;
    }

    public void setLegendLocation(LegendLocation legendLocation) {
        this.legendLocation = legendLocation;
    }

    public void setResetGroup(String resetGroup) {
        this.resetGroup = resetGroup;
    }

    public void setSeries(int index, Series vSeries) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.seriesList.size()) {
            throw new IndexOutOfBoundsException("setSeries: Index value '" + index + "' not in range [0.." + (this.seriesList.size() - 1) + "]");
        }
        this.seriesList.set(index, vSeries);
    }

    public void setSeries(Series[] vSeriesArray) {
        this.seriesList.clear();
        for (int i = 0; i < vSeriesArray.length; ++i) {
            this.seriesList.add(vSeriesArray[i]);
        }
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
        this._hasshowBorder = true;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
        this._hasshowLegend = true;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public void setValuesColumn(int index, String vValuesColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.valuesColumnList.size()) {
            throw new IndexOutOfBoundsException("setValuesColumn: Index value '" + index + "' not in range [0.." + (this.valuesColumnList.size() - 1) + "]");
        }
        this.valuesColumnList.set(index, vValuesColumn);
    }

    public void setValuesColumn(String[] vValuesColumnArray) {
        this.valuesColumnList.clear();
        for (int i = 0; i < vValuesColumnArray.length; ++i) {
            this.valuesColumnList.add(vValuesColumnArray[i]);
        }
    }

    public void setWidth(int width) {
        this.width = width;
        this._haswidth = true;
    }

    public static Chart unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Chart)Unmarshaller.unmarshal(Chart.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

