/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.deployer.archive.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlTransformer
implements ArtifactUrlTransformer {
    private Logger logger = LoggerFactory.getLogger(UrlTransformer.class);

    public URL transform(URL url) throws Exception {
        return new URL("pentaho-webpackage", null, url.toExternalForm());
    }

    public boolean canHandle(File file) {
        if (!file.exists()) {
            return false;
        }
        if (this.isTarGzFile(file)) {
            return this.canHandleTarGzFile(file);
        }
        if (this.isZipFile(file)) {
            return this.canHandleZipFile(file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean canHandleZipFile(File file) {
        ZipFile zipFile = null;
        try {
            ZipInputStream zipInputStream;
            block33: {
                boolean bl;
                block32: {
                    zipFile = new ZipFile(file);
                    if (zipFile.getEntry("META-INF/MANIFEST.MF") != null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    zipInputStream = null;
                    try {
                        ZipEntry entry;
                        zipInputStream = new ZipInputStream(new FileInputStream(file));
                        while ((entry = zipInputStream.getNextEntry()) != null) {
                            String name = FilenameUtils.getName((String)entry.getName());
                            if (!name.equals("package.json")) continue;
                            bl = true;
                            break block32;
                        }
                        break block33;
                    }
                    catch (IOException iOException) {
                        try {
                            if (zipInputStream == null) return false;
                            zipInputStream.close();
                            return false;
                        }
                        catch (IOException iOException2) {
                            return false;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (zipInputStream == null) throw throwable;
                                zipInputStream.close();
                                throw throwable;
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    if (zipInputStream == null) return bl;
                    zipInputStream.close();
                    return bl;
                }
                catch (IOException iOException) {
                    // empty catch block
                    return bl;
                }
            }
            try {
                if (zipInputStream == null) return false;
                zipInputStream.close();
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canHandleTarGzFile(File file) {
        TarArchiveInputStream tarInput = null;
        try {
            tarInput = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(file)));
            TarArchiveEntry currentEntry = tarInput.getNextTarEntry();
            while (true) {
                if (currentEntry != null) {
                    if (currentEntry.getName().endsWith("package.json")) {
                        boolean bl = true;
                        return bl;
                    }
                    currentEntry = tarInput.getNextTarEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (tarInput != null) {
                try {
                    tarInput.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    boolean isZipFile(File file) {
        return file.getName().endsWith(".zip") || file.getName().endsWith(".jar");
    }

    boolean isTarGzFile(File file) {
        return file.getName().endsWith(".tgz") || file.getName().endsWith(".tar.gz");
    }
}

