/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class XYDataSetCollectorFunction
extends AbstractFunction {
    private static final Log LOG = LogFactory.getLog((String)XYDataSetCollectorFunction.class.getName());
    private ArrayList seriesNames = new ArrayList();
    private String domainColumn;
    private XYSeriesCollection xyDataset;
    private String resetGroup;
    private HashMap series = new HashMap();

    public XYDataSetCollectorFunction() {
        this.xyDataset = new XYSeriesCollection();
    }

    public void setSeriesName(int index, String field) {
        if (this.seriesNames.size() == index) {
            this.seriesNames.add(field);
        } else {
            this.seriesNames.set(index, field);
        }
    }

    public String getSeriesName(int index) {
        return (String)this.seriesNames.get(index);
    }

    public int getSeriesNameCount() {
        return this.seriesNames.size();
    }

    public String[] getSeriesName() {
        return this.seriesNames.toArray(new String[this.seriesNames.size()]);
    }

    public void setSeriesName(String[] fields) {
        this.seriesNames.clear();
        this.seriesNames.addAll(Arrays.asList(fields));
    }

    public String getDomainColumn() {
        return this.domainColumn;
    }

    public void setDomainColumn(String domainColumn) {
        this.domainColumn = domainColumn;
    }

    public String getResetGroup() {
        return this.resetGroup;
    }

    public void setResetGroup(String resetGroup) {
        this.resetGroup = resetGroup;
    }

    public Object getValue() {
        return this.xyDataset;
    }

    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup((String)this.getResetGroup(), (ReportEvent)event)) {
            if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"XYDataSetCollectorFunction.groupStarted ");
                }
                XYSeriesCollection xyDataset = new XYSeriesCollection();
                for (int i = 0; i < this.getSeriesName().length; ++i) {
                    String s = this.getSeriesName()[i];
                    XYSeries series = new XYSeries((Comparable)((Object)s), true, true);
                    xyDataset.addSeries(series);
                    this.series.put(s, series);
                }
                this.xyDataset = xyDataset;
            } else if (FunctionUtilities.isLayoutLevel((ReportEvent)event)) {
                // empty if block
            }
        } else if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"XYDataSetCollectorFunction.groupStarted ");
            }
            XYSeriesCollection xyDataset = new XYSeriesCollection();
            for (int i = 0; i < this.getSeriesName().length; ++i) {
                String s = this.getSeriesName()[i];
                XYSeries series = new XYSeries((Comparable)((Object)s), true, true);
                xyDataset.addSeries(series);
                this.series.put(s, series);
            }
            this.xyDataset = xyDataset;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            Object domainValue = this.getDataRow().get(this.getDomainColumn());
            if (domainValue == null) {
                return;
            }
            if (!(domainValue instanceof Number)) {
                return;
            }
            Number x = (Number)domainValue;
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                String sn = (String)this.seriesNames.get(i);
                Object o = this.getDataRow().get(sn);
                if (!(o instanceof Number)) continue;
                Number y = (Number)o;
                XYSeries o1 = (XYSeries)this.series.get(sn);
                o1.add(x, y);
            }
        }
    }

    public Expression getInstance() {
        XYDataSetCollectorFunction fn = (XYDataSetCollectorFunction)super.getInstance();
        fn.xyDataset = null;
        fn.series = new HashMap();
        return fn;
    }
}

