/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.exolab.castor.xml.dtd.Attribute;
import org.exolab.castor.xml.dtd.ContentParticle;
import org.exolab.castor.xml.dtd.DTDException;
import org.exolab.castor.xml.dtd.DTDdocument;

public class Element {
    private static final short ANY = 0;
    private static final short EMPTY = 1;
    private static final short MIXED = 2;
    private static final short ELEMENTS_ONLY = 3;
    private String name;
    private final DTDdocument document;
    private short contentType = (short)-1;
    private Set<String> mixedChildren = null;
    private ContentParticle content = null;
    private final Hashtable<String, Attribute> attributes = new Hashtable();

    public Element(DTDdocument document, String name) {
        if (document == null) {
            String err = "Element constructor: document must not be null.";
            throw new IllegalArgumentException(err);
        }
        this.name = name;
        this.document = document;
    }

    public Element(DTDdocument document) {
        this(document, null);
    }

    public String getName() {
        return this.name;
    }

    public DTDdocument getDocument() {
        return this.document;
    }

    public Iterator<String> getMixedContentChildren() {
        if (this.isMixedContent()) {
            return this.mixedChildren.iterator();
        }
        return null;
    }

    public Enumeration<Attribute> getAttributes() {
        return this.attributes.elements();
    }

    public ContentParticle getContent() {
        if (this.isElemOnlyContent()) {
            return this.content;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAnyContent() {
        this.contentType = 0;
    }

    public boolean isAnyContent() {
        return this.contentType == 0;
    }

    public void setEmptyContent() {
        this.contentType = 1;
    }

    public boolean isEmptyContent() {
        return this.contentType == 1;
    }

    public void setMixedContent() {
        this.contentType = (short)2;
        this.mixedChildren = new HashSet<String>();
    }

    public boolean isMixedContent() {
        return this.contentType == 2;
    }

    public void setElemOnlyContent(ContentParticle cp) {
        this.contentType = (short)3;
        this.content = cp;
    }

    public boolean isElemOnlyContent() {
        return this.contentType == 3;
    }

    public synchronized void addMixedContentChild(String child) throws DTDException {
        if (this.mixedChildren.contains(child)) {
            String err = "Element \"" + this.name + "\" already contains child element ";
            err = err + "\"" + child + "\".";
            throw new DTDException(err);
        }
        this.mixedChildren.add(child);
    }

    public synchronized void addAttribute(Attribute attribute) {
        String name = attribute.getName();
        if (!this.attributes.containsKey(name)) {
            this.attributes.put(name, attribute);
        }
    }
}

