/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.xml.dtd.DTDException;
import org.exolab.castor.xml.dtd.Element;
import org.exolab.castor.xml.dtd.GeneralEntity;
import org.exolab.castor.xml.dtd.Notation;

public class DTDdocument {
    private final String name;
    private final Hashtable<String, Element> elements = new Hashtable();
    private final Hashtable<String, Notation> notations = new Hashtable();
    private final Hashtable<String, GeneralEntity> generalEntities = new Hashtable();

    public DTDdocument() {
        this(null);
    }

    public DTDdocument(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addElement(Element element) throws DTDException {
        String name = element.getName();
        if (name == null) {
            String err = "An element declaration must contain a name.";
            throw new DTDException(err);
        }
        if (this.elements.containsKey(name)) {
            String err = "An element declaration already exists with the given name: ";
            throw new DTDException(err + name);
        }
        this.elements.put(name, element);
    }

    public Element getElement(String name) {
        return this.elements.get(name);
    }

    public synchronized void addNotation(Notation notation) throws DTDException {
        String name = notation.getName();
        if (name == null) {
            String err = "A notation declaration must contain a name.";
            throw new DTDException(err);
        }
        if (this.notations.containsKey(name)) {
            String err = "A notation declaration already exists with the given name: ";
            throw new DTDException(err + name);
        }
        this.notations.put(name, notation);
    }

    public Notation getNotation(String name) {
        return this.notations.get(name);
    }

    public synchronized void addGeneralEntity(GeneralEntity generalEntity) {
        String name = generalEntity.getName();
        if (!this.generalEntities.containsKey(name)) {
            this.generalEntities.put(name, generalEntity);
        }
    }

    public GeneralEntity getGeneralEntity(String name) {
        return this.generalEntities.get(name);
    }

    public Enumeration<Element> getElements() {
        return this.elements.elements();
    }

    public Enumeration<GeneralEntity> getGeneralEntities() {
        return this.generalEntities.elements();
    }

    public Enumeration<Notation> getNotations() {
        return this.notations.elements();
    }
}

