/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.server.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoOSGIActivator
implements BundleActivator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void start(BundleContext bundleContext) throws Exception {
        IApplicationContext applicationContext = PentahoSystem.getApplicationContext();
        Object innerContext = applicationContext.getContext();
        if (innerContext instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)innerContext;
            servletContext.setAttribute(BundleContext.class.getName(), (Object)bundleContext);
            this.updateRootContextInConfigurationAdmin(bundleContext, applicationContext);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    private void updateRootContextInConfigurationAdmin(BundleContext bundleContext, IApplicationContext webApplicationContext) throws IOException {
        String fullyQualifiedServerURL;
        URL url;
        String webappPath;
        ServiceReference configurationAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminServiceReference);
        Configuration configuration = configurationAdmin.getConfiguration("org.pentaho.requirejs", null);
        Hashtable<String, String> properties = configuration.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        if ((webappPath = (url = new URL(fullyQualifiedServerURL = webApplicationContext.getFullyQualifiedServerURL())).getPath()) == null || "".equals(webappPath)) {
            webappPath = "/";
        } else {
            if (!webappPath.endsWith("/")) {
                webappPath = webappPath + "/";
            }
            if (!webappPath.startsWith("/")) {
                webappPath = "/" + webappPath;
            }
        }
        webappPath = webappPath + "osgi/";
        ((Dictionary)properties).put("context.root", webappPath);
        configuration.update(properties);
    }
}

