/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class UserGroupInformationService
implements Service {
    private ConcurrentMap<String, UserGroupInformation> cache = new ConcurrentHashMap<String, UserGroupInformation>();

    @Override
    public void init(Services services) throws ServiceException {
    }

    @Override
    public void destroy() {
        for (UserGroupInformation ugi : this.cache.values()) {
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException ioe) {
                XLog.getLog(this.getClass()).warn((Object)("Exception occurred while closing filesystems for " + ugi.getUserName()), ioe);
            }
        }
        this.cache.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return UserGroupInformationService.class;
    }

    public UserGroupInformation getProxyUser(String user) throws IOException {
        this.cache.putIfAbsent(user, UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser()));
        return (UserGroupInformation)this.cache.get(user);
    }
}

