/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.StatisticsProvider;
import mondrian.spi.impl.SqlStatisticsProvider;
import mondrian.util.ClassResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcDialectImpl
implements Dialect {
    private static final Log LOGGER = LogFactory.getLog(JdbcDialectImpl.class);
    private final String quoteIdentifierString;
    private final String productName;
    protected final String productVersion;
    private final Set<List<Integer>> supportedResultSetTypes;
    private final boolean readOnly;
    private final int maxColumnNameLength;
    protected boolean permitsSelectNotInGroupBy;
    protected final Dialect.DatabaseProduct databaseProduct;
    private final List<StatisticsProvider> statisticsProviders;
    private static final int[] RESULT_SET_TYPE_VALUES = new int[]{1003, 1004, 1005};
    private static final int[] CONCURRENCY_VALUES = new int[]{1007, 1008};
    private static final int SINGLE_QUOTE_SIZE = 10;
    private static final int DOUBLE_QUOTE_SIZE = 21;
    private static final Map<Types, SqlStatement.Type> DEFAULT_TYPE_MAP;

    public JdbcDialectImpl(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        this.quoteIdentifierString = this.deduceIdentifierQuoteString(metaData);
        this.productName = this.deduceProductName(metaData);
        this.productVersion = this.deduceProductVersion(metaData);
        this.supportedResultSetTypes = this.deduceSupportedResultSetStyles(metaData);
        this.readOnly = this.deduceReadOnly(metaData);
        this.maxColumnNameLength = this.deduceMaxColumnNameLength(metaData);
        this.databaseProduct = JdbcDialectImpl.getProduct(this.productName, this.productVersion);
        this.permitsSelectNotInGroupBy = this.deduceSupportsSelectNotInGroupBy(connection);
        this.statisticsProviders = this.computeStatisticsProviders();
    }

    public JdbcDialectImpl() {
        this.quoteIdentifierString = "";
        this.productName = "";
        this.productVersion = "";
        this.supportedResultSetTypes = null;
        this.readOnly = true;
        this.maxColumnNameLength = 0;
        this.databaseProduct = null;
        this.permitsSelectNotInGroupBy = true;
        this.statisticsProviders = null;
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    @Override
    public void appendHintsAfterFromClause(StringBuilder buf, Map<String, String> hints) {
    }

    @Override
    public boolean allowsDialectSharing() {
        return true;
    }

    protected int deduceMaxColumnNameLength(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getMaxColumnNameLength();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while detecting maxColumnNameLength");
        }
    }

    protected boolean deduceReadOnly(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.isReadOnly();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while detecting isReadOnly");
        }
    }

    protected String deduceProductName(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while detecting database product");
        }
    }

    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        try {
            String quoteIdentifierString = databaseMetaData.getIdentifierQuoteString();
            return "".equals(quoteIdentifierString) ? null : quoteIdentifierString;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while quoting identifier");
        }
    }

    protected String deduceProductVersion(DatabaseMetaData databaseMetaData) {
        String productVersion;
        try {
            productVersion = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e11) {
            throw Util.newInternal(e11, "while detecting database product version");
        }
        return productVersion;
    }

    protected Set<List<Integer>> deduceSupportedResultSetStyles(DatabaseMetaData databaseMetaData) {
        HashSet<List<Integer>> supports = new HashSet<List<Integer>>();
        for (int type : RESULT_SET_TYPE_VALUES) {
            for (int concurrency : CONCURRENCY_VALUES) {
                try {
                    if (!databaseMetaData.supportsResultSetConcurrency(type, concurrency)) continue;
                    String driverName = databaseMetaData.getDriverName();
                    if (type != 1003 && driverName.equals("JDBC-ODBC Bridge (odbcjt32.dll)")) continue;
                    supports.add(new ArrayList<Integer>(Arrays.asList(type, concurrency)));
                }
                catch (SQLException e) {
                    Util.discard((Object)e);
                }
            }
        }
        return supports;
    }

    protected boolean deduceSupportsSelectNotInGroupBy(Connection conn) throws SQLException {
        return false;
    }

    @Override
    public String toUpper(String expr) {
        return "UPPER(" + expr + ")";
    }

    @Override
    public String caseWhenElse(String cond, String thenExpr, String elseExpr) {
        return "CASE WHEN " + cond + " THEN " + thenExpr + " ELSE " + elseExpr + " END";
    }

    @Override
    public String quoteIdentifier(String val) {
        int size = val.length() + 10;
        StringBuilder buf = new StringBuilder(size);
        this.quoteIdentifier(val, buf);
        return buf.toString();
    }

    @Override
    public void quoteIdentifier(String val, StringBuilder buf) {
        String q = this.getQuoteIdentifierString();
        if (q == null) {
            buf.append(val);
            return;
        }
        if (val.startsWith(q) && val.endsWith(q)) {
            buf.append(val);
            return;
        }
        String val2 = Util.replace(val, q, q + q);
        buf.append(q);
        buf.append(val2);
        buf.append(q);
    }

    @Override
    public String quoteIdentifier(String qual, String name) {
        int size = name.length() + (qual == null ? 10 : qual.length() + 21);
        StringBuilder buf = new StringBuilder(size);
        this.quoteIdentifier(buf, qual, name);
        return buf.toString();
    }

    @Override
    public void quoteIdentifier(StringBuilder buf, String ... names) {
        int nonNullNameCount = 0;
        for (String name : names) {
            if (name == null) continue;
            if (nonNullNameCount > 0) {
                buf.append('.');
            }
            assert (name.length() > 0) : "name should probably be null, not empty";
            this.quoteIdentifier(name, buf);
            ++nonNullNameCount;
        }
    }

    @Override
    public String getQuoteIdentifierString() {
        return this.quoteIdentifierString;
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String s) {
        Util.singleQuoteString(s, buf);
    }

    @Override
    public void quoteNumericLiteral(StringBuilder buf, String value) {
        buf.append(value);
    }

    @Override
    public void quoteBooleanLiteral(StringBuilder buf, String value) {
        if (!value.equalsIgnoreCase("TRUE") && !value.equalsIgnoreCase("FALSE")) {
            throw new NumberFormatException("Illegal BOOLEAN literal:  " + value);
        }
        buf.append(value);
    }

    @Override
    public void quoteDateLiteral(StringBuilder buf, String value) {
        Date date;
        try {
            date = Date.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            try {
                date = new Date(Timestamp.valueOf(value).getTime());
            }
            catch (IllegalArgumentException ex2) {
                throw new NumberFormatException("Illegal DATE literal:  " + value);
            }
        }
        this.quoteDateLiteral(buf, date.toString(), date);
    }

    protected void quoteDateLiteral(StringBuilder buf, String value, Date date) {
        buf.append("DATE ");
        Util.singleQuoteString(value, buf);
    }

    @Override
    public void quoteTimeLiteral(StringBuilder buf, String value) {
        try {
            Time.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            throw new NumberFormatException("Illegal TIME literal:  " + value);
        }
        buf.append("TIME ");
        Util.singleQuoteString(value, buf);
    }

    @Override
    public void quoteTimestampLiteral(StringBuilder buf, String value) {
        try {
            Timestamp.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            throw new NumberFormatException("Illegal TIMESTAMP literal:  " + value);
        }
        buf.append("TIMESTAMP ");
        Util.singleQuoteString(value, buf);
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return false;
    }

    @Override
    public boolean allowsAs() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return true;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return false;
    }

    @Override
    public boolean allowsCountDistinct() {
        return true;
    }

    @Override
    public boolean allowsMultipleCountDistinct() {
        return this.allowsCountDistinct();
    }

    @Override
    public boolean allowsMultipleDistinctSqlMeasures() {
        return this.allowsMultipleCountDistinct();
    }

    @Override
    public boolean allowsCountDistinctWithOtherAggs() {
        return this.allowsCountDistinct();
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineForAnsi("t", columnNames, columnTypes, valueList, false);
    }

    protected String generateInlineGeneric(List<String> columnNames, List<String> columnTypes, List<String[]> valueList, String fromClause, boolean cast) {
        int i;
        StringBuilder buf = new StringBuilder();
        int columnCount = columnNames.size();
        assert (columnTypes.size() == columnCount);
        Integer[] maxLengths = new Integer[columnCount];
        if (cast) {
            for (i = 0; i < columnTypes.size(); ++i) {
                String columnType = columnTypes.get(i);
                Dialect.Datatype datatype = Dialect.Datatype.valueOf(columnType);
                if (datatype != Dialect.Datatype.String) continue;
                int maxLen = -1;
                for (String[] strings : valueList) {
                    if (strings[i] == null || strings[i].length() <= maxLen) continue;
                    maxLen = strings[i].length();
                }
                maxLengths[i] = maxLen;
            }
        }
        for (i = 0; i < valueList.size(); ++i) {
            if (i > 0) {
                buf.append(" union all ");
            }
            String[] values = valueList.get(i);
            buf.append("select ");
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                if (j > 0) {
                    buf.append(", ");
                }
                String columnType = columnTypes.get(j);
                String columnName = columnNames.get(j);
                Dialect.Datatype datatype = Dialect.Datatype.valueOf(columnType);
                Integer maxLength = maxLengths[j];
                if (maxLength != null) {
                    buf.append("CAST(");
                    this.quote(buf, value, datatype);
                    buf.append(" AS VARCHAR(").append(maxLength).append("))");
                } else {
                    this.quote(buf, value, datatype);
                }
                if (this.allowsAs()) {
                    buf.append(" as ");
                } else {
                    buf.append(' ');
                }
                this.quoteIdentifier(columnName, buf);
            }
            if (fromClause == null) continue;
            buf.append(fromClause);
        }
        return buf.toString();
    }

    public String generateInlineForAnsi(String alias, List<String> columnNames, List<String> columnTypes, List<String[]> valueList, boolean cast) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT * FROM (VALUES ");
        String[] castTypes = null;
        if (cast) {
            castTypes = new String[columnNames.size()];
            for (i = 0; i < columnNames.size(); ++i) {
                String columnType = columnTypes.get(i);
                if (!columnType.equals("String")) continue;
                castTypes[i] = JdbcDialectImpl.guessSqlType(columnType, valueList, i);
            }
        }
        for (i = 0; i < valueList.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            String[] values = valueList.get(i);
            buf.append("(");
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                if (j > 0) {
                    buf.append(", ");
                }
                String columnType = columnTypes.get(j);
                Dialect.Datatype datatype = Dialect.Datatype.valueOf(columnType);
                if (value == null) {
                    String sqlType = JdbcDialectImpl.guessSqlType(columnType, valueList, j);
                    buf.append("CAST(NULL AS ").append(sqlType).append(")");
                    continue;
                }
                if (cast && castTypes[j] != null) {
                    buf.append("CAST(");
                    this.quote(buf, value, datatype);
                    buf.append(" AS ").append(castTypes[j]).append(")");
                    continue;
                }
                this.quote(buf, value, datatype);
            }
            buf.append(")");
        }
        buf.append(") AS ");
        this.quoteIdentifier(alias, buf);
        buf.append(" (");
        for (int j = 0; j < columnNames.size(); ++j) {
            String columnName = columnNames.get(j);
            if (j > 0) {
                buf.append(", ");
            }
            this.quoteIdentifier(columnName, buf);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public boolean needsExponent(Object value, String valueString) {
        return false;
    }

    @Override
    public void quote(StringBuilder buf, Object value, Dialect.Datatype datatype) {
        if (value == null) {
            buf.append("null");
        } else {
            String valueString = value.toString();
            if (this.needsExponent(value, valueString)) {
                valueString = valueString + "E0";
            }
            datatype.quoteValue(buf, this, valueString);
        }
    }

    private static String guessSqlType(String basicType, List<String[]> valueList, int column) {
        if (basicType.equals("String")) {
            int maxLen = 1;
            for (String[] values : valueList) {
                String value = values[column];
                if (value == null) continue;
                maxLen = Math.max(maxLen, value.length());
            }
            return "VARCHAR(" + maxLen + ")";
        }
        return "INTEGER";
    }

    @Override
    public boolean allowsDdl() {
        return !this.readOnly;
    }

    @Override
    public String generateOrderItem(String expr, boolean nullable, boolean ascending, boolean collateNullsLast) {
        if (nullable) {
            return this.generateOrderByNulls(expr, ascending, collateNullsLast);
        }
        if (ascending) {
            return expr + " ASC";
        }
        return expr + " DESC";
    }

    protected String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        if (collateNullsLast) {
            if (ascending) {
                return "CASE WHEN " + expr + " IS NULL THEN 1 ELSE 0 END, " + expr + " ASC";
            }
            return "CASE WHEN " + expr + " IS NULL THEN 1 ELSE 0 END, " + expr + " DESC";
        }
        if (ascending) {
            return "CASE WHEN " + expr + " IS NULL THEN 0 ELSE 1 END, " + expr + " ASC";
        }
        return "CASE WHEN " + expr + " IS NULL THEN 0 ELSE 1 END, " + expr + " DESC";
    }

    protected final String generateOrderByNullsAnsi(String expr, boolean ascending, boolean collateNullsLast) {
        if (collateNullsLast) {
            return expr + (ascending ? " ASC" : " DESC") + " NULLS LAST";
        }
        return expr + (ascending ? " ASC" : " DESC") + " NULLS FIRST";
    }

    @Override
    public boolean supportsGroupByExpressions() {
        return true;
    }

    @Override
    public boolean allowsSelectNotInGroupBy() {
        return this.permitsSelectNotInGroupBy;
    }

    @Override
    public boolean allowsJoinOn() {
        return false;
    }

    @Override
    public boolean supportsGroupingSets() {
        return false;
    }

    @Override
    public boolean supportsUnlimitedValueList() {
        return false;
    }

    @Override
    public boolean requiresGroupByAlias() {
        return false;
    }

    @Override
    public boolean requiresOrderByAlias() {
        return false;
    }

    @Override
    public boolean requiresHavingAlias() {
        return false;
    }

    @Override
    public boolean allowsOrderByAlias() {
        return this.requiresOrderByAlias();
    }

    @Override
    public boolean requiresUnionOrderByOrdinal() {
        return true;
    }

    @Override
    public boolean requiresUnionOrderByExprToBeInSelectClause() {
        return true;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return this.supportedResultSetTypes.contains(Arrays.asList(type, concurrency));
    }

    public String toString() {
        return this.productName;
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return false;
    }

    @Override
    public String generateCountExpression(String exp) {
        return exp;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegExp) {
        return null;
    }

    @Override
    public List<StatisticsProvider> getStatisticsProviders() {
        return this.statisticsProviders;
    }

    @Override
    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex + 1);
        SqlStatement.Type internalType = null;
        if (columnType != 2 && columnType != 3) {
            internalType = DEFAULT_TYPE_MAP.get(columnType);
        } else {
            int precision = metaData.getPrecision(columnIndex + 1);
            int scale = metaData.getScale(columnIndex + 1);
            internalType = scale == 0 && precision <= 9 ? SqlStatement.Type.INT : SqlStatement.Type.DOUBLE;
        }
        internalType = internalType == null ? SqlStatement.Type.OBJECT : internalType;
        this.logTypeInfo(metaData, columnIndex, internalType);
        return internalType;
    }

    void logTypeInfo(ResultSetMetaData metaData, int columnIndex, SqlStatement.Type internalType) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            int columnType = metaData.getColumnType(columnIndex + 1);
            int precision = metaData.getPrecision(columnIndex + 1);
            int scale = metaData.getScale(columnIndex + 1);
            String columnName = metaData.getColumnName(columnIndex + 1);
            LOGGER.debug((Object)("JdbcDialectImpl.getType Dialect- " + (Object)((Object)this.getDatabaseProduct()) + ", Column-" + columnName + " is of internal type " + (Object)((Object)internalType) + ". JDBC type was " + columnType + ".  Column precision=" + precision + ".  Column scale=" + scale));
        }
    }

    protected List<StatisticsProvider> computeStatisticsProviders() {
        List<String> names = this.getStatisticsProviderNames();
        if (names == null) {
            return Collections.singletonList(new SqlStatisticsProvider());
        }
        ArrayList<StatisticsProvider> providerList = new ArrayList<StatisticsProvider>();
        for (String name : names) {
            try {
                StatisticsProvider provider = (StatisticsProvider)ClassResolver.INSTANCE.instantiateSafe(name, new Object[0]);
                providerList.add(provider);
            }
            catch (Exception e) {
                LOGGER.info((Object)("Error instantiating statistics provider (class=" + name + ")"), (Throwable)e);
            }
        }
        return providerList;
    }

    private List<String> getStatisticsProviderNames() {
        String path = MondrianProperties.instance().StatisticsProviders.getPath() + "." + this.getDatabaseProduct().name();
        String nameList = MondrianProperties.instance().getProperty(path);
        if (nameList != null && nameList.length() > 0) {
            return Arrays.asList(nameList.split(","));
        }
        nameList = MondrianProperties.instance().StatisticsProviders.get();
        if (nameList != null && nameList.length() > 0) {
            return Arrays.asList(nameList.split(","));
        }
        return null;
    }

    public static Dialect.DatabaseProduct getProduct(String productName, String productVersion) {
        String upperProductName = productName.toUpperCase();
        if (productName.equals("ACCESS")) {
            return Dialect.DatabaseProduct.ACCESS;
        }
        if (upperProductName.trim().equals("APACHE DERBY")) {
            return Dialect.DatabaseProduct.DERBY;
        }
        if (upperProductName.trim().equals("DBMS:CLOUDSCAPE")) {
            return Dialect.DatabaseProduct.DERBY;
        }
        if (productName.startsWith("DB2")) {
            if (productName.startsWith("DB2 UDB for AS/400")) {
                String[] version_release = productVersion.split("\\.", 3);
                if ("04".compareTo(version_release[0]) >= 0) {
                    return Dialect.DatabaseProduct.DB2_OLD_AS400;
                }
                return Dialect.DatabaseProduct.DB2_AS400;
            }
            return Dialect.DatabaseProduct.DB2;
        }
        if (upperProductName.indexOf("FIREBIRD") >= 0) {
            return Dialect.DatabaseProduct.FIREBIRD;
        }
        if (upperProductName.equals("HIVE") || upperProductName.equals("APACHE HIVE")) {
            return Dialect.DatabaseProduct.HIVE;
        }
        if (productName.startsWith("Informix")) {
            return Dialect.DatabaseProduct.INFORMIX;
        }
        if (upperProductName.equals("INGRES")) {
            return Dialect.DatabaseProduct.INGRES;
        }
        if (productName.equals("Interbase")) {
            return Dialect.DatabaseProduct.INTERBASE;
        }
        if (upperProductName.equals("LUCIDDB") || upperProductName.equals("OPTIQ")) {
            return Dialect.DatabaseProduct.LUCIDDB;
        }
        if (upperProductName.indexOf("SQL SERVER") >= 0) {
            return Dialect.DatabaseProduct.MSSQL;
        }
        if (productName.equals("Oracle")) {
            return Dialect.DatabaseProduct.ORACLE;
        }
        if (upperProductName.indexOf("POSTGRE") >= 0) {
            return Dialect.DatabaseProduct.POSTGRESQL;
        }
        if (upperProductName.indexOf("NETEZZA") >= 0) {
            return Dialect.DatabaseProduct.NETEZZA;
        }
        if (upperProductName.equals("MYSQL (INFOBRIGHT)")) {
            return Dialect.DatabaseProduct.INFOBRIGHT;
        }
        if (upperProductName.equals("MYSQL")) {
            return Dialect.DatabaseProduct.MYSQL;
        }
        if (upperProductName.equals("MONETDB")) {
            return Dialect.DatabaseProduct.MONETDB;
        }
        if (upperProductName.equals("VERTICA") || upperProductName.equals("VERTICA DATABASE")) {
            return Dialect.DatabaseProduct.VERTICA;
        }
        if (upperProductName.equals("VECTORWISE")) {
            return Dialect.DatabaseProduct.VECTORWISE;
        }
        if (productName.startsWith("HP Neoview")) {
            return Dialect.DatabaseProduct.NEOVIEW;
        }
        if (upperProductName.indexOf("SYBASE") >= 0 || upperProductName.indexOf("ADAPTIVE SERVER") >= 0) {
            return Dialect.DatabaseProduct.SYBASE;
        }
        if (upperProductName.indexOf("TERADATA") >= 0) {
            return Dialect.DatabaseProduct.TERADATA;
        }
        if (upperProductName.indexOf("HSQL") >= 0) {
            return Dialect.DatabaseProduct.HSQLDB;
        }
        if (upperProductName.indexOf("VERTICA") >= 0) {
            return Dialect.DatabaseProduct.VERTICA;
        }
        if (upperProductName.indexOf("VECTORWISE") >= 0) {
            return Dialect.DatabaseProduct.VECTORWISE;
        }
        if (upperProductName.startsWith("PDI")) {
            return Dialect.DatabaseProduct.PDI;
        }
        if (upperProductName.startsWith("GOOGLE BIGQUERY")) {
            return Dialect.DatabaseProduct.GOOGLEBIGQUERY;
        }
        return Dialect.DatabaseProduct.getDatabaseProduct(upperProductName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isDatabase(Dialect.DatabaseProduct databaseProduct, Connection connection) {
        boolean version2;
        ResultSet resultSet;
        Statement statement;
        block7: {
            String dbProduct;
            block6: {
                statement = null;
                resultSet = null;
                dbProduct = databaseProduct.name().toLowerCase();
                if (!connection.getMetaData().getDatabaseProductName().toLowerCase().contains(dbProduct)) break block6;
                LOGGER.debug((Object)("Using " + databaseProduct.name() + " dialect"));
                boolean bl = true;
                Util.close(resultSet, statement, null);
                return bl;
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select version()");
            if (!resultSet.next()) break block7;
            String version2 = resultSet.getString(1);
            LOGGER.debug((Object)("Version=" + version2));
            if (version2 == null || !version2.toLowerCase().contains(dbProduct)) break block7;
            LOGGER.info((Object)("Using " + databaseProduct.name() + " dialect"));
            boolean bl = true;
            Util.close(resultSet, statement, null);
            return bl;
        }
        try {
            LOGGER.debug((Object)("NOT Using " + databaseProduct.name() + " dialect"));
            version2 = false;
        }
        catch (SQLException e) {
            boolean bl;
            try {
                LOGGER.debug((Object)("NOT Using " + databaseProduct.name() + " dialect."), (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
            Util.close(resultSet, statement, null);
            return bl;
        }
        Util.close(resultSet, statement, null);
        return version2;
    }

    static {
        HashMap<Integer, SqlStatement.Type> typeMapInitial = new HashMap<Integer, SqlStatement.Type>();
        typeMapInitial.put(5, SqlStatement.Type.INT);
        typeMapInitial.put(4, SqlStatement.Type.INT);
        typeMapInitial.put(16, SqlStatement.Type.INT);
        typeMapInitial.put(8, SqlStatement.Type.DOUBLE);
        typeMapInitial.put(6, SqlStatement.Type.DOUBLE);
        typeMapInitial.put(-5, SqlStatement.Type.DOUBLE);
        DEFAULT_TYPE_MAP = Collections.unmodifiableMap(typeMapInitial);
    }
}

