/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.RolapResult;

class RolapSetEvaluator
implements Evaluator.SetEvaluator,
TupleList.PositionCallback {
    private final RolapResult.RolapResultEvaluatorRoot rrer;
    private final Exp exp;
    private TupleList list;
    private static final TupleList DUMMY_LIST = TupleCollections.createList(1);
    private int currentOrdinal;

    public RolapSetEvaluator(RolapResult.RolapResultEvaluatorRoot rrer, Exp exp) {
        this.rrer = rrer;
        this.exp = exp;
    }

    @Override
    public TupleIterable evaluateTupleIterable() {
        this.ensureList();
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureList() {
        if (this.list != null) {
            if (this.list == DUMMY_LIST) {
                throw this.rrer.result.slicerEvaluator.newEvalException(null, "Illegal attempt to reference value of a set '" + this.getExpression() + "' while evaluating itself");
            }
            return;
        }
        if (RolapResult.LOGGER.isDebugEnabled()) {
            RolapResult.LOGGER.debug((Object)("Set " + this.exp + ": starting evaluation"));
        }
        this.list = DUMMY_LIST;
        try {
            TupleList rawList;
            Calc calc = this.rrer.getCompiled(this.exp, false, ResultStyle.ITERABLE);
            TupleIterable iterable = (TupleIterable)this.rrer.result.evaluateExp(calc, this.rrer.result.slicerEvaluator, null);
            if (iterable instanceof TupleList) {
                rawList = (TupleList)iterable;
            } else {
                rawList = TupleCollections.createList(iterable.getArity());
                TupleCursor cursor = iterable.tupleCursor();
                while (cursor.forward()) {
                    rawList.addCurrent(cursor);
                }
            }
            if (RolapResult.LOGGER.isDebugEnabled()) {
                RolapResult.LOGGER.debug((Object)this.generateDebugMessage(calc, rawList));
            }
            this.list = rawList.withPositionCallback(this);
        }
        finally {
            if (this.list == DUMMY_LIST) {
                this.list = null;
            }
        }
    }

    private String generateDebugMessage(Calc calc, TupleList rawList) {
        StringBuilder buf = new StringBuilder();
        buf.append(this);
        buf.append(": ");
        buf.append("Set expression ");
        buf.append(this.getExpression());
        buf.append(" evaluated to:");
        buf.append(Util.nl);
        int arity = calc.getType().getArity();
        int rowCount = 0;
        int maxRowCount = 100;
        if (arity == 1) {
            for (Member t : rawList.slice(0)) {
                if (rowCount++ > 100) {
                    buf.append("...");
                    buf.append(Util.nl);
                    break;
                }
                buf.append(t);
                buf.append(Util.nl);
            }
        } else {
            for (List t : rawList) {
                if (rowCount++ > 100) {
                    buf.append("...");
                    buf.append(Util.nl);
                    break;
                }
                int k = 0;
                for (Member member : t) {
                    if (k++ > 0) {
                        buf.append(", ");
                    }
                    buf.append(member);
                }
                buf.append(Util.nl);
            }
        }
        return buf.toString();
    }

    private String getExpression() {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        this.exp.unparse(printWriter);
        return ((Object)result).toString();
    }

    @Override
    public int currentOrdinal() {
        return this.currentOrdinal;
    }

    @Override
    public void onPosition(int index) {
        this.currentOrdinal = index;
    }

    @Override
    public Member[] currentTuple() {
        List tuple = (List)this.list.get(this.currentOrdinal);
        return tuple.toArray(new Member[tuple.size()]);
    }

    @Override
    public Member currentMember() {
        return this.list.get(0, this.currentOrdinal);
    }
}

