/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

class ExistsFunDef
extends FunDefBase {
    static final Resolver resolver = new ReflectiveMultiResolver("Exists", "Exists(<Set1>, <Set2>])", "Returns the the set of tuples of the first set that exist with one or more tuples of the second set.", new String[]{"fxxx"}, ExistsFunDef.class);

    public ExistsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList leftTuples = listCalc1.evaluateList(evaluator);
                if (leftTuples.isEmpty()) {
                    return TupleCollections.emptyList(leftTuples.getArity());
                }
                TupleList rightTuples = listCalc2.evaluateList(evaluator);
                if (rightTuples.isEmpty()) {
                    return TupleCollections.emptyList(leftTuples.getArity());
                }
                TupleList result = TupleCollections.createList(leftTuples.getArity());
                List leftDims = ExistsFunDef.getHierarchies((List)leftTuples.get(0));
                List rightDims = ExistsFunDef.getHierarchies((List)rightTuples.get(0));
                block0: for (List leftTuple : leftTuples) {
                    for (List rightTuple : rightTuples) {
                        if (!FunUtil.existsInTuple(leftTuple, rightTuple, leftDims, rightDims, null)) continue;
                        result.add(leftTuple);
                        continue block0;
                    }
                }
                return result;
            }
        };
    }

    private static List<Hierarchy> getHierarchies(List<Member> members) {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        for (Member member : members) {
            hierarchies.add(member.getHierarchy());
        }
        return hierarchies;
    }
}

