/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Literal;
import mondrian.olap.MemberProperty;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.util.ArrayStack;

abstract class ValidatorImpl
implements Validator {
    protected final ArrayStack<QueryPart> stack = new ArrayStack();
    private final FunTable funTable;
    private final Map<QueryPart, QueryPart> resolvedNodes = new HashMap<QueryPart, QueryPart>();
    private final QueryPart placeHolder = Literal.zero;
    private final Map<FunCall, List<String>> scopeExprs = new HashMap<FunCall, List<String>>();

    protected ValidatorImpl(FunTable funTable, Map<QueryPart, QueryPart> resolvedIdentifiers) {
        Util.assertPrecondition(funTable != null, "funTable != null");
        this.funTable = funTable;
        this.resolvedNodes.putAll(resolvedIdentifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exp validate(Exp exp, boolean scalar) {
        Type type;
        Exp resolved;
        try {
            resolved = (Exp)((Object)this.resolvedNodes.get(exp));
        }
        catch (ClassCastException e) {
            throw Util.newInternal(e, "Infinite recursion encountered while validating '" + Util.unparse(exp) + "'");
        }
        if (resolved == null) {
            try {
                this.stack.push((QueryPart)((Object)exp));
                this.resolvedNodes.put((QueryPart)((Object)exp), this.placeHolder);
                resolved = exp.accept(this);
                Util.assertTrue(resolved != null);
                this.resolvedNodes.put((QueryPart)((Object)exp), (QueryPart)((Object)resolved));
            }
            finally {
                this.stack.pop();
            }
        }
        if (scalar && !TypeUtil.canEvaluate(type = resolved.getType())) {
            String exprString = Util.unparse(resolved);
            throw MondrianResource.instance().MdxMemberExpIsSet.ex(exprString);
        }
        return resolved;
    }

    @Override
    public void validate(ParameterExpr parameterExpr) {
        ParameterExpr resolved = (ParameterExpr)this.resolvedNodes.get(parameterExpr);
        if (resolved != null) {
            return;
        }
        try {
            this.stack.push(parameterExpr);
            this.resolvedNodes.put(parameterExpr, this.placeHolder);
            resolved = (ParameterExpr)parameterExpr.accept(this);
            assert (resolved != null);
            this.resolvedNodes.put(parameterExpr, resolved);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void validate(MemberProperty memberProperty) {
        MemberProperty resolved = (MemberProperty)this.resolvedNodes.get(memberProperty);
        if (resolved != null) {
            return;
        }
        try {
            this.stack.push(memberProperty);
            this.resolvedNodes.put(memberProperty, this.placeHolder);
            memberProperty.resolve(this);
            this.resolvedNodes.put(memberProperty, memberProperty);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void validate(QueryAxis axis) {
        QueryAxis resolved = (QueryAxis)this.resolvedNodes.get(axis);
        if (resolved != null) {
            return;
        }
        try {
            this.stack.push(axis);
            this.resolvedNodes.put(axis, this.placeHolder);
            axis.resolve(this);
            this.resolvedNodes.put(axis, axis);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void validate(Formula formula) {
        Formula resolved = (Formula)this.resolvedNodes.get(formula);
        if (resolved != null) {
            return;
        }
        try {
            this.stack.push(formula);
            this.resolvedNodes.put(formula, this.placeHolder);
            formula.accept(this);
            this.resolvedNodes.put(formula, formula);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public FunDef getDef(Exp[] args, String funName, Syntax syntax) {
        String signature = syntax.getSignature(funName, 0, ExpBase.getTypes(args));
        List<Resolver> resolvers = this.funTable.getResolvers(funName, syntax);
        assert (resolvers != null);
        ArrayList<Resolver.Conversion> conversionList = new ArrayList<Resolver.Conversion>();
        int minConversionCost = Integer.MAX_VALUE;
        ArrayList<FunDef> matchDefs = new ArrayList<FunDef>();
        ArrayList<Resolver.Conversion> matchConversionList = null;
        for (Resolver resolver : resolvers) {
            conversionList.clear();
            FunDef def = resolver.resolve(args, this, conversionList);
            if (def == null) continue;
            int conversionCost = this.sumConversionCost(conversionList);
            if (conversionCost < minConversionCost) {
                minConversionCost = conversionCost;
                matchDefs.clear();
                matchDefs.add(def);
                matchConversionList = new ArrayList<Resolver.Conversion>(conversionList);
                continue;
            }
            if (conversionCost != minConversionCost) continue;
            matchDefs.add(def);
        }
        switch (matchDefs.size()) {
            case 0: {
                throw MondrianResource.instance().NoFunctionMatchesSignature.ex(signature);
            }
            case 1: {
                break;
            }
            default: {
                StringBuilder buf = new StringBuilder();
                for (FunDef matchDef : matchDefs) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(matchDef.getSignature());
                }
                throw MondrianResource.instance().MoreThanOneFunctionMatchesSignature.ex(signature, buf.toString());
            }
        }
        FunDef matchDef = (FunDef)matchDefs.get(0);
        for (Resolver.Conversion conversion : matchConversionList) {
            conversion.checkValid();
            conversion.apply(this, Arrays.asList(args));
        }
        return matchDef;
    }

    @Override
    public boolean alwaysResolveFunDef() {
        return false;
    }

    private int sumConversionCost(List<Resolver.Conversion> conversionList) {
        int cost = 0;
        for (Resolver.Conversion conversion : conversionList) {
            cost += conversion.getCost();
        }
        return cost;
    }

    @Override
    public boolean canConvert(int ordinal, Exp fromExp, int to, List<Resolver.Conversion> conversions) {
        return TypeUtil.canConvert(ordinal, fromExp.getType(), to, conversions);
    }

    @Override
    public boolean requiresExpression() {
        return this.requiresExpression(this.stack.size() - 1);
    }

    private boolean requiresExpression(int n) {
        if (n < 1) {
            return false;
        }
        Object parent = this.stack.get(n - 1);
        if (parent instanceof Formula) {
            return ((Formula)parent).isMember();
        }
        if (parent instanceof ResolvedFunCall) {
            ResolvedFunCall funCall = (ResolvedFunCall)parent;
            if (funCall.getFunDef().getSyntax() == Syntax.Parentheses) {
                return this.requiresExpression(n - 1);
            }
            int k = this.whichArg(funCall, (Exp)this.stack.get(n));
            if (k < 0) {
                return false;
            }
            FunDef funDef = funCall.getFunDef();
            int[] parameterTypes = funDef.getParameterCategories();
            return parameterTypes[k] != 8;
        }
        if (parent instanceof UnresolvedFunCall) {
            UnresolvedFunCall funCall = (UnresolvedFunCall)parent;
            if (funCall.getSyntax() == Syntax.Parentheses || funCall.getFunName().equals("*")) {
                return this.requiresExpression(n - 1);
            }
            int k = this.whichArg(funCall, (Exp)this.stack.get(n));
            if (k < 0) {
                return false;
            }
            return this.requiresExpression(funCall, k);
        }
        return false;
    }

    boolean requiresExpression(UnresolvedFunCall funCall, int k) {
        List<Resolver> resolvers = this.funTable.getResolvers(funCall.getFunName(), funCall.getSyntax());
        for (Resolver resolver2 : resolvers) {
            if (resolver2.requiresExpression(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FunTable getFunTable() {
        return this.funTable;
    }

    @Override
    public Parameter createOrLookupParam(boolean definition, String name, Type type, Exp defaultExp, String description) {
        SchemaReader schemaReader = this.getQuery().getSchemaReader(false);
        Parameter param = schemaReader.getParameter(name);
        if (definition) {
            if (param != null) {
                if (param.getScope() == Parameter.Scope.Statement) {
                    ParameterImpl paramImpl = (ParameterImpl)param;
                    paramImpl.setDescription(description);
                    paramImpl.setDefaultExp(defaultExp);
                    paramImpl.setType(type);
                }
                return param;
            }
            param = new ParameterImpl(name, defaultExp, description, type);
            this.defineParameter(param);
            return param;
        }
        if (param != null) {
            return param;
        }
        throw MondrianResource.instance().UnknownParameter.ex(name);
    }

    private int whichArg(FunCall node, Exp arg) {
        Exp[] children = node.getArgs();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != arg) continue;
            return i;
        }
        return -1;
    }

    protected abstract void defineParameter(Parameter var1);
}

