/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.splitfields;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class SplitFieldsStepAnalyzer
extends StepAnalyzer<FieldSplitterMeta> {
    protected Set<StepField> getUsedFields(FieldSplitterMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        usedFields.addAll(this.createStepFields(meta.getSplitField(), this.getInputs()));
        return usedFields;
    }

    protected void customAnalyze(FieldSplitterMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        rootNode.setProperty("delimiter", (Object)meta.getDelimiter());
        rootNode.setProperty("enclosure", (Object)meta.getEnclosure());
    }

    public Set<ComponentDerivationRecord> getChangeRecords(FieldSplitterMeta meta) throws MetaverseAnalyzerException {
        String originalField = meta.getSplitField();
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        String[] fieldNames = meta.getFieldName();
        if (!Const.isEmpty((String[])fieldNames)) {
            for (int i = 0; i < meta.getFieldName().length; ++i) {
                ComponentDerivationRecord cdr = new ComponentDerivationRecord(originalField, fieldNames[i], ChangeType.DATA);
                cdr.addOperation(new Operation("mapping", ChangeType.DATA, fieldNames[i], "Token " + i + " of split string"));
                changeRecords.add(cdr);
            }
        }
        return changeRecords;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(FieldSplitterMeta.class);
        return supportedSteps;
    }
}

