/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.jobentry.job;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IClonableJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.JobEntryAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobJobEntryAnalyzer
extends JobEntryAnalyzer<JobEntryJob> {
    private Logger log = LoggerFactory.getLogger(JobJobEntryAnalyzer.class);

    public Set<Class<? extends JobEntryInterface>> getSupportedEntries() {
        HashSet<Class<? extends JobEntryInterface>> supportedEntries = new HashSet<Class<? extends JobEntryInterface>>();
        supportedEntries.add(JobEntryJob.class);
        return supportedEntries;
    }

    protected void customAnalyze(JobEntryJob entry, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        JobMeta subJobMeta = null;
        JobMeta parentJobMeta = entry.getParentJob().getJobMeta();
        parentJobMeta.activateParameters();
        Repository repo = parentJobMeta.getRepository();
        String jobPath = null;
        switch (entry.getSpecificationMethod()) {
            case FILENAME: {
                try {
                    jobPath = parentJobMeta.environmentSubstitute(entry.getFilename());
                    String normalized = KettleAnalyzerUtil.normalizeFilePath((String)jobPath);
                    subJobMeta = this.getSubJobMeta(normalized);
                    jobPath = normalized;
                    break;
                }
                catch (Exception e) {
                    throw new MetaverseAnalyzerException("Sub job can not be found - " + jobPath, (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                if (repo != null) {
                    String dir = parentJobMeta.environmentSubstitute(entry.getDirectory());
                    String file = parentJobMeta.environmentSubstitute(entry.getJobName());
                    try {
                        RepositoryDirectoryInterface rdi = repo.findDirectory(dir);
                        subJobMeta = repo.loadJob(file, rdi, null, null);
                        String filename = subJobMeta.getFilename() == null ? subJobMeta.toString() : subJobMeta.getFilename();
                        jobPath = filename + "." + subJobMeta.getDefaultExtension();
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub job can not be found in repository - " + file, (Throwable)e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the job");
            }
            case REPOSITORY_BY_REFERENCE: {
                if (repo != null) {
                    try {
                        subJobMeta = repo.loadJob(entry.getJobObjectId(), null);
                        String filename = subJobMeta.getFilename() == null ? subJobMeta.toString() : subJobMeta.getFilename();
                        jobPath = filename + "." + subJobMeta.getDefaultExtension();
                        break;
                    }
                    catch (KettleException e) {
                        throw new MetaverseAnalyzerException("Sub job can not be found by reference - " + entry.getJobObjectId(), (Throwable)e);
                    }
                }
                throw new MetaverseAnalyzerException("Not connected to a repository, can't get the job");
            }
        }
        subJobMeta.copyVariablesFrom((VariableSpace)parentJobMeta);
        MetaverseComponentDescriptor ds = new MetaverseComponentDescriptor(subJobMeta.getName(), "Job", this.descriptor.getNamespace().getParentNamespace());
        IMetaverseNode jobNode = this.createNodeFromDescriptor((IComponentDescriptor)ds);
        jobNode.setProperty("namespace", (Object)ds.getNamespaceId());
        jobNode.setProperty("path", (Object)jobPath);
        jobNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        this.metaverseBuilder.addLink(rootNode, "executes", jobNode);
        IDocument subTransDocument = KettleAnalyzerUtil.buildDocument((IMetaverseBuilder)this.getMetaverseBuilder(), (AbstractMeta)subJobMeta, (String)jobPath, (INamespace)this.getDocumentDescriptor().getNamespace());
        if (subTransDocument != null) {
            MetaverseComponentDescriptor subtransDocumentDescriptor = new MetaverseComponentDescriptor(subTransDocument.getStringID(), "Transformation", this.getDocumentDescriptor().getNamespace(), this.getDescriptor().getContext());
            this.getDocumentAnalyzer().analyze((IComponentDescriptor)subtransDocumentDescriptor, (AbstractMeta)subJobMeta, jobNode, jobPath);
        }
    }

    protected JobMeta getSubJobMeta(String filePath) throws FileNotFoundException, KettleXMLException, KettleMissingPluginsException {
        FileInputStream fis = new FileInputStream(filePath);
        return new JobMeta((InputStream)fis, null, null);
    }

    public IClonableJobEntryAnalyzer newInstance() {
        return new JobJobEntryAnalyzer();
    }
}

